// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDEREPORT_H
#define HK_KDEREPORT_H
#include "hk_class.h"
#include <qwidget.h>
#include "hk_presentation.h"
#include <kparts/dockmainwindow.h>

class QButtonGroup;
class QLabel;
class hk_kdesimplereport;
class hk_database;
class hk_kdetoolbar;
class QToolButton;
class QVBoxLayout;
class QHBoxLayout;
class KLibFactory;
class KRadioAction;
class QWidgetStack;

class hk_kdereportscrollview;
/**
 *
 *@short  KDE high level widget to display and design reports
 *@author Horst Knorr (hk_classes@knoda.org)
 *@version $Revision: 1.18 $
 *
 *this is a high level widget to display and design reports. It hereby uses @ref hk_kdesimplereport.
 *To use it set the database with @ref set_database. If you want to show or edit an existing reports
 * load it with @ref load_report.
 */

class hk_kdereport:public KParts::DockMainWindow, public hk_class
{

    Q_OBJECT

        public:
        hk_kdereport( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        virtual    ~hk_kdereport();
        bool        set_presentationdatasource(long n,bool r=true);
        long        presentationdatasource(void);
        void set_database(hk_database*);
        hk_database* database(void);
        void set_nodesignmode(bool);
        void set_mode(hk_presentation::enum_mode s);
        hk_kdesimplereport* simplereport(void);
        bool load_report(const hk_string& name="");
    signals:
        void signal_closed(QWidget*);

    public slots:
        void set_designmode(void);
        void set_viewmode(void);
        void    save_report(void);
        void    saveas_report(void);
        void    close_report(void);
        void    slot_showtoolbar(void);
        void    print_report(void);
        void    select_section(void);
    protected:
        void closeEvent ( QCloseEvent* e);

    protected slots:
        void fieldbutton_clicked(void);
        void pointerbutton_clicked(void);
        void viewbutton_clicked(void);
        void designbutton_clicked(void);
        void field_created(void);
        void bulkfont_clicked(void);
        void bulkforegroundcolour_clicked(void);
        void bulkbackgroundcolour_clicked(void);

    private:

        void set_reporttoolbar(void);
/* QWidget* p_reporttoolbar;
 QButtonGroup* reportbuttongroup;
 QToolButton* reportdatabutton;
 QToolButton* reportpointerbutton;
 QToolButton* reportsectionbutton;
*/
        hk_kdesimplereport* p_report;
        bool p_nodesignmode;
	QWidgetStack* p_stack;
        KParts::ReadOnlyPart* p_previewpart;
        hk_kdereportscrollview* p_scrollview;
        KRadioAction* p_pointeraction;
        KRadioAction* p_fieldaction;
        KRadioAction* p_designaction;
        KRadioAction* p_viewaction;
        KAction*  p_printaction;
        KAction*  p_sectionaction;
        KAction*  p_reportpropertyaction;
        KAction*  p_closeaction;
        KAction*  p_saveaction;
        KAction*  p_saveasaction;
        KActionMenu*   p_bulkaction;
        KAction*       p_bulkfontaction;
        KAction*       p_bulkforegroundcolouraction;
        KAction*       p_bulkbackgroundcolouraction;

        bool p_whilepreview;
        bool p_closewindow;
        void set_caption(void);

};
#endif
