// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdecomboboxtextlist.h"
#include <qtable.h>
#include <qpushbutton.h>
#include <hk_dscombobox.h>


/* 
 *  Constructs a hk_kdecomboboxtextlist which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdecomboboxtextlist::hk_kdecomboboxtextlist( QWidget* parent, hk_dscombobox* c, const char* name, bool modal, WFlags fl )
    : hk_kdecomboboxtextlistbase( parent, name, modal, fl )
{
  p_combobox=c;
  grid->installEventFilter(this);
  ok_button->installEventFilter(this);
  cancel_button->installEventFilter(this);
  grid->setColumnWidth(0,grid->contentsWidth());
set_existing_fields();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
hk_kdecomboboxtextlist::~hk_kdecomboboxtextlist()
{
    // no need to delete child widgets, Qt does it all for us
}


void hk_kdecomboboxtextlist::slot_data_changed(int row, int /*col*/)
{
cerr <<"slot_data_changed row="<<row<<endl;
  if (row==grid->numRows()-1 
  	&& grid->item(row,0)
	&&  !grid->item(row,0)->text().isEmpty() )
  	{
		add_row();
	}
	else cerr <<"nicht hinzugefgt, da leer: " <<grid->item(row,0)<<endl;

}


void hk_kdecomboboxtextlist::add_row(void)
{
cerr <<"add_row"<<endl;
grid->setNumRows(grid->numRows()+1);

}

bool hk_kdecomboboxtextlist::eventFilter(QObject* object,QEvent* e)
{
 QKeyEvent* event=dynamic_cast<QKeyEvent*>(e);
 if (event  && event->key()==Qt::Key_Delete && event->type()==QEvent::KeyRelease)
   {
       delete_rows(); 
       //event->accept();
       return true;
   }
  else return hk_kdecomboboxtextlistbase::eventFilter(object,e);
}


void hk_kdecomboboxtextlist::delete_rows(void)
{
 //cerr <<"hk_kderelationdialog::delete_rows"<<endl;
 int beginrow=grid->selection(0).topRow();
 int endrow=grid->selection(0).bottomRow();
 if (endrow==grid->numRows()-1) --endrow;
if (beginrow>-1&&endrow>=beginrow)
{
QMemArray<int> a(endrow-beginrow+1);
int c=0;//cerr <<"a new ="<<endrow-beginrow+1<<endl;
	for (int i=beginrow;i<=endrow;++i)
	{
	 a[c]=i;//cerr <<"a["<<c<<"]="<<i<<endl;
	 ++c;
	}
	grid->removeRows(a);
}
else
{
//cerr <<"delete_row "<<grid->currentRow()<<endl;
if (grid->currentRow()>-1 &&grid->currentRow()<grid->numRows()-1) 
	grid->removeRow(grid->currentRow());
}

}




void hk_kdecomboboxtextlist::set_existing_fields(void)
{
if (!p_combobox)
      return;
  
 list<hk_string>* l=p_combobox->textlist();
list<hk_string>::iterator it=l->begin();
while (it!=l->end())
	{
		grid->setText(grid->numRows()-1,0,QString::fromUtf8(l2u((*it)).c_str()));
		++it;
		add_row();
	}
}



void hk_kdecomboboxtextlist::ok_clicked(void)
{
if (p_combobox)
 {
   list<hk_string> l;
   for (int row=0;row<grid->numRows()-1;++row)
  {
    
    hk_string txt=u2l(grid->item(row,0)->text().utf8().data());
    l.push_back(txt);
  }

  p_combobox->set_textlist(l);
 }
accept();

}

