// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.28 $

#include "hk_kdecsvexportdialog.h"
#include "hk_kdecsvexportdialog.moc"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <vector>
#include <hk_database.h>
#include <hk_connection.h>
#include <qprogressdialog.h>
#include <kapplication.h>
#include <kconfig.h>

bool    hk_kdecsvexportdialog::p_cancelimport=false;
QProgressDialog* hk_kdecsvexportdialog::p_progressdialog=NULL;
/*
 *  Constructs a hk_kdecsvexportdialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdecsvexportdialog::hk_kdecsvexportdialog( const QString& table, QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdecsvexportdialogbase( parent, name, modal, fl )    ,hk_reportcsv()
{
    if ( !name )
        setName( "hk_kdecsvexportdialog" );
    resize( 328, 171 );
    p_tablename=table;
    setCaption( i18n( "CSV export Dialog"  ) );
    setSizeGripEnabled( TRUE );
    setMaximumSize( QSize( 32767, 32767 ) );
    setBackgroundOrigin( QDialog::WidgetOrigin );
    moreframe->hide();
// signals and slots connections
    p_datasourcetype=dt_table;
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("CSVExport");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
      p_tab=i18n("Tab");
    columnseparatorfield->setEditable(true);
    columnseparatorfield->insertItem(  ","  );
    columnseparatorfield->insertItem(  ";"  );
    columnseparatorfield->insertItem(  "|"  );
    columnseparatorfield->insertItem( p_tab);
    timeformatfield->setText(QString::fromUtf8(l2u(defaulttimeformat()).c_str()));
    dateformatfield->setText(QString::fromUtf8(l2u(defaultdateformat()).c_str()));
    datetimeformatfield->setText(QString::fromUtf8(l2u(defaultdatetimeformat()).c_str()));
    for (unsigned int i=0;i<sizeof(charsets)/sizeof(hk_string);++i)
    {
    charsetfield->insertItem(QString::fromUtf8(l2u(charsets[i]).c_str()));
    }

    for (unsigned int i=0;i<sizeof(locales)/sizeof(hk_string);++i)
    {
    localefield->insertItem(QString::fromUtf8(l2u(locales[i]).c_str()));
    }

    charsetfield->setCurrentText(QString::fromUtf8(l2u(filecharset()).c_str()));
    localefield->setCurrentText(QString::fromUtf8(l2u(filelocale()).c_str()));

}


hk_kdecsvexportdialog::~hk_kdecsvexportdialog()
{
// no need to delete child widgets, Qt does it all for us
//    delete p_export;
}


void hk_kdecsvexportdialog::ok_clicked(void)
{
//  wanna_debug(true);
    set_filename(u2l(filefield->text().utf8().data()));
    long ds=new_datasource(u2l(tablefield->currentText().utf8().data()),p_datasourcetype);
    set_presentationdatasource(ds);
    set_withheader(firstrow->isChecked());
    QString sep=columnseparatorfield->currentText();
    if (sep==p_tab) sep="\t";
    set_filedefinition(
    u2l(textdelimiterfield->text().utf8().data()),
    u2l(sep.utf8().data()),
    "\n",
    u2l(datetimeformatfield->text().utf8().data()),
    u2l(dateformatfield->text().utf8().data()),
    u2l(timeformatfield->text().utf8().data()),
    u2l(charsetfield->currentText().utf8().data()),
    u2l(localefield->currentText().utf8().data()));
    set_progressdialog(&hk_kdecsvexportdialog::set_progress);
    p_cancelimport=false;
    set_filecharset(u2l(charsetfield->currentText().utf8().data()));
    set_filelocale(u2l(localefield->currentText().utf8().data()));
   p_progressdialog= new  QProgressDialog(this,NULL,true);
   p_progressdialog->setCaption(i18n("Exporting data..."));
   p_progressdialog->setTotalSteps(100);
   connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(printing_cancelled()));
   p_progressdialog->show();
   qApp->processEvents();
    if ( execute()) accept();
  delete p_progressdialog;
  p_progressdialog=NULL;

  KConfig* c=kapp->config();
  c->setGroup("CSVExport");
  c->writeEntry("Geometry",geometry());
}

void hk_kdecsvexportdialog::printing_cancelled(void)
{
    cout <<"cancelclicked"<<endl;
    p_cancelimport=true;

}

void hk_kdecsvexportdialog::filebutton_clicked()
{

    p_file = KFileDialog::getOpenFileName( ":csv", QString::null, this,i18n("Select a CSV file"));
    filefield->setText(p_file);
}


void hk_kdecsvexportdialog::buttons_enabled()
{
    if (    !filefield->text().isEmpty()
        &&!columnseparatorfield->currentText().isEmpty()
        &&!tablefield->currentText().isEmpty()
        )
        buttonOk->setEnabled(true);
    else buttonOk->setEnabled(false);
}


void hk_kdecsvexportdialog::set_usetablelist()
{
    p_datasourcetype=dt_table;
    set_datasourcelist();
}

void hk_kdecsvexportdialog::set_useviewlist()
{
    p_datasourcetype=dt_view;
    set_datasourcelist();
}

void hk_kdecsvexportdialog::set_usequerylist()
{
    p_datasourcetype=dt_query;
    set_datasourcelist();
}


void hk_kdecsvexportdialog::set_database(hk_database* d)
{
    typefield->clear();
    typefield->insertItem(i18n("Table"));
    typefield->insertItem(i18n("Query"));
    hk_presentation::set_database(d);
    if (d && d->connection()->server_supports(hk_connection::SUPPORTS_VIEWS))
    {
        typefield->insertItem(i18n("View"));

    }
    set_datasourcelist();
}

void hk_kdecsvexportdialog::listtype_changed()
{
switch (typefield->currentItem())
{
 case 1: p_datasourcetype=dt_query;break;
 case 2: p_datasourcetype=dt_view;break;
 default: p_datasourcetype=dt_table;
}
set_datasourcelist();
}


void hk_kdecsvexportdialog::set_datasourcelist(void)
{
    tablefield->clear();
    hk_database* p_db=database();
    if (p_db==NULL)return ;
    vector<hk_string>* tbl=p_db->tablelist();
    switch (p_datasourcetype)
    {
    case dt_table:
    {
        //tbl already set as default
        //TextLabel1_2->setText( i18n("Tablename:"  ) );
	break;
    }
    case dt_query:
    {
        tbl=p_db->querylist();
        //TextLabel1_2->setText( i18n("Queryname:"  ) );
	break;
    }
    case dt_view:
    {
        tbl=p_db->viewlist();
        //TextLabel1_2->setText( i18n("Viewname:"  ) );
	break;
    }
    }
    vector<hk_string>::iterator it;
    if (tbl!=NULL)
    {
        for(it=tbl->begin();it!=tbl->end();it++)
        {
            QString l=QString::fromUtf8 (l2u((*it)).c_str());
            tablefield->insertItem(l);
            if (!p_tablename.isEmpty()&& p_tablename==l) tablefield->setCurrentItem(tablefield->count()-1);
        }
    }

}


void hk_kdecsvexportdialog::keyPressEvent ( QKeyEvent * e )
{
  if (e->key()==Key_F1) help_clicked();
}



void hk_kdecsvexportdialog::help_clicked()
{
kapp->invokeHelp("exportcsv");
}


bool hk_kdecsvexportdialog::set_progress(long int position,long int total,const hk_string&txt)
{
    if (p_progressdialog)
    {

        p_progressdialog->setCaption(QString::fromUtf8(l2u(txt).c_str()));
        p_progressdialog->setTotalSteps(total);
        p_progressdialog->setProgress(position);
        p_progressdialog->raise();
        qApp->processEvents();
    }
    return p_cancelimport;
}

void hk_kdecsvexportdialog::morebutton_clicked()
{
    
    if (morebutton->state()==QButton::Off)
     moreframe->hide();
     else
     moreframe->show();
//adjustSize();
}

