
// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "hk_kdepreferencesdialog.h"
#include <hk_class.h>
#include <hk_drivermanager.h>
#include <hk_report.h>
#include <hk_visible.h>
#include <hk_dsdatavisible.h>
#include <hk_kdedblistview.h>
#include <qfontdatabase.h>

#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>

hk_kdepreferencesdialog::hk_kdepreferencesdialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdepreferencesdialogbase( parent, name, modal, fl )
{

    datelabel->setText( i18n( "Date format:"  ) );
    timelabel->setText( i18n( "Time format:"  ) );
    datetimelabel->setText( i18n( "Date&Time format:"  ) );
    setCaption( i18n( "Preferences"  ) );
    regionaltab->changeTab(regionalpage,i18n("&Regional"));
    regionaltab->changeTab(printerpage,i18n("&Printer"));
    regionaltab->changeTab(generalpage,i18n("&General"));
    driverpathlabel->setText( i18n( "Driverpath:"  ) );
    encodinglabel->setText( i18n( "Fontencoding:"  ) );
    printcommandlabel->setText( i18n( "Printcommand:"  ) );
    bepedanticlabel->setText( i18n( "Show all questions:"  ) );
    maximizedlabel->setText( i18n( "Show maximized:"  ) );
    storepasswordlabel->setText( i18n( "Store password:"  ) );
    fontlabel->setText(i18n("Default Font:"));
    defaultdriverlabel->setText(i18n("Default driver:"));
    QFontDatabase*p_fontdatabase = new QFontDatabase();
    QStringList strlist=p_fontdatabase->families();
    QStringList newstrlist;
    for (QStringList::iterator it=strlist.begin();it!=strlist.end();++it)
    {
        QString f=(*it);
        int pos= f.find("[",0);
        if (pos!=-1) f.truncate(pos-1);
	// eliminate fonts with a space in the name
	pos=f.find(" ",0);

        if (!newstrlist.contains(f)&&pos==-1)
	   newstrlist.append(f);
    }

    fontfield->insertStringList(newstrlist);
    delete p_fontdatabase;
    QString left=i18n("Left");
    QString right=i18n("Right");
    QString center=i18n("Center");
    textalignmentfield->insertItem(left);
    textalignmentfield->insertItem(center);
    textalignmentfield->insertItem(right);

    numberalignmentfield->insertItem(left);
    numberalignmentfield->insertItem(center);
    numberalignmentfield->insertItem(right);
    textalignmentlabel->setText(i18n("Text alignment:"));
    numberalignmentlabel->setText(i18n("Number alignment:"));
    separatorlabel->setText(i18n("Separator:"));
    precisionlabel->setText(i18n("Precision:"));
    QString yes=i18n("Yes");
    QString no=i18n("No");
    bepedanticfield->insertItem(yes);
    bepedanticfield->insertItem(no);
    storepasswordfield->insertItem(yes);
    storepasswordfield->insertItem(no);
    maximizedfield->insertItem(yes);
    maximizedfield->insertItem(no);
    separatorfield->insertItem(yes);
    separatorfield->insertItem(no);

    use_singleclickfield->insertItem(i18n("Singleclick"));
    use_singleclickfield->insertItem(i18n("Doubleclick"));
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Preferencesdialog");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
    timefield->setText(QString::fromUtf8(l2u(hk_class::defaulttimeformat()).c_str())),
    datefield->setText(QString::fromUtf8(l2u(hk_class::defaultdateformat()).c_str())),
    datetimefield->setText(QString::fromUtf8(l2u(hk_class::defaultdatetimeformat()).c_str()));
    localefield->setText(QString::fromUtf8(l2u(hk_class::locale()).c_str()));
    printcommandfield->setText(QString::fromUtf8(l2u(hk_report::printcommand()).c_str()));
    driverpathfield->setText(QString::fromUtf8(l2u(hk_drivermanager::path()).c_str()));
    bepedanticfield->setCurrentItem(hk_class::showpedantic()?0:1);
    maximizedfield->setCurrentItem(hk_visible::open_maximized_windows()?0:1);
    fontfield->setEditText(QString::fromUtf8(l2u(hk_font::defaultfontname()).c_str()));
    fontsizefield->setValue(hk_font::defaultfontsize());
    precisionfield->setValue(hk_dsdatavisible::defaultprecision());
    separatorfield->setCurrentItem(hk_dsdatavisible::defaultuse_numberseparator()?0:1);
    sizetypefield->setCurrentItem(hk_presentation::defaultsizetype()==hk_presentation::relative?0:1);
    measurefield->setCurrentItem(hk_class::measuresystem()==hk_class::cm?0:1);
    use_singleclickfield->setCurrentItem(hk_kdedblistview::use_singleclick()?0:1);
    snap2gridxfield->setValue(hk_presentation::snap2gridx());
    snap2gridyfield->setValue(hk_presentation::snap2gridy());
    automaticupdatefield->setCurrentItem(hk_class::default_automatic_data_update()?0:1);
  c->setGroup("Preferences");
  bool gc;
  gc=c->readBoolEntry("StorePassword",false);
  storepasswordfield->setCurrentItem(gc?0:1);

    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        defaultdriverfield->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
        if ((*it)==hk_class::defaultdriver())
            defaultdriverfield->setCurrentItem(di);
        di++;
    }

    list<hk_string>* encodelist =hk_report::fontencodinglist();
    encodingfield->clear();
    list<hk_string>::iterator eit=encodelist->begin();
    int i=0;
    while (eit!=encodelist->end())
    {
        encodingfield->insertItem(QString::fromUtf8(l2u((*eit)).c_str()));
        if ((*eit)==hk_report::fontencodingstring()) encodingfield->setCurrentItem(i);
        eit++;
        i++;
    }

    switch (hk_visible::defaulttextalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    textalignmentfield->setCurrentItem(i);

    switch (hk_visible::defaultnumberalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    numberalignmentfield->setCurrentItem(i);



}


hk_kdepreferencesdialog::~hk_kdepreferencesdialog()
{
// no need to delete child widgets, Qt does it all for us
}


void hk_kdepreferencesdialog::driverpathbutton_clicked()
{
//cout <<"driverpathbutton_clicked"<<endl;
    hk_drivermanager::show_driverselectdialog();
    driverpathfield->setText(hk_drivermanager::path().c_str());

}



void hk_kdepreferencesdialog::accept(void)
{
KConfig* c=kapp->config();
  c->setGroup("Preferencesdialog");
  c->writeEntry("Geometry",geometry());


        hk_class::set_defaultdatetimeformat(
            u2l(timefield->text().utf8().data()),
            u2l(datefield->text().utf8().data()),
            u2l(datetimefield->text().utf8().data())
            );
	 hk_class::set_locale(u2l(localefield->text().utf8().data()));
        hk_class::set_showpedantic( bepedanticfield->currentItem()==0);
        hk_visible::set_open_maximized_windows(maximizedfield->currentItem()==0);
        hk_report::set_fontencoding(u2l(encodingfield->currentText().utf8().data()));
        hk_report::set_printcommand(u2l(printcommandfield->text().utf8().data()));
        hk_drivermanager::set_path(u2l(driverpathfield->text().utf8().data()));
        hk_font::set_defaultfont(u2l(fontfield->currentText().utf8().data()),fontsizefield->value());
	hk_presentation::set_snap2gridx(snap2gridxfield->value());
	hk_presentation::set_snap2gridy(snap2gridyfield->value());
        hk_visible::alignmenttype a=hk_visible::alignleft;
        hk_class::set_default_automatic_data_update(automaticupdatefield->currentItem()==0);

        switch (textalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaulttextalignment(a);
    hk_presentation::set_defaultsizetype(sizetypefield->currentItem()==0?hk_presentation::relative:hk_presentation::absolute);
    hk_class::set_measuresystem(measurefield->currentItem()==0?hk_class::cm:hk_class::inch);

        a=hk_visible::alignleft;
        switch (numberalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaultnumberalignment(a);
        hk_dsdatavisible::set_defaultnumberformat(separatorfield->currentItem()==0,precisionfield->value());
        hk_class::set_defaultdriver(u2l(defaultdriverfield->currentText().utf8().data()));

        hk_class::save_preferences();
        hk_kdedblistview::set_use_singleclick(use_singleclickfield->currentItem()==0);
  c->setGroup("Preferences");
  c->writeEntry("StorePassword",(storepasswordfield->currentItem()==0));
  c->writeEntry("UseSingleclick",(use_singleclickfield->currentItem()==0));







QDialog::accept();
}


void hk_kdepreferencesdialog::keyPressEvent ( QKeyEvent * e )
{
  if (e->key()==Key_F1) help_clicked();
}



void hk_kdepreferencesdialog::help_clicked()
{
kapp->invokeHelp("options");
}

