// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdeqbe.h"
#include "hk_kdedbdesigner.h"
#include <hk_column.h>
#include<hk_database.h>
#include<hk_connection.h>
#include <qtable.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qlayout.h>
#include <klocale.h>
#include <qapplication.h>


class internalgrid:public QTable
{
public:
internalgrid(QWidget* parent,hk_kdeqbe* qbe, const char* name=0):QTable(parent,name)
   {
     p_qbe=qbe;
     viewport()->setAcceptDrops(true);
     installEventFilter(this);
   }
hk_kdeqbe* p_qbe;

protected:
bool delete_rows(void)
	{
	  QMemArray<int> myarray(0);
	  int i=0; int col=0;
	  int leftcol=999;
	  while (i<numSelections())
	  {
	  QTableSelection s=selection(i);
	  if (isColumnSelected(s.leftCol(),true))
	  {
	   myarray.resize(myarray.size()+s.numCols());
	   if (s.leftCol()<leftcol)leftcol=s.leftCol();
	   for (int c=s.leftCol();c<=s.rightCol();++c)
	     {
	      myarray[col]=c;
	      ++col;
	     }
	  }
	  ++i;
	  }
	  myarray.sort();
	  if (myarray.size()==0) return false;
	  removeColumns(myarray);
         setCurrentCell(currentRow(),leftcol);
 	 p_qbe->slot_has_changed();
	 return true;
	}


bool   eventFilter( QObject *o, QEvent *e )
	{
	  if (e->type()==QEvent::KeyPress)
          {
            QKeyEvent *ke = (QKeyEvent*)e;
            if (ke->key() == Key_Delete&& o->isWidgetType())
	    {

	       QWidget* w=(QWidget*)o;
	       while (w)
	       {
	       if ( w==this)
	       {
	         if (delete_rows()) return true;
		}
		w=w->parentWidget();
	       }
	    }
	  }

        return QTable::eventFilter(o,e);
       };




virtual void contentsDragEnterEvent(QDragEnterEvent* event)
   {
       event->accept(event->provides("application/x-hk_kdedbdesigner"));
   }

virtual void contentsDropEvent(QDropEvent* event)
{

   if (! event->encodedData("application/x-hk_kdedbdesigner"))
    {
      cerr <<"internalgrid event->encodedData==0 !!!"<<endl;
      return;
    }
   hk_string eventtxt=u2l(event->encodedData("application/x-hk_kdedbdesigner").data());
   long vupn;
   hk_string columnname;
   if (!(     hk_class::get_tagvalue(eventtxt,"VUPN",vupn)
         && hk_class::get_tagvalue(eventtxt,"VALUE",columnname)))
	 {
            hk_class::show_warningmessage("Error in drag&drop protocol");
            cerr <<eventtxt<<endl;
	    return;
	 }

    int dcol=columnAt(event->pos().x());
    p_qbe->add_column(dcol,vupn,columnname);
    event->acceptAction(true);

} // end drop Event


}; //  internalgrid END


class internalcombo: public QComboTableItem
{
public:
internalgrid* p_grid;
internalcombo(internalgrid *table, const QStringList &list, bool editable = FALSE ):QComboTableItem(table,list,editable)
   {
   p_grid=table;
   }

void setContentFromEditor( QWidget *w )
{

    if (!isEditable())
     {
       QComboTableItem::setContentFromEditor(w);
       return;
     }
    if ( w->inherits( "QComboBox" ) ) {
	QComboBox *cb = (QComboBox*)w;
	QString s=cb->currentText();
	if (!s.isEmpty() && s!=p_settext)
	{
	QStringList l;
	l.append(s);
	setStringList(l);
	setText( s );
	p_settext=s;
        p_grid->p_qbe->slot_has_changed();
	}

    }

}
private:
QString p_settext;
};



class hk_kdeqbeprivate
{
public:

hk_kdeqbeprivate()
	{
	  p_designer=NULL;
	}
hk_kdedbdesigner* p_designer;
internalgrid* p_table;
QSplitter* p_splitter;
QVBoxLayout* p_layout;
QStringList p_tablenames;

};

const int maxrows=15;
const int maxcolumns=64;

const int R_TABLE=0;
const int R_FIELDNAME=1;
const int R_ALIAS=2;
const int R_FUNCTION=3;
const int R_ORDER=4;
const int R_SHOW=5;
const int R_UPDATEVALUE=6;
const int R_CRITERIA=7;
const int R_OR=8;



hk_kdeqbe::hk_kdeqbe(QWidget* w,const char* n,WFlags f) :KParts::MainWindow(w,n,f),hk_qbe()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::hk_kdeqbe");
#endif
  p_private= new hk_kdeqbeprivate;
  p_private->p_layout=new QVBoxLayout(this);
  p_private->p_splitter=new QSplitter(this);
  p_private->p_layout->addWidget(p_private->p_splitter);
  p_private->p_splitter->setOrientation(QSplitter::Vertical);
  p_private->p_designer=new hk_kdedbdesigner(p_private->p_splitter);
  p_private->p_designer->set_presentation(this);
  p_private->p_table=new internalgrid(p_private->p_splitter,this);
  p_private->p_table->setNumRows(maxrows);
  p_private->p_table->setNumCols(maxcolumns);
  p_private->p_table->verticalHeader()->setLabel(R_TABLE,i18n("Table:"));
  p_private->p_table->verticalHeader()->setLabel(R_FIELDNAME,i18n("Fieldname:"));
  p_private->p_table->verticalHeader()->setLabel(R_ALIAS,i18n("Alias:"));
  p_private->p_table->verticalHeader()->setLabel(R_FUNCTION,i18n("Function:"));
  p_private->p_table->verticalHeader()->setLabel(R_ORDER,i18n("Order:"));
  p_private->p_table->verticalHeader()->setLabel(R_SHOW,i18n("Show:"));
  p_private->p_table->verticalHeader()->setLabel(R_UPDATEVALUE,i18n("Updatevalue:"));
  p_private->p_table->verticalHeader()->setLabel(R_CRITERIA,i18n("Criteria:"));
  p_private->p_table->verticalHeader()->setLabel(R_OR,i18n("Or:"));
  for (int k=R_TABLE;k<maxrows;++k)
   {
     p_private->p_table->setRowHeight(k,(int)(p_private->p_table->rowHeight(k)*1.5+0.5));
   }
  for (int k=R_OR+1;k<maxrows;++k)
   {
  	p_private->p_table->verticalHeader()->setLabel(k,"");
   }

  for (int k=0;k<p_private->p_table->numCols();++k)
   {
     init_column(k);
   }
  widget_specific_querytype_has_changed(hk_qbe::qt_select,hk_qbe::qt_select);
  connect(p_private->p_table, SIGNAL(valueChanged(int,int)),this,SLOT(value_changed(int,int)));
  connect(p_private->p_designer,SIGNAL(signal_definition_has_changed()),this, SLOT (datasourcedefiniton_changed()));
  connect(p_private->p_designer,SIGNAL(signal_field_doubleclicked(int,const hk_string&)),
  this, SLOT (add_column(int , const hk_string&)));
}



hk_kdeqbe::~hk_kdeqbe()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::~hk_kdeqbe");
#endif
delete p_private;
}




void hk_kdeqbe::init_column(int col)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::init_column");
#endif
  QStringList sl;
  p_private->p_table->horizontalHeader()->setLabel(col,"");
  QComboTableItem* citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(R_TABLE,col,citem);
  citem= new internalcombo(p_private->p_table,sl);
  citem->setEditable(true);
  p_private->p_table->setItem(R_FIELDNAME,col,citem);

  sl.clear();
  sl.append(i18n("Group"));
  sl.append(i18n("Sum"));
  sl.append(i18n("Count"));
  sl.append(i18n("Min"));
  sl.append(i18n("Max"));
  sl.append(i18n("Average"));
  sl.append(i18n("Condition"));
  citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(R_FUNCTION,col,citem);
  p_private->p_table->setColumnWidth(col,p_private->p_table->columnWidth(col)*2);
  sl.clear();
  sl.append(i18n("none"));
  sl.append(i18n("ascending"));
  sl.append(i18n("descending"));
  citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(R_ORDER,col,citem);
  sl.clear();
  sl.append(i18n("Yes"));
  sl.append(i18n("No"));
  QComboTableItem* ch=new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(R_SHOW,col,ch);
  p_private->p_table->setColumnWidth(col,160);
}



void hk_kdeqbe::set_datasource(hk_datasource* ds)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_datasource");
#endif
     hk_qbe::set_datasource(ds);
     hk_database* db=NULL;
     if (ds) db=ds->database();
     p_private->p_designer->set_database(db);
     p_private->p_designer->set_presentation(this);
}

void hk_kdeqbe::set_database(hk_database* db)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_datasource");
#endif
     hk_qbe::set_database(db);
     //p_private->p_designer->set_database(db);
     p_private->p_designer->set_presentation(this);
     widget_specific_querytype_has_changed(querytype(),querytype());
}




void hk_kdeqbe::add_datasource(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::add_datasource");
#endif
   p_private->p_designer->add_datasource();
}




void hk_kdeqbe::set_has_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_has_changed");
#endif
  hk_qbe::set_has_changed();
  if (! block_has_changed()) emit signal_qbe_has_changed();
}




void hk_kdeqbe::slot_has_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::slot_has_changed");
#endif
  set_has_changed();

}



void hk_kdeqbe::datasourcedefiniton_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::datasourcedefinition_changed");
#endif
  set_tablenames();
  set_has_changed();
}



void hk_kdeqbe::set_tablenamelist(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_tablenamelist");
#endif
 p_private->p_tablenames.clear();
  p_private->p_tablenames.append("");
  list<hk_datasource*>* dslist=datasources();
  list<hk_datasource*>::iterator it=dslist->begin();
  while (it!=dslist->end())
  {
    p_private->p_tablenames.append(QString::fromUtf8(l2u(
    unique_shortdatasourcename((*it)->presentationnumber())).c_str()));
    ++it;
  }
}

void hk_kdeqbe::set_tablenames(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_tablenames");
#endif
  set_tablenamelist();
  for (int k=0;k<p_private->p_table->numCols();++k)
  {

    QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(R_TABLE,k));
    QString current=item->currentText();
    init_tablenames(k);
    int i=p_private->p_tablenames.findIndex(current);
    if (i>-1)item->setCurrentItem(i);
  }
}

void hk_kdeqbe::init_tablenames(int col)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::init_tablenames");
#endif
   QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(R_TABLE,col));
    item->setStringList(p_private->p_tablenames);
}


void hk_kdeqbe::value_changed(int row, int col)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::value_changed");
#endif
   set_has_changed();
   if (row==R_TABLE/*table*/)
      {
         set_columnnames(col);
      }
}



void hk_kdeqbe::set_columnnames(int col)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_columnnames("+longint2string(col)+")");
#endif
   set_has_changed();
   QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(R_FIELDNAME,col));
   hk_string tbl=u2l(p_private->p_table->item(R_TABLE,col)->text().utf8().data());
   hk_datasource* ds= get_datasource_by_shortname(tbl);
  ((QComboTableItem*)p_private->p_table->item(R_FIELDNAME,col))->setEditable(tbl=="");

   QStringList strlist;
    strlist.append("");
    if (ds)
    {
     list<hk_column*>* collist=ds->columns();
     if (collist)
     {
      strlist.append("*");
      list<hk_column*>::iterator it=collist->begin();
      while (it!=collist->end())
      {
       strlist.append(QString::fromUtf8(l2u((*it)->name()).c_str()));
       ++it;
      }
     }
    }
   item->setStringList(strlist);
}


  void hk_kdeqbe::widget_specific_querytype_has_changed(enum_querytype ,enum_querytype nt)
  {
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::widget_specific_querytype_has_changed");
#endif

  if (!database())
    {
     //cerr <<"no database"<<endl;
     return;
    }
    bool s_alias=database()->connection()->server_supports(hk_connection::SUPPORTS_SQL_ALIAS);
    bool s_where=database()->connection()->server_supports(hk_connection::SUPPORTS_SQL_WHERE);
    bool s_groupby=database()->connection()->server_supports(hk_connection::SUPPORTS_SQL_GROUP_BY);
    bool s_orderby=database()->connection()->server_supports(hk_connection::SUPPORTS_SQL_ORDER_BY);
    //cerr <<"a:"<<s_alias<<" w:"<<s_where<<" g:"<<s_groupby<<" o:"<<s_orderby<<endl;
       switch (nt)
      {
        case qt_select:
			p_private->p_table->showRow(R_ALIAS);//Alias
			p_private->p_table->hideRow(R_FUNCTION);//Function
			p_private->p_table->showRow(R_ORDER);//Order
			p_private->p_table->showRow(R_SHOW);//show
			p_private->p_table->hideRow(R_UPDATEVALUE);//UpdateValue
			break;
        case qt_groupselect:
			p_private->p_table->showRow(R_ALIAS);//Alias
			p_private->p_table->showRow(R_FUNCTION);//Function
			p_private->p_table->showRow(R_ORDER);//Order
			p_private->p_table->hideRow(R_SHOW);//show
			p_private->p_table->hideRow(R_UPDATEVALUE);//UpdateValue
			break;
	case qt_update:
			p_private->p_table->hideRow(R_ALIAS);//Alias
			p_private->p_table->hideRow(R_FUNCTION);//Function
			p_private->p_table->hideRow(R_ORDER);//Order
			p_private->p_table->hideRow(R_SHOW);//show
			p_private->p_table->showRow(R_UPDATEVALUE);//UpdateValue
			break;
	case qt_delete:
			p_private->p_table->hideRow(R_ALIAS);//Alias
			p_private->p_table->hideRow(R_FUNCTION);//Function
			p_private->p_table->hideRow(R_ORDER);//Order
			p_private->p_table->hideRow(R_SHOW);//show
			p_private->p_table->hideRow(R_UPDATEVALUE);//UpdateValue
      }

   if (!s_alias)   p_private->p_table->hideRow(R_ALIAS);
   if (!s_groupby)   p_private->p_table->hideRow(R_FUNCTION);
   if (!s_orderby)   p_private->p_table->hideRow(R_ORDER);
   if (!s_where)
     {
         for(int i=R_CRITERIA;i<maxrows;++i)
		p_private->p_table->hideRow(i);//WHERE Fields

     }
  emit signal_qbetype_has_changed();
  }



void hk_kdeqbe::set_columnvalues(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_columnvalues");
#endif
  set_block_has_changed(true);
  clear_definition(false);
  for (int i=0;i<p_private->p_table->numCols();++i)
  {
    if ( ((QComboTableItem*)(p_private->p_table->item(R_FIELDNAME,i)))->currentItem()>0 // field
          || !(((QComboTableItem*)(p_private->p_table->item(R_FIELDNAME,i)))->currentText().isEmpty())
       )
     {

        hk_qbedataclass cl;
	hk_datasource* ds=get_datasource_by_shortname(u2l(p_private->p_table->item(R_TABLE,i)->text().utf8().data()));
	if (ds)
	{
	  cl.table=ds->presentationnumber();
	}  else cl.table=-1;
	cl.field=u2l(p_private->p_table->item(R_FIELDNAME,i)->text().utf8().data());
	if (p_private->p_table->item(R_ALIAS,i))cl.alias=u2l(p_private->p_table->item(R_ALIAS,i)->text().utf8().data());
	switch(((QComboTableItem*)(p_private->p_table->item(R_FUNCTION,i)))->currentItem())
	{
	  case 0: cl.functiontype=ft_group;break;
	  case 1: cl.functiontype=ft_sum;break;
	  case 2: cl.functiontype=ft_count;break;
	  case 3: cl.functiontype=ft_min;break;
	  case 4: cl.functiontype=ft_max;break;
	  case 5: cl.functiontype=ft_condition;break;
	}
	switch(((QComboTableItem*)(p_private->p_table->item(R_ORDER,i)))->currentItem())
	{
	  case 0: cl.order=none;break;
	  case 1: cl.order=ascending;break;
	  case 2: cl.order=descending;break;
	}
	cl.show=(((QComboTableItem*)(p_private->p_table->item(R_SHOW,i)))->currentItem()==0);


	if (p_private->p_table->item(R_UPDATEVALUE,i))cl.updatevalue=u2l(p_private->p_table->item(R_UPDATEVALUE,i)->text().utf8().data());
	int endconditions=R_CRITERIA;
	for (int c=R_CRITERIA;c<maxrows;++c)
	  {
	    hk_string condi= trim(u2l(p_private->p_table->text(c,i).utf8().data()));
	    if (condi.size()>0) endconditions=c;

	  }

         for(int c=R_CRITERIA;c<=endconditions;++c)
	 	{
		  hk_string condi= trim(u2l(p_private->p_table->text(c,i).utf8().data()));
		  cl.conditions.insert(cl.conditions.end(),condi);
		}
        add_definition(&cl);
     }
  }
  set_block_has_changed(false);
}

void hk_kdeqbe::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::loaddata");
#endif
   hk_qbe::loaddata(definition);
   list<hk_qbe::hk_qbedataclass>::const_iterator it=definitionlist()->begin();
   int counter=0;
   set_tablenames();
   while (it!=definitionlist()->end())
   {
	QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(R_TABLE,counter));
	int i=p_private->p_tablenames.findIndex(QString::fromUtf8(l2u(unique_shortdatasourcename((*it).table)).c_str()));

        if (i>-1)
	   {
	      item->setCurrentItem(i);  // set tablename
	      set_columnnames(counter);
	   }

	item=(QComboTableItem*)(p_private->p_table->item(R_FIELDNAME,counter));

	i=-1;
	for (int k=0;k<item->count();++k)
	  {
	    if (item->text(k)==QString::fromUtf8(l2u((*it).field).c_str()))
	      i=k;
	  }
        if (i>-1)
	   {
	      item->setCurrentItem(i);  // set fieldname
	   }
	 if ((*it).table==-1)
	  {
	    QStringList strlist;
            strlist.append("");
	    strlist.append(QString::fromUtf8(l2u((*it).field).c_str()));
            item->setEditable(true);
	    item->setStringList(strlist);
	    item->setCurrentItem(1);
	  }
	//set alias
	p_private->p_table->setText(R_ALIAS,counter,QString::fromUtf8(l2u((*it).alias).c_str()));

	//set functiontype
	i=0;
	switch ((*it).functiontype)
	{
	case ft_group:i=0;break;
	case ft_sum:i=1;break;
	case ft_count:i=2;break;
	case ft_min:i=3;break;
	case ft_max:i=4;break;
	case ft_avg:i=5;break;
	case ft_condition:i=6;break;
        }
	item=(QComboTableItem*)(p_private->p_table->item(R_FUNCTION,counter));
	item->setCurrentItem(i);

	// set order
	item=(QComboTableItem*)(p_private->p_table->item(R_ORDER,counter));
	switch ((*it).order)
	{
	case none: i=0;break;
	case ascending: i=1;break;
	case descending: i=2;break;
	}
	item->setCurrentItem(i);

	//set show
	item=(QComboTableItem*)(p_private->p_table->item(R_SHOW,counter));
	if ((*it).show) i=0; else i=1;
	item->setCurrentItem(i);
	//set updatevalue
	p_private->p_table->setText(R_UPDATEVALUE,counter,QString::fromUtf8(l2u((*it).updatevalue).c_str()));
        vector<hk_string>::iterator condit;
	vector<hk_string> l=(*it).conditions;
	condit=l.begin();
	i=R_CRITERIA;
	while( condit!=l.end())
	{
	 p_private->p_table->setText(i,counter,QString::fromUtf8(l2u((*condit)).c_str()));
	 ++condit;++i;
	}

    ++it;++counter;
   }
  emit (signal_distinct_has_changed());
}

void hk_kdeqbe::add_column(int table, const hk_string& columnname)
{
  int pos=0;
    while(!p_private->p_table->text(R_TABLE,pos).isEmpty() &&pos<p_private->p_table->numCols())
   {
     ++pos;
   }

  add_column(pos,table,columnname);


}

void hk_kdeqbe::add_column(int pos, int table, const hk_string& columnname)
{
//return;
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::add_column");
#endif

p_private->p_table->insertColumns(pos);
init_column(pos);
init_tablenames(pos);
int i=p_private->p_tablenames.findIndex(QString::fromUtf8(l2u(unique_shortdatasourcename(table)).c_str()));
QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(R_TABLE,pos));
if (i>-1)
   {
      item->setCurrentItem(i);  // set tablename
      set_columnnames(pos);
   }

item=(QComboTableItem*)(p_private->p_table->item(R_FIELDNAME,pos));

i=-1;
for (int k=0;k<item->count();++k)
  {
    if (item->text(k)==QString::fromUtf8(l2u(columnname).c_str()))
      i=k;
  }
   if (i>-1)
   {
      item->setCurrentItem(i);  // set fieldname
   }
 p_private->p_table->setCurrentCell(p_private->p_table->currentRow(),pos);

}



void hk_kdeqbe::distinct_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::distinct_changed");
#endif
  set_distinct(!distinct());
}

