// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.23 $

#include "hk_kdequerypartwidget.h"
#include "hk_kdequerypartwidget.moc"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qclipboard.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmultilineedit.h>
#include <klocale.h>
#include <hk_actionquery.h>
#include <hk_connection.h>
#include "hk_kdegrid.h"
#include "hk_kdeqbe.h"
#include <kparts/genericfactory.h>
//#include "hk_kdegridpart.h"
#include <locale.h>

#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kmdichildview.h>
#include <kparts/partmanager.h>
#include "../hk_kdequerypart/hk_kdequerypart.h"

class hk_kdequerypartwidgetprivate
{
public:
        bool          p_autoclose;
        bool 	      p_nodesignmode;
        hk_kdegrid*   p_grid;
        hk_kdeqbe*      p_qbe;
        KParts::ReadWritePart* p_part;
	KParts::ReadWritePart* p_qbepart;
        Kate::View*   p_designkate;
	Kate::Document* p_katepart;
        bool          highlighting_set;
	bool          p_asview;
	hk_kdequerypart* p_querypart;


};



/*
 *  Constructs a hk_kdequerypartwidget which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdequerypartwidget::hk_kdequerypartwidget(hk_kdequerypart* part,QWidget* w,const char* n,WFlags f):QWidgetStack(w,n,f),hk_dsquery()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::hk_kdequerypartwidget");
    hkclassname("hk_kdequerypartwidget");
#endif
    p_private= new hk_kdequerypartwidgetprivate;
    p_private->p_querypart=part;
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    setFocusPolicy(StrongFocus);

 //p_private->p_querypart->setXMLFile(locate("data","hk_kdeclasses/hk_kdequerypart.rc"));

    KLibFactory* p_factory= KLibLoader::self()->factory( "libkatepart" );
    p_private->p_katepart = (Kate::Document *) p_factory->create (0L, "kate", "KTextEditor::Document");
    p_private->p_designkate=(Kate::View *)p_private->p_katepart->createView (this, 0L);
    p_private->p_designkate->setFocus();
    setName( "hk_kdequerypartwidget" );
    resize( 596, 480 );
    p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );
    p_private->p_part=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdegridpart", "KParts::ReadWritePart");
   if (!p_private->p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Grid part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now..."));
     exit(1);
    }
     p_factory= KLibLoader::self()->factory( "libhk_kdeqbepart" );
    p_private->p_qbepart=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdeqbepart", "KParts::ReadWritePart");
    p_private->p_grid = (hk_kdegrid*)p_private->p_part->widget();
    p_private->p_grid->set_enablingbehaviour(true,true);
    p_private->p_grid->hkclassname("grid");
    addWidget(p_private->p_grid);
//    p_design = new QMultiLineEdit(this);
    p_private->p_qbe = (hk_kdeqbe*)p_private->p_qbepart->widget();
    p_private->p_qbe->hkclassname("QBE");
    addWidget(p_private->p_designkate);
    addWidget(p_private->p_grid);
    p_private->p_autoclose =true;
    p_private->p_asview=false;
    p_designaction=NULL;
    p_viewaction=NULL;
    p_saveaction=NULL;
    p_saveasaction=NULL;
    p_printaction=NULL;
    p_qbeaction=NULL;
    p_distinctaction=NULL;
    p_addaction=NULL;
    p_qbetypeselectaction=NULL;
    p_qbetypeselect=NULL;
    p_copyaction=NULL;
    p_copybackendsqlaction=NULL;
    p_pasteaction=NULL;
    p_replaceaction=NULL;
    p_findaction=NULL;
    p_findnextaction=NULL;
    p_findpreviousaction=NULL;
    p_cutaction=NULL;
    p_undoaction=NULL;
    p_redoaction=NULL;
    p_selectallaction=NULL;
    p_configeditoraction=NULL;
    p_storeresultaction=NULL;

    set_nodesignmode(runtime_only());
    designbutton_clicked();
    connect( p_private->p_designkate->getDoc(), SIGNAL( textChanged() ), this, SLOT( query_changed() ) );
    connect (p_private->p_qbe,SIGNAL(signal_qbe_has_changed()),this, SLOT(qbe_has_changed()));
    p_private->p_designkate->setLineNumbersOn(true);
    p_private->highlighting_set=false;
    p_private->p_qbe->hide();


}


hk_kdequerypartwidget::~hk_kdequerypartwidget()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::~hk_kdequerypartwidget");
#endif
    removeWidget(p_private->p_designkate);
    p_private->p_designkate=NULL;
    delete p_private->p_katepart;
    hk_datasource* d=p_private->p_grid->datasource();

    if (d!=NULL)
    {
        if (!d->presentation())d->disable();
        if (p_private->p_asview ) p_private->p_grid->save_view(d->name(),false);
    }
    delete p_private->p_qbepart;
    p_private->p_grid=NULL;
    p_private->p_qbe=NULL;
    delete p_designaction;
    delete p_viewaction;
    delete p_saveaction;
    delete p_saveasaction;
delete p_private;
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::~hk_kdequerypartwidget END");
#endif

}


void hk_kdequerypartwidget::set_datasource(hk_datasource* d)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_datasource");
#endif
    hk_dsquery::set_datasource(d);
    p_private->p_grid->set_datasource(d);
    //p_private->p_qbe->set_datasource(d);
    hk_database* db=NULL;
    p_private->p_asview=false;
    if (d)
     {
      db=d->database();

      if (d->type()==hk_datasource::ds_view)
       {
       p_private->p_asview=true;
       p_private->p_grid->load_view();
       }
     }
    p_private->p_qbe->set_database(db);
    if (d!=NULL)
    {
    //p_private->p_designkate->getDoc()->blockSignals(true);
    if (d->sql().c_str())
     {
       p_private->p_designkate->getDoc()->setText(QString::fromUtf8(l2u(d->sql()).c_str()));
       p_private->p_designkate->getDoc()->clearUndo();
     }
    //p_private->p_designkate->getDoc()->blockSignals(false);
    }
    reset_has_changed();

}




void hk_kdequerypartwidget::designbutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::designbutton_clicked");
#endif
  set_mode(hk_presentation::designmode);
}

void hk_kdequerypartwidget::internal_set_designmode(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::internal_set_designmode");
#endif

    if (p_private->p_nodesignmode)
    {
        querybutton_clicked();
        return;
    }
    hk_datasource* d=p_private->p_grid->datasource();
    if (d!=NULL) d->disable();



    if (p_qbetypeselectaction)p_qbetypeselectaction->setEnabled(use_qbe());
    if (p_qbetypeselect)p_qbetypeselect->setEnabled(use_qbe());
    if (p_distinctaction)p_distinctaction->setEnabled(use_qbe());
    if (p_addaction)p_addaction->setEnabled(use_qbe());
    if (p_copyaction)p_copyaction->setEnabled(!use_qbe());
    if (p_cutaction)p_cutaction->setEnabled(!use_qbe());
    if (p_undoaction)p_undoaction->setEnabled(!use_qbe());
    if (p_redoaction)p_redoaction->setEnabled(!use_qbe());
    if (p_pasteaction)p_pasteaction->setEnabled(!use_qbe());
    if (p_replaceaction)p_replaceaction->setEnabled(!use_qbe());
    if (p_findaction)p_findaction->setEnabled(!use_qbe());
    if (p_findnextaction)p_findnextaction->setEnabled(!use_qbe());
    if (p_findpreviousaction)p_findpreviousaction->setEnabled(!use_qbe());
    if (p_selectallaction)p_selectallaction->setEnabled(!use_qbe());
    if (p_configeditoraction)p_configeditoraction->setEnabled(!use_qbe());
    if (p_storeresultaction)p_storeresultaction->setEnabled(false);







    if (use_qbe())
    {
     p_private->p_querypart->setXMLFile(locate("data","hk_kdeclasses/hk_kdequerypartqbe.rc"));
     //if (p_private->p_querypart->manager())p_private->p_querypart->manager()->setActivePart(p_private->p_querypart);

	set_block_has_changed(true);
	raiseWidget(p_private->p_qbe);
	set_block_has_changed(false);
    }
    else
    {
     p_private->p_querypart->setXMLFile(locate("data","hk_kdeclasses/hk_kdequerypartsql.rc"));
     //if (p_private->p_querypart->manager())p_private->p_querypart->manager()->setActivePart(p_private->p_querypart);
        raiseWidget(p_private->p_designkate);
        p_private->p_designkate->setFocus();

    if (p_designaction)p_designaction->setChecked(true);
    unsigned int i=0;
    Kate::Document *doc = p_private->p_designkate->getDoc();
    if (!p_private->highlighting_set)
    {
        while (i<doc->hlModeCount())
        {
            if (doc->hlModeName(i)=="SQL")
            {
                doc->setHlMode(i);
            }
            ++i;
        }
        p_private->highlighting_set=true;
    }
   } // end else if (use_qbe())
   if (p_designaction)
      p_designaction->setChecked(true);
   if (p_qbeaction)
   {
   p_qbeaction->blockSignals(true);
   p_qbeaction->setChecked(use_qbe());
   p_qbeaction->blockSignals(false);
   p_qbeaction->setEnabled(true);

   }
   set_caption();

}


void hk_kdequerypartwidget::querybutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::querybutton_clicked");
#endif
  set_mode(hk_presentation::viewmode);

}

void hk_kdequerypartwidget::internal_set_viewmode(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::internal_set_viewmode");
#endif
    if (p_qbetypeselectaction)p_qbetypeselectaction->setEnabled(false);
    if (p_qbetypeselect)p_qbetypeselect->setEnabled(false);
    if (p_distinctaction)p_distinctaction->setEnabled(false);
    if (p_addaction)p_addaction->setEnabled(false);


    if (p_copyaction)p_copyaction->setEnabled(false);
    if (p_cutaction)p_cutaction->setEnabled(false);
    if (p_undoaction)p_undoaction->setEnabled(false);
    if (p_redoaction)p_redoaction->setEnabled(false);
    if (p_pasteaction)p_pasteaction->setEnabled(false);
    if (p_replaceaction)p_replaceaction->setEnabled(false);
    if (p_findaction)p_findaction->setEnabled(false);
    if (p_findnextaction)p_findnextaction->setEnabled(false);
    if (p_findpreviousaction)p_findpreviousaction->setEnabled(false);
    if (p_selectallaction)p_selectallaction->setEnabled(false);
    if (p_configeditoraction)p_configeditoraction->setEnabled(false);
    if (p_qbeaction)p_qbeaction->setEnabled(false);
    if (p_storeresultaction)p_storeresultaction->setEnabled(true);









    hk_datasource* d=p_private->p_grid->datasource();
    bool actionquery=false;

    if (!use_qbe())
    {
    hk_string tst_sql=u2l(p_private->p_designkate->getDoc()->text().utf8().data());
    hk_string separator=" \t\n";
    hk_string::size_type startpos=hk_string::npos;
    for (unsigned int tt=0;tt<tst_sql.size();tt++)
    {
        tst_sql[tt]=toupper(tst_sql[tt]);
    }
   startpos=tst_sql.find_first_not_of(separator);
   if (startpos==hk_string::npos)
      {
        set_designmode();
	return;
      }
   hk_string::size_type endpos=tst_sql.find_first_of(separator,startpos+1);
    hk_string value=tst_sql.substr(startpos,endpos-startpos);

    actionquery=(value=="ALTER");
    if (!actionquery) actionquery=(value=="DROP");
    if (!actionquery) actionquery=(value=="INSERT");
    if (!actionquery) actionquery=(value=="UPDATE");
    if (!actionquery) actionquery=(value=="CREATE");
    if (!actionquery) actionquery=(value=="GRANT");
    if (!actionquery) actionquery=(value=="REVOKE");
    if (!actionquery) actionquery=(value=="FLUSH");
    }// !use_qbe end

    if (d!=NULL)
    {
        if ((!use_qbe()&&!actionquery)||
	((use_qbe()&& p_private->p_qbe &&
	(p_private->p_qbe->querytype()==hk_qbe::qt_select
	||p_private->p_qbe->querytype()==hk_qbe::qt_groupselect)))
	)
        {
            if (use_qbe()&& p_private->p_qbe)
	    {
              p_private->p_qbe->set_columnvalues();
	      if (d->set_query(p_private->p_qbe))
	      {
	        p_private->p_designkate->getDoc()->blockSignals(true);
                if (d->sql().c_str())p_private->p_designkate->getDoc()->setText(QString::fromUtf8(l2u(d->sql()).c_str()));
                p_private->p_designkate->getDoc()->blockSignals(false);
	      }
	      else
	      {//cerr <<"use_qbe="<<use_qbe()<<" p_qbe="<<p_private->p_qbe<<endl;
	        if (!runtime_only())
		{
		  set_designmode();
		  return;
		}
	      }
	    }
	    else
	    {
	     d->set_sql(u2l(p_private->p_designkate->getDoc()->text().utf8().data()),true);
	    }
            if ( !d->enable())
            {
                hk_string reason=hk_translate("Query could not be executed")+"\n"+hk_translate("Servermessage: ")+d->database()->connection()->last_servermessage();
                show_warningmessage(reason);
                if (!runtime_only())
                {
                    set_designmode();
                    return;
                }

            }
        }
        else
        {
            hk_actionquery* q=d->database()->new_actionquery();
            if (q!=NULL)
            {
                hk_string sql=u2l(p_private->p_designkate->getDoc()->text().utf8().data());
	      if (p_private->p_qbe&&use_qbe())
	      {
	      p_private->p_qbe->set_columnvalues();
	       if(p_private->p_qbe->querytype()==hk_qbe::qt_update
	       ||p_private->p_qbe->querytype()==hk_qbe::qt_delete)
                if (!p_private->p_qbe->create_sql(sql))
		{
	         set_designmode();
		 return;
		}
	        if (!show_yesnodialog(hk_translate(
"Warning: This function is not stable:\nAre you sure that you want to execute the following SQL code?\n\n")+sql,true))
		{
	          set_designmode();
		  return;
	      	}
  	      }
		q->set_sql(sql,true);
                if (q->execute())
                    show_warningmessage(hk_class::hk_translate("Query was successful"));
                else
                    show_warningmessage(hk_class::hk_translate("Query could not be executed")+"\n"+hk_translate("Servermessage: ")+d->database()->connection()->last_servermessage());
                delete q;
                if (!runtime_only())
                {
                    set_designmode();
                    return;
                }
            }

        }
    }
    raiseWidget(p_private->p_grid);
       setChildGeometries();

    set_caption();
    if (p_viewaction)p_viewaction->setChecked(true);
    p_private->p_querypart->setXMLFile(locate("data","hk_kdeclasses/hk_kdequerypart.rc"));

}


bool  hk_kdequerypartwidget::set_mode(enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_mode");
#endif
    hk_dsmodevisible::set_mode(s);
    switch (s)
    {
	case hk_dsmodevisible::designmode :
					internal_set_designmode();
					break;
	case hk_dsmodevisible::viewmode :
					internal_set_viewmode();
					break;

    }

return true;
}






void hk_kdequerypartwidget::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::before_source_vanishes");
#endif
    if (has_changed())
    {
        save_query();
        reset_has_changed();

    }

    if (p_private->p_autoclose)
        close();
    else
    {
        hk_datasource* d=datasource();
        if (d!=NULL)d->disable();
        set_datasource(NULL);

    }
    //hk_dsquery::before_source_vanishes();
}


void hk_kdequerypartwidget::query_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::query_changed");
#endif
    set_has_changed();
    //p_private->p_saveaction->setEnabled(true);

    if (datasource()!=NULL)  datasource()->set_sql(u2l(p_private->p_designkate->getDoc()->text().utf8().data()),true);
}


void hk_kdequerypartwidget::closeEvent ( QCloseEvent* e)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::closeEvent");
#endif
    if (has_changed())
    {
        save_query();
        reset_has_changed();

    }
    delete p_private->p_katepart;
    p_private->p_katepart=NULL;


    QWidgetStack::closeEvent(e);
   emit signal_closed(this);

}


void hk_kdequerypartwidget::set_nodesignmode(bool d)
{
    p_private->p_nodesignmode=d;

}


bool hk_kdequerypartwidget::save_query(const hk_string& n,bool ask)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::save_query");
#endif
    set_caption();
    if (p_private->p_qbe) p_private->p_qbe->set_columnvalues();
    if (use_qbe()&& p_private->p_qbe)
	    {
	      p_private->p_grid->datasource()->set_query(p_private->p_qbe);
	    }
     return hk_dsquery::save_query(n,ask);
}


bool hk_kdequerypartwidget::load_query(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::load_query");
#endif
   set_block_has_changed(true);

    bool r= hk_dsquery::load_query();
    hk_datasource* d=datasource();
    if (d==NULL)return false;
    //p_private->p_designkate->getDoc()->blockSignals(true);
    if (d->sql().c_str())
    {
    p_private->p_designkate->getDoc()->setText(QString::fromUtf8(l2u(d->sql()).c_str()));
    p_private->p_designkate->getDoc()->clearUndo();

    }
    //p_private->p_designkate->getDoc()->blockSignals(false);
    p_private->p_grid->set_font(hk_font());
    set_caption();
    reset_has_changed();
    set_block_has_changed(false);
    p_saveaction->setEnabled(false);
 return r;
}


void hk_kdequerypartwidget::savebutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::savebutton_clicked");
#endif
    if (save_query("",false))
    {
        reset_has_changed();
        //p_private->p_saveaction->setEnabled(false);
    }
    set_caption();
}


void hk_kdequerypartwidget::saveasbutton_clicked(void)
{
    if (!p_private->p_grid->datasource()) return;
    hk_string oldname=p_private->p_grid->datasource()->name();
    p_private->p_grid->datasource()->set_name("");
    if (save_query("",true))
    {
        reset_has_changed();

        set_caption();

    }
    else
    {
        p_private->p_grid->datasource()->set_name(oldname);

    }

}


void hk_kdequerypartwidget::close_query(void)
{
    close();
}


void hk_kdequerypartwidget::set_caption(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::set_caption");
#endif
    hk_datasource* d=datasource();
    if (d!=NULL)
    {
        QString n=((d->type()==hk_datasource::ds_view)? i18n("View - "):i18n("Query - "));
        n+=QString::fromUtf8(l2u(d->name()).c_str());
	QString name=QString::fromUtf8(l2u(d->database()->connection()->drivername()).c_str())+" "+n;
        setCaption(name);
    	KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
        if (v) v->setCaption(n);
 }

}


void hk_kdequerypartwidget::print(void)
{

#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::print");
#endif
    if (in_designmode())
    {
// this is a workaround: otherwise float numbers in the postscript file
// would be created with locale dots (e.g. a comma in Germany) from Qt
        hk_string origlocale=setlocale(LC_NUMERIC,NULL);
        hk_string origmonetarylocale=setlocale(LC_MONETARY,NULL);
        setlocale(LC_NUMERIC,"C");
        setlocale(LC_MONETARY,"C");
        p_private->p_designkate->getDoc()->printDialog();
//workaround part 2
        setlocale(LC_NUMERIC,origlocale.c_str());
        setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
    }
    else
        p_private->p_grid->print_grid();
}


void    hk_kdequerypartwidget::keyPressEvent ( QKeyEvent * e )
{

  QWidgetStack::keyPressEvent(e);
}

hk_dsgrid *hk_kdequerypartwidget::grid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::grid");
#endif
return p_private->p_grid;
}



bool hk_kdequerypartwidget::in_designmode(void) const
{
return mode()==hk_dsmodevisible::designmode;
}


void hk_kdequerypartwidget::set_autoclose(bool c)
{
p_private->p_autoclose=c;
}


bool hk_kdequerypartwidget::autoclose(void) const
{
return p_private->p_autoclose;

}

void hk_kdequerypartwidget::action_useqbe(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeqbe::action_useqbe");
#endif
  if (!use_qbe() && !show_yesnodialog(
  			hk_translate("If you change to the QBE window your SQL statement will be lost. Continue?"),true))
	{
	    p_qbeaction->blockSignals(true);
    	    p_qbeaction->setChecked(use_qbe());
            p_qbeaction->blockSignals(false);
        return;
	}

     set_use_qbe(!use_qbe());


     if (in_designmode()) designbutton_clicked();
    p_qbeaction->blockSignals(true);
    p_qbeaction->setChecked(use_qbe());
    p_qbeaction->blockSignals(false);
    emit signal_qbetypechanged();
}


hk_qbe*  hk_kdequerypartwidget::qbe(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::qbe()");
#endif
 return p_private->p_qbe;
}

hk_kdeqbe*  hk_kdequerypartwidget::kdeqbe(void) const
{
#ifdef HK_DEBUG
    hkdebug("hk_kdequerypartwidget::kdeqbe()");
#endif
 return p_private->p_qbe;
}


void hk_kdequerypartwidget::qbe_has_changed(void)
{
  set_has_changed();
}


void hk_kdequerypartwidget::show()
{
  set_block_has_changed(true);
  QWidgetStack::show();
  set_block_has_changed(false);
}

void hk_kdequerypartwidget::showMaximized()
{
  set_block_has_changed(true);
  QWidgetStack::showMaximized();
  set_block_has_changed(false);

}

void hk_kdequerypartwidget::set_has_changed(enum_has_changed forcesetting)
{
//cerr <<"hk_kdequerypartwidget::set_has_changed"<<endl;
hk_dsquery::set_has_changed(forcesetting);
 if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& has_changed());
}



void hk_kdequerypartwidget::reset_has_changed(void)
{
  hk_dsquery::reset_has_changed();
  if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& has_changed());
}


void hk_kdequerypartwidget::copy_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->copy();
}


void hk_kdequerypartwidget::copybackendsql_clicked(void)
{
if (datasource())
   {
	QApplication::clipboard()->setText(QString::fromUtf8(l2u(datasource()->backendsql()).c_str()));
   }
}

void hk_kdequerypartwidget::paste_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->paste();
}

void hk_kdequerypartwidget::replace_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->replace();
}

void hk_kdequerypartwidget::find_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->find();
}

void hk_kdequerypartwidget::findnext_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->findAgain();
}

void hk_kdequerypartwidget::findprevious_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->findPrev();
}

void hk_kdequerypartwidget::cut_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->cut();
}

void hk_kdequerypartwidget::undo_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->undo();

}

void hk_kdequerypartwidget::redo_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->redo();
}

void hk_kdequerypartwidget::selectall_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->selectAll();
}

void hk_kdequerypartwidget::configeditor_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->configDialog();
}


void hk_kdequerypartwidget::show_widget(void)
{
  show();
}

void hk_kdequerypartwidget::hide_widget(void)
{
  hide();
}

void hk_kdequerypartwidget::close_widget(void)
{
  close();
}


void hk_kdequerypartwidget::storeresult_clicked(void)
{
  if (!datasource()) return;
  datasource()->database()->copy_table(datasource(),true,false,true);
}
