// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_KDESUBFORMDIALOG_H
#define HK_KDESUBFORMDIALOG_H
#include "hk_kderelationdialogbase.h"
#include <hk_column.h>
#include <list>
class hk_kdedatasourceframe;
class hk_subform;
class hk_form;


class hk_kdesubformdialog : public hk_kderelationdialogbase
{
    Q_OBJECT

public:
    hk_kdesubformdialog( hk_subform*, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~hk_kdesubformdialog();
    int masterindex(const QString&);
    int slaveindex(const QString&);

public slots:
    virtual void ok_button_clicked();
    virtual void slot_data_changed(int,int);
  void add_row(void);

protected:
void keyPressEvent(QKeyEvent * );
bool eventFilter(QObject* object,QEvent* event);
  
  
  
private:
  void set_stringlist(QStringList* strlist,list<hk_column*>*);
  void set_existing_fields(void);
  int    textposition(QStringList* ,const hk_string&  );
void delete_rows(void);
hk_datasource* p_masterds;
hk_datasource* p_slaveds;
hk_subform* p_subform;
hk_form* p_form;
QStringList		p_mastercollist;
QStringList		p_slavecollist;
};

#endif // hk_kdesubformdialog_H
