// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
// $Revision: 1.7 $
#include "hk_kdetaborder.h"
#include "hk_kdesimpleform.h"
#include <hk_class.h>

#include <qlistview.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>

#include <kiconloader.h>

/* 
 *  Constructs a hk_kdetaborder which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdetaborder::hk_kdetaborder( hk_kdesimpleform*f, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kdetaborderdialogbase( parent, name, modal, fl )
{
p_form=f;
 KIconLoader* loader=KGlobal::iconLoader();
 loader->addAppDir("hk_kdeclasses");
 upbutton->setIconSet(loader->loadIcon("up",KIcon::Desktop));
 downbutton->setIconSet(loader->loadIcon("down",KIcon::Desktop));
 addbutton->setIconSet(loader->loadIcon("next",KIcon::Desktop));
 deletebutton->setIconSet(loader->loadIcon("previous",KIcon::Desktop));

taborderlist->setSorting(-1);
if (!p_form) hk_class::show_warningmessage("hk_kdetaborder ERROR form is NULL!!!");
p_has_changed=false;
init();cerr <<"nach init"<<endl;
check_buttons();
}


void hk_kdetaborder::init(void)
{
list<int> t=p_form->taborder();
list<int>::reverse_iterator it=t.rbegin();
while (it!=t.rend())
{
  hk_visible* v=p_form->get_visible(*it);
  QString n;
     n.setNum(*it);
  if (v)
    new QListViewItem(taborderlist,n,QString::fromUtf8(l2u(v->identifier()).c_str()));
  ++it;
}
taborderlist->setAllColumnsShowFocus(true);
taborderlist->setCurrentItem(taborderlist->firstChild());

// now set the non-used field names

list<hk_visible*>* l=p_form->visibles();
list<int> vlist;
list<hk_visible*>::iterator lit=l->begin();
while (lit!=l->end())
{
if ((*lit)->type()!=hk_visible::textlabel)
vlist.push_back((*lit)->presentationnumber());
++lit;
}


it=t.rbegin();
while (it!=t.rend())
{
  vlist.remove(*it);
  ++it;
}


t=vlist;
it=t.rbegin();
while (it!=t.rend())
{
  hk_visible* v=p_form->get_visible(*it);
  QString n;
     n.setNum(*it);
  if (v)
    new QListViewItem(baselist,n,QString::fromUtf8(l2u(v->identifier()).c_str()));
  ++it;
}

baselist->setAllColumnsShowFocus(true);
taborderlist->setFocus();






}

/*  
 *  Destroys the object and frees any allocated resources
 */
hk_kdetaborder::~hk_kdetaborder()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void hk_kdetaborder::add_clicked()
{
   if (!baselist->currentItem()) return;
   QListViewItem* c=baselist->currentItem();
   new QListViewItem(taborderlist,taborderlist->lastItem(),c->text(0),c->text(1));
   baselist->setCurrentItem(c->itemAbove());
   delete c;
    
    p_has_changed=true;
    check_buttons();
}

/*
 * public slot
 */
void hk_kdetaborder::check_buttons()
{
    deletebutton->setEnabled(taborderlist->currentItem());
    upbutton->setEnabled(taborderlist->currentItem() && taborderlist->currentItem()->itemAbove());
    downbutton->setEnabled(taborderlist->currentItem() && taborderlist->currentItem()->itemBelow());
    addbutton->setEnabled(baselist->currentItem());
    okbutton->setEnabled(p_has_changed);
    QWidget* w=NULL; 
    if (taborderlist->currentItem() )
       w=dynamic_cast<QWidget*>(p_form->get_visible(taborderlist->currentItem()->text(0).toInt()));
    
    if ( baselist->currentItem() && baselist->hasFocus())
       w=dynamic_cast<QWidget*>(p_form->get_visible(baselist->currentItem()->text(0).toInt()));
    p_form->set_focus(w,false);
}

/*
 * public slot
 */
void hk_kdetaborder::delete_clicked()
{
   if (!taborderlist->currentItem()) return;
   QListViewItem* c=taborderlist->currentItem();
   new QListViewItem(baselist,c->text(0),c->text(1));
   taborderlist->setCurrentItem(c->itemAbove());
   delete c;
    
    p_has_changed=true;
    check_buttons();
}

/*
 * public slot
 */
void hk_kdetaborder::down_clicked()
{
   if (!taborderlist->currentItem()) return;
   if (taborderlist->currentItem()->itemBelow())
       taborderlist->currentItem()->moveItem(taborderlist->currentItem()->itemBelow());
    p_has_changed=true;
   check_buttons();
}

/*
 * public slot
 */
void hk_kdetaborder::up_clicked()
{
   if (!taborderlist->currentItem()) return;
   if (taborderlist->currentItem()->itemAbove())
    if (taborderlist->currentItem()->itemAbove()->itemAbove())
       taborderlist->currentItem()->moveItem(taborderlist->currentItem()->itemAbove()->itemAbove());
    else
    {
       QListViewItem* i=taborderlist->currentItem();
       taborderlist->takeItem(i);
       taborderlist->insertItem(i);
       taborderlist->setCurrentItem(i);   
    }   
    p_has_changed=true;
       
   check_buttons();
}

void hk_kdetaborder::ok_clicked()
{
  list<int> i;
  
  QListViewItemIterator it(taborderlist);
  while (it.current())
  {
    QListViewItem* current=it.current();
    i.push_back(current->text(0).toInt());
    ++it;
  }
  p_form->set_taborder(i);
  accept();
}


