// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_KDEDATE
#define HK_KDEDATE
#include "hk_dsdate.h"
#include <kdatepicker.h>

class hk_kdedate : public KDatePicker, public hk_dsdate
{
Q_OBJECT

public:
  hk_kdedate(QWidget* wid,hk_form* form=NULL);
virtual void show_widget(void);
virtual void hide_widget(void);
virtual bool close_widget(void);
	virtual void set_value(const hk_string&);
	virtual hk_string value(void);


protected:
        virtual void  resizeEvent (QResizeEvent *);
        virtual void  moveEvent ( QMoveEvent * ) ;
        virtual bool  widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight);
        virtual bool  widget_specific_row_change(void);
        virtual void  widget_specific_enable_disable(void);
        virtual void            mousePressEvent(QMouseEvent*);
        virtual void            mouseDoubleClickEvent(QMouseEvent*);
     virtual void focusInEvent ( QFocusEvent * );
     virtual void focusOutEvent ( QFocusEvent * );
        virtual void widget_specific_backgroundcolour_changed(const hk_colour&);
        virtual void widget_specific_foregroundcolour_changed(const hk_colour&);
        virtual void widget_specific_font_changed(void);
	virtual void widget_specific_enabled_changed(void);
	virtual bool	presentationmode_changed(void);

    protected slots:
        void     slot_data_changed(void);
        void slot_table_clicked(void);


private:
	        void    reposition(void);
        bool    p_widget_specific_row_change;

};
#endif //hk_kdedate
