// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.17 $
#ifndef KNODAMAINDOCKWINDOW_H
#define KNODAMAINDOCKWINDOW_H
#include "knodamaindockwindowbase.h"

class hk_kdetablepartwidget;
class hk_kdequerypartwidget;
class hk_kdeformpartwidget;
class hk_kdereportpartwidget;

typedef void show_dbfunction(int);

class knodamaindockwindow : public knodamaindockwindowbase
{
Q_OBJECT

public:
knodamaindockwindow(struct_commandlinefields* commandline=NULL,QWidget* parent=0L,const char* name=0L, WFlags f=WType_TopLevel|WDestructiveClose,const QString& dbname="",const QString& form="");
virtual ~knodamaindockwindow();
 
 hk_kdetablepartwidget* new_table(void);
 hk_kdequerypartwidget* new_query(bool as_view=false);
 hk_kdeformpartwidget*  new_form(void);
 hk_kdereportpartwidget*new_report(void);


public slots:

 virtual void setCaption(const QString&);
 virtual void slot_new_database(void);
 virtual void slot_delete_database(const QString&);


 virtual void slot_new_table(void);
 virtual void slot_delete_table(const QString&);
 virtual void slot_designmode_table(const QString&);
 virtual void slot_viewmode_table(const QString&);

 virtual void slot_new_query(void);
 virtual void slot_delete_query(const QString&);
 virtual void slot_designmode_query(const QString&);
 virtual void slot_viewmode_query(const QString&);

 virtual void slot_new_view(void);
 virtual void slot_delete_view(const QString&);
 virtual void slot_designmode_view(const QString&);
 virtual void slot_viewmode_view(const QString&);

 virtual void slot_new_form(void);
 virtual void slot_delete_form(const QString&);
 virtual void slot_designmode_form(const QString&);
 virtual void slot_viewmode_form(const QString&);

 virtual void slot_new_report(void);
 virtual void slot_delete_report(const QString&);
 virtual void slot_designmode_report(const QString&);
 virtual void slot_viewmode_report(const QString&);
 
virtual void rename_clicked();
virtual void importcsv_clicked();
virtual void exportcsv_clicked();
virtual void exportxml_clicked();
virtual void newpassworddialog_selected(void);
virtual void copy_clicked(void);
virtual void paste_clicked(void);
virtual void clipboarddata_has_changed(void);
virtual void slot_listbox_popup(QListViewItem*,const QPoint&);
virtual void databasesettings_clicked(void);
virtual void objecthandler_clicked(void);
virtual void newwindow_clicked(void); 
 void slot_childClosed(QWidget*);
 void slot_childClosed(KMdiChildView*);
virtual void settings_clicked(void);
virtual void show_drivers();
virtual void show_exportdbdrivers();
virtual void show_importdbdrivers();
 
 void slot_raise_form(const hk_string&); 
 protected slots:
 
 void slot_selection_changed(void);
 
 
 private:
 enum enum_function{f_connect,f_exportdb,f_importdb};
 void show_drivers(KPopupMenu* menu, enum_function);
hk_kdeformpartwidget* find_existing_form(const hk_string& n);
hk_kdereportpartwidget* find_existing_report(const hk_string& n);
hk_kdetablepartwidget* find_existing_table(const hk_string& n);
hk_kdequerypartwidget* find_existing_query(const hk_string& n);
hk_kdequerypartwidget* find_existing_view(const hk_string& n);

};


#endif //KNODAMAINDOCKWINDOW_H
