<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: init.php 354 2007-04-21 17:44:50Z lordlamer $
 */

if (!isset ($_SERVER['ORIG_PATH_TRANSLATED'])) { $_SERVER['ORIG_PATH_TRANSLATED'] = ''; }
if (!isset ($_SERVER['ORIG_SCRIPT_FILENAME'])) { $_SERVER['ORIG_SCRIPT_FILENAME'] = ''; }
// get base path
define('KNOWLEDGEROOT_PATH',str_replace('//','/', str_replace('\\','/', (php_sapi_name()=='cgi' || php_sapi_name()=='isapi' || php_sapi_name()=='cgi-fcgi') && ($_SERVER['ORIG_PATH_TRANSLATED'] ? $_SERVER['ORIG_PATH_TRANSLATED'] : $_SERVER['PATH_TRANSLATED'])? ($_SERVER['ORIG_PATH_TRANSLATED']?$_SERVER['ORIG_PATH_TRANSLATED']:$_SERVER['PATH_TRANSLATED']):($_SERVER['ORIG_SCRIPT_FILENAME']?$_SERVER['ORIG_SCRIPT_FILENAME']:$_SERVER['SCRIPT_FILENAME']))));
$base_path = dirname(KNOWLEDGEROOT_PATH) . "/";

// get base url
$baseurl = $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
preg_match("/(.*\/).*/", $baseurl, $url_arr);

if($url_arr[1] == "") {
	$url_arr[1] = $_SERVER['HTTP_HOST'];
}

// init session
session_name(md5($url_arr[1]));
session_start();

// check for include prefix
if(isset($CONFIG['include_prefix']) && $CONFIG['include_prefix'] != "") {
	$base_path .= $CONFIG['include_prefix'];
}

// load required files
require_once($base_path."include/version.php");
require_once($base_path."include/class-tree.php");
require_once($base_path."include/function.php");
require_once($base_path."include/class-knowledgeroot.php");
require_once($base_path."include/fckeditor.php");
require_once($base_path."include/tinymce.php");
require_once($base_path."include/class-knowledgeroot-header.php");
require_once($base_path."include/class-knowledgeroot-content.php");
require_once($base_path."include/class-knowledgeroot-themes.php");
require_once($base_path."include/class-language.php");
require_once($base_path."system/phpmailer/class.phpmailer.php");
require_once($base_path."include/class-email-notification.php");
require_once($base_path."include/class-knowledgeroot-extension.php");
require_once($base_path."include/class-extension-base.php");
require_once($base_path."include/class-default-menu.php");
require_once($base_path."include/class-error.php");
require_once($base_path."include/class-auth.php");
require_once($base_path."include/class-hooks.php");
require_once($base_path."include/class-error.php");

// this is the variable where all classes are in
$CLASS = array();

// define global variables
$CLASS['vars'] = $CONFIG;

$CLASS['error'] = new knowledgeroot_error();
$CLASS['error']->start($CLASS);

// set base paths
$CLASS['vars']['base_path'] = dirname(KNOWLEDGEROOT_PATH) . "/";

if(isset($CONFIG['include_prefix']) && $CONFIG['include_prefix'] != "") {
	$CLASS['vars']['base_path'] .= $CONFIG['include_prefix'];
}

// load databaseclass
if($CLASS['vars']['db']['type'] == "mysql") {
	require_once($base_path."include/class-mysql.php");
}

if($CLASS['vars']['db']['type'] == "mysqli") {
	require_once($base_path."include/class-mysqli.php");
}

if($CLASS['vars']['db']['type'] == "pgsql") {
	require_once($base_path."include/class-pgsql.php");
}

if(isset($KNOWLEDGEROOTDB) && $KNOWLEDGEROOTDB != "PGSQL" && $KNOWLEDGEROOTDB != "MYSQL") {
	echo "WRONG DBTYPE SELECTED!\n";
	exit();
}

// init error
$CLASS['error'] = new knowledgeroot_error();
$CLASS['error']->start($CLASS);

// init hooks
$CLASS['hooks'] = new hooks();
$CLASS['hooks']->start($CLASS);

// init error
$CLASS['auth'] = new auth();
$CLASS['auth']->start($CLASS);

// init databaseclass
$CLASS['db'] = new db();

// connect to database
$CLASS['db']->connect($CLASS['vars']['db']['host'],$CLASS['vars']['db']['user'],$CLASS['vars']['db']['pass'],$CLASS['vars']['db']['database'],$CLASS['vars']['db']['schema'],$CLASS['vars']['db']['encoding']);

// init knowledgerootclass
$CLASS['knowledgeroot'] = new knowledgeroot();
$CLASS['knowledgeroot']->start($CLASS);

// load config from db
$CLASS['vars'] = $CLASS['knowledgeroot']->replace_array($CLASS['vars'], $CLASS['knowledgeroot']->getConfigArr());

// init language
$CLASS['language'] = new language();
$CLASS['language']->start($CLASS,$CLASS['vars']['knowledgeroot']['language']);

// init email notification class
$CLASS['notification'] = new knowledgeroot_notification($CLASS);

// check for opera and konqueror
// this is a short fix beacause the ajaxtree does not work in opera and konqueror
if($CLASS['vars']['menu']['ajax'] == "yes") {
	if(isset($_SERVER['HTTP_USER_AGENT']) && (preg_match("/.*[Kk]onqueror.*/",$_SERVER['HTTP_USER_AGENT']) || preg_match("/.*[Ss]afari.*/",$_SERVER['HTTP_USER_AGENT']))) {
		$CLASS['vars']['menu']['ajax'] = "no";
	}
}

// addslashes on GET/POST/COOKIE/REQUEST/SERVER
$CLASS['knowledgeroot']->addSlashesOnArray($_GET);
$CLASS['knowledgeroot']->addSlashesOnArray($_POST);
$CLASS['knowledgeroot']->addSlashesOnArray($_COOKIE);
$CLASS['knowledgeroot']->addSlashesOnArray($_REQUEST);
$CLASS['knowledgeroot']->addSlashesOnArray($_SERVER);

// here comes the stuff of index.php

// load extensions
$CLASS['kr_extension'] = new knowledgeroot_extension();
$CLASS['kr_extension']->start($CLASS);

// init tree
$CLASS['tree'] = new categoryTree();
$CLASS['tree']->start($CLASS);

// init tree_path
$CLASS['path'] = new pathTree();
$CLASS['path']->start($CLASS);

// init header
$CLASS['kr_header'] = new knowledgeroot_header();
$CLASS['kr_header']->start($CLASS);

// init content
$CLASS['kr_content'] = new knowledgeroot_content();
$CLASS['kr_content']->start($CLASS);

// start all extensions
$CLASS['kr_extension']->start_extensions();

// check header variables
$CLASS['kr_header']->check_vars();

// check if site is a download
$CLASS['kr_header']->check_download();

// load default menu
$CLASS['default_menu'] = new default_menu();
$CLASS['default_menu']->start($CLASS);

// init themes
$CLASS['themes'] = new knowledgeroot_themes();
$CLASS['themes']->start($CLASS,$CLASS['vars']['knowledgeroot']['default_theme']);

// init fckeditor
$CLASS['oFCKeditor'] = new FCKeditor('content');
$CLASS['oFCKeditor']->use = $CLASS['vars']['htmleditor']['use'];
$sBasePath = $_SERVER['PHP_SELF'] ;
$sBasePath = substr( $sBasePath, 0, strpos( $sBasePath, "index.php" ) );
$CLASS['oFCKeditor']->BasePath	= $sBasePath;
$CLASS['oFCKeditor']->Value = '';
$CLASS['oFCKeditor']->Width  = $CLASS['vars']['htmleditor']['fckeditor']['width'];
$CLASS['oFCKeditor']->Height = $CLASS['vars']['htmleditor']['fckeditor']['height'];
$CLASS['oFCKeditor']->Config['AutoDetectLanguage']	= $CLASS['vars']['htmleditor']['fckeditor']['langdetect'];
$CLASS['oFCKeditor']->Config['DefaultLanguage']		= $CLASS['vars']['htmleditor']['fckeditor']['langdefault'];
$CLASS['oFCKeditor']->Config['SkinPath'] = $sBasePath . 'system/fckeditor/skins/' . $CLASS['vars']['htmleditor']['fckeditor']['skin'] . '/' ;
$CLASS['oFCKeditor']->ToolbarSet = $CLASS['vars']['htmleditor']['fckeditor']['toolbar'];

$CLASS['tinymce'] = new tinymce();
$CLASS['tinymce']->start($CLASS);

// add javascript to htmlheader
if(!isset($CONFIG['include_prefix'])) {
	$CONFIG['include_prefix'] = "";
}

$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/prototype.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/scriptaculous.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/effects.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/dragdrop.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/showhide.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/ajax-tree.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/messagebox.js");

// add loadingmessage for messagebox
$CLASS['kr_header']->addjs("var msgboxloading = '".$CLASS['language']->get['messagebox']['loading']."';");

// add theme
$CLASS['kr_header']->addcsssrc($CLASS['themes']->load_theme());

// add favicon pointer
$CLASS['kr_header']->addheader("<link rel=\"shortcut icon\" href=\"".$CONFIG['include_prefix']."favicon.ico\" type=\"image/x-icon\" />");

// add generator
if(isset($version))
	$CLASS['kr_header']->addheader("<meta name=\"generator\" content=\"Knowledgeroot - ".$version."\" />");

// add hook
$CLASS['hooks']->setHook("init","init","end");
?>
