/***************************************************************************
                          knutclient.cpp  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutprefdlg.h"
#include "knutprintupsvar.h"
#include "knutinstcomms.h"
#include "knutrwvar.h"
#include "knutclient.h"

#include <qdatetime.h>

#include <kconfig.h>
#include <ksimpleconfig.h>

#include <unistd.h>

//#include <iostream>

//  const char *nameUpsVars1[] = {
//  "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID","BATTVOLT","OUTVOLT",CURRENT};
//  const char *nameUpsVars2[] = {
//    "none", "input.voltage", "battery.charge", "ups.temperature", "input.frequency", "ups.load", "ambient.temperature", "ambient.humidity","battery.voltage","output.voltage","output.current","battery.temperature","battery.current"};

  extern const char *nameUpsVars1[];
  extern const char *nameUpsVars2[];

KNutClient::KNutClient(bool noDock, QObject* parent, const char *name) : QObject(parent, name) {

  upsRecords = new KNutUpsData();
  analogRecords = new KNutVarData();

  upsTimer = new QTimer (this);
  connect( upsTimer, SIGNAL(timeout()), SLOT(timeout()) );

  //  data pro combo
  listKNutEvent = new QStringList();
  
  // inicializace a natazeni configurace;
  initVars();
  
  loadConfiguration();
  
  if (!noDock) {
    myDock = new KNutDock(&mainUpsInfo,&settingData,upsRecords);
    
    myDock->show();
    connect(myDock, SIGNAL(endApplication()), this, SLOT(slotExitApplication()));
    connect(myDock, SIGNAL(activeMainWindow()), this, SLOT(activeMainWindow()));
    connect(myDock, SIGNAL(minimize()), this, SLOT(minimizeMainWindow()));
    connect(myDock, SIGNAL(UPSChanged(QString)), this, SLOT(setNewUPS (QString)));

    connect(myDock, SIGNAL(preferences()),this, SLOT(slotPreferenceUps()));
    connect(myDock, SIGNAL(printUPSVars()),this, SLOT(slotPrintUPSVars()));
    connect(myDock, SIGNAL(instComms()),this, SLOT(slotInstComms()));
    connect(myDock, SIGNAL(RWVars()),this, SLOT(slotRWVars()));
    }
  
  addEventString(i18n("Ready."));

  // nastavime data pro vybranou polozku
  setActiveUpsInfo(mainUpsInfo.record.name);

  mainUpsInfo.oldStatus=KNutNet::initStatus;
  // activujeme ups na prednastavenou UPSku
  upsActivate();

  // nechame prekreslit dock;
  
  if (myDock) myDock->repaintDock(0);
    
  if (settingData.useMainWindow || noDock) makeMainWindow ();

  if (myDock) myMessMan = new KNutMessageManager(this);
    
  if ((mainUpsInfo.upsNet->getState() == KNutNet::Connected) && (!mainUpsInfo.errorUpsData)) {
    showStatusEvent();
    upsTimer->start( mainUpsInfo.record.delay, TRUE ); // nastartujeme casovac
    }
  }

  
KNutClient::~KNutClient() {

  if (myMessMan) delete myMessMan;

  // melo by uz byt zruseno - jistota
  if (myDock) { myDock->close(); myDock=0l;}
  
  if (mainUpsInfo.upsNet) {
  // melo by uz byt zruseno - jistota
    delete mainUpsInfo.upsNet;
    mainUpsInfo.upsNet = 0;
    }
  listKNutEvent->clear();
  delete listKNutEvent;

  // melo by uz byt zruseno - jistota
  if (mainWindow) delete mainWindow;

  delete upsRecords;
  delete analogRecords;
  }


void KNutClient::initVars (void) {
// Nasledujici data jsou nastavena pri natazeni konfigurace
  settingData.panelFlags = knc::DefaultPanelFlags; // informace v hlavnim panelu
  settingData.toolTipFlags = knc::DefaultToolTipFlags; // informace v hlavnim panelu

  mainUpsInfo.record.name="";
  mainUpsInfo.upsNet=0L;
  mainUpsInfo.netError=0; // zadna chyba
  mainUpsInfo.name="";
  mainUpsInfo.password="";
  mainUpsInfo.errorUpsData=false;
  mainUpsInfo.nutVariables=0;
  mainUpsInfo.runtimeVar="";
  mainUpsInfo.lowxferVar="";
  mainUpsInfo.highxferVar="";
  mainUpsInfo.statusVar="";
  mainUpsInfo.upsLoadVar="";
  mainUpsInfo.upsDriverStatus=knc::notConnected;
  panelsAreZeroing=false;
  lastError=0; // zadna chyba


//  existDock=false;
  mainWindow=0;
  myDock=0;
  myMessMan=0;
  }


  void KNutClient::loadConfiguration ( void ) {
  QString groupName;
  upsRecord upsData; // struktura obsahuje udaje o UPS
  QFont appFont = kapp->font(); // systemovy font pri startu
  settingData.areYouSure=kapp->config()->readBoolEntry("AreYouSure",FALSE);
  settingData.useMainWindow=kapp->config()->readBoolEntry("UseMainWindow",TRUE);
  settingData.x=kapp->config()->readNumEntry("PosX",0);
  settingData.y=kapp->config()->readNumEntry("PosY",0);
  settingData.width=kapp->config()->readNumEntry("Width",300);
  settingData.height=kapp->config()->readNumEntry("Height",200);
  settingData.useDescription=kapp->config()->readBoolEntry("UseDescription",FALSE);
  settingData.countCols=kapp->config()->readNumEntry("NumberOfCols",knc::DefaultCountCols);
  settingData.panelFlags=kapp->config()->readUnsignedNumEntry("PanelFlags",knc::DefaultPanelFlags);
  settingData.inputFrequency=kapp->config()->readNumEntry("InputFrequency",knc::DefaultInputFrequency);
  settingData.inputVoltage=kapp->config()->readNumEntry("InputVoltage",knc::DefaultInputVoltage);
  settingData.lowHighXfer=kapp->config()->readBoolEntry("LowHighXfer",FALSE);
  settingData.customFont=kapp->config()->readBoolEntry("CustomFont",FALSE);
  settingData.aPanelFont=kapp->config()->readFontEntry("AnalogPanelFont",&appFont);
  settingData.mPanelFont=kapp->config()->readFontEntry("MainPanelFont",&appFont);
  int upsCount=kapp->config()->readNumEntry("NumberOfUpsRecords",0);
  settingData.customBColor=kapp->config()->readBoolEntry("CustomBColor",FALSE);
  settingData.mainBackgroundColor=kapp->config()->readColorEntry ("MainBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.customBPanelColor=kapp->config()->readBoolEntry("CustomBPanelColor",FALSE);
  settingData.customBAnalogColor=kapp->config()->readBoolEntry("CustomBAnalogColor",FALSE);
  settingData.customOAnalogColor=kapp->config()->readBoolEntry("CustomOAnalogColor",FALSE);
  settingData.mPanelBackgroundColor=kapp->config()->readColorEntry ("MPanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.aPanelBackgroundColor=kapp->config()->readColorEntry ("APanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.analogFingerColor=kapp->config()->readColorEntry ("AnalogFingerColor",& DEFAULT_FINGER_COLOR);
  settingData.analogOKColor=kapp->config()->readColorEntry ("AnalogOKColor",& DEFAULT_OK_COLOR);
  settingData.analogWarnningColor=kapp->config()->readColorEntry ("AnalogWarnningColor",& DEFAULT_WARNNING_COLOR);
  settingData.analogErrorColor=kapp->config()->readColorEntry ("AnalogErrorColor",& DEFAULT_ERROR_COLOR);
  settingData.analogScaleColor=kapp->config()->readColorEntry ("AnalogScaleColor",& DEFAULT_SCALE_COLOR);
  settingData.analogFontColor=kapp->config()->readColorEntry ("AnalogFontColor",& DEFAULT_FONT_COLOR);
  settingData.toolTipFlags=kapp->config()->readUnsignedNumEntry("ToolTipFlags",knc::DefaultToolTipFlags);
  settingData.customKIconColor=kapp->config()->readBoolEntry("CustomKIconColor",FALSE);
  settingData.kIconBackgroundColor=kapp->config()->readColorEntry ("KIconBackGroundColor",& DEFAULT_KICON_COLOR);
  settingData.typeOfKIcon=kapp->config()->readBoolEntry("TypeOfKIcon",knc::pictureKI);

  mainUpsInfo.record.name=kapp->config()->readEntry("ActiveUps","");

  for (int i = 0; i < upsCount; i++) {
    groupName.sprintf ("UPS %d",i);
    kapp->config()->setGroup (groupName);
    if ((upsData.name = kapp->config()->readEntry ("Name")) != QChar::null) {
      // zaznam existuje pokracujeme dale
      upsData.upsName = kapp->config()->readEntry ("UpsName","");
      if (((upsData.upsAddress = kapp->config()->readEntry ("UpsAddress")) != QChar::null)
        || (( upsData.upsAddress == QChar::null)  &&    (upsData.upsName != QChar::null ))) {

        // only for backwards compatibility with older release then 0.7
        if (upsData.upsAddress.isEmpty()) {
          int charPos;
          if ((charPos=upsData.upsName.find('@')) == -1) {
            upsData.upsAddress=upsData.upsName;
            upsData.upsName="";
            }
          else {
            upsData.upsAddress=upsData.upsName.mid(charPos+1);
            upsData.upsName=upsData.upsName.left(charPos);
            }         
          }
        // zaznam existuje pokracujeme dale a nacteme zbytek hodnotet
        upsData.delay = kapp->config()->readNumEntry("Delay",knc::DefaultDelay);
        upsData.port = kapp->config()->readNumEntry("Port",knc::DefaultPort);
        upsData.tcp = kapp->config()->readBoolEntry("Tcp",TRUE);
        upsData.userName=kapp->config()->readEntry("UserName","");
        upsData.password=kapp->config()->readEntry("Password","");
        upsData.savePassword=kapp->config()->readBoolEntry("SavePassword",false);
        for (int j=0; j < knc::NumberOfVars; j++) {
          groupName.sprintf ("Var %d",j);
          upsData.upsVarCode[j]=kapp->config()->readNumEntry (groupName,0);
          }
        upsRecords->add (upsData);
        }
      }
    }
  }

void KNutClient::saveConfiguration ( bool all ) {
  QString groupName;
  QString codeName;
  upsRecord upsData; // struktura obsahuje udaje o UPS
  int upsCount = upsRecords->getCount();

  kapp->config()->setGroup ("");

  if (all) {
    kapp->config()->writeEntry ("TypeOfKIcon",settingData.typeOfKIcon);
    kapp->config()->writeEntry ("KIconBackGroundColor",settingData.kIconBackgroundColor);
    kapp->config()->writeEntry ("CustomKIconColor",(settingData.customKIconColor));
    kapp->config()->writeEntry ("ToolTipFlags",(settingData.toolTipFlags));
    }
  kapp->config()->writeEntry ("ActiveUps",(QString)mainUpsInfo.record.name); //

  if (all) {
    kapp->config()->writeEntry ("AnalogFontColor",settingData.analogFontColor);
    kapp->config()->writeEntry ("AnalogScaleColor",settingData.analogScaleColor);
    kapp->config()->writeEntry ("AnalogErrorColor",settingData.analogErrorColor);
    kapp->config()->writeEntry ("AnalogWarnningColor",settingData.analogWarnningColor);
    kapp->config()->writeEntry ("AnalogOKColor",settingData.analogOKColor);
    kapp->config()->writeEntry ("AnalogFingerColor",settingData.analogFingerColor);
    kapp->config()->writeEntry ("APanelBackGroundColor",settingData.aPanelBackgroundColor);
    kapp->config()->writeEntry ("MPanelBackGroundColor",settingData.mPanelBackgroundColor);
    kapp->config()->writeEntry ("MainBackGroundColor",settingData.mainBackgroundColor);
    kapp->config()->writeEntry ("NumberOfUpsRecords",upsCount);
    kapp->config()->writeEntry ("CustomFont",settingData.customFont);
    kapp->config()->writeEntry ("AnalogPanelFont",settingData.aPanelFont);
    kapp->config()->writeEntry ("MainPanelFont",settingData.mPanelFont);
    kapp->config()->writeEntry ("CustomBColor",(settingData.customBColor));
    kapp->config()->writeEntry ("CustomBPanelColor",(settingData.customBPanelColor));
    kapp->config()->writeEntry ("CustomBAnalogColor",(settingData.customBAnalogColor));
    kapp->config()->writeEntry ("CustomOAnalogColor",(settingData.customOAnalogColor));
    kapp->config()->writeEntry ("LowHighXfer",(settingData.lowHighXfer));
    kapp->config()->writeEntry ("InputVoltage",(settingData.inputVoltage));
    kapp->config()->writeEntry ("InputFrequency",(settingData.inputFrequency));
    kapp->config()->writeEntry ("PanelFlags",(settingData.panelFlags | 3));
    kapp->config()->writeEntry ("NumberOfCols",settingData.countCols);
    kapp->config()->writeEntry ("UseDescription",settingData.useDescription);
    kapp->config()->writeEntry ("AreYouSure",settingData.areYouSure);
    kapp->config()->writeEntry ("UseMainWindow",settingData.useMainWindow);
    }
  kapp->config()->writeEntry ("Height",settingData.height); //
  kapp->config()->writeEntry ("Width",settingData.width); //
  kapp->config()->writeEntry ("PosY",settingData.y); //
  kapp->config()->writeEntry ("PosX",settingData.x); //

  if (all) {
    for (int i=0; i<upsCount; i++) {
      groupName.sprintf ("UPS %d",i);
      kapp->config()->setGroup (groupName);
      upsRecords->get(i,upsData);
      kapp->config()->writeEntry ("Tcp",upsData.tcp);
      kapp->config()->writeEntry ("Port",upsData.port);
      kapp->config()->writeEntry ("Delay",upsData.delay);
      kapp->config()->writeEntry ("UpsAddress",upsData.upsAddress);
      kapp->config()->writeEntry ("UpsName",upsData.upsName);
      kapp->config()->writeEntry ("Name",upsData.name);
      if (upsData.savePassword) {
        kapp->config()->writeEntry ("UserName",upsData.userName);
        kapp->config()->writeEntry ("Password",upsData.password);
        }
      kapp->config()->writeEntry ("SavePassword",upsData.savePassword);
      for (int j=0; j < knc::NumberOfVars; j++) {
        groupName.sprintf ("Var %d",j);
        kapp->config()->writeEntry (groupName,upsData.upsVarCode[j]);
        }
      kapp->config()->setGroup ("");
      }
    }
  kapp->config()->sync();
  }


bool KNutClient::commitData (QSessionManager&) {

  saveConfiguration(false);
  return true;
  }

  bool KNutClient::saveState (QSessionManager&) {

  saveConfiguration(false);
  return true;
  }


  
void KNutClient::upsActivate (void) {

  mainUpsInfo.upsNet = new KNutNet( mainUpsInfo.record.upsAddress,mainUpsInfo.record.upsName,mainUpsInfo.record.tcp,mainUpsInfo.record.port,0,1);
  if (mainUpsInfo.upsNet->getState() != KNutNet::Connected) {
    mainUpsInfo.netError=mainUpsInfo.upsNet->getError(); // aktivace ups skoncila s chybou
    KNutVarData::showError(mainUpsInfo.netError);
    mainUpsInfo.errorUpsData=true;
    mainUpsInfo.upsDriverStatus=knc::notConnected;
    }
  else {
    if (mainUpsInfo.upsNet->switchedToTCP())
      addEventString (i18n("upsd > 1.2 doesn't support UDP. Connection is switched to TCP"),mainUpsInfo.record.name);
    mainUpsInfo.nutVariables = mainUpsInfo.upsNet->getNutVariables();
    mainUpsInfo.nutProtocol = mainUpsInfo.upsNet->getNutProtocol();

    int countRevision = 2; // pocet max opakovani po kterych muzeme zjistovat hodnoty
    do {
      if (!(mainUpsInfo.netError = mainUpsInfo.upsNet->getUpsVars())) break;
      if (mainUpsInfo.netError == KNutNet::UnknownUps) break;
      if (mainUpsInfo.netError == KNutNet::DriverNotConnected) break;
      countRevision--;
      if (countRevision) sleep (2);
      }
    while (countRevision);
    
    if (mainUpsInfo.netError) {
       addEventString (KNutVarData::errorToText(mainUpsInfo.netError),mainUpsInfo.record.name);
       KNutVarData::showError (mainUpsInfo.netError);
       mainUpsInfo.errorUpsData=true;
       if (mainUpsInfo.netError == KNutNet::DriverNotConnected)
         mainUpsInfo.upsDriverStatus=knc::notConnected;
       else
         mainUpsInfo.upsDriverStatus=knc::error;
       }
    else {
      mainUpsInfo.upsDriverStatus=knc::connected;

      switch (mainUpsInfo.nutVariables) {
          case 1:
            if (!(mainUpsInfo.upsNet->existName("BATT_RUNTIME"))) mainUpsInfo.runtimeVar="BATT_RUNTIME";
            else mainUpsInfo.runtimeVar="RUNTIME";
            mainUpsInfo.upsLoadVar="LOADPCT";
            mainUpsInfo.lowxferVar="LOWXFER";
            mainUpsInfo.highxferVar="HIGHXFER";
            mainUpsInfo.statusVar="STATUS";
          break;
          case 2:
            mainUpsInfo.runtimeVar="battery.runtime";
            mainUpsInfo.upsLoadVar="ups.load";
            mainUpsInfo.lowxferVar="input.transfer.low";
            mainUpsInfo.highxferVar="input.transfer.high";
            mainUpsInfo.statusVar="ups.status";
         }

      if ((settingData.useDescription) && (!mainUpsInfo.upsNet->isDescription())) mainUpsInfo.upsNet->getDescription();
        // test presunut do setActiveUpsVars
      if (mainWindow) setActiveUpsVars(true);
      else setActiveUpsVars(false);
      }
    }
  }

void KNutClient::upsDeactivate (void) {
  upsTimer->stop();
  mainUpsInfo.upsDriverStatus=knc::notConnected;
  if (mainUpsInfo.upsNet != 0L) {
    mainUpsInfo.netError=0; // zadna chyba
    delete mainUpsInfo.upsNet;
    mainUpsInfo.upsNet = 0L;
    mainUpsInfo.nutVariables=0;
    }
  } 

//void KNutClient::setActiveUpsVars (void) {
void KNutClient::setActiveUpsVars (bool mWindow) {
  // nastavujeme jen pokud existuji nejake promene
  if ( mainUpsInfo.upsNet->readNumberVars() > 0) {
    // deaktivujeme veskere promene
    mainUpsInfo.upsNet->unSetActivateAll();

    if (mWindow) {
      for (int j=0; j < knc::NumberOfVars; j++) {
        switch (mainUpsInfo.nutVariables) {
          case 1:
            if (mainUpsInfo.record.upsVarCode[j] != 0 ) mainUpsInfo.upsNet->setActivate(nameUpsVars1[mainUpsInfo.record.upsVarCode[j]]);
          break;
          case 2:
            if (mainUpsInfo.record.upsVarCode[j] != 0 ) mainUpsInfo.upsNet->setActivate(nameUpsVars2[mainUpsInfo.record.upsVarCode[j]]);
          break;
          }
        }
      }
    mainUpsInfo.upsNet->setActivate(mainUpsInfo.runtimeVar); //runtime je vzdy pridano v merenym polozkam
    if (myDock) mainUpsInfo.upsNet->setActivate(mainUpsInfo.upsLoadVar);
    // status se nastavi vzdy
    mainUpsInfo.upsNet->setActivate(mainUpsInfo.statusVar);
    // xfer se nastavi vzdy pokud existuje
    // podrebujeme ho znat jeste pred startem a pak behen behu programu
    setActiveXFerVars(true);
    }
  }
  

void KNutClient::setActiveXFerVars (bool activate) {
  if (activate) {
    // podkud neexistuje jedna z promenych neaktivujeme ani jednu
    if (!(mainUpsInfo.upsNet->setActivate(mainUpsInfo.lowxferVar)))
      if (mainUpsInfo.upsNet->setActivate(mainUpsInfo.highxferVar))
        mainUpsInfo.upsNet->unSetActivate(mainUpsInfo.lowxferVar);
    }
  else {
    mainUpsInfo.upsNet->unSetActivate(mainUpsInfo.lowxferVar);
    mainUpsInfo.upsNet->unSetActivate(mainUpsInfo.highxferVar);
    }
  }

void KNutClient::setActiveUpsInfo (QString name) {
  //presuneme jmena  z databaze ups-ek - je nahrana z config. souboru
  upsRecord* upsRecordPointer;
  
  if ((!name.isNull()) && (!name.isEmpty()) && ((upsRecordPointer = upsRecords->findName(name)) != 0L)) {

    mainUpsInfo.record.upsName = upsRecordPointer->upsName;
    mainUpsInfo.record.upsAddress = upsRecordPointer->upsAddress;
    mainUpsInfo.record.delay = upsRecordPointer->delay;
    mainUpsInfo.record.port = upsRecordPointer->port;
    mainUpsInfo.record.tcp = upsRecordPointer->tcp;
    mainUpsInfo.record.userName = upsRecordPointer->userName;
    mainUpsInfo.record.password = upsRecordPointer->password;
    for (int i =0; i < knc::NumberOfVars; i++) mainUpsInfo.record.upsVarCode[i] = 0; // vynulujeme polozky
    int ii = 0;
    for (int i =0; i < knc::NumberOfVars; i++)
      if (upsRecordPointer->upsVarCode[i]>0) mainUpsInfo.record.upsVarCode[ii++] = upsRecordPointer->upsVarCode[i];
    }       
  }


void KNutClient::getUpsData (void) {
  int runNetError;

  if (!(runNetError=mainUpsInfo.upsNet->getUpsValues(false))) {
    ///  podarilo se nacist vsechny hodnoty pro ups
    mainUpsInfo.netError=runNetError;
    if (mainUpsInfo.errorUpsData) {
      mainUpsInfo.errorUpsData=false;
      addEventString (i18n("Data OK"),mainUpsInfo.record.name);
      if (myMessMan) myMessMan->addMessage(i18n("Data OK"),knc::errorLevel,true);
      }
    }
  else {
    mainUpsInfo.netError=runNetError;
    if (!mainUpsInfo.errorUpsData) {
      addEventString (KNutVarData::errorToText(runNetError),mainUpsInfo.record.name);
      if (myMessMan) myMessMan->addMessage(KNutVarData::errorToText(runNetError),knc::errorLevel);
      lastError=runNetError;
      mainUpsInfo.errorUpsData=true;
      }
    else {
      if (lastError != runNetError) {
        addEventString (KNutVarData::errorToText(runNetError),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(KNutVarData::errorToText(runNetError),knc::errorLevel);
        lastError=runNetError;
        }
      }    
    }
  }


void KNutClient::addEventString (const QString text, const QString UPSAddress) {

  if (mainWindow)
    mainWindow->addComboStatusItem (text,UPSAddress);
  else
    {
      QString dateTime(QDate::currentDate().toString());
      dateTime +=" " + QTime::currentTime().toString();
      if (UPSAddress.isEmpty()) listKNutEvent->append(dateTime+" "+text);
      else listKNutEvent->append(dateTime+" "+UPSAddress+" : "+text);
      if (listKNutEvent->count() > knc::maxCountKNutEvent) listKNutEvent->remove(listKNutEvent->begin());
      }
    }  
  

/**************** SLOTS **********************/
  
void KNutClient::timeout (void) {
  getUpsData();
  if (!mainUpsInfo.errorUpsData) {
    if (mainWindow) {
      mainWindow->repaintPanel();
      mainWindow->repaintAnalogs();
      }
    panelsAreZeroing=false;
    showStatusEvent();
    }
  else {
    if ((mainWindow) && (!panelsAreZeroing)) mainWindow->zeroingPanels();
    panelsAreZeroing=true;
    }    
  if (myDock) myDock->repaintDock(mainUpsInfo.netError);
  upsTimer->start( mainUpsInfo.record.delay, TRUE ); // nastartujem znovu
  }                                                                                                                                                                                                                                                                                                

void KNutClient::showStatusEvent(void) {

  int status = mainUpsInfo.upsNet->readStatus();
  if (status != mainUpsInfo.oldStatus) {
    if ((status & KNutNet::OFF) != (mainUpsInfo.oldStatus & KNutNet::OFF)) {
      if (status & KNutNet::OFF) {
        addEventString(i18n("UPS is off."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is off."),knc::criticalLevel);
        }
      else {
        addEventString(i18n("UPS is back on."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is back on."),knc::criticalLevel,true);
        }
      }
    if ((status & KNutNet::OL) != (mainUpsInfo.oldStatus & KNutNet::OL)){
       if (status & KNutNet::OL)  {
         addEventString(i18n("Power is back online."),mainUpsInfo.record.name);
         if (myMessMan) myMessMan->addMessage(i18n("Power is back online."),knc::warningLevel,true);
         }
       }
    if ((status & KNutNet::OB) != (mainUpsInfo.oldStatus & KNutNet::OB)) {
      if (status & KNutNet::OB)  {
        addEventString(i18n("UPS is on battery."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is on battery."),knc::warningLevel);
        }
      }
    if ((status & KNutNet::LB) != (mainUpsInfo.oldStatus & KNutNet::LB)) {
      if (status & KNutNet::LB) {
        addEventString(i18n("UPS battery is low."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS battery is low."),knc::criticalLevel);
        }
      else {
        addEventString(i18n("UPS battery is OK."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS battery is OK."),knc::criticalLevel,true);
        }
      }
    if ((status & KNutNet::RB) != (mainUpsInfo.oldStatus & KNutNet::RB)) {
      if (status & KNutNet::RB) {
        addEventString(i18n("UPS battery is bad and needs be replaced."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS battery is bad and needs be replaced."),knc::infoLevel);
        }
      }
    if ((status & KNutNet::OVER) != (mainUpsInfo.oldStatus & KNutNet::OVER)) {
      if (status & KNutNet::OVER) {
        addEventString(i18n("UPS is overloaded."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is overloaded."),knc::lowWarningLevel);
        }
      else {
        addEventString(i18n("UPS isn't overloaded."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS isn't overloaded."),knc::lowWarningLevel,true);
        }
      }
    if ((status & KNutNet::CAL) != (mainUpsInfo.oldStatus & KNutNet::CAL)) {
      if (status & KNutNet::CAL) {
        addEventString(i18n("UPS is performing calibration")+".",mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is performing calibration")+".",knc::infoLevel);
        }
      else {
        addEventString(i18n("Calibration of UPS is ended."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("Calibration of UPS is ended."),knc::infoLevel,true);
        }
      }
    if ((status & KNutNet::BOOST) != (mainUpsInfo.oldStatus & KNutNet::BOOST)) {
      if (status & KNutNet::BOOST) {
        addEventString(i18n("UPS is boosting incoming voltage."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is boosting incoming voltage."),knc::infoLevel);
        }
      else {
        addEventString(i18n("Boosting of UPS is ended."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("Boosting of UPS is ended."),knc::infoLevel,true);
        }
      }
    if ((status & KNutNet::TRIM) != (mainUpsInfo.oldStatus & KNutNet::TRIM)) {
      if (status & KNutNet::TRIM) {
        addEventString(i18n("UPS is trimming incoming voltage."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("UPS is trimming incoming voltage."),knc::infoLevel);
        }
      else {
        addEventString(i18n("Trimming of UPS is ended."),mainUpsInfo.record.name);
        if (myMessMan) myMessMan->addMessage(i18n("Trimming of UPS is ended."),knc::infoLevel,true);
        }
      }
    mainUpsInfo.oldStatus=status;
    }
  }
  
void KNutClient::setNewUPS (QString name) {

  if (name  != mainUpsInfo.record.name) {
    // nastavime na docku iconu
    if (myDock) {
      myDock->initImage();
      myDock->repaint();
      }
    upsDeactivate();
    addEventString(i18n("Switched"),name);
    if (myMessMan) myMessMan->deleteMessage();

    mainUpsInfo.record.name=name;
    mainUpsInfo.errorUpsData=false;
    setActiveUpsInfo(mainUpsInfo.record.name);
    upsActivate();

    // zde je nutno hned provest prekresleni
    if (mainWindow) {
      mainWindow->setCombo(name);
      mainWindow->showUpsData();
      }
    if (myDock) {
      myDock->repaintDock(true);
      myDock->setNewUPS();
      }

    panelsAreZeroing=false;
    lastError=0; // zadna chyba
    mainUpsInfo.oldStatus=KNutNet::initStatus;

    if ((mainUpsInfo.upsNet->getState() == KNutNet::Connected) && (!mainUpsInfo.errorUpsData)) {
      showStatusEvent();
      upsTimer->start( mainUpsInfo.record.delay, TRUE ); // nastartujeme casovac
      }
    }  
  }

  
void KNutClient::slotPreferenceUps (void) {

  KNutPrefDlg* prefDlg = new KNutPrefDlg ( upsRecords, analogRecords, &settingData, mainUpsInfo.record.name ); // aktivujeme dialog pro preference
  connect (prefDlg,SIGNAL(signalChangeConfig(unsigned int)),this,SLOT(slotSetConfig(unsigned int)));
  prefDlg->exec();
  delete prefDlg;
  }


void KNutClient::slotSetConfig (unsigned int changeSetting) {

  if (changeSetting) {
    // cely blok konfiguraci ukladame jen zde
    saveConfiguration(true);
    if (changeSetting & knc::ChangeXFer) {
      if (settingData.lowHighXfer)
        setActiveXFerVars(false);
      else
        setActiveXFerVars(true);
      }

    if (changeSetting & knc::ChangeUpsSetting) {
//********** stejny kod jako v setNewUPS
      upsDeactivate();

      if (mainUpsInfo.record.name == "") {
        QString name = upsRecords->getName(0);
        addEventString(i18n("Switched"),name);
        mainUpsInfo.record.name=name;
        mainUpsInfo.errorUpsData=false;
        myMessMan->deleteMessage();
        }
      else {
        if (upsRecords->getCount() == 0) {
          addEventString(i18n("Switched"),"");
          mainUpsInfo.record.name="";
          mainUpsInfo.errorUpsData=false;
          mainUpsInfo.record.upsName = "";
          mainUpsInfo.record.upsAddress = "";
          myMessMan->deleteMessage();
          }
        }
      setActiveUpsInfo(mainUpsInfo.record.name);
      upsActivate();
      getUpsData(); // provedeme hned natazeni zbytku promenych oby se nastavili meraky
                    // protoze UPS byla odpojena a znovu pripojena
      // zde je nutno hned provest prekresleni
      // showUpsData je nutno privect take proto ze se mohl zmenit vyber meraku
      if (mainWindow) mainWindow->showUpsData();
      if (myDock) myDock->repaintDock(mainUpsInfo.netError);

      if ((mainUpsInfo.upsNet->getState() == KNutNet::Connected) && (!mainUpsInfo.errorUpsData)) {
        showStatusEvent();
        upsTimer->start( mainUpsInfo.record.delay, TRUE ); // nastartujeme casovac
        }
      }
    
    if (changeSetting & knc::ChangeUpsCount) {
      if (myDock) myDock->changeUps();
      }

    if (changeSetting & knc::ChangeTypeOfKIcon) {
      if (myDock) myDock->changeKIcon();
      }

    if (changeSetting & knc::ChangeCustomKIconColor) {
      if (myDock) myDock->changeKIBColor();
      }

    if (changeSetting & knc::ChangeKIconBColor) {
      if (myDock) myDock->changeKIBColor();
      }

    if (changeSetting & knc::ChangeToolTip) {
      if (myDock) myDock->changeToolTip();
      }
                
    if (mainWindow) mainWindow->setConfig (changeSetting);
    }
  }


void KNutClient::slotPrintUPSVars() {

  if (!mainUpsInfo.errorUpsData) {
    if ((mainUpsInfo.upsNet->readNumberVars (KNutNet::AllVars)) || (mainUpsInfo.upsNet->readNumberComms ())) {
      KNutPrintUpsVar *windowUpsVars = new KNutPrintUpsVar(mainUpsInfo.upsNet,settingData.useDescription);
      if (windowUpsVars->upsOk()) windowUpsVars->exec();
      delete windowUpsVars;
      }
    }  
  }


void KNutClient::slotInstComms() {

  if (!mainUpsInfo.errorUpsData) {
    if (mainUpsInfo.upsNet->readNumberComms ()) {
      KNutInstComms *windowInstComms = new KNutInstComms(&mainUpsInfo.name,&mainUpsInfo.password,mainUpsInfo.record.userName,mainUpsInfo.record.password,mainUpsInfo.upsNet);
      if (windowInstComms->upsOk()) windowInstComms->exec();
      delete windowInstComms;
      }
    }
  }

void KNutClient::slotRWVars() {

  if (!mainUpsInfo.errorUpsData) {
    if (mainUpsInfo.upsNet->readNumberVars (KNutNet::RWVars)) {
      KNutRWVar *windowRWVars = new KNutRWVar(&mainUpsInfo.name,&mainUpsInfo.password,mainUpsInfo.record.userName,mainUpsInfo.record.password,mainUpsInfo.upsNet);
      connect (windowRWVars,SIGNAL(signalChangeRWVars(QString)),this,SLOT(slotChangeRWVars(QString)));
      if (windowRWVars->upsOk())  windowRWVars->exec();
      delete windowRWVars;
      }
    }
  }
    

void KNutClient::slotChangeRWVars( QString varName) {
  // informace ze doslo k uspesne zmene promene
  // vzhledem k asynchronimu zpracovani muze upsd vratit tuto hodnotu az za nejakou dobu
  // nevim zda bude potreba
  }
      
            
void KNutClient::exitMainWindow (void) {

  mainWindow=0;
  if (mainUpsInfo.upsNet) setActiveUpsVars(false);
  // Pokud neni aktivovan dock musime ukoncit aplikaci..
  // When dock isn't activated we must close application.
  if (myDock == 0l) {
    saveConfiguration(false);
    if (mainUpsInfo.upsNet) {
      delete mainUpsInfo.upsNet;
      mainUpsInfo.upsNet = 0;
      }
    kapp->quit();
    }
  }


void KNutClient::makeMainWindow (void) {

  mainWindow = new KNutMainWindow(listKNutEvent ,&mainUpsInfo, &settingData, upsRecords, analogRecords);
  connect(mainWindow, SIGNAL(UPSChanged (QString)), this, SLOT(setNewUPS (QString)));
  connect(mainWindow, SIGNAL(preferenceUps()),this, SLOT(slotPreferenceUps()));
  connect(mainWindow, SIGNAL(showUPSVars()),this, SLOT(slotPrintUPSVars()));
  connect(mainWindow, SIGNAL(makeInstComms()),this, SLOT(slotInstComms()));
  connect(mainWindow, SIGNAL(makeRWVars()),this, SLOT(slotRWVars()));

  connect(mainWindow, SIGNAL(endApplication()), this, SLOT(slotExitApplication()));
  connect(mainWindow, SIGNAL(destroyed()), this, SLOT(exitMainWindow()));
  }
  
void KNutClient::activeMainWindow (void) {
  if (!mainWindow) {
    //  pred activaci nastaveme promenne znovu precteme data
    if (mainUpsInfo.upsDriverStatus==knc::connected) {
      upsTimer->stop();
      setActiveUpsVars(true);
      getUpsData(); 
      makeMainWindow();
      if (myDock) myDock->repaintDock(mainUpsInfo.netError);
      upsTimer->start( 1, TRUE ); // nastartujem znovu
      // 1 proto aby se zpracovali pripadne udalosti o zruseni spojeni
      }
    else {
      setActiveUpsVars(true);
      //getUpsData();  zrusene protoze kdyz nebylo spojeni navazeno vratil by prikaz
      // getValues error=0 a doslo by vypsani data ok.
      makeMainWindow();
      if (!mainUpsInfo.errorUpsData) {
        if (myDock) myDock->repaintDock(mainUpsInfo.netError);
        }
      }  
    } // end if mainWindow
  }

void KNutClient::minimizeMainWindow (void) {
  if (mainWindow) {
    if (myDock) myDock->repaintDock(mainUpsInfo.netError);
    upsTimer->stop();
    mainWindow->close();
    mainWindow=0;
    upsTimer->start( 1, TRUE ); // nastartujeme casovac
    }
  }


  
void KNutClient::slotExitApplication(void) {

  upsTimer->stop();
  if (mainWindow) {
    // odpojime protoze exitMainWindow by byl vykonan az po zkonceni procedury;
    disconnect(mainWindow, SIGNAL(destroyed()), this, SLOT(exitMainWindow()));
    delete mainWindow;
    mainWindow = 0;
    }
  saveConfiguration(false);
  if (mainUpsInfo.upsNet) {
    delete mainUpsInfo.upsNet;
    mainUpsInfo.upsNet = 0;
    }
  if (myDock) { myDock->close(); myDock = 0;}
  kapp->quit();
  }

#include "knutclient.moc"  

