/***************************************************************************
                          knutmainwindow.cpp  -  description
                             -------------------
    begin                : Po cen 16 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "knutmainwindow.h"
#include "knutvardata.h"

#include <kmessagebox.h>
#include <kstdaction.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
#include <kstatusbar.h>
#include <kkeydialog.h>


#include <qfont.h>
#include <qpalette.h>
#include <qbrush.h>
#include <qcolor.h>
#include <qstring.h>
#include <qscrollview.h>
#include <qlayout.h>

#include <math.h>
#include <stdlib.h>
#include <unistd.h>

//#include <iostream>


extern const char *nameUpsVars1[];
extern const char *nameUpsVars2[];


KNutMainWindow::KNutMainWindow(QStringList *tListKNutEvent, struct upsInfo* tActiveUpsInfo, SettingDataDef* tSettingData, KNutUpsData* tUpsRecords, KNutVarData* tAnalogRecords, QWidget* parent, const char *name) : KMainWindow(parent, name) {

  settingData = tSettingData;
  activeUpsInfo = tActiveUpsInfo;
  upsRecords = tUpsRecords;
  analogRecords = tAnalogRecords;
  listKNutEvent=tListKNutEvent;  

  initVars();
  setPalette(mainPalette);
  initStatusBar();
  initAction();
//  createGUI ("/home/dan/Projekty/knutclient/knutclient/knutclientui.rc"); // pred distribuci nezapomenou odstranit retezec
  // createGUI vytvori zakladni strukturu podle souboru knutclientui.rc
  createGUI ();
  initToolBar ();


  descriptionAction->setChecked(settingData->useDescription);

  //nastavime vstupni frekvenci a vstupni napeti
  analogRecords->setFrequency(settingData->inputFrequency);
  analogRecords->setVoltage(settingData->inputVoltage);

  // nastavime paletu pro analogove panely
  if (settingData->customBAnalogColor) {
    aPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->aPanelBackgroundColor);
    }

 if (settingData->customBColor) {
    areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mainBackgroundColor);
    }

  
  // Vytvorime hlavni plochu
  area = new QLabel (this);
  setCentralWidget (area);

  QHBoxLayout* mainLayout = new QHBoxLayout(area);
  mainSplit = new QSplitter(Qt::Horizontal,area);
  mainSplit->setOpaqueResize(true);

  mainLayout->addWidget(mainSplit);
  if (settingData->customBPanelColor) {
    mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mPanelBackgroundColor);
    }

  QScrollView* panelSV = new QScrollView(mainSplit,"panelSV");    
  if (settingData->customFont)
    frontPanel = new KNutFrontPanel (&mPanelPalette,mainSplit,settingData->panelFlags,&(settingData->mPanelFont),"FrontPanel");
  else
    frontPanel = new KNutFrontPanel (&mPanelPalette,mainSplit,settingData->panelFlags,&(settingData->systemFont),"FrontPanel");
  panelSV->addChild(frontPanel);
  panelSV->setResizePolicy ( QScrollView::AutoOneFit ) ;
  mainSplit->setResizeMode (panelSV,QSplitter::FollowSizeHint);

  panelMeter = new KNutPanelMeter(aPanelPalette,activeUpsInfo,settingData,analogRecords,mainSplit);
  mainSplit->setResizeMode (panelMeter,QSplitter::Stretch );

  setPalette(areaPalette);
  area->setPalette(areaPalette);
  frontPanel->setPalette(mPanelPalette);
  panelMeter->setPalette(areaPalette);
  
  // Nastavime COMBO  a pripadne aktivujeme spojeni na merici panely
  int activeUpsNameIndex = activeMainCombo ();
  if (activeUpsNameIndex != -1) toolBar(0)->getCombo(1)->setCurrentItem( activeUpsNameIndex );
  showUpsData();
  setGeometry (settingData->x,settingData->y,settingData->width,settingData->height);
  show();

   // mesage musime vlozit do status baru az po zobrazeni okna,
  // jinak se nastavi minimalni velikost ne mensi nez delka aktivni zpravy.
  initStatusBarMessage();
  }



void KNutMainWindow::addComboStatusItem (const QString text, const QString name) {
  if (infoCombo->count() >= (int)knc::maxCountKNutEvent) infoCombo->removeItem(0);
  if (listKNutEvent->count() > knc::maxCountKNutEvent) listKNutEvent->remove(listKNutEvent->begin());

  QString dateTime(QDate::currentDate().toString());
  dateTime +=" " + QTime::currentTime().toString();
  if (name.isEmpty()) {
    infoCombo->insertItem(dateTime+" "+text);
    listKNutEvent->append(dateTime+" "+text);
     }
  else {
    infoCombo->insertItem(dateTime+" "+name+" : "+text);
    listKNutEvent->append(dateTime+" "+name+" : "+text);
    }
  infoCombo->setCurrentItem(infoCombo->count()-1);
  if (listKNutEvent->count() > knc::maxCountKNutEvent) listKNutEvent->remove(listKNutEvent->begin());
  }


KNutMainWindow::~KNutMainWindow() {

  settingData->height = height();
  settingData->width = width();
  settingData->y = y();
  settingData->x = x();

  delete frontPanel;
  delete panelMeter;
  }


void KNutMainWindow::slotShowToolBar() {
  statusBar()->message(i18n("Toggle the toolbar..."),2000);
  if(toolBar("mainToolBar")->isVisible()) toolBar("mainToolBar")->hide();
  else toolBar("mainToolBar")->show();
  }


void KNutMainWindow::slotShowStatusBar() {
  statusBar()->message(i18n("Toggle the statusbar..."),2000);
  if(statusBar()->isVisible()) statusBar()->hide();
  else statusBar()->show();
  }

void KNutMainWindow::slotDescription() {
  if (descriptionAction->isChecked()) {
    if (!activeUpsInfo->upsNet->isDescription()) activeUpsInfo->upsNet->getDescription();
    settingData->useDescription=true;
    }
  else settingData->useDescription=false;
  }



void KNutMainWindow::slotPrintUPSVars() {

  emit showUPSVars();
}


void KNutMainWindow::slotInstComms() {

  emit makeInstComms();
  }

void KNutMainWindow::slotRWVars() {

  emit makeRWVars();
  }


void KNutMainWindow::slotChangeRWVars ( QString varName) {
  }


void KNutMainWindow::setConfig (unsigned int changeSetting) {

  VarStrucDef analogMemberData;
  bool repaintVoltagePanels = false;
  bool repaintFrequencyPanels = false;
  bool repaintAllPanels = false;
  bool repaintOAPanels = false;

  // Main Setting

  // Nastavime zmenu barvy pozadi
  if (changeSetting & knc::ChangeCustomBColor) {
    if (!settingData->customBColor) { // nastavime barvu pozadi podle systemu
      setPalette (mainPalette);
      area->setPalette (mainPalette);
      panelMeter->setPalette (mainPalette);
      repaint();
      }
    else {
      areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mainBackgroundColor);
      setPalette (areaPalette);
      area->setPalette (areaPalette);
      panelMeter->setPalette (areaPalette);
      repaint();
      }
    }
  else {
    if (changeSetting & knc::ChangeMBColor ) {
      areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mainBackgroundColor);
      setPalette (areaPalette);
      area->setPalette (areaPalette);
      panelMeter->setPalette (areaPalette);
      repaint();
      }
    }

  // Nastavime pozadi pod panely
  // nastavime frevenci
  // nastavime  napeti
  // je zapnuto XFER a existuje na UPS


  if ((changeSetting & knc::ChangeXFer) || // je provedena nejaka zmena na napeti nebo frekvence
      (changeSetting & knc::ChangeVoltage) || (changeSetting & knc::ChangeFrequency)) {

    if ((changeSetting & knc::ChangeXFer) && (settingData->lowHighXfer) && (existLowHighXfer)) {
    // xfer bylo aktivovano
      if (changeSetting & knc::ChangeXFer) {
        if (abs((int)(230 - (lowXfer + (highXfer  - lowXfer) /2))) > abs((int)(120 - (lowXfer + (highXfer  - lowXfer) /2)))) {
          analogRecords->setVoltage(120);
          analogRecords->setFrequency(60);
          }
        else {
          analogRecords->setVoltage(230);
          analogRecords->setFrequency(50);
          }
        analogRecords->setXfer(lowXfer,highXfer);
        repaintVoltagePanels = true;
        repaintFrequencyPanels = true;
        }
      }
    else {
    // XFER neni aktivovano nebo je nepodporuje UPS
    if ((changeSetting & knc::ChangeVoltage) || ((changeSetting & knc::ChangeXFer))) {
    // byla aktivovana zmena napeti nebo zmena xfer a zaroven ho ups podporuje
      analogRecords->setVoltage(settingData->inputVoltage);
      repaintVoltagePanels=true;
      }
    if ((changeSetting & knc::ChangeFrequency) || ((changeSetting & knc::ChangeXFer))) {
    // byla aktivovana zmena napeti nebo zmena xfer a zaroven ho ups podporuje
      analogRecords->setFrequency(settingData->inputFrequency);
      repaintFrequencyPanels=true;
      }
    }
  }

  // Analog setting
  if ((changeSetting & knc::ChangeCustomAPanelBColor) || // je provedena zmena barvy panelu
      (changeSetting & knc::ChangeAPBColor)) {
  if (settingData->customBAnalogColor) {
    aPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->aPanelBackgroundColor);
    repaintAllPanels=true;
    panelMeter->setAnalogBG(aPanelPalette);
    }
  else {
    aPanelPalette = mainPalette;
    repaintAllPanels=true;
    panelMeter->setAnalogBG(aPanelPalette);
    }
  }

  if ((changeSetting & knc::ChangeCustomAPanelOColor) || // je provedena zmena barvy panelu
      (changeSetting & knc::ChangeAPOColor)) {
     if (settingData->customOAnalogColor) {
       repaintAllPanels=true;
       repaintOAPanels=true;
       }
     else {
       repaintAllPanels=true;
       repaintOAPanels=true;
       }
    }

  // pregenerovani panelu slozi pro settingMain a setting Analog
  panelMeter->repaintAnalogPanels (repaintFrequencyPanels, repaintVoltagePanels, repaintAllPanels);

  if (activeUpsInfo->record.name != "") {
    panelMeter->setSize();
    mainSplit->refresh();
    }

  // UPS Setting
  if (changeSetting & knc::ChangeUpsSetting ) activeMainCombo();
  else {
    if (changeSetting & knc::ChangeUpsCount) activeMainCombo();
    }

  // Main Panel Setting
  // zmena barvy pozadi;
  if (changeSetting & knc::ChangeCustomMPanelBColor) {
    if (!settingData->customBPanelColor) { // nastavime barvu pozadi podle systemu
      frontPanel->setPalette (mainPalette);
      }
    else {
      mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mPanelBackgroundColor);
      frontPanel->setPalette (mPanelPalette);
      }
    }
  else {
    if (changeSetting & knc::ChangeMPBColor ) {
      mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData->mPanelBackgroundColor);
      frontPanel->setPalette (mPanelPalette);
      }
    }

  if (changeSetting & knc::ChangeMainPanelSetting ) {
    if (settingData->panelFlags != frontPanel->getPanelFlags()) {
      frontPanel->setPanelFlags(settingData->panelFlags);
      //aktivujema a presuneme prvky panelu
      frontPanel->paintPanel();
      }
    }

  // Font panel setting
  if (changeSetting & knc::ChangeAnalogFont ) {
    QFont newAnalogFont;
    if (settingData->customFont) {
      newAnalogFont=settingData->aPanelFont;
      }
    else {
      newAnalogFont=settingData->systemFont;
      }

    panelMeter->slotSetPanelsFont(newAnalogFont);
    }
  if (changeSetting & knc::ChangePanelFont ) {
    QFont newPanelFont;
    if (settingData->customFont) {
      frontPanel->slotSetPanelFont(settingData->mPanelFont);
      }
    else {
      frontPanel->slotSetPanelFont(settingData->systemFont);
      }
    }
  }


void KNutMainWindow::slotConfigureKeys() {

  KKeyDialog::configure( actionCollection(), this );
  }

  
void KNutMainWindow::slotCloseKnutClient (void) {
  if (settingData->areYouSure) {
    if (KMessageBox::warningYesNo (0,i18n("Are you sure ?")) == 3) 
      emit endApplication();
    }
  else emit endApplication();
  }


void KNutMainWindow::closeEvent( QCloseEvent *e ){

  e->accept();
  }


void KNutMainWindow::showUpsData (void) {

  if ((activeUpsInfo->upsNet != 0L) && (!activeUpsInfo->netError)) {
    int runtimeVal;
    QString nutStringVar;
    bool okFloat;
//    activeUpsInfo->oldStatus=KNutNet::initStatus;

    // Nastaveni nemenych dat jsou precteny pouze jednou, predpoklada se jejich nemenost
    nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->lowxferVar);
    switch (activeUpsInfo->nutVariables) {
      case 1:
        manufacturer = activeUpsInfo->upsNet->readStringVar("MFR");
        upsModel = activeUpsInfo->upsNet->readStringVar("MODEL");
        serial = activeUpsInfo->upsNet->readStringVar("SERIAL");
        firmrev = activeUpsInfo->upsNet->readStringVar("FIRMREV");
      break;
      case 2:
        manufacturer = activeUpsInfo->upsNet->readStringVar("ups.mfr");
        upsModel = activeUpsInfo->upsNet->readStringVar("ups.model");
        serial = activeUpsInfo->upsNet->readStringVar("ups.serial");
        firmrev = activeUpsInfo->upsNet->readStringVar("ups.firmware");
      break;
      }  
    QString allUpsName = manufacturer + " " + upsModel;
    frontPanel->setAllNameUps (allUpsName);
    frontPanel->setMFRUps (manufacturer);
    frontPanel->setNameUps (upsModel);

    frontPanel->setSerialUps (serial);
    frontPanel->setFirmRevUps (firmrev);
    //Zjistime zda existuji LOWXFER a HIGHXFER pripadne jeji hodnoty

    if (nutStringVar.isNull()) {
      lowXfer =-1;
      highXfer=-1;
      existLowHighXfer = false;
      }
    else {
      lowXfer = atof(nutStringVar);
      nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->highxferVar);
      if (nutStringVar.isEmpty()) {
        highXfer = -1;
        existLowHighXfer = false;
        }
      else {
        highXfer = atof(nutStringVar);
        existLowHighXfer = true;
        }
      }
    int upsStatus=0;
    if ((upsStatus = activeUpsInfo->upsNet->readStatus ()) != -1)
      frontPanel->setPanel(upsStatus);

    if ( !activeUpsInfo->upsNet->existName(activeUpsInfo->runtimeVar)) {
      nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->runtimeVar);
      if (nutStringVar.isEmpty()) runtimeVal=knc::numberVarError;
      else {
        runtimeVal=(int)nutStringVar.toFloat(&okFloat);
        if (!okFloat) runtimeVal = knc::numberVarError;
        }
      }
    else runtimeVal=knc::numberVarError;
    frontPanel->setRuntime(runtimeVal);
      
    panelMeter->deActivateAnalogs();

    // pokud je pouzito XFER nastavime hodnoty
      if (settingData->lowHighXfer) {
        // xfer je nastaveno
        if (existLowHighXfer) {
          if (abs((int)(230 - (lowXfer + (highXfer  - lowXfer) /2))) > abs((int)(120 - (lowXfer + (highXfer  - lowXfer) /2)))) {
            analogRecords->setVoltage(120);
            analogRecords->setFrequency(60);
            }
          else {
            analogRecords->setVoltage(230);
            analogRecords->setFrequency(50);
            }
          analogRecords->setXfer(lowXfer,highXfer);
          }
        }

    panelMeter->activateAnalogs();
    panelMeter->setSize(true);
//    panelMeter->resizeContents(panelMeter->sizeHint().width(),panelMeter->sizeHint().height());
    mainSplit->refresh();
    repaintAnalogs();
    }
  else {
    frontPanel->cleanPanel();
    panelMeter->deActivateAnalogs();
    panelMeter->setSize(false);
//    panelMeter->resizeContents(panelMeter->sizeHint().width(),panelMeter->sizeHint().height());
    mainSplit->refresh();
    }
  }


void KNutMainWindow::zeroingPanels (void) {

  panelMeter->zeroingPanels();
  frontPanel->setRuntime(knc::numberVarError);  
  frontPanel->setPanel(0);
  }

  
void KNutMainWindow::hideUpsData (void) {
  frontPanel->cleanPanel();
  }

void KNutMainWindow::setCombo (QString name) {
  if (toolBar(0)->getCombo(1)->currentText() != name) toolBar(0)->getCombo(1)->setCurrentText(name);
  }

void KNutMainWindow::repaintPanel (void) {
  QString nutStringVar;

  if (activeUpsInfo->upsNet == 0) return;
  if (!activeUpsInfo->upsNet->existName(activeUpsInfo->runtimeVar)) {
    nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->runtimeVar);
    if (nutStringVar.isEmpty())  frontPanel->setRuntime(0);
    else frontPanel->setRuntime( nutStringVar.toInt());
    }
  else frontPanel->setRuntime(knc::numberVarError);
  // precteme status a nastavime zarovky panelu
  int status = activeUpsInfo->upsNet->readStatus();
  frontPanel->setPanel(status);
  }


/// je volan vzdy po timeautu  
void KNutMainWindow::repaintAnalogs (void) {
  QString nutStringVar;
  float numVar;
  bool  newRange = false;

  if ((settingData->lowHighXfer) && (existLowHighXfer)) {
    QString nutStringVar;

    nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->lowxferVar);
    if (! nutStringVar.isEmpty()) {
      float helpLowXfer = nutStringVar.toFloat();
      nutStringVar = activeUpsInfo->upsNet->readStringVar(activeUpsInfo->highxferVar);
      if (! nutStringVar.isEmpty()) {
        float helpHighXfer = nutStringVar.toFloat();
        if ((helpLowXfer != lowXfer) || (helpHighXfer != highXfer)) {
          lowXfer=helpLowXfer;
          highXfer=helpHighXfer;
          analogRecords->setXfer(lowXfer,highXfer);
          newRange = true;
          }
        }
      }
    }


  for (int i=0; i< knc::NumberOfVars; i++) {
    if (activeUpsInfo->record.upsVarCode[i] != 0) { // jistota pokud by nam to nekde propadlo
      switch (activeUpsInfo->nutVariables) {
        case 1:
          nutStringVar = activeUpsInfo->upsNet->readStringVar ((char *)nameUpsVars1[activeUpsInfo->record.upsVarCode[i]]);
        break;
        case 2:
          nutStringVar = activeUpsInfo->upsNet->readStringVar ((char *)nameUpsVars2[activeUpsInfo->record.upsVarCode[i]]);
        break;
        }

      if (nutStringVar.isEmpty())  numVar=0;
      else numVar = nutStringVar.toFloat();

      panelMeter->repaintScaleAnalogPanel (i, numVar);
      if (newRange) panelMeter->repaintAnalogPanels (true, true, false); //freq volt
      panelMeter->repaintAnalogFinger(i,numVar);
      }
    } // end for
  }


  void KNutMainWindow::slotChangeUPS (const QString &name) {
  emit UPSChanged (name);
  }

  
void KNutMainWindow::slotPreferencesUps() {
    emit preferenceUps();
  }



  

/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/


void KNutMainWindow::initStatusBar ( void ) {
  // nastavime hlavni hlaseni v statusbaru

  infoCombo = new KComboBox (statusBar(),"infoCombo");
  infoCombo->setMaxCount(knc::maxCountKNutEvent+1); // nastavime maximalni pocet polozek v Combu
                                                 // pro rezervu pridame jeste jednu
  statusBar()->addWidget(infoCombo,10,false);
  }


void KNutMainWindow::initStatusBarMessage ( void ) {
  // naplnime combo
  #if defined  (KDE_VERSION_MAJOR)
    #if KDE_VERSION_MAJOR >= 3
      QStringList::iterator it;
    #else
      QStringList::Iterator it;
    #endif
  #else
      QStringList::Iterator it;
  #endif


  for ( it = listKNutEvent->begin(); it != listKNutEvent->end(); ++it ) {
    infoCombo->insertItem((*it));
    }
  statusBar()-> setItemAlignment(0,Qt::AlignHCenter|Qt::AlignVCenter);
  infoCombo->setCurrentItem(infoCombo->count()-1);
  }  
  

void KNutMainWindow::initToolBar ( void ) {
  QLabel *upsNazev = new QLabel ("UPS : ",toolBar("mainToolBar"));
  // upsNazev je navazan na toolBar neni potreba volat destruktor
  toolBar ("mainToolBar")->insertWidget (0,upsNazev->sizeHint().width(),upsNazev);
  toolBar ("mainToolBar")->insertCombo("",1,false, SIGNAL (activated (const QString &)),this,SLOT (slotChangeUPS (const QString &)));
  // bude se pouze vybirat-------------------^^^
  KComboBox *combo = toolBar("mainToolBar")->getCombo(1);
  combo->clear();
  toolBar("mainToolBar")->setBarPos (KToolBar::Top);
  //nastavime toolBar nepresovatelny
  setToolBarsMovable(false);
  }


void KNutMainWindow::initAction ( void ) {
  quit = KStdAction::quit (this, SLOT (slotCloseKnutClient()), actionCollection());
  quit->setStatusText(i18n("Quits the application"));

  preferencesUps = KStdAction::preferences (this, SLOT (slotPreferencesUps()), actionCollection(),"options_configure");
  new KAction(i18n("&Showing UPS variables and commands"),0,this,SLOT(slotPrintUPSVars()),actionCollection(),"printupsvars");
  new KAction(i18n("&Running instant commands"),0,this,SLOT(slotInstComms()),actionCollection(),"instcomms");
  new KAction(i18n("Setting R&W variables"),0,this,SLOT(slotRWVars()),actionCollection(),"rwvars");
  KStdAction::showToolbar (this, SLOT (slotShowToolBar()), actionCollection());
  KStdAction::showStatusbar (this, SLOT (slotShowStatusBar()), actionCollection());
  descriptionAction = new KToggleAction(i18n("&Using descriptions"),0,this,SLOT(slotDescription()),actionCollection(),"use_description");
  KStdAction::keyBindings( this, SLOT(slotConfigureKeys()),actionCollection());

  }

void KNutMainWindow::initVars ( void ) {

  activeUpsIndex = -1;

  //nastavime fonty
  mainPalette= kapp->palette();
  areaPalette=mainPalette;
  mPanelPalette=mainPalette;
  aPanelPalette=mainPalette;
  }


int KNutMainWindow::activeMainCombo (void) {
  int activeUpsNameIndex = -1; // zadne upsName neni aktivni
  KComboBox *combo = toolBar(0)->getCombo(1);

  //naplnime comboBox
  combo->clear();
  for (int i=0; i < upsRecords->getCount (); i++) {
    combo->insertItem (upsRecords->getName(i));
    // ulozime si poradove cislo jmena aktivniho ups
    if ((upsRecords->getName(i)) == activeUpsInfo->record.name) activeUpsNameIndex = i;
    }
  return activeUpsNameIndex;
  }

#include "knutmainwindow.moc"
