/***************************************************************************
                          knutmessage.cpp  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutmessage.h"
#include <kglobal.h>
#include <kiconloader.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qtimer.h>



KNutMessage::KNutMessage(const QString messageText, const typeOfMessage type, const long int timeValidity, QWidget *parent, const char *name) : KDialogBase(Plain, "Messages",Ok,Ok, parent, name, false, false) {

  //setWFlags(Qt::WType_TopLevel);
  setCaption("KNutClient");
  messageTimer = 0;
  KIconLoader *loader = KGlobal::iconLoader();

  switch(type) {
    case infoMess:
       ret = loader->loadIcon("messagebox_info", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    case warningMess:
       ret = loader->loadIcon("messagebox_warning", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    case criticalMess:
       ret = loader->loadIcon("messagebox_critical", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    }

   QFrame *page = plainPage();
    
   QVBoxLayout *setTopLayout =     new QVBoxLayout( page, 10, spacingHint(), "setTopLayout" );
   QHBoxLayout *setMessageLayout = new QHBoxLayout( setTopLayout, spacingHint(), "setMessageLayout" );

   QLabel* picture = new QLabel (page);
   QLabel* text = new QLabel (messageText,page);
   picture->setPixmap(ret);

   setMessageLayout->addWidget(picture);
   setMessageLayout->addWidget(text);

   if (timeValidity > 0 ) {
     messageTimer = new QTimer(this);
     if (timeValidity > maxTime)
       messageTimer->start(maxTime*1000);
     else
       messageTimer->start(timeValidity*1000);
     connect (messageTimer,SIGNAL(timeout()),this,SLOT(timeout()));
     disableResize();
    }
  }

KNutMessage::~KNutMessage(){
  }

void KNutMessage::timeout(void) {

  if (messageTimer) messageTimer->stop();
  emit endMessage();
  }


void KNutMessage::slotOk (void) {

  if (messageTimer) messageTimer->stop();
  emit endMessage();
  }

#include "knutmessage.moc"
