/***************************************************************************
                          knutupsdata.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTUPSDATA_H
#define KNUTUPSDATA_H

#include "knutconst.h"
#include "kanalog.h"

#include <qstring.h>
#include <qvaluelist.h>

class QString;

/**
  *@author Daniel Prynych
  */

struct upsRecord {
  QString name; // jmeno
  QString upsName; // name of UPSky <> mojeups
  QString upsAddress; // address of UPS <> muj.pc.cz
  long delay;
  unsigned int port;
  bool tcp;
  QString userName;
  QString password;
  bool savePassword;
  int upsVarCode[knc::NumberOfVars];
  };


 /**
  * Trida obsahuje data o UPS-kach,
  * nazev, adresu port, protokol, promenne atd.
  *
  * @author Daniel Prynych
  * @short Informace o UPS
  * @version 0.3
  **/
class KNutUpsData {

public:
 /**
  * Konstruktor
  *
  * @since  0.2
  **/
  KNutUpsData();

 /**
  * Destruktor
  *
  * @since  0.2
  **/
  ~KNutUpsData();

 /**
  * Prida zaznam.
  *
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  * @since  0.3
  **/
  void add (const upsRecord upsMember);

 /**
  * Prepise zaznam.
  *
  * @param index Udava poradove cislo zaznamu..
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  * @since  0.3
  **/
  void put (const int index, const upsRecord upsMember );

 /**
  * Vrati zaznam.
  *
  * @param index Udava poradove cislo zaznamu.
  * @param upsMember Jsou data zaznamu ve strukture UpsInfo.
  *
  * @since  0.3
  **/
  void get (const int index, upsRecord& upsMember );

 /**
  * Vrati jmeno zaznamu.
  *
  * @param index Udava poradove cislo zaznamu.
  * @since  0.2
  **/
  QString getName (const int index);

 /**
  * Zrusi zaznam.
  *
  * @param index Udava poradove cislo zaznamu.
  *
  * @since  0.2
  **/
  void deleteName (const int index);

 /**
  * Vrati pocet zaznamu.
  *
  * @since  0.2
  **/
  int getCount ( void );

 /**
  * Vrati ukazatel na zaznam, pokud zaznam neexistuje vrati 0.
  *
  * @param name Je jmeno zaznamu.
  * @since  0.2
  **/
  upsRecord* findName (const QString name);



private:
  int countMembers;

 QValueList<upsRecord> listRecords;
};


#endif
