/***************************************************************************
                          knutupsdata.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutupsdata.h"
#include "knutvardata.h"

#include <qstring.h>


KNutUpsData::KNutUpsData()  {
// vytvori seznam UPS
  m_listRecords.clear();
  m_countMembers = 0;
  }

KNutUpsData::~KNutUpsData() { m_listRecords.clear(); }

void KNutUpsData::add (const upsRecord upsMember) {
// vlozime ups na konec
  m_countMembers++;
  m_listRecords.append(upsMember);
  }


void KNutUpsData::put (const int index, const upsRecord upsMember ) {
  if ((index > -1 ) && (index < m_countMembers)) {
    m_listRecords[index] = (upsMember);
    }
  }


void KNutUpsData::get (const int index, upsRecord& upsMember ) {
  if ((index > -1 ) && (index < m_countMembers)) upsMember=m_listRecords[index];
  }

QString KNutUpsData::getName (const int index) {
  if ((index > -1 ) && (index < m_countMembers)) return m_listRecords[index].name;
  else return 0L;
  }


void KNutUpsData::deleteName (const int index) {
  if ((index > -1 ) && (index < m_countMembers)) {
  QValueList<upsRecord>::Iterator it = m_listRecords.begin();
  for (int i =0; i < index; i++) it++;
  m_listRecords.remove(it);
  m_countMembers--;
  }
}


int KNutUpsData::getCount ( void ) { return m_countMembers; }


upsRecord* KNutUpsData::findName (const QString name) {
  QValueList<upsRecord>::Iterator it;
  for (it = m_listRecords.begin(); it != m_listRecords.end(); it++) {
    if ((*it).name == name) {
      return &(*it); // vratime adresu
      }
    }
   return 0l;
  }

