/***************************************************************************
                MODIFIED BY MATIAS HENTTUNEN FOR KOCTAVE!         
		 kwritemain.h  -  description
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kparts/mainwindow.h>
#include <kate/view.h>
#include <kate/document.h>
#include <qstringlist.h>

class KAction;
class KToggleAction;
class KSelectAction;
class KRecentFilesAction;

class Editor : public KParts::MainWindow
{
  Q_OBJECT

  public:
    Editor(Kate::Document * = 0L);
    ~Editor();
    void init(); 			//initialize caption, status and show
    void loadURL(const KURL &url);

  protected:
    class KLibFactory *factory;
    Kate::View *kateView;		//Kate's part in the window
    KRecentFilesAction * m_recentFiles;
    KToggleAction * m_paShowPath;
    KToggleAction * m_paShowToolBar;
    KToggleAction * m_paShowStatusBar;
    
    void setupEditWidget(Kate::Document *);
    void setupActions();
    void setupStatusBar();

    virtual void dragEnterEvent( QDragEnterEvent * );
    virtual void dropEvent( QDropEvent * );
    virtual bool queryClose();
    virtual bool queryExit();
    void setupFxmenu(QPopupMenu *);

  private:
    KURL delayedURL;
    QPopupMenu *fxmenu;		//function menu
    QPopupMenu *subPopup;	//sub menus
    QStringList fxEntry;		//list of functions (including A-Z)    
    int fxFirst;		//id of first in menu    
  public slots:
    void slotSave();		//my own save dialog!	
    void slotNew();
    void slotOpen();
    void slotOpen( const KURL& url);
    void slotOpen_delayed1( const KURL& url );
    void slotOpen_delayed2();
    void slotClose();
    void newView();
    void toggleToolBar();
    void toggleStatusBar();
    void editKeys();
    void editToolbars();
    void functions();		//function menu

  signals:
    void runBuffer(QString *);
    
  public slots:
    void printNow();
    void printDlg();
    void newCurPos();
    void newStatus();
    void newCaption();
    void slotDropEvent(QDropEvent *);
    void slotEnableActions( bool enable );
    bool eventFilter(QObject*, QEvent *);			//F5 = run
    void insertFunction(int);		//insert the selected f(x) to editor

  public:
    void readConfig(KConfig *);	    //common config
    void writeConfig(KConfig *);
    void readConfig();   	    //config file
    
  public slots:
    void writeConfig();
    void runCMDS(int);		//execute this file in octave

  //session management
  public:
    void restore(KConfig *,int);

  protected:
    virtual void readProperties(KConfig *);
    virtual void saveProperties(KConfig *);
    virtual void saveGlobalProperties(KConfig *);		
  private:
    QString encoding;
};
