/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KIS_RAW_IMPORT_H_
#define KIS_RAW_IMPORT_H_

#include <KoFilter.h>

#include "imageviewer.h"
#include "ui_wdgrawimport.h"

class WdgRawImport : public QWidget, public Ui::WdgRawImport
{
    Q_OBJECT

    public:
        WdgRawImport(QWidget *parent) : QWidget(parent) { setupUi(this); }
};

class K3Process;
class KDialog;
class WdgRawImport;
class KoColorProfile;
class QProgressDialog;

class KisRawImport : public KoFilter {
    Q_OBJECT

public:
    KisRawImport(QObject* parent, const QStringList&);
    virtual ~KisRawImport();

public:
    virtual KoFilter::ConversionStatus convert(const QByteArray& from, const QByteArray& to);


private slots:

    void slotUpdatePreview();
    void slotFillCmbProfiles();
    void slotProcessDone();
    void slotReceivedStdout(K3Process *proc, char *buffer, int buflen);
    void slotReceivedStderr(K3Process *proc, char *buffer, int buflen);
    void incrementProgress();

private:

    QStringList createArgumentList(bool forPreview = false);
    QSize determineSize(quint32& startOfImageData);
    void getImageData(QStringList arguments);
    KoColorProfile * profile();
    KoID colorSpace();
    
private:
    QByteArray * m_data;
    KDialog * m_dialog;
    WdgRawImport * m_page;
    KoColorProfile * m_monitorProfile;
    K3Process * m_process;
    QProgressDialog* m_progress;
};

#endif // KIS_RAW_IMPORT_H_

