<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See docs/AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.5 $
 *
 *  ABOUT
 *  -----
 *
 *  This script displays a users free/busy information.
 *
 */

/* Load the required free/busy libraries - this also loads Horde:: and
 Util:: as well as the PEAR constants*/ 
require_once 'Kolab/Freebusy/Page.php';

/* Load the configuration */ 
require_once 'config.php';

/* Profiling */
$timer = &new Timer();

/* Get the user requsted */
$req_owner = Util::getFormData('uid');

Horde::logMessage(sprintf(_("Starting generation of free/busy data for user %s"), 
                          $req_owner), __FILE__, __LINE__, PEAR_LOG_DEBUG);

/* Validate folder access */
$access = &new FolderAccess();
$result = $access->parseOwner($req_owner);
if (is_a($result, 'PEAR_Error')) {
    Kolab_Freebusy_Error::notFound($result);
}

Horde::logMessage(sprintf(_("Free/busy data of owner %s on server %s requested by user %s."),
                          $access->owner, $access->homeserver, $access->user), 
                  __FILE__, __LINE__, PEAR_LOG_DEBUG);

/* Try to fetch the data if it is stored on a remote server */
$result = $access->fetchRemote();
if (is_a($result, 'PEAR_Error')) {
    Kolab_Freebusy_Error::unauthorized($result);
}

/* Load the cache class now */
require_once('Kolab/Freebusy/Cache.php');

/* Where is the cache data stored? */
if (!empty($conf['fb']['cache_dir'])) {
    $cache_dir = $conf['fb']['cache_dir'];
} else {
    /* This default is not recommended so make sure you set a 
     * cache dir outside of the apache document root.
     */
    $cache_dir = dirname(__FILE__) . '/cache';
}
$cache = &new FreeBusyCache($cache_dir);

/* Get the cache request variables */
$req_extended = Util::getFormData('extended', false);

$result = $cache->load($access, $req_extended);
if (is_a($result, 'PEAR_Error')) {
    Kolab_Freebusy_Error::notFound($result);
}

/* And finally send it out */
$view = &new FreeBusyView($result);
$view->render($access->owner . '.vfb');

/* Finish up */
Horde::logMessage(sprintf(_("Free/busy generation complete, execution time was %s seconds."), 
                          $timer->stop()), __FILE__, __LINE__, PEAR_LOG_DEBUG);
?>
