<?php
/*
 *  COPYRIGHT
 *  ---------
 *
 *  See docs/AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.7 $
 *
 *  ABOUT
 *  -----
 *
 *  This script regenerates the cached free/busy information.
 *
 */

error_reporting(E_ALL);
ini_set('memory_limit', -1); /* requires safe_mode to be turned off */

/* Load the configuration */ 
require_once 'config.php';

/* Load the required free/busy libraries - this also loads Horde:: and
 Util:: as well as the PEAR constants*/ 
require_once 'Kolab/Freebusy/Page.php';

$access = &new FolderAccess();
$result = $access->authenticate();
if (is_a($result, 'PEAR_Error')) {
    echo "Failed to authenticate!\n";
    echo $result->getMessage();
    exit(-1);
 }

/* Load the required Kolab libraries */ 
require_once "Horde/Kolab.php";
require_once "Horde/Kolab/IMAP.php";

$imap = new Kolab_IMAP();
$folders = $imap->listFolders();

if (is_a($folders, 'PEAR_Error')) {
    echo "Failed to fetch the IMAP folders!\n";
    echo $folders->getMessage();
    exit(-1);
 }

if (!is_array($folders)) {
    echo "Expected list of IMAP folders but got:\n";
    var_dump($folders);
    exit(-1);
 }

$calendars = array();

foreach ($folders as $folder) {

    if ($folder[1] == 'event' && (substr($folder[0], 0, 6) != 'shared')) {
        $calendars[] = $folder[0];
    }
}

/* Load the cache class now */
require_once('Kolab/Freebusy/Cache.php');

/* Where is the cache data stored? */
if (!empty($conf['fb']['cache_dir'])) {
    $cache_dir = $conf['fb']['cache_dir'];
} else {
    /* This default is not recommended so make sure you set a 
     * cache dir outside of the apache document root.
     */
    $cache_dir = dirname(__FILE__) . '/cache';
}

$cache = &new FreeBusyCache($cache_dir);

foreach ($calendars as $calendar) {

    $failed = false;

    /* We are using imap folders for our calendar list but 
     * the library expects us to follow the tripper format
     * used by pfb.php
     */
    $req_domain = explode('@', $calendar);
    $domain = $req_domain[1];
    $req_folder = explode('/', $req_domain[0]);
    unset($req_folder[0]);
    $owner = $req_folder[1];
    unset($req_folder[1]);
    $trigger = $owner . '@' . $domain . '/' . join('/', $req_folder);
    $trigger = String::convertCharset($trigger, 'UTF7-IMAP', 'UTF-8');

    /* Validate folder access */
    $result = $access->parseFolder($trigger);
    if (is_a($result, 'PEAR_Error')) {
        echo "Failed accessing calendar \"" . $calendar . "\"!\n";
        var_dump($result);
        exit(-1);
    }

    /* Hack for allowing manager access */
    if ($access->user == 'manager') {
        $imapc = &Kolab_IMAP_Connection::singleton(Kolab::getServer('imap'),
                                                   $GLOBALS['conf']['kolab']['imap']['port']);
        $imapc->connect($access->user, $access->pass);
        if (is_a($imapc, 'PEAR_Error')) {
            echo "Failed connecting the server!\n";
            var_dump($imapc->getMessage());
            exit(-1);
        }
        $acl = $imapc->getACL($calendar);
        if (is_a($acl, 'PEAR_Error')) {
            echo "Failed accessing calendar \"" . $calendar . "\"!\n";
            var_dump($acl->getMessage());
            exit(-1);
        }
        $oldacl = '';
        if (isset($acl['manager'])) {
            $oldacl = $acl['manager'];
        }
        $result = $imapc->setACL($calendar, 'manager', 'lrs');
        if (is_a($result, 'PEAR_Error')) {
            echo "Failed setting manager ACL to \"lrs\"!\n";
            var_dump($result->getMessage());
            exit(-1);
        }
    }

    echo "Regenerating calendar \"" . $calendar . "\"!\n";

    /* Update the cache */
    $result = $cache->store($access);
    if (is_a($result, 'PEAR_Error')) {
        echo "Failed regenerating cache for calendar \"" . $calendar . "\"!\n";
        echo $result->getMessage();
        $failed = true;
    }

    /* Revert the acl  */
    if ($access->user == 'manager' && $oldacl) {
        $result = $imapc->setACL($calendar, 'manager', $oldacl);
        if (is_a($result, 'PEAR_Error')) {
            echo "Failed resetting manager ACL to \"" . $oldacl . "\"!\n";
            var_dump($result->getMessage());
            exit(-1);
        }
    }

    if ($failed) {
        exit(-1);
    }
}
?>
