/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "administrator_description.h"
#include "administrator_listingmodel.h"
#include "administrator_policy.h"
#include "administrator_record.h"

#include "administrator_page.h"

AdministratorPage::AdministratorPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

AdministratorPage::~AdministratorPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString AdministratorPage::name() const
{
  return "administrator";
}

QString AdministratorPage::title() const
{
  return QObject::tr( "Administrators" );
}

QString AdministratorPage::description() const
{
  return QObject::tr( "Manage Administrators" );
}

QString AdministratorPage::iconName() const
{
  return "administrator";
}

ListingModel* AdministratorPage::model()
{
  if ( !mModel )
    mModel = new AdministratorListingModel;

  return mModel;
}

Form::Description* AdministratorPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::AdministratorDescription;

  return mDescription;
}

Form::PagePolicy* AdministratorPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::AdministratorPolicy;

  return mPolicy;
}

Form::Record* AdministratorPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::AdministratorRecord;

  return mRecord;
}
