/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QCheckBox>

#include "booleanfield.h"

using namespace Form;

BooleanField::BooleanField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mCheckBox = new QCheckBox( this );

  fieldLayout()->addWidget( mCheckBox, 0, 0 );
}

void BooleanField::loadEntry( const Entry &entry )
{
  if ( defaultValue() == "TRUE" )
    mCheckBox->setChecked( true );
  else
    mCheckBox->setChecked( false );

  if ( entry.value( name() ) == "TRUE" )
    mCheckBox->setChecked( true );
  else if ( entry.value( name() ) == "FALSE" )
    mCheckBox->setChecked( false );
}

void BooleanField::saveEntry( Entry &entry ) const
{
  entry.setValue( name(), ( mCheckBox->isChecked() ? "TRUE" : "FALSE" ) );
}

bool BooleanField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void BooleanField::setEditable( bool editable )
{
  mCheckBox->setEnabled( editable );
}

