/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QLineEdit>

#include "stringfield.h"

using namespace Form;

StringField::StringField( const QString &name, ValidateType type, QWidget *parent )
  : Field( name, parent ), mType( type )
{
  mLineEdit = new QLineEdit( this );

  fieldLayout()->addWidget( mLineEdit, 0, 0 );
}

void StringField::loadEntry( const Entry &entry )
{
  mLineEdit->setText( entry.value( name() ) );
}

void StringField::saveEntry( Entry &entry ) const
{
  entry.setValue( name(), mLineEdit->text() );
}

bool StringField::isValid( QString &message, PagePolicy::State ) const
{
  if ( mType == InvalidateEmpty && mLineEdit->text().isEmpty() ) {
    message = QObject::tr( "You have to fill out all required fields (%1)" ).arg( name() );
    return false;
  } else
    return true;
}

void StringField::setEditable( bool editable )
{
  mLineEdit->setReadOnly( !editable );
}

