/***************************************************************************
                          mymaster.cpp  -  description
                             -------------------
    begin                : Thu Apr 6 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include <kdebug.h>

#include "mymaster.h"

MyMaster::MyMaster (const QString & workgroup, QObject * parent):
QObject (parent),
proc (0),
wg (workgroup)
{
}

MyMaster::~MyMaster ()
{
  if (proc)
    {
      kdWarning (7199) << "MyMaster: Process not exited..." << endl;
      proc->kill ();
      delete proc;
    }
}

/** Liest den Masterbrowser ein */
void
MyMaster::getMaster ()
{
  proc = new KProcess ();
  if (!proc)
    {
      kdError (7199) << "MyMaster : Can't create a process." << endl;
      return;
    }
  (*proc) << "nmblookup" << "-M" << wg << "-S";
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (MyMasterStdout (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::Stdout);
  return;
}


void
MyMaster::MyMasterStdout (KProcess *, char *buffer, int n)
{
  out.append (QString::fromLocal8Bit (buffer, n));
}

/** Wird aufgerufen wenn der Process sich beendet */
void
MyMaster::onProcExit (KProcess * killedproc)
{
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdWarning (7199) << "MyMaster : Mmmhhh... not my process" << endl;
  int i;
  u_long ip = 0;
  QString s = out;
  i = s.find (wg + "<1d>");	// <1d> means ->Workgroup
  // Find the IP
  if (i > 0)
    {
      s.truncate (i);
      i = s.findRev ("\n");
      if (i > 0)
	s = s.right (s.length () - i - 1);
      ip = htonl (inet_addr ((const char *) s.stripWhiteSpace ()));
      s = out;
      // Find the Mastername
      i = s.find ("<00>");	// <00> means ->Workstation
      if (i > 0)
	{
	  s.truncate (i);
	  i = s.findRev ("\n");
	  if (i > 0)
	    {
	      s = s.right (s.length () - i - 1);
	      s = s.stripWhiteSpace ();
	    }
	}
      else
	s = "NONAMEFOUND";
      emit isMasterName (s, wg, ip);
    }
  emit isExited (this);
}
