***************************************************************************
  net.cpp - description
/* Gnomba - Gnome Samba Browser
 * Copyright (C) 1999 Gnomba Team
 *
 * net.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "net.h"
#include "stream.h"
  net::net ()
{
  host_count = 0;
}

int
net::getNMBInfo (u_long ip, char *machine, char *workgroup)
{
  struct sockaddr_in sin_dst;
  struct nmbhdr *nmb;
  struct typez *typz;
  char *data;

  char buffer[1024];
  SOCKET socket_client;
  int i;
  int longueur = sizeof (struct sockaddr_in);
  int count;
  struct _nameinfo
  {
    char name[15];
    char type;
    char res;
    char fill;
  }
   *ninf;
  struct timeval timeout1 = { 0, 10000 };
  fd_set rfds;
  bool canread = true;


  bzero (buffer, sizeof (buffer));
  nmb = (struct nmbhdr *) buffer;
  data = (char *) (buffer + NMBHDRSIZE);
  typz = (struct typez *) (buffer + NMBHDRSIZE + 33);

  sin_dst.sin_family = AF_INET;
  sin_dst.sin_port = htons (137);
  sin_dst.sin_addr.s_addr = ip;

  memcpy (data, "CKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 34);

  nmb->id = 0x600;
  nmb->R = 0;			/* 0 for question 1 for response */
  nmb->opcode = 0;		/* 0 = query */
  nmb->que_num = htons (1);	/* i have only 1 question :) */
  nmb->namelen = 0x20;
  typz->type = 0x2100;
  typz->type2 = 0x0100;

  socket_client = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);

  sendto (socket_client, buffer, 50, 0, (struct sockaddr *) &sin_dst,
	  sizeof (sockaddr_in));

  FD_ZERO (&rfds);
  FD_SET (socket_client, &rfds);
  bzero (buffer, sizeof (buffer));
  nmb = (struct nmbhdr *) (buffer);
  machine[0] = '\0';
  workgroup[0] = '\0';

  sock_unblock (socket_client);
  if (select (socket_client + 1, &rfds, 0, 0, &timeout1) < 0
      || !FD_ISSET (socket_client, &rfds))
    // there nothing to read, timeout reached.
    canread = false;

  if (canread)
    {
      if (recvfrom
	  (socket_client, buffer, sizeof (buffer), 0,
	   (struct sockaddr *) &sin_dst, (socklen_t *) & longueur) != -1)
	{
	  if (nmb->rep_num != 0)
	    {

	      /*set to first nameblock after header */
	      count = 0;
	      ninf =
		(struct _nameinfo *) (buffer + 57 +
				      (count++ * sizeof (struct _nameinfo)));
	      while ((machine[0] == '\0')
		     && (57 + (count * sizeof (struct _nameinfo)) < 1024))
		{
		  if (ninf->type == 0)
		    {
		      i = 0;
		      while ((i < 15))
			{
			  machine[i] = ninf->name[i];
			  i++;
			}
		      machine[i] = '\0';
		      trim (machine);
		    }
		  ninf =
		    (struct _nameinfo *) (buffer + 57 +
					  (count++ *
					   sizeof (struct _nameinfo)));
		}
	      if (machine[0] == '\0')
		{
		  printf
		    ("we finished without finding anything, giving up\n");
		  close (socket_client);
		  return (-1);
		}
	      while ((workgroup[0] == '\0')
		     && (57 + (count * sizeof (struct _nameinfo)) < 1024))
		{
		  if (ninf->type == 0)
		    {
		      i = 0;
		      while ((i < 15))
			{
			  workgroup[i] = ninf->name[i];
			  i++;
			}
		      workgroup[i] = '\0';
		      trim (workgroup);
		    }
		  ninf =
		    (struct _nameinfo *) (buffer + 57 +
					  (count++ *
					   sizeof (struct _nameinfo)));
		}
	      if (workgroup[0] == '\0')
		{
		  printf
		    ("we finished without finding anything, giving up\n");
		  close (socket_client);
		  return (-1);
		}
	      close (socket_client);
	      return 0;
	    }
	  close (socket_client);
	  return (-1);
	}
    }
  close (socket_client);
  return (-1);

}

net::~net ()
{
}

void
net::sock_unblock (SOCKET s)
{
#ifdef WIN32
  u_long flag = 1;		/* (doblock ? 0 : 1) */
  ioctlsocket (s, FIONBIO, &flag);
#else
  int flag = O_NONBLOCK | fcntl (s, F_GETFL);
  fcntl (s, F_SETFL, flag);
#endif
}

void
net::sock_block (SOCKET s)
{
#ifdef WIN32
  u_long flag = 0;		/* (doblock ? 0 : 1) */
  ioctlsocket (s, FIONBIO, &flag);
#else
  int flag = (~O_NONBLOCK) & fcntl (s, F_GETFL);
  fcntl (s, F_SETFL, flag);
#endif
}

void
net::trim (char *str)
{

  int i;

  for (i = strlen (str) - 1; i >= 0; i--)
    if (str[i] != ' ' && str[i] != '\t')
      break;
  str[i + 1] = '\0';
}
