/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIG_H
#define CONFIG_H

#include <qdom.h>
#include <qlistview.h>

#include "kommando.h"

class Config{
	public:
		static Config& getSingleton(){
			static Config instance;
			return instance;
		}
		
		~Config();
		
		bool readConfigFile();
		bool writeConfigFile();
		void fromConfigDlg(const QListView* listView);
		void toConfigDlg(QListView* listView);
		void toKommandoMenu(Kommando* buttonParent);
		void setDefaultValues( QListView* listView);

		void setConfigPath(const QString& path){ mConfigPath = path; }

		void setShortcut(const QString& cut){ mShortcut = cut; }

		QString Shortcut() const{ return mShortcut; }

		void setTintColor(const QColor& theValue){ mTintColor = theValue; }
		QColor tintColor() const { return mTintColor; }

		void setOpacity(const float value){mOpacity=value;}
		float opacity() const {return mOpacity;}

	protected:
		Config();
		Config( const Config&);
		QString mConfigPath;
		QString mShortcut;
		QColor mTintColor;
		float mOpacity;
		QDomDocument* doc;
		
};

#endif
