/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORWIDGET_H_
#define _KOMPARATORWIDGET_H_

#include <QWidget>
#include <QKeyEvent>
#include <QCustomEvent>
#include <QPixmap>
#include <QDropEvent>

#include <kio/jobclasses.h>

#include "komparatorpreset.h"
#include "ui_komparatorwidgetbase.h"

class KomparatorCompareJob;
class KomparatorEmptyDirectoryJob;
class KFileItem;
class KFileItemExt;
class KListViewItemDups;
class KSystemTrayIcon;
class QColor;
class QMovie;
class QTimer;
class KTemporaryFile;
class KQuery;
class KMenu;
class KomparatorDynamicErrorDialog;

enum STATUS
{
	CLEAN = 0,
	SEARCHING_URL_1,
	SEARCHING_URL_2,
	SEARCHING_EMPTY_DIRECTORIES,
	COMPARING,
	READY,
	INTERACTING
};

enum URL_MODE
{
	URL_URL = 0,
	URL_DIR_OR_URL,
	URL_DIR_OR_URL_ONLY,
	URL_FILE_NAME,
	URL_REPLACE
};

enum LIST_VIEW
{
	DUPLICATES = 0,
	MISSING,
	NEWER
};

enum FILE_REMOVE
{
	IDLE = 0,
	TRASH,
	DELETE,
	TRASH_COREF,
	DELETE_COREF
};

class KomparatorWidget : public QWidget, public Ui::komparatorwidgetbase
{
	Q_OBJECT

	public:
		KomparatorWidget( const KUrl &url1, const KUrl &url2, QWidget* parent = 0 );
		~KomparatorWidget();

		void keyPressEvent( QKeyEvent *event );

		KomparatorTreeWidget *current_list_view; // public for key event handler.

		KomparatorCompareJob *compare_job;        // public for byte comparison (KFileItemExt::getFile(...))

		bool isEnabled( LIST_VIEW list_view ); // public for komparatorpreset

		KIcon broadIcon( const QPixmap pm1, const QPixmap pm2 );

		bool isSystrayVisible();
	private:
		Ui::komparatorwidgetbase ui_komparatorwidgetbase;

	public slots:
    // USER INTERFACE SLOTS
		virtual void slotSearch();
		virtual void slotWhatsThis();
		virtual void slotKomparatorTreeWidgetDropped( QWidget *source, QWidget *destination, const QPoint &pos );
		virtual void slotContextMenuDups1( const QPoint &p ) { slotContextMenu( duplicates1_KListView, p ); }
		virtual void slotContextMenuDups2( const QPoint &p ) { slotContextMenu( duplicates2_KListView, p ); }
		virtual void slotContextMenuNewer1( const QPoint &p ) { slotContextMenu( newer1_KListView, p ); }
		virtual void slotContextMenuNewer2( const QPoint &p ) { slotContextMenu( newer2_KListView, p ); }
		virtual void slotContextMenuMissing1( const QPoint &p ) { slotContextMenu( missing1_KListView, p ); }
		virtual void slotContextMenuMissing2( const QPoint &p ) { slotContextMenu( missing2_KListView, p ); }
		virtual void slotContextMenu( KomparatorTreeWidget *list_view, const QPoint &p );
		virtual void slotCompareEqual();
		virtual void slotCompareSelected();
		virtual void slotRemoveFromList();
		virtual void slotOpenBinding();
		virtual void slotExecute( QTreeWidgetItem *item, int );
		virtual void slotOpenDirectory();
		virtual void slotCopySelection();
		virtual void slotTrashFiles();
		virtual void slotDeleteFiles();
		virtual void slotTrashNonreferenceFiles();
		virtual void slotDeleteNonreferenceFiles();
		virtual void slotRemoveNext( KJob *finished_job );
		virtual void slotOpenWith();
		virtual void slotFileProperties();
		virtual void slotFilePropertiesRenamed( const KUrl &old_url, KUrl &new_url );
		virtual void slotFilePropertiesChanged();
		virtual void slotFilePropertiesNextStat( KJob *finished_job );
		virtual void slotCopyNewerR2L();
		virtual void slotCopyNewerL2R();
		virtual void slotCopyMissingR2L();
		virtual void slotCopyMissingL2R();
		virtual void slotCopyToOtherSide();
		virtual void slotCopyNext( KJob *finished_job );
		virtual void slotCopyNextStat( KJob *finished_job );
		virtual void slotMoveMissingL2R();
		virtual void slotMoveMissingR2L();
		virtual void slotMoveNewerL2R();
		virtual void slotMoveNewerR2L();
		virtual void slotMoveToOtherSide();
		virtual void slotMoveNext( KJob *finished_job );
		virtual void slotMoveNextStat( KJob *finished_job );
		virtual void slotTrashDuplicates();
		virtual void slotDeleteDuplicates();
		virtual void slotRemoveSelectionMissing1();
		virtual void slotRemoveSelectionMissing2();
		virtual void slotRemoveSelectionNewer1();
		virtual void slotRemoveSelectionNewer2();
		virtual void slotReferenceLeft( bool is_ref );
		virtual void slotDuplicateSelected();
		virtual void slotPresetSelected( int sel );
		virtual void slotAddPreset();
		virtual void slotRemovePreset();
		virtual void slotUpdatePreset();
		virtual void slotSystray();
		virtual void slotTextColor();
		virtual void slotWarningTrash();
		virtual void slotWarningDelete();
		virtual void slotWarningOverwriteCopy();
		virtual void slotWarningOverwriteMove();
		virtual void slotWarningReload();
		virtual void slotWarningRemovePreset();
		virtual void sizeComboActivated( int act );

		// KQUERY SLOTS
		virtual void slotResult( int error_code, QString error_string );
		virtual void slotAddFile( const KFileItem* item, const QString & );

		// KOMPAREJOB SLOTS
		virtual void slotFileDownloaded( KJob *job );

		// KOMPARATOR FILE FILTER SLOTS
		virtual void slotFilterChanged( KomparatorFileFilter *filter, const QString &name, const QString &path,
			const QString &owner, const QString &group, const unsigned long &min_size, const unsigned long &max_size,
			const bool &consider_date, const QDate &date, const bool &newer_real, const bool &newer_equal, const bool &newer_same_time );
		virtual void slotFilterChanged( KomparatorFileFilter *, const QString &/*name*/,
			const QString &/*path*/, const QString &/*owner*/, const QString &/*group*/, const unsigned long &/*min_size*/,
			const unsigned long &/*max_size*/, const bool &/*consider date*/, const QDate &/*date*/,
			const bool &/*duplicates_normal*/, const bool &/*duplicates_multiple*/ );
		virtual void slotFilterChanged( KomparatorFileFilter *filter, const QString &name, const QString &path,
			const QString &owner, const QString &group, const unsigned long &min_size, const unsigned long &max_size,
			const bool &consider_date, const QDate &date );

		// INTERACTION SLOTS
		virtual void slotInteractionDuplicate( KFileItemExt *file );
		virtual void slotInteractionCompMissing( KFileItemExt *file );
		virtual void slotInteractionCompNewer( KFileItemExt *file1, KFileItemExt *file2 );
		virtual void slotInteractionCompNewerEqual( KFileItemExt *file1, KFileItemExt *file2 );
		virtual void slotInteractionCompNewerSameTime( KFileItemExt *file1, KFileItemExt *file2 );
		virtual void slotInteractionCompFinished();
		virtual void slotInteractionEmptyFinished();
		virtual void slotInteractionDownloadFile( KFileItemExt *file );
		virtual void slotInteractionProgressProgress( const QString &message, const int &progress );
		virtual void slotInteractionMessageError( const QString &message, const QString &title );

		// INTERNAL SLOTS
		virtual void slotSizeTypeChanged( int i );
		virtual void slotMD5ChecksumEnabled( bool e );
		virtual void slotDuplicatesOnlyEnabled( bool e );
		virtual void slotSizeEnabled( bool e );
		virtual void slotProgress( QString str, int percent, QString notification );
		virtual void slotProgressUndefined();
		virtual void slotCount( int list_view, int which, int visible_items ); // -1 visible_items means: calculate it.
		virtual void slotStartSystrayMovie();
		virtual void slotStopSystrayMovie();

	signals:
		void signalProgress( QString, int, QString );
		void signalSaveListViewColumnWidth();
		void signalStartSystrayMovie();
		void signalStopSystrayMovie();
		void signalCount( int, int, int );
		void signalAddErrorMessage( QString );

	private:
		KQuery *m_query;
		STATUS m_status;
		FILE_REMOVE m_file_remove_action;

		KomparatorDynamicErrorDialog *m_error_dialog;

		KUrl m_url1;
		KUrl m_url2;

		KUrl::List m_symlinked_directories;
		KUrl::List m_virtual_subdirectories;
		KUrl m_virtual_subdirectory_current;

		KomparatorEmptyDirectoryJob *m_empty_directory_job;

		KMenu *m_popup_menu;

		KFileItemExt *m_files;
		KFileItemExt *m_dirs_dupes;

		QStringList m_unreadable_files;
		uint m_number_of_files;

		int m_duplicates1_width[7];
		int m_duplicates2_width[8];
		int m_missing1_width[7];
		int m_missing2_width[7];
		int m_newer1_width[7];
		int m_newer2_width[7];

		QList< KomparatorPreset* > m_preset_list;

		QColor m_red, m_green, m_blue, m_purple;

		bool m_interaction_cancel;
		uint m_interaction_progress;
		QString m_interaction_progress_str;
		uint m_interaction_total;
		QList< QTreeWidgetItem* > m_interaction_copy_remaining_items;
		QList< KFileItemExt* > m_interaction_remove_remaining_items;
		KUrl::List m_interaction_empty_dirs;
		KUrl::List m_interaction_empty_dirs_file_urls;

		void addWhatsThisHelp();

		void removeFirst();

		bool m_properties_renamed;

		void removeDeletedFromLists( KFileItemExt *item, bool duplicates_only = false, bool add_brother_missing = true );
		void checkEmptyDirs( KUrl::List &urls, KUrl::List &file_urls );

		bool initializeQuery();
		bool isDateValid();
		void enable( bool e );
		void resizeListViewColumns();
		void updateFilters();

		QString prettyUrl( const KUrl &url, URL_MODE mode, const KUrl &rep );

		KFileItemExt *m_requested_download;
		KJob *m_requested_download_job;

		QTimer *m_progress_timer;

		KSystemTrayIcon *m_systray;
		QMovie *m_systray_movie;

		KSharedConfigPtr m_config;
		KConfigGroup m_configgroup;
};

#endif
