/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPAREDIALOG_H_
#define _KOMPAREDIALOG_H_

#include <kdialogbase.h>

class KFileItem;
class KFileItemExt;
class KProcess;
class QString;
class KSqueezedTextLabel;
class QPushButton;

enum KOMPARE_RESULT
{
	CANCEL = 0,
	COPY_LEFT_TO_RIGHT = 1,
	COPY_RIGHT_TO_LEFT = 2,
	MOVE_LEFT_TO_RIGHT = 4,
	MOVE_RIGHT_TO_LEFT = 8,
	TRASH_LEFT = 16,
	TRASH_RIGHT = 32,
	DELETE_LEFT = 64,
	DELETE_RIGHT = 128,
	DIRTY = 256
};

class KompareDialog : public KDialogBase
{
	Q_OBJECT

	public:
		KompareDialog( QWidget *_parent, KFileItemExt *_item1, KFileItemExt *_item2, const QString &url1, const QString &url2, bool _md5 );
		~KompareDialog();
		int getResult();

	public slots:
		void slotMD5_1();
		void slotMD5_2();
		void slotPreview( const KFileItem *item, const QPixmap &pixmap );
		virtual void slotOk();
		virtual void slotCancel();
		virtual void slotUser1();
		void slotReceivedStdout( KProcess *, char *buffer, int );
		void slotProcessExited( KProcess * );
		void slotCopyLeftRight( bool toggled );
		void slotCopyRightLeft( bool toggled );
		void slotMoveLeftRight( bool toggled );
		void slotMoveRightLeft( bool toggled );
		void slotTrashRight( bool toggled );
		void slotTrashLeft( bool toggled );
		void slotDeleteRight( bool toggled );
		void slotDeleteLeft( bool toggled );
	
	private:
		QWidget *m_parent;
		KProcess *m_kompare_proc;
		bool m_has_kdiff3;
		bool m_md5;
		KSqueezedTextLabel *m_md5_label1;
		KSqueezedTextLabel *m_md5_label2;
		QPushButton *m_md5_button1;
		QPushButton *m_md5_button2;
		QLabel *m_preview_label1;
		QLabel *m_preview_label2;
		KFileItemExt *m_item1;
		KFileItemExt *m_item2;

		int m_result;

		QPushButton *m_copy_l_r;
		QPushButton *m_move_l_r;
		QPushButton *m_trash_l;
		QPushButton *m_delete_l;
		QPushButton *m_trash_r;
		QPushButton *m_delete_r;
		QPushButton *m_copy_r_l;
		QPushButton *m_move_r_l;

		void createTitle( QWidget *local_parent, KFileItemExt *item );
		QWidget *createBasicInfos( QWidget *local_parent, KFileItemExt *item, const QString &url );
		QWidget *createExtendedInfos( QWidget *local_parent, KFileItemExt *item );
		void createMetaInfos( QWidget *local_parent, KFileItemExt *item );

		bool isTextFile( KFileItemExt *item );
};

#endif
