/*******************************************************************************
**                         profilemanager.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef PROFILEMANAGER_H
#define PROFILEMANAGER_H

// Qt includes
#include <qstring.h>
#include <qptrlist.h>

// KDE includes
#include <kurl.h>

// My includes
#include "backupprofile.h"
#include "profilemngrinterface.h"

////////////////////////////////////////////////////////////////////////////////
///////                  class ProfileManager                            ///////
////////////////////////////////////////////////////////////////////////////////

class ProfileManager : public QObject, public Subject
{
    Q_OBJECT

public:
    ProfileManager();
    ~ProfileManager();

    void insertCalled( BackupProfile *b );
    void changeCalled( BackupProfile *b );
    void removeCalled( QString s );
    bool existsCalled( QString s );
    void restoreCalled( QString s );

public slots:
    void activate();
    void slotDoBackup( QString identifier );

private:
    void insertProfile( BackupProfile *bp );
    void newProfile( BackupProfile *bp );
    void changeProfile( BackupProfile *bp );
    void removeProfile( QString id );

    BackupProfile* getProfile( QString id );

private:
    QPtrList<BackupProfile> mProfileList;
};

#endif
