/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QtGui>
#include <QtNetwork>
  #ifdef WIN32
#include <winsock.h>
  #endif
#include "ClientShell.h"

ClientShell::ClientShell()
    : file("./file.kop")
{
    QHostInfo hostInfo = QHostInfo::fromName(QHostInfo::localHostName());
    addresses = hostInfo.addresses();
    image = new QLabel(this);
    #ifdef WIN32
    image->setPixmap(QPixmap(":/icons/120px-Computer-windows.png"));
    #elif defined (linux)
    image->setPixmap(QPixmap(":/icons/120px-Computer-linux2.png"));
    #elif defined __APPLE__
    image->setPixmap(QPixmap(":/icons/120px-Computer-mac.png"));
    #endif
    groupBox = new QGroupBox(tr("Host information"), this);
    QGridLayout *gridBox = new QGridLayout;
    gridBox->addWidget(image, 0, 0);
    #ifdef WIN32
    QString os = QString("Microsoft Windows");
    #elif defined (linux)
    QString os = QString("GNU/Linux");
    #elif defined __APPLE__
    QString os = QString("Mac OS X");
    #endif
    QLabel *infos1 = new QLabel(QString(os));
    gridBox->addWidget(infos1, 1, 0);
    if (!addresses.isEmpty()) {
        gridBox->addWidget(new QLabel(addresses.first().toString()), 2, 0);
        gridBox->addWidget(new QLabel(addresses.last().toString()), 3, 0);
    }
    gridBox->addWidget(new QLabel(" "), 4, 0, 7, 1);
    groupBox->setLayout(gridBox);
    statusLabel = new QLabel(tr("Status : Disconnected"), this);
    QLabel *label = new QLabel(tr("<strong>KontrolPack in Client Mode</strong> is aimed to be connected via <br /><strong>TCP/IP</strong> to a <strong>KontrolPack started in Server mode</strong><br />.<br /><br /> Connect remotely <strong>KontrolPack in server mode</strong> to control<br /> this computer :<br />"
					"<a href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a>"), this);
    startButton = new QPushButton(QIcon(":/icons/media-playback-start.png"), tr("Connect to server"), this);
    stopButton = new QPushButton(QIcon(":/icons/media-playback-stop.png"), tr("Stop"), this);
    label->setOpenExternalLinks(true);
    stopButton->setDisabled(true);
    xmlParser = new XmlResultsParserClient();
    connect(startButton, SIGNAL(clicked()), this, SLOT(connectToServer()));
    connect(stopButton, SIGNAL(clicked()), this, SLOT(stopClient()));
    QString path = QDir::homePath();
    isClientConnected = false;
    timer = new QTimer(this);
    timer->setSingleShot(true);
    xmlCreator = new XmlCreatorClient();
    readMode = QString("xml");
    #ifdef WIN32
    path.replace(QString("/"), QString("\\"));
    #endif
    #ifdef WIN32
    strcpy(contextKontrol, qPrintable(path));
    #elif defined (linux)
    strcpy(contextKontrol, qPrintable(path));
    #elif defined __APPLE__
    strcpy(contextKontrol, qPrintable(path));
    #endif
    hostLabel = new QLabel(tr("&KontrolPack Server IP address:"));
    portLabel = new QLabel(tr("KontrolPack S&erver port:"));
    checkbox = new QCheckBox("Connect to server directly at each KontrolPack startup.", this);
    connect(checkbox, SIGNAL(stateChanged(int)), this, SLOT(checked(int)));
    hostLineEdit = new QLineEdit("");
    QStringList list = XmlDataStore::getClientIp();
    hostLineEdit->setText(list.at(0));
    portLineEdit = new QLineEdit("17984");
    hostLineEdit->setMinimumWidth(25);
    portLineEdit->setMinimumWidth(25);
    portLineEdit->setValidator(new QIntValidator(1, 65535, this));

    hostLabel->setBuddy(hostLineEdit);
    portLabel->setBuddy(portLineEdit);
    QFrame *upFrame = new QFrame( this );
    upFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QFrame *downFrame = new QFrame( this );
    downFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    i = 0;
    tcpSocket = new QTcpSocket(this);

    connect(tcpSocket, SIGNAL(readyRead()), this, SLOT(readFromServer()), Qt::DirectConnection);
    connect(tcpSocket, SIGNAL(connected()), this, SLOT(onConnect()), Qt::DirectConnection);
    connect(tcpSocket, SIGNAL(disconnected()), this, SLOT(onDisconnect()), Qt::DirectConnection);
    connect(tcpSocket, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(displayError(QAbstractSocket::SocketError)), Qt::DirectConnection);
    thread = new ExecThread("", tcpSocket, contextKontrol);
    connect(thread, SIGNAL(sendToSocket(QByteArray)), this, SLOT(sendToSocket(QByteArray)), Qt::DirectConnection);
    connect(thread, SIGNAL(terminated()), this, SLOT(sendEndCommandToSocket()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->addWidget(groupBox, 0, 0, 9, 1);
    mainLayout->addWidget(label, 0, 1, 1, 2);
    setWindowFlags(Qt::Dialog);
    mainLayout->addWidget(upFrame, 1, 1, 1, 2);
    mainLayout->addWidget(hostLabel, 2, 1);
    mainLayout->addWidget(hostLineEdit, 2, 2);
    mainLayout->addWidget(portLabel, 3, 1);
    mainLayout->addWidget(portLineEdit, 3, 2);
    mainLayout->addWidget(downFrame, 5, 1, 1, 2);
    mainLayout->addWidget(checkbox, 6, 1, 1, 2);
    mainLayout->addWidget(startButton, 7, 1);
    mainLayout->addWidget(stopButton, 7, 2);
    mainLayout->addWidget(statusLabel, 8, 1, 1, 2);
    setLayout(mainLayout);
    hostLineEdit->setFocus();
}

void ClientShell::sendEndCommandToSocket()
{
    #ifdef WIN32
    /*QString result = thread->concatenedResult + "\n";
    QByteArray block2;
    QDataStream out2(&block2, QIODevice::WriteOnly);
    out2.setVersion(QDataStream::Qt_4_0);
    out2 << result;
    tcpSocket->write(block2);*/
    #elif defined (linux)
    #elif defined __APPLE__
    #endif
    QByteArray block3;
    QDataStream out3(&block3, QIODevice::WriteOnly);
    out3.setVersion(QDataStream::Qt_4_0);
    out3 << QString("####EXECUTED COMMAND####\n");
    tcpSocket->write(block3);
}

void ClientShell::sendToSocket(QByteArray data)
{
    tcpSocket->write(data);
}

void ClientShell::onConnect()
{
    isClientConnected = true;
    disconnectedByServer = true;
    startButton->setDisabled(true);
    stopButton->setDisabled(false);
    statusLabel->setText(tr("Status : Connnected to remote KontrolPack server"));
    sendClientInformation();
}

void ClientShell::sendClientInformation()
{
    XmlCreatorClient *xmlCreator = new XmlCreatorClient();
    QStringList *ipList = new QStringList();
    QHostInfo hostInfo = QHostInfo::fromName(QHostInfo::localHostName());
    QList<QHostAddress> addresses = hostInfo.addresses();
    if (!addresses.isEmpty()) {
        for (int i=0; i < addresses.size(); i++) {
                QHostAddress address = addresses.at(i);
                ipList->append(address.toString());
        }
    }
    char _hostname[70];
    gethostname(_hostname, sizeof _hostname);
    QString parameters = xmlCreator->createXmlParameters(_hostname, QString(contextKontrol), ipList) + "\n";
    qDebug(qPrintable(parameters));
    printf("\n\nComputer name : %s \n\n", _hostname);
    QByteArray block;
    QDataStream out(&block, QIODevice::WriteOnly);
    out.setVersion(QDataStream::Qt_4_0);
    out << parameters;
    tcpSocket->write(block);
}

void ClientShell::readFromServer()
{
    if (readMode.startsWith("xml", Qt::CaseSensitive))
    {
        QDataStream in(tcpSocket);
        QString resultat;
        quint16 c;
        int i = 0;
        while(tcpSocket->bytesAvailable() > 0)
        {
            if (tcpSocket->bytesAvailable() >= sizeof(quint16 ))
            {
               in >> c;
               //char h = c;
               //qDebug() << tcpSocket->bytesAvailable() << " (" << c << ") (" << h << ")";
               if (i > 1) {
                  resultat+= c;
              }
               i++;
            }
        }
        qDebug() << "data " <<  resultat.size() <<" (" << resultat<< ")";
        if (resultat.startsWith("<!DOCTYPE fileSender>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
        {
            readMode = "file";
            fileList = xmlParser->getFilePathFromXml(resultat);
            filePath = fileList.at(0);
            fileSize = fileList.at(1).toInt();
            qDebug() << fileSize << " bytes Total";
            bytesCount = 0;
            #ifdef WIN32
            file.setFileName(QString(contextKontrol) + "\\" + filePath);
            #elif defined (linux)
            file.setFileName(QString(contextKontrol) + "/" + filePath);
            #elif defined __APPLE__
            file.setFileName(QString(contextKontrol) + "/" + filePath);
            #endif
            qDebug(qPrintable(file.fileName()));
        }
        else if (resultat.startsWith("<!DOCTYPE fileAsker>", Qt::CaseSensitive)  && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
        {
            readMode = "xml";
            fileAsked = xmlParser->getAskedFileFromXml(resultat);
            sendAskedFileToserver();
        }
        else if (resultat.startsWith("<!DOCTYPE command>", Qt::CaseSensitive)  && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
        {
            readMode = "xml";
            file.close();

            QString commandFromXml = xmlParser->getCommandFromXml(resultat);
            qDebug(qPrintable("XML : "+QString(resultat.toLatin1())));
            qDebug() << "commandFromXml " <<  resultat.size() <<" (" << commandFromXml<< ")";
            thread->commandText = commandFromXml;
            thread->contextKontrol = contextKontrol;
            thread->endCommandExecution();
            QByteArray block;
            QDataStream out(&block, QIODevice::WriteOnly);
            out.setVersion(QDataStream::Qt_4_0);
            out << thread->getCommandContext();
            //out.
            tcpSocket->write(block);
            tcpSocket->flush();
            // TODO block editor commands.
            if (commandFromXml.contains(" cd ", Qt::CaseInsensitive) || commandFromXml.startsWith("cd ", Qt::CaseInsensitive) || commandFromXml.startsWith("edit", Qt::CaseInsensitive)  || commandFromXml.startsWith("vi", Qt::CaseInsensitive) || commandFromXml.startsWith("nano", Qt::CaseInsensitive) || commandFromXml.contains("ping ", Qt::CaseInsensitive))
            {
                sendEndCommandToSocket();
            } else {
                thread->command_handler();
            }
        }
    } else  if (readMode.startsWith("file", Qt::CaseSensitive))
    {
        if(file.isOpen()==false)
        {
            if(!file.open(QIODevice::WriteOnly))
            {
                // Be carefull, the socket must be empty before to go back into
                qDebug("File badly opened");

            }
        }
        while(tcpSocket->bytesAvailable() > 0)
        {
            if (bytesCount < fileSize)
            {
                file.write(tcpSocket->read(1));
                bytesCount++;
            }
        }
        if (bytesCount == fileSize)
        {
            readMode = "xml";
            qDebug("CloseFile!");
            qDebug() << bytesCount << " bytes Total";
            tellServerFileTransfertSucceeded();
            file.close();
            bytesCount = 0;
            return;
        }
    }
}



void ClientShell::tellServerFileTransfertSucceeded()
{
    QByteArray block;
    QDataStream out(&block, QIODevice::WriteOnly);
    out.setVersion(QDataStream::Qt_4_0);
    out << xmlCreator->createXmlToTellServerFileTransfertDoneFlow(file.fileName());
    tcpSocket->write(block);
    QString contextXml = xmlCreator->createXmlForFileContext(QString(contextKontrol));
    QByteArray block2;
    QDataStream out2(&block2, QIODevice::WriteOnly);
    out2.setVersion(QDataStream::Qt_4_0);
    out2 << contextXml;
    tcpSocket->write(block2);
}

void ClientShell::tellServerFileTransfertFailed()
{
    QByteArray block;
    QDataStream out(&block, QIODevice::WriteOnly);
    out.setVersion(QDataStream::Qt_4_0);
    out << xmlCreator->createXmlToTellServerFileTransfertDoneFlow("FAILURE");
    tcpSocket->write(block);
    QString contextXml = xmlCreator->createXmlForCommandContext(QString(contextKontrol));
    QByteArray block2;
    QDataStream out2(&block2, QIODevice::WriteOnly);
    out2.setVersion(QDataStream::Qt_4_0);
    out2 << contextXml;
    tcpSocket->write(block2);
}

void ClientShell::displayError(QAbstractSocket::SocketError socketError)
{
    switch (socketError) {
    case QAbstractSocket::RemoteHostClosedError:
        break;
    case QAbstractSocket::HostNotFoundError:
        qDebug("The host was not found. Please check the "
                                    "host name and port settings.");
        break;
    case QAbstractSocket::ConnectionRefusedError:
        qDebug("The connection was refused by the peer. "
                                    "Make sure the fortune server is running, "
                                    "and check that the host name and port "
                                    "settings are correct.");
        break;
    default:
        ;
    }
}

void ClientShell::connectToServer()
{
      if (hostLineEdit->text() != "")
        {
              if (portLineEdit->text() != "")
                {
                    QString ipClient = hostLineEdit->text();
                    if (checkbox->isChecked())
                        XmlDataStore::saveClientIp(ipClient, "true");
                    else
                        XmlDataStore::saveClientIp(ipClient, "false");
                    blockSize = 0;
                    tcpSocket->abort();
                    disconnectedByServer = true;
                    tcpSocket->connectToHost(hostLineEdit->text(), portLineEdit->text().toInt());
                    startButton->setDisabled(true);
                    stopButton->setDisabled(false);
                    emit hideUi();
                    if (isClientConnected == false)
                        QTimer::singleShot(3000, this, SLOT(tryConnecting()));
                } else {
                        QMessageBox::information(this, tr("Warning"), tr("Input a port number in the field above to connect."));
                }
        } else {
                QMessageBox::information(this, tr("Warning"), tr("Input an IP address in the field above to connect."));
        }
}


void ClientShell::autoConnect()
{
      if (hostLineEdit->text() != "")
        {
              if (portLineEdit->text() != "")
                {
                    checkbox->setCheckState(Qt::Checked);
                    QString ipClient = hostLineEdit->text();
                    if (checkbox->isChecked())
                        XmlDataStore::saveClientIp(ipClient, "true");
                    else
                        XmlDataStore::saveClientIp(ipClient, "false");
                    blockSize = 0;
                    tcpSocket->abort();
                    disconnectedByServer = true;
                    tcpSocket->connectToHost(hostLineEdit->text(), portLineEdit->text().toInt());
                    startButton->setDisabled(true);
                    stopButton->setDisabled(false);
                    emit hideUi();
                    if (isClientConnected == false)
                        QTimer::singleShot(3000, this, SLOT(tryConnecting()));
                } else {
                        QMessageBox::information(this, tr("Warning"), tr("Input a port number in the field above to connect."));
                }
        } else {
                QMessageBox::information(this, tr("Warning"), tr("Input an IP address in the field above to connect."));
        }
}


void ClientShell::onDisconnect()
{
    isClientConnected = false;
    statusLabel->setText(tr("Status : Disconnected"));
    qDebug("Diconnected");
    startButton->setDisabled(false);
    stopButton->setDisabled(true);
    if  (disconnectedByServer == true)
        QTimer::singleShot(3000, this, SLOT(tryConnecting()));
}

void ClientShell::tryConnecting()
{
    qDebug("Trying to connect");
    if (isClientConnected == false)
    {
        tcpSocket->abort();
        tcpSocket->connectToHost(hostLineEdit->text(), portLineEdit->text().toInt());
        QCoreApplication::processEvents();
    }
    if (tcpSocket->waitForConnected(1500))
        qDebug("Connected!");
    else
    {
        tcpSocket->abort();
        QCoreApplication::processEvents();

        QTimer::singleShot(3000, this, SLOT(tryConnecting()));
    }
}

void ClientShell::stopClient()
{
    statusLabel->setText(tr("Status : Disconnected"));
    disconnectedByServer = false;
    tcpSocket->close();
    tcpSocket->abort();
    startButton->setDisabled(false);
    stopButton->setDisabled(true);
}

void ClientShell::sendAskedFileToserver()
{
#ifdef WIN32
     QString localFilePath = QString(contextKontrol) + "\\" + fileAsked;
#elif defined (linux)
     QString localFilePath = QString(contextKontrol) + "/" + fileAsked;
#elif defined __APPLE__
     QString localFilePath = QString(contextKontrol) + "/" + fileAsked;
#endif
    QFile f(localFilePath);
    if (!f.exists()) {
        readMode = "xml";
        QByteArray blockFileAsked1;
        QDataStream outFileAsked1(&blockFileAsked1, QIODevice::WriteOnly);
        outFileAsked1.setVersion(QDataStream::Qt_4_0);
        outFileAsked1 << xmlCreator->createXmlToSendFileFlow(fileAsked, 0, false);
        tcpSocket->write(blockFileAsked1);
        return;
    }
    QByteArray bytes;
    if (!f.open(QIODevice::ReadOnly))
    {
        readMode = "xml";
        QByteArray blockFileAsked2;
        QDataStream outFileAsked2(&blockFileAsked2, QIODevice::WriteOnly);
        outFileAsked2.setVersion(QDataStream::Qt_4_0);
        outFileAsked2 << xmlCreator->createXmlToSendFileFlow(fileAsked, 0, false);
        tcpSocket->write(blockFileAsked2);
        return;
    }
    bool readable = f.isReadable();
    while (!f.atEnd())
    {
        bytes = f.readAll();
    }
    f.close();
    int size = bytes.size();
    QByteArray blockFileAsked;
    QDataStream outFileAsked(&blockFileAsked, QIODevice::WriteOnly);
    outFileAsked.setVersion(QDataStream::Qt_4_0);
    outFileAsked << xmlCreator->createXmlToSendFileFlow(fileAsked, size, readable);
    tcpSocket->write(blockFileAsked);
    if (size > 50000000) {
        readMode = "xml";
        return;
    }
#ifdef WIN32
     //Sleep(500);
#elif defined (linux)
     //usleep((500 * 1000));
#elif defined __APPLE__
     //usleep((500 * 1000));
#endif
    if (!f.open(QIODevice::ReadOnly))
    {
        readMode = "xml";
        tellServerFileTransfertFailed();
        return;
    }
    while (!f.atEnd())
    {
        QByteArray b = f.read(1024);
        tcpSocket->write(b);
        if(tcpSocket->waitForBytesWritten(5000)==false) {
            // Added 23/06
            qDebug("Wait for bytes written time out.");
            tellServerFileTransfertFailed();
            readMode = "xml";
            return;
        }
    }
    f.close();
    readMode = "xml";
    timer->stop();
    return;
}

void ClientShell::stopFileTransfer()
{
        //readMode = "xml";
}

void ClientShell::checked(int check)
{
    QString ipClient = hostLineEdit->text();
    if (checkbox->isChecked())
        XmlDataStore::saveClientIp(ipClient, "true");
    else
        XmlDataStore::saveClientIp(ipClient, "false");
}
