/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "RemoteClientWidget.h"

RemoteClientWidget::RemoteClientWidget(int clientNbr, QLabel *pict, QStringList parameters, QString pathString, QWidget *parent)
        :nbr(clientNbr), image(pict), params(parameters), QWidget(parent), clientPathString(pathString)
{
    // Host infos
    QString os =  parameters.at(0);
    remoteFoldersList = QStringList();
    remoteFilesList = QStringList();
    QGroupBox *groupBox = new QGroupBox(tr("LAN ID Card"), this);
    QGridLayout *gridBox = new QGridLayout;
    gridBox->addWidget(image, 0, 0);
    QLabel *infos1 = new QLabel(QString(params.at(1)));
    QLabel *infos2 = new QLabel(QString(params.at(0)));
    gridBox->addWidget(infos1, 1, 0);
    gridBox->addWidget(infos2, 2, 0);
    for (int i=2; i < params.size(); i++) {
        gridBox->addWidget(new QLabel(params.at(i)), i+1, 0);
    }
    // End host infos
    QLabel *folderLabel = new QLabel(tr("Remote documents explorer"), this);
    groupBox->setLayout(gridBox);
    commandModel = new QStringListModel(QStringList());
    textBrowser = new QTextEdit(this);
    textBrowser->setReadOnly(true);
    textBrowser->insertHtml(
            QString("<font color=\"#000000\">")
            +
            tr("A new KontrolPack client number : ") + QString::number(nbr) + tr(" is now connected to this server.<br /><br />Command results will be displayed in this text area. Input commands into the field at the bottom of this window.<br /><br/><div align=\"center\" > <img src=\":/icons/cmd2.png\"/></div></font>")
            +
                QString("</font>"));
    path = new QLabel(clientPathString, this);
    list = new QListCyborgWidget;
    list->setIconSize(QSize(22, 22));
    QScrollArea *scroller = new QScrollArea(this);
    DefinedCommand *definedCommand = new DefinedCommand(params.at(1));
    connect(definedCommand, SIGNAL(executeCommand(QString)), this, SLOT(executeDefinedCommand(QString)));
    scroller->setWidget(definedCommand);
    QGroupBox *commandsGroupBox = new QGroupBox(tr("Pre-defined commands"), this);
    QGridLayout *commandsLayout = new QGridLayout;
    commandsLayout->addWidget(scroller);
    commandsGroupBox->setLayout(commandsLayout);
    QSplitter *commandSplitter = new QSplitter(this);
    commandSplitter->addWidget(textBrowser);
    commandSplitter->addWidget(commandsGroupBox);
    commandSplitter->setOrientation(Qt::Vertical);

    connect(list, SIGNAL(clicked(QModelIndex)), this, SLOT(clicCommandSelection()));
    connect(list, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(doubleClicSelection()));
    QSplitter *splitter = new QSplitter(this);
    QSplitter *infoSplitter = new QSplitter(this);
    QFrame *leftFrame = new QFrame(this);
    QFrame *rightFrame = new QFrame(this);

    QFrame *infoTopFrame = new QFrame(this);
    QFrame *infoBottomFrame = new QFrame(this);
    QVBoxLayout *infoTopBox = new QVBoxLayout;
    infoTopBox->addWidget(groupBox);
    QVBoxLayout *infoBottomBox = new QVBoxLayout;
    infoBottomBox->addWidget(folderLabel);
    infoBottomBox->addWidget(list);
    infoTopFrame->setLayout(infoTopBox);
    infoBottomFrame->setLayout(infoBottomBox);
    infoSplitter->addWidget(infoTopFrame);
    infoSplitter->addWidget(infoBottomFrame);
    infoSplitter->setOrientation(Qt::Vertical);
    infoSplitter->setStretchFactor(50, 0);
    QVBoxLayout *rightBox = new QVBoxLayout;
    rightBox->addWidget(path);
    rightBox->addWidget(commandSplitter);
    QVBoxLayout *leftBox = new QVBoxLayout;

    leftBox->addWidget(infoSplitter);

    rightFrame->setLayout(rightBox);
    leftFrame->setLayout(leftBox);
    splitter->addWidget(rightFrame);
    splitter->addWidget(leftFrame);
    splitter->setStretchFactor(0, 5);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(splitter);
    setLayout(layout);
}

void RemoteClientWidget::clicCommandSelection()
{
    QItemSelectionModel *selection = list->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)list->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    QString selectedDocument = elementSelectionne.toString();
    for (int j = 0; j < remoteFoldersList.size(); j++) {
            QString folderName = remoteFoldersList.at(j);
            if (QString::compare(folderName, selectedDocument, Qt::CaseInsensitive) == 0)
            {
                    emit setCommandLine("cd " + elementSelectionne.toString());
                    return;
            }
    }
}

void RemoteClientWidget::doubleClicSelection()
{
    QItemSelectionModel *selection = list->selectionModel();
    QModelIndex indexElementSelectionne = selection->currentIndex();
    QStringListModel *listModel = (QStringListModel*)list->model();
    QVariant elementSelectionne = listModel->data(indexElementSelectionne, Qt::DisplayRole);
    QString selectedDocument = elementSelectionne.toString();
    for (int j = 0; j < remoteFoldersList.size(); j++) {
            QString folderName = remoteFoldersList.at(j);
            if (QString::compare(folderName, selectedDocument, Qt::CaseInsensitive) == 0)
            {
                    emit sendCommand("cd " + selectedDocument, nbr);
                    return;
            }
    }
}

void RemoteClientWidget::executeDefinedCommand(QString command)
{
    emit sendCommand(command, nbr);
}
