/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "ServerHome.h"

ServerHome::ServerHome(QTextEdit *textBrowser, QWidget *parent)
        :QWidget(parent), textEdit(textBrowser)
{
    resolver = new DnsResolverUi();
    workstationList = new QList<Workstation*>();
    QLabel *label = new QLabel(tr("<a style='color: blue;' href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a>"), this);
    label->setOpenExternalLinks(true);
    ipList = QStringList();
    QHostInfo hostInfo = QHostInfo::fromName(QHostInfo::localHostName());
    addresses = hostInfo.addresses();
    QPushButton *button = new QPushButton(tr("Network overview"));
    button->setIcon(QIcon(":/icons/network-map.png"));
    button->setMinimumHeight(60);
    connect(button, SIGNAL(clicked()), this, SLOT(showNetworkMap()));
    QPushButton *dnsButton = new QPushButton(tr("DNS Resolver"));
    dnsButton->setIcon(QIcon(":/icons/applications-internet.png"));
    dnsButton->setMinimumHeight(60);
    connect(dnsButton, SIGNAL(clicked()), this, SLOT(showDNSResolver()));
    image = new QLabel(this);
    #ifdef WIN32
    image->setPixmap(QPixmap(":/icons/120px-Computer-windows.png"));
    #elif defined (linux)
    image->setPixmap(QPixmap(":/icons/120px-Computer-linux2.png"));
    #elif defined __APPLE__
    image->setPixmap(QPixmap(":/icons/120px-Computer-mac.png"));
    #endif
    groupBox = new QGroupBox(tr("Host information"), this);
    QGridLayout *gridBox = new QGridLayout;
    gridBox->addWidget(image, 0, 0);
        #ifdef WIN32
      QString os = QString("Microsoft Windows");
        #elif defined (linux)
      QString os = QString("GNU/Linux");
        #elif defined __APPLE__
       QString os = QString("Mac OS X");
        #endif
    QLabel *infos1 = new QLabel(QString(os));
    gridBox->addWidget(infos1, 1, 0);
    if (!addresses.isEmpty()) {
        gridBox->addWidget(new QLabel(addresses.first().toString()), 2, 0);
        gridBox->addWidget(new QLabel(addresses.last().toString()), 3, 0);
    }
    gridBox->addWidget(new QLabel(" "), 4, 0, 7, 1);
    gridBox->addWidget(button, 6, 0, 1, 1);
    gridBox->addWidget(dnsButton, 5, 0, 1, 1);
    gridBox->addWidget(label, 7, 0, 1, 1);
    groupBox->setLayout(gridBox);

    QSplitter *splitter = new QSplitter(this);
    splitter->addWidget(groupBox);
    splitter->addWidget(textEdit);
    splitter->setStretchFactor(1, 50);

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(splitter);
    setLayout(layout);
}

void ServerHome::showDNSResolver()
{
    resolver->exec();
}

void ServerHome::showNetworkMap()
{
    groupBox = new QGroupBox(tr("KontrolPack Server Mode"), this);
    QGridLayout *gridBox = new QGridLayout;
    image = new QLabel(this);
    #ifdef WIN32
    image->setPixmap(QPixmap(":/icons/120px-Computer-windows-small.png"));
    #elif defined (linux)
    image->setPixmap(QPixmap(":/icons/120px-Computer-linux2-small.png"));
    #elif defined __APPLE__
    image->setPixmap(QPixmap(":/icons/120px-Computer-mac-small.png"));
    #endif
    gridBox->addWidget(image, 0, 0);
        #ifdef WIN32
      QString os = QString("Microsoft Windows");
        #elif defined (linux)
      QString os = QString("GNU/Linux");
        #elif defined __APPLE__
       QString os = QString("Mac OS X");
        #endif
    QLabel *infos1 = new QLabel(QString(os));
    gridBox->addWidget(infos1, 1, 0);
    if (!addresses.isEmpty()) {
        gridBox->addWidget(new QLabel(addresses.first().toString()), 2, 0);
        gridBox->addWidget(new QLabel(addresses.last().toString()), 3, 0);
    }

    groupBox->setLayout(gridBox);
    NetworkMapDialog *networkMapDialog = new NetworkMapDialog(groupBox, workstationList);
    networkMapDialog->exec();
}

void ServerHome::addWorkstation(Workstation *workstation)
{
	QString ip;
        QStringList workstationIpList = workstation->list;
        if (!workstationIpList.isEmpty()) {
                for (int i=0; i < workstationIpList.size(); i++) {
                        QString info = workstationIpList.at(i);
			if (info.length() <= 15)
			{
				ip = info;
			}
		}
	}
	if (!ipList.contains(ip, Qt::CaseSensitive))
	{
		ipList.append(ip);
                workstationList->append(workstation);
	}
}

void ServerHome::removeWorkstation(Workstation *workstation)
{
}
