/***************************************************************************
                          item.cpp  -  description
                             -------------------
    begin                : Fri May 23 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <kicontheme.h>

#include <qfile.h>
#include <qimage.h>
#include <qtextstream.h>
  
#include "item.h"

Item::Item(QString iconName, QString cmd, QString name, int minSize, int maxSize) {
   iLoader = KGlobal::iconLoader();
   command = cmd;
   this->name = name;

   this->minSize = minSize;
   this->maxSize = maxSize;
   this->iconName = iconName;

   QImage icon(iLoader->loadIcon(iconName, KIcon::NoGroup, 64).convertToImage());
   if (minSize <= maxSize)
   {
      int count = maxSize - minSize + 1;

      icons.setAutoDelete(TRUE);

      for(int i=0; i<count; i++)
      {
         if (i % SIZE_INC == 0)
         {
            icons.append(new QPixmap(icon.smoothScale(minSize + i, minSize + i)));
         }
      }
   }

   id = 0;
   animed = FALSE;
}


Item::Item(QString fileName, int minSize, int maxSize)
{
   QString line;
   QFile in(fileName);
   in.open(IO_ReadOnly);

   if(in.readLine(line, MAX_LEN) != -1)
   {
      if(line.contains("[Desktop Entry]", FALSE) > 0)
      {
         while (in.readLine(line, MAX_LEN) != -1)
         {
            if(line.startsWith("Exec="))
            {
               command = line.mid(5).stripWhiteSpace();
            }
            else if(line.startsWith("Icon="))
            {
               iconName = line.mid(5).stripWhiteSpace();
            }
            else if(line.startsWith("Name="))
            {
               name = line.mid(5).stripWhiteSpace();
            }
         }
      }
   }

   in.close();

   iLoader = KGlobal::iconLoader();
   this->minSize = minSize;
   this->maxSize = maxSize;
   this->filename = fileName;

   QImage icon(iLoader->loadIcon(iconName, KIcon::NoGroup, 64).convertToImage());
   if (minSize <= maxSize)
   {
      int count = maxSize - minSize + 1;

      icons.setAutoDelete(TRUE);

      for(int i=0; i<count; i++)
      {
         if (i % SIZE_INC == 0)
         {
            icons.append(new QPixmap(icon.smoothScale(minSize + i, minSize + i)));
         }
      }
   }

   id = 0;
   animed = FALSE;
}

Item::Item(QPixmap iconBig, WId id, QString name, int minSize, int maxSize)
{
   this->id = id;
   this->name = name;
   this->minSize = minSize;
   this->maxSize = maxSize;
   command = "";

   QImage icon(iconBig.convertToImage());
   if(minSize <= maxSize)
   {
      int count = maxSize - minSize + 1;

      icons.setAutoDelete(TRUE);

      for(int i=0; i<count; i++)
      {
         if (i % SIZE_INC == 0)
         {
            icons.append(new QPixmap(icon.smoothScale(minSize + i, minSize + i)));
         }
      }
   }
   animed = FALSE;
}

Item::~Item()
{
}

QPixmap* Item::getIcon(int size)
{
   if ((size >= minSize) && (size <= maxSize))
   {
      int d = size - minSize;
      return icons.at(d / SIZE_INC);
   }
   else
   {
      return(0);
   }
}

QString Item::getCommand()
{
   return(command);
}

QString Item::getName()
{
   return(name);
}

QString Item::getFilename()
{
   return(filename);
}

WId Item::getId()
{
   return(id);
}

void Item::setIcon(QPixmap iconBig)
{
   icons.clear();
   QImage icon(iconBig.convertToImage());

   int count = maxSize - minSize + 1;

   for (int i = 0; i < count; i++)
   {
      if (i % SIZE_INC == 0)
      {
         icons.append(new QPixmap(icon.smoothScale(minSize + i, minSize + i)));
      }
   }
}

void Item::setName(QString newName)
{
   name = newName;
}

bool Item::isAnimed()
{
   return(this->animed);
}

void Item::anim(bool param)
{
   this->animed=param;
}
