#include "xosd.h"

#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontmetrics.h>

#include <qwidget.h>
#include <klocale.h>
#include <netwm.h>
#include <netwm_def.h>
#include <kwin.h>

#include <kdebug.h>

xosd::xosd(QWidget *parent, const char *name) : QWidget(parent, name, WStyle_Customize |  WRepaintNoErase | WStyle_NoBorder | WDestructiveClose | WResizeNoErase | WMouseNoMask | WStyle_StaysOnTop | WX11BypassWM)
{
   info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState);
   info->setDesktop( NETWinInfo::OnAllDesktops );
   KWin::setState(winId(), NET::SkipTaskbar | NET::SkipPager);
   setCaption("kooldock xosd window");
}

xosd::~xosd()
{
}

void xosd::setColor(QString color)
{
   fontColor=color;
}

void xosd::setShadowColor(QString color)
{
   shadowColor=color;
}

void xosd::setShadowOffset(int off)
{
   shadowOffset=off;
}

void xosd::setText(QString t)
{
   //setMask(QRegion(0,0,0,0));
   // NOTICE: it appears that with WX11BypassWM, resize() doesn't flick the widget anymore :)
   // so, setMask() is no more needed.
   // -- Matias
   resize(0,0);
   text = t;
   update();
}

void xosd::setFont(QString font)
{
   f.setFamily(font);
}

void xosd::setItalic()
{
   f.setItalic(TRUE);
}

void xosd::setBold()
{
   f.setBold(TRUE);
}

void xosd::setSize(int size)
{
   f.setPointSize(size);
   fontSize = size;
}

void xosd::paintEvent(QPaintEvent *)
{
   QFontMetrics *metrics = new QFontMetrics(f);
   w = metrics->width(text);
   w = w + shadowOffset + 5; // 5 pixels more
   h = metrics->height();
	
   resize(w,h);
	
   QPixmap pm(size());
   QBitmap bm(size());
   QPainter p;
   
   p.begin(&pm, this);
   // Shadow Color ,, the only problem is that some color intend to be 'dotty', test yellow and you see that. // William aka ZyK
   // fill the painter with white color
   p.fillRect(rect(), Qt::white);
   // now we must draw the text with black color for making the mask
   p.setPen( QColor(shadowColor) );
   
   p.setFont(f);
   //p.drawText(rect(), AlignLeft | AlignTop, text);
   p.drawText(shadowOffset, fontSize + shadowOffset, text, AlignCenter);	// shadow
   
   p.setPen( Qt::black );
   p.drawText(1, fontSize, text, AlignCenter);	// front
	
   bm = pm;	// set bm as the widget bitmap
	
   // now, draw normal text
   p.setPen( QColor(fontColor) );
   p.setFont(f);
   p.drawText(1, fontSize, text, AlignCenter);	// front
	
   p.end();
   bitBlt(this, 0, 0, &pm);	// update the widget
   info->setState(NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager, NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager);
   setMask(bm);
}
