/**************************************************************************
*   Copyright (C) 2006 by Conrad Hoffmann                                 *
*   conrausch@gmx.de                                                      *
*   http://conrausch.doesntexist.org                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

/* DESKLISTD PLUGIN FOR THE KOPETE KDE INSTANT MESSENGER
 *
 * Displays a (rather basic) contact list right on the desktop.
 * Designed for eyecandy.
 *
 */

#ifndef KOPETE_DESKLIST_PLUGIN_H
#define KOPETE_DESKLIST_PLUGIN_H

#include <qdict.h>
#include <qpixmap.h>

#include <kopeteplugin.h>
#include <kopeteonlinestatus.h>

#include "linkedlist.h"

class KopeteDesklistItem;
class KopeteDesklistGroup;
class KopeteDesklistRootWidget;
class KToggleAction;

namespace Kopete
{
	class MetaContact;
	class ContactListElement;
}


class KopeteDesklistPlugin : public Kopete::Plugin
{
	Q_OBJECT

public:
	KopeteDesklistPlugin( QObject* parent, const char* name, const QStringList& args );
	~KopeteDesklistPlugin();

	static KopeteDesklistPlugin* self();
	virtual void aboutToUnload();

	void requestRedraw();
	void requestGroupRefresh( Kopete::MetaContact* cause );
	void showContextMenu( Kopete::MetaContact* mc, const QPoint& position );

private:
	void generateList();
	void refreshGroup( Kopete::Group* group );

	static KopeteDesklistPlugin* pluginStatic_;

	static QString bool2string( bool b );
	static bool string2bool( QString s );

	QDict<LinkedList> m_activeGroups;
	QDict<KopeteDesklistItem> m_activeItems;
	KopeteDesklistRootWidget* m_mainWidget;
	KopeteDesklistRootWidget* m_bufferedWidget;
	QTimer* m_redrawTimer;
	int m_photoWidth;
	bool m_forceSingleLine;
	KPopupMenu* m_popup;
	KToggleAction* m_toggleItemVisibility;

private slots:
	void init();
	void slotRedraw();
	void slotTriggerImmediateRedraw();
	void slotTriggerDelayedRedraw();
	void slotEvaluateStatusChange( Kopete::MetaContact* mc, Kopete::OnlineStatus::StatusType status );
	void slotMetaContactAdded( Kopete::MetaContact* mc );
	void slotMetaContactRemoved( Kopete::MetaContact* mc );
	void slotGroupMembersChanged( Kopete::MetaContact* mc, Kopete::Group* fromGroup );
	void slotPrepareContextMenu();
	void slotToggleItemVisibility();
	void slotSettingsChanged();
	void slotRestoreContextMenu();


};

#endif
