/**************************************************************************
*   Copyright (C) 2006 by Conrad Hoffmann                                 *
*   conrausch@gmx.de                                                      *
*   http://conrausch.doesntexist.org                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

/* DESKLIST PLUGIN FOR THE KOPETE KDE INSTANT MESSANGER
 *
 * KConfigXT preferences base class implementation
 *
 */

#include <qlayout.h>

#include <kgenericfactory.h>

#include "kopetedesklistprefsbase.h"
#include "kopetedesklistprefs.h"
#include "kopete_desklist.h"

typedef KGenericFactory<KopeteDesklistPrefs> KopeteDesklistPrefsFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_desklist, KopeteDesklistPrefsFactory( "kcm_kopete_desklist" ) )


KopeteDesklistPrefs::KopeteDesklistPrefs( QWidget* parent, const char* /*name*/, const QStringList& args )
		: KCModule( KopeteDesklistPrefsFactory::instance(), parent, args )
{
	// just tell Kconfig what widget to use... all the magic is done by KConfigTX
	m_preferencesDialog = new KopeteDesklistPrefsUI( this );
	( new QVBoxLayout( this ) )->setAutoAdd( true );
	KopeteDesklistKcfg::self()->readConfig();
	this->addConfig( KopeteDesklistKcfg::self(), m_preferencesDialog );
	load();
}


#include "kopetedesklistprefs.moc"
