/***************************************************************************
 *   Copyright (C) 2005 by Conrad Hoffmann                                 *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef LINKEDLIST_H
#define LINKEDLIST_H

#include <qstring.h>


namespace Kopete
{
	class MetaContact;
	class Group;
}
class LinkedListNode;

class LinkedList
{
public:
	LinkedList( Kopete::Group* group );

	void insert( Kopete::MetaContact* );
	void clear();

	Kopete::MetaContact* first();
	Kopete::MetaContact* next();

	Kopete::Group* group() const;

	bool isVisible() const;

	void setOnlineCount( int count );
	int getOnlineCount() const;

private:
	Kopete::Group* m_group;
	LinkedListNode* m_root;
	LinkedListNode* m_current;
	int m_currentOnlineCount;
};


class LinkedListNode
{
friend class LinkedList;

private:
	LinkedListNode( Kopete::MetaContact* mc );

	const QString& sortString();
	void append( LinkedListNode* node );
	void setNext( LinkedListNode* node );
	Kopete::MetaContact* getMetaContact() const;

private:
	Kopete::MetaContact* m_metaContact;
	LinkedListNode* m_next;
	QString m_sortString;
};

#endif
