/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#ifndef _GAME_H_
#define _GAME_H_

#include "player.h"

typedef enum
{ NOTPLAYING = 0, PREGAME, INGAME, POSTGAME }
Gamemode_gm;

typedef enum
{ TAKETURNS = 0, SIMULTANEOUS }
Gametype_gm;

typedef enum
{RANDOM=0, LOOSERFIRST, WINNERFIRST}
Turnmodetype_gm;

typedef enum
{SU_ANGLE=0,SU_ARMOR,SU_WEAPON,SU_WIND,SU_PLAYER,SU_ALLPLSTATUS,SU_ALL}
statusUpdate;

extern Gamemode_gm gm_gamemode;
extern Gametype_gm gm_gametype;
extern char gm_quit;
extern int gm_activeplayers;
extern int gm_numberPlayers;
extern int gm_currentRound;
extern int gm_totalRounds;
extern int gm_iAmServer;
extern Player_pl *gm_firing_order[10];
extern char gm_stuff_happening;
extern int gm_death_queue[256];
extern int gm_dq_pos;
extern int gm_killNumber;	/* how many people have died so far */
extern int gm_def_armor;
#endif
