/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _RELAY_H_
#define _RELAY_H_

#include <sys/time.h>

extern int rl_idcounter;

#define USEDQSPACE(st, en, sz) (st <= en ? en - st : sz + (en - st))
#define FREEQSPACE(st, en, sz) (sz - USEDQSPACE(st, en, sz))

typedef struct Connectlist_rl
{
    int socket;
    int id;
    char buffer[32768];
    int toread;
    int qstart;
    int qend;
    char buffstate;
    struct Connectlist_rl *next;
    struct Connectlist_rl *prev;
}
Connectlist_rl;

struct handlerlist;
struct Relay_rl;

typedef struct Handlerlist_rl
{
    char type[2];
    void (*func) (struct Relay_rl * rl, int who, char *pkt, int pktlen);
    struct Handlerlist_rl *next;
    struct Handlerlist_rl *prev;
}
Handlerlist_rl;

typedef struct Relay_rl
{
    Connectlist_rl *cbegin;
    Connectlist_rl *cend;
    Handlerlist_rl *hbegin;
    Handlerlist_rl *hend;
    void (*logofffunc) (struct Relay_rl * rl, int who);
    int listensock;
}
Relay_rl;

void rlRegisterHandler(Relay_rl * rl, char *pkttype,
		       void (*handler) (Relay_rl *, int, char *, int));
Relay_rl *rlInit(short unsigned int port);
void rlMain(Relay_rl * rl, struct timeval *tv);
void rlSend(Relay_rl * rl, int who, void *message, int len);
void rlSendTyped(Relay_rl * rl, int who, char *type, void *message, int len);
void rlBroadcast(Relay_rl * rl, int *who, void *message, int len);
void rlBroadcastTyped(Relay_rl * rl, int *who, char *type, void *message,
		      int len);
void rlSetDisconnectFunc(Relay_rl * rl, void (*handler) (Relay_rl *, int));
void rlDisconnect(Relay_rl *rl, int id);
int rlAddConnection(Relay_rl * rl, int sock);
void rlRemoveHandler(Relay_rl * rl, char *pkttype);

#endif
