/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "weapon.h"
#include "../ballistics.h"
#include "../terrain.h"
#include "basic.h"
#include "large.h"
#include "cluster.h"
#include "dirt.h"
#include "dirtvaporizer.h"
#include "mirv.h"
#include "roller.h"
#include "simple.h"
#include "supernuke.h"
#include "tacnuke.h"
#include "funkybomb.h"
#include "dfa.h"
#include "napalm.h"
#include "tunnel.h"
#include "blackhole.h"
#include "laser.h"
#include "depthcharge.h"
#include "dirtcurtain.h"

/* note: WeaponList is a CIRCULAR linked list! */
Weapon_wep *wep_WeaponList = NULL;

void
wepAddWeapon(char *name, int cost, int count,
	     Shellstat_bal(*initguidance) (struct Projectilepos_bal *
					   prjpos, void **guideshotinfo,
					   Shellstat_bal(*initexplosion)
					   (struct Projectilepos_bal *
					    prjpos, void **explosioninfo),
					   void **explosioninfo),
	     Shellstat_bal(*doguidance) (void *info,
					 struct Projectilepos_bal * prjpos,
					 Shellstat_bal(*initexplosion)
					 (struct Projectilepos_bal * prjpos,
					  void **explosioninfo),
					 void **explosioninfo),
	     Shellstat_bal(*initexplosion) (struct Projectilepos_bal *
					    prjpos, void **explosioninfo),
	     Shellstat_bal(*doexplosion) (void *info))
{
    static unsigned wid = 0;
    Weapon_wep *wnew = (Weapon_wep *) malloc(sizeof(Weapon_wep));

    wnew->name = name;
    wnew->cost = cost;
    wnew->count = count;
    wnew->id = wid++;
    wnew->initguidance = initguidance;
    wnew->doguidance = doguidance;
    wnew->initexplosion = initexplosion;
    wnew->doexplosion = doexplosion;
    wnew->drawshot = NULL;
    wnew->drawexplosion = NULL;

    if(wep_WeaponList)
    {
	wnew->next = wep_WeaponList;
	wnew->prev = wep_WeaponList->prev;
	wnew->next->prev = wnew;
	wnew->prev->next = wnew;
	wep_WeaponList = wnew;
    }
    else
    {
	wnew->next = wnew;
	wnew->prev = wnew;
	wep_WeaponList = wnew;
    }
}

Weapon_wep *wepLookupWeapon(char *name)
{
    Weapon_wep *wcur;

    if(wep_WeaponList == NULL)
	return NULL;
    if(strcmp(name, wep_WeaponList->name) == 0)
	return wep_WeaponList;
    wcur = wep_WeaponList;
    do
    {
	if(strcmp(name, wcur->name) == 0)
	    return wcur;
	wcur = wcur->next;
    }
    while(wcur != wep_WeaponList);
    return NULL;
}

Weapon_wep *wepLookupWeaponByID(unsigned id)
{
    Weapon_wep *wcur;

    if(wep_WeaponList == NULL)
	return NULL;
    if(wep_WeaponList->id == id)
	return wep_WeaponList;
    wcur = wep_WeaponList;
    do
    {
	if(wcur->id == id)
	    return wcur;
	wcur = wcur->next;
    }
    while(wcur != wep_WeaponList);
    return NULL;
}

void wepInit()
{
    wepAddWeapon("Basic Shell", 0, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepBasicExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Large Shell", 50, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepLargeExplosionInit, wepSimpleExplosion);

    wepAddWeapon("Tunneler", 70, 1,
		 wepTunnelInit, wepTunnelGuidance, NULL, NULL);
    wepAddWeapon("Cluster Bomb", 240, 1,
		 wepBasicInit, wepBasicGuidance, wepClusterExplosionInit, NULL);
    wepAddWeapon("Cluster Fragment", 0, 1,
		 wepBasicInit,
		 wepBasicGuidance,
		 wepFragmentExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Laser", 250, 1,
		 wepLaserInit,
		 NULL,
		 wepLaserExplosionInit,
		 wepLaserExplosion);

    wepAddWeapon("Dirt Vaporizer", 250, 1,
		 wepBasicInit,
		 wepBasicGuidance,
		 wepDirtVaporizerExplosionInit,
		 wepDirtVaporizerExplosion);
    wepAddWeapon("Dirt Ball", 280, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepDirtExplosionInit, wepDirtExplosion);
    wepAddWeapon("Dirt Curtain", 280, 1,
		 wepBasicInit,
		 wepDirtCurtainGuidance,
		 wepDirtCurtainExplosionInit,
		 wepSimpleExplosion);
    wepAddWeapon("MIRV", 300, 1,
		 wepBasicInit,
		 wepMIRVGuidance, wepBasicExplosionInit, wepSimpleExplosion);
    wepAddWeapon("MIRV Shell", 0, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepBasicExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Death From Above", 400, 1,
		 wepBasicInit,
		 wepDFAGuidance, wepLargeExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Black Hole", 400, 1,
		 wepBasicInit,
		 wepBlackHoleGuidance,
		 wepBlackHoleExplosionInit,
		 wepBlackHoleExplosion);
    wepAddWeapon("Tac Nuke", 500, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepTacNukeExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Depth Charge", 530, 1,
		 wepBasicInit,
		 wepBasicGuidance,
		 wepDepthChargeExplosionInit,
		 NULL);
    wepAddWeapon("Depth Charge Shell", 0, 1,
		 wepDepthChargeInit,
		 wepDepthChargeGuidance,
		 wepTacNukeExplosionInit,
		 wepSimpleExplosion);

    wepAddWeapon("Roller", 600, 1,
		 wepBasicInit, wepBasicGuidance, wepRollerExplosionInit, NULL);
    wepAddWeapon("Roller Ball", 0, 1,
		 wepRollerInit,
		 wepRollerGuidance,
		 wepTacNukeExplosionInit, wepSimpleExplosion);
   wepAddWeapon("Napalm", 650, 1,
		 wepBasicInit,
		 wepNapalmGuidance, wepBasicExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Burning Napalm", 0, 1,
		 wepBasicInit,
		 wepBasicGuidance,
		 wepBurningNapalmExplosionInit, wepBurningNapalmExplosion);
    wepAddWeapon("Funky Bomb", 650, 1,
		 wepBasicInit,
		 wepFunkyGuidance, wepBasicExplosionInit, wepSimpleExplosion);
    wepAddWeapon("Funky Fragment", 0, 1,
		 wepBasicInit,
		 wepBasicGuidance, wepLargeExplosionInit, wepSimpleExplosion);

    wepAddWeapon("Super Nuke", 1200, 1,
		 wepBasicInit,
		 wepBasicGuidance,
		 wepSuperNukeExplosionInit, wepSimpleExplosion);
}
