/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LightAnalysisModeTestGenerated extends AbstractLightAnalysisModeTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
    }

    @TestMetadata("compiler/testData/codegen/box/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractLightAnalysisModeTest {
        @TestMetadata("wrongAnnotationArgumentInCtor.kt")
        public void ignoreWrongAnnotationArgumentInCtor() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/wrongAnnotationArgumentInCtor.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedAnnotationParameter.kt")
        public void testAnnotatedAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedAnnotationParameter.kt");
        }

        @TestMetadata("annotatedEnumEntry.kt")
        public void testAnnotatedEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedEnumEntry.kt");
        }

        @TestMetadata("annotatedObjectLiteral.kt")
        public void testAnnotatedObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedObjectLiteral.kt");
        }

        @TestMetadata("annotationWithKotlinProperty.kt")
        public void testAnnotationWithKotlinProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinProperty.kt");
        }

        @TestMetadata("annotationWithKotlinPropertyFromInterfaceCompanion.kt")
        public void testAnnotationWithKotlinPropertyFromInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinPropertyFromInterfaceCompanion.kt");
        }

        @TestMetadata("annotationsOnDefault.kt")
        public void testAnnotationsOnDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnDefault.kt");
        }

        @TestMetadata("annotationsOnNonExistentAccessors.kt")
        public void testAnnotationsOnNonExistentAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnNonExistentAccessors.kt");
        }

        @TestMetadata("annotationsOnTypeAliases.kt")
        public void testAnnotationsOnTypeAliases() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnTypeAliases.kt");
        }

        @TestMetadata("constValInAnnotation.kt")
        public void testConstValInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/constValInAnnotation.kt");
        }

        @TestMetadata("defaultParameterValues.kt")
        public void testDefaultParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/defaultParameterValues.kt");
        }

        @TestMetadata("delegatedPropertySetter.kt")
        public void testDelegatedPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/delegatedPropertySetter.kt");
        }

        @TestMetadata("fileClassWithFileAnnotation.kt")
        public void testFileClassWithFileAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/fileClassWithFileAnnotation.kt");
        }

        @TestMetadata("jvmAnnotationFlags.kt")
        public void testJvmAnnotationFlags() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/jvmAnnotationFlags.kt");
        }

        @TestMetadata("kotlinPropertyFromClassObjectAsParameter.kt")
        public void testKotlinPropertyFromClassObjectAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinPropertyFromClassObjectAsParameter.kt");
        }

        @TestMetadata("kotlinTopLevelPropertyAsParameter.kt")
        public void testKotlinTopLevelPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinTopLevelPropertyAsParameter.kt");
        }

        @TestMetadata("kt10136.kt")
        public void testKt10136() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kt10136.kt");
        }

        @TestMetadata("nestedClassPropertyAsParameter.kt")
        public void testNestedClassPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassPropertyAsParameter.kt");
        }

        @TestMetadata("nestedClassesInAnnotations.kt")
        public void testNestedClassesInAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassesInAnnotations.kt");
        }

        @TestMetadata("parameterAnnotationInDefaultImpls.kt")
        public void testParameterAnnotationInDefaultImpls() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterAnnotationInDefaultImpls.kt");
        }

        @TestMetadata("parameterWithPrimitiveType.kt")
        public void testParameterWithPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterWithPrimitiveType.kt");
        }

        @TestMetadata("propertyWithPropertyInInitializerAsParameter.kt")
        public void testPropertyWithPropertyInInitializerAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/propertyWithPropertyInInitializerAsParameter.kt");
        }

        @TestMetadata("resolveWithLowPriorityAnnotation.kt")
        public void testResolveWithLowPriorityAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
        }

        @TestMetadata("singleAssignmentToVarargInAnnotation.kt")
        public void testSingleAssignmentToVarargInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/singleAssignmentToVarargInAnnotation.kt");
        }

        @TestMetadata("typeAnnotationOnJdk6.kt")
        public void testTypeAnnotationOnJdk6() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/typeAnnotationOnJdk6.kt");
        }

        @TestMetadata("useTypeParameterAnnotationFromJava.kt")
        public void testUseTypeParameterAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeParameterAnnotationFromJava.kt");
        }

        @TestMetadata("useTypeUseAnnotationFromJava.kt")
        public void testUseTypeUseAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeUseAnnotationFromJava.kt");
        }

        @TestMetadata("varargInAnnotationParameter.kt")
        public void testVarargInAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/varargInAnnotationParameter.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotatedLambda extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotatedLambda() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("funExpression.kt")
            public void testFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/funExpression.kt");
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/lambda.kt");
            }

            @TestMetadata("samFunExpression.kt")
            public void testSamFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunExpression.kt");
            }

            @TestMetadata("samLambda.kt")
            public void testSamLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samLambda.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("argumentOrderInObjectSuperCall.kt")
        public void testArgumentOrderInObjectSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCall.kt");
        }

        @TestMetadata("argumentOrderInSuperCall.kt")
        public void testArgumentOrderInSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInSuperCall.kt");
        }

        @TestMetadata("arguments.kt")
        public void testArguments() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/arguments.kt");
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/captured.kt");
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
        }

        @TestMetadata("defaults.kt")
        public void testDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/defaults.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extension.kt");
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
        }

        @TestMetadata("kt9277.kt")
        public void testKt9277() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simple.kt");
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/arrays")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arrays extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInArrays() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConstructorsSimple.kt")
        public void testArrayConstructorsSimple() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
        }

        @TestMetadata("arrayGetAssignMultiIndex.kt")
        public void testArrayGetAssignMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
        }

        @TestMetadata("arrayGetMultiIndex.kt")
        public void testArrayGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
        }

        @TestMetadata("arrayInstanceOf.kt")
        public void testArrayInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
        }

        @TestMetadata("arrayPlusAssign.kt")
        public void testArrayPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
        }

        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
        }

        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/cloneArray.kt");
        }

        @TestMetadata("clonePrimitiveArrays.kt")
        public void testClonePrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
        }

        @TestMetadata("collectionAssignGetMultiIndex.kt")
        public void testCollectionAssignGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
        }

        @TestMetadata("collectionGetMultiIndex.kt")
        public void testCollectionGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
        }

        @TestMetadata("forEachBooleanArray.kt")
        public void testForEachBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
        }

        @TestMetadata("forEachByteArray.kt")
        public void testForEachByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
        }

        @TestMetadata("forEachCharArray.kt")
        public void testForEachCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
        }

        @TestMetadata("forEachDoubleArray.kt")
        public void testForEachDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
        }

        @TestMetadata("forEachFloatArray.kt")
        public void testForEachFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
        }

        @TestMetadata("forEachIntArray.kt")
        public void testForEachIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
        }

        @TestMetadata("forEachLongArray.kt")
        public void testForEachLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
        }

        @TestMetadata("forEachShortArray.kt")
        public void testForEachShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
        }

        @TestMetadata("genericArrayInObjectLiteralConstructor.kt")
        public void testGenericArrayInObjectLiteralConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/genericArrayInObjectLiteralConstructor.kt");
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/hashMap.kt");
        }

        @TestMetadata("inProjectionAsParameter.kt")
        public void testInProjectionAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
        }

        @TestMetadata("inProjectionOfArray.kt")
        public void testInProjectionOfArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
        }

        @TestMetadata("inProjectionOfList.kt")
        public void testInProjectionOfList() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
        }

        @TestMetadata("indices.kt")
        public void testIndices() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indices.kt");
        }

        @TestMetadata("indicesChar.kt")
        public void testIndicesChar() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indicesChar.kt");
        }

        @TestMetadata("inlineInitializer.kt")
        public void testInlineInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inlineInitializer.kt");
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iterator.kt");
        }

        @TestMetadata("iteratorBooleanArray.kt")
        public void testIteratorBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
        }

        @TestMetadata("iteratorByteArray.kt")
        public void testIteratorByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
        }

        @TestMetadata("iteratorByteArrayNextByte.kt")
        public void testIteratorByteArrayNextByte() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
        }

        @TestMetadata("iteratorCharArray.kt")
        public void testIteratorCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
        }

        @TestMetadata("iteratorDoubleArray.kt")
        public void testIteratorDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
        }

        @TestMetadata("iteratorFloatArray.kt")
        public void testIteratorFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
        }

        @TestMetadata("iteratorIntArray.kt")
        public void testIteratorIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
        }

        @TestMetadata("iteratorLongArray.kt")
        public void testIteratorLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
        }

        @TestMetadata("iteratorLongArrayNextLong.kt")
        public void testIteratorLongArrayNextLong() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
        }

        @TestMetadata("iteratorShortArray.kt")
        public void testIteratorShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
        }

        @TestMetadata("kt1291.kt")
        public void testKt1291() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt1291.kt");
        }

        @TestMetadata("kt17134.kt")
        public void testKt17134() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt17134.kt");
        }

        @TestMetadata("kt238.kt")
        public void testKt238() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt238.kt");
        }

        @TestMetadata("kt2997.kt")
        public void testKt2997() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt2997.kt");
        }

        @TestMetadata("kt33.kt")
        public void testKt33() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt33.kt");
        }

        @TestMetadata("kt3771.kt")
        public void testKt3771() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt3771.kt");
        }

        @TestMetadata("kt4118.kt")
        public void testKt4118() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4118.kt");
        }

        @TestMetadata("kt4348.kt")
        public void testKt4348() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4348.kt");
        }

        @TestMetadata("kt4357.kt")
        public void testKt4357() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4357.kt");
        }

        @TestMetadata("kt503.kt")
        public void testKt503() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt503.kt");
        }

        @TestMetadata("kt594.kt")
        public void testKt594() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt594.kt");
        }

        @TestMetadata("kt602.kt")
        public void testKt602() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt602.kt");
        }

        @TestMetadata("kt7009.kt")
        public void testKt7009() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7009.kt");
        }

        @TestMetadata("kt7288.kt")
        public void testKt7288() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7288.kt");
        }

        @TestMetadata("kt7338.kt")
        public void testKt7338() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7338.kt");
        }

        @TestMetadata("kt779.kt")
        public void testKt779() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt779.kt");
        }

        @TestMetadata("kt945.kt")
        public void testKt945() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt945.kt");
        }

        @TestMetadata("kt950.kt")
        public void testKt950() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt950.kt");
        }

        @TestMetadata("longAsIndex.kt")
        public void testLongAsIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/longAsIndex.kt");
        }

        @TestMetadata("multiArrayConstructors.kt")
        public void testMultiArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
        }

        @TestMetadata("nonLocalReturnArrayConstructor.kt")
        public void testNonLocalReturnArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
        }

        @TestMetadata("nonNullArray.kt")
        public void testNonNullArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonNullArray.kt");
        }

        @TestMetadata("primitiveArrays.kt")
        public void testPrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/primitiveArrays.kt");
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/stdlib.kt");
        }

        @TestMetadata("varargsWithJava.kt")
        public void testVarargsWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/varargsWithJava.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/arraysOfInlineClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArraysOfInlineClass extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessArrayOfInlineClass.kt")
            public void testAccessArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfInlineClass.kt");
            }

            @TestMetadata("accessArrayOfUnsigned.kt")
            public void testAccessArrayOfUnsigned() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfUnsigned.kt");
            }

            public void testAllFilesPresentInArraysOfInlineClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/arraysOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("arrayOfInlineClassOfArrayOfInlineClass.kt")
            public void testArrayOfInlineClassOfArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/arrayOfInlineClassOfArrayOfInlineClass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiDecl extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiDecl() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt15560.kt")
            public void testKt15560() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15560.kt");
            }

            @TestMetadata("kt15568.kt")
            public void testKt15568() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15568.kt");
            }

            @TestMetadata("kt15575.kt")
            public void testKt15575() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15575.kt");
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLong() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/assert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Assert extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInAssert() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/assert"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("alwaysDisable.kt")
        public void testAlwaysDisable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysDisable.kt");
        }

        @TestMetadata("alwaysEnable.kt")
        public void testAlwaysEnable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysEnable.kt");
        }

        @TestMetadata("legacy.kt")
        public void testLegacy() throws Exception {
            runTest("compiler/testData/codegen/box/assert/legacy.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/assert/jvm")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Jvm extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJvm() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/assert/jvm"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("interfaceAssertionsDisabled.kt")
            public void testInterfaceAssertionsDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsDisabled.kt");
            }

            @TestMetadata("interfaceAssertionsEnabled.kt")
            public void testInterfaceAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsEnabled.kt");
            }

            @TestMetadata("localAnonymousFunction.kt")
            public void testLocalAnonymousFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localAnonymousFunction.kt");
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localClass.kt");
            }

            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localFunction.kt");
            }

            @TestMetadata("localLambda.kt")
            public void testLocalLambda() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localLambda.kt");
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localObject.kt");
            }

            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/nonLocalReturn.kt");
            }

            @TestMetadata("ordinary.kt")
            public void testOrdinary() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/ordinary.kt");
            }

            @TestMetadata("superClassInitializer.kt")
            public void testSuperClassInitializer() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/superClassInitializer.kt");
            }

            @TestMetadata("suspendFunctionAssertionDisabled.kt")
            public void testSuspendFunctionAssertionDisabled_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionDisabled.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendFunctionAssertionDisabled.kt")
            public void testSuspendFunctionAssertionDisabled_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionDisabled.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendFunctionAssertionsEnabled.kt")
            public void testSuspendFunctionAssertionsEnabled_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionsEnabled.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendFunctionAssertionsEnabled.kt")
            public void testSuspendFunctionAssertionsEnabled_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionsEnabled.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendLambdaAssertionsDisabled.kt")
            public void testSuspendLambdaAssertionsDisabled_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsDisabled.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendLambdaAssertionsDisabled.kt")
            public void testSuspendLambdaAssertionsDisabled_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsDisabled.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendLambdaAssertionsEnabled.kt")
            public void testSuspendLambdaAssertionsEnabled_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsEnabled.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendLambdaAssertionsEnabled.kt")
            public void testSuspendLambdaAssertionsEnabled_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsEnabled.kt", "kotlin.coroutines");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/binaryOp")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BinaryOp extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInBinaryOp() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bitwiseOp.kt")
        public void testBitwiseOp() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
        }

        @TestMetadata("bitwiseOpAny.kt")
        public void testBitwiseOpAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
        }

        @TestMetadata("bitwiseOpNullable.kt")
        public void testBitwiseOpNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/call.kt");
        }

        @TestMetadata("callAny.kt")
        public void testCallAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callAny.kt");
        }

        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callNullable.kt");
        }

        @TestMetadata("compareBoxedChars.kt")
        public void testCompareBoxedChars() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareBoxedChars.kt");
        }

        @TestMetadata("compareWithBoxedDouble.kt")
        public void testCompareWithBoxedDouble() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedDouble.kt");
        }

        @TestMetadata("compareWithBoxedLong.kt")
        public void testCompareWithBoxedLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedLong.kt");
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
        }

        @TestMetadata("intrinsicAny.kt")
        public void testIntrinsicAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
        }

        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
        }

        @TestMetadata("kt11163.kt")
        public void testKt11163() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163.kt");
        }

        @TestMetadata("kt11163_properIeee754comparisons.kt")
        public void testKt11163_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163_properIeee754comparisons.kt");
        }

        @TestMetadata("kt23030_properIeee754comparisons.kt")
        public void testKt23030_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt23030_properIeee754comparisons.kt");
        }

        @TestMetadata("kt6747_identityEquals.kt")
        public void testKt6747_identityEquals() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
        }

        @TestMetadata("overflowChar.kt")
        public void testOverflowChar() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
        }

        @TestMetadata("overflowInt.kt")
        public void testOverflowInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
        }

        @TestMetadata("overflowLong.kt")
        public void testOverflowLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boxedIntegersCmp.kt")
        public void testBoxedIntegersCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedIntegersCmp.kt");
        }

        @TestMetadata("boxedPrimitivesAreEqual.kt")
        public void testBoxedPrimitivesAreEqual() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedPrimitivesAreEqual.kt");
        }

        @TestMetadata("boxedRealsCmp.kt")
        public void testBoxedRealsCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedRealsCmp.kt");
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/casts.kt");
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @TestMetadata("explicitEqualsOnDouble.kt")
        public void testExplicitEqualsOnDouble() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/explicitEqualsOnDouble.kt");
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/fold.kt");
        }

        @TestMetadata("foldRange.kt")
        public void testFoldRange() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
        }

        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/intCompareTo.kt");
        }

        @TestMetadata("kClassEquals.kt")
        public void testKClassEquals() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kClassEquals.kt");
        }

        @TestMetadata("kt15871.kt")
        public void testKt15871() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt15871.kt");
        }

        @TestMetadata("kt17748.kt")
        public void testKt17748() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt17748.kt");
        }

        @TestMetadata("kt19767.kt")
        public void testKt19767() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767.kt");
        }

        @TestMetadata("kt19767_2.kt")
        public void testKt19767_2() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_2.kt");
        }

        @TestMetadata("kt19767_3.kt")
        public void testKt19767_3() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_3.kt");
        }

        @TestMetadata("kt19767_chain.kt")
        public void testKt19767_chain() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_chain.kt");
        }

        @TestMetadata("kt5493.kt")
        public void testKt5493() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
        }

        @TestMetadata("kt5588.kt")
        public void testKt5588() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
        }

        @TestMetadata("kt5844.kt")
        public void testKt5844() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
        }

        @TestMetadata("kt6047.kt")
        public void testKt6047() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6047.kt");
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
        }

        @TestMetadata("maxMinBy.kt")
        public void testMaxMinBy() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/maxMinBy.kt");
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simple.kt");
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @TestMetadata("taintedValues.kt")
        public void testTaintedValues() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValues.kt");
        }

        @TestMetadata("taintedValuesBox.kt")
        public void testTaintedValuesBox() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValuesBox.kt");
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/variables.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/bridges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Bridges extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInBridges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bridgeInInterface.kt")
        public void testBridgeInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterface.kt");
        }

        @TestMetadata("bridgeInInterfaceWithProperties.kt")
        public void testBridgeInInterfaceWithProperties() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterfaceWithProperties.kt");
        }

        @TestMetadata("complexMultiInheritance.kt")
        public void testComplexMultiInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
        }

        @TestMetadata("complexTraitImpl.kt")
        public void testComplexTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegation.kt");
        }

        @TestMetadata("delegationComplex.kt")
        public void testDelegationComplex() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplex.kt");
        }

        @TestMetadata("delegationComplexWithList.kt")
        public void testDelegationComplexWithList() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
        }

        @TestMetadata("delegationProperty.kt")
        public void testDelegationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationProperty.kt");
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/diamond.kt");
        }

        @TestMetadata("fakeCovariantOverride.kt")
        public void testFakeCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverride.kt")
        public void testFakeGenericCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
        }

        @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
        public void testFakeGenericCovariantOverrideWithDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
        }

        @TestMetadata("fakeOverrideFromInterfaceThroughIntermediateClass.kt")
        public void testFakeOverrideFromInterfaceThroughIntermediateClass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideFromInterfaceThroughIntermediateClass.kt");
        }

        @TestMetadata("fakeOverrideOfTraitImpl.kt")
        public void testFakeOverrideOfTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
        }

        @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
        public void testFakeOverrideWithSeveralSuperDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
        }

        @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
        public void testFakeOverrideWithSynthesizedImplementation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/genericProperty.kt");
        }

        @TestMetadata("kt12416.kt")
        public void testKt12416() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt12416.kt");
        }

        @TestMetadata("kt1939.kt")
        public void testKt1939() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1939.kt");
        }

        @TestMetadata("kt1959.kt")
        public void testKt1959() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1959.kt");
        }

        @TestMetadata("kt2498.kt")
        public void testKt2498() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2498.kt");
        }

        @TestMetadata("kt2702.kt")
        public void testKt2702() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2702.kt");
        }

        @TestMetadata("kt2833.kt")
        public void testKt2833() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2833.kt");
        }

        @TestMetadata("kt2920.kt")
        public void testKt2920() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2920.kt");
        }

        @TestMetadata("kt318.kt")
        public void testKt318() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt318.kt");
        }

        @TestMetadata("longChainOneBridge.kt")
        public void testLongChainOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
        }

        @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
        public void testManyTypeArgumentsSubstitutedSuccessively() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
        }

        @TestMetadata("methodFromTrait.kt")
        public void testMethodFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
        }

        @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
        public void testNoBridgeOnMutableCollectionInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
        }

        @TestMetadata("objectClone.kt")
        public void testObjectClone() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/objectClone.kt");
        }

        @TestMetadata("overrideAbstractProperty.kt")
        public void testOverrideAbstractProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
        }

        @TestMetadata("overrideReturnType.kt")
        public void testOverrideReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
        }

        @TestMetadata("propertyAccessorsWithoutBody.kt")
        public void testPropertyAccessorsWithoutBody() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
        }

        @TestMetadata("propertyDiamond.kt")
        public void testPropertyDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
        }

        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertySetter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simple.kt");
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleEnum.kt");
        }

        @TestMetadata("simpleGenericMethod.kt")
        public void testSimpleGenericMethod() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleObject.kt");
        }

        @TestMetadata("simpleReturnType.kt")
        public void testSimpleReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
        }

        @TestMetadata("simpleTraitImpl.kt")
        public void testSimpleTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
        }

        @TestMetadata("simpleUpperBound.kt")
        public void testSimpleUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
        }

        @TestMetadata("strListContains.kt")
        public void testStrListContains() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListContains.kt");
        }

        @TestMetadata("strListRemove.kt")
        public void testStrListRemove() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListRemove.kt");
        }

        @TestMetadata("traitImplInheritsTraitImpl.kt")
        public void testTraitImplInheritsTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges2() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
        }

        @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
        public void testTwoParentsWithTheSameMethodOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SubstitutionInSuperClass extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractFun.kt")
            public void testAbstractFun() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
            }

            public void testAllFilesPresentInSubstitutionInSuperClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boundedTypeArguments.kt")
            public void testBoundedTypeArguments() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
            }

            @TestMetadata("delegation.kt")
            public void testDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
            }

            @TestMetadata("differentErasureInSuperClass.kt")
            public void testDifferentErasureInSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
            }

            @TestMetadata("differentErasureInSuperClassComplex.kt")
            public void testDifferentErasureInSuperClassComplex() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
            }

            @TestMetadata("genericMethod.kt")
            public void testGenericMethod() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
            }

            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinStubMethods extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("abstractMember.kt")
        public void testAbstractMember() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/abstractMember.kt");
        }

        public void testAllFilesPresentInBuiltinStubMethods() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("Collection.kt")
        public void testCollection() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Collection.kt");
        }

        @TestMetadata("customReadOnlyIterator.kt")
        public void testCustomReadOnlyIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
        }

        @TestMetadata("delegationToArrayList.kt")
        public void testDelegationToArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/delegationToArrayList.kt");
        }

        @TestMetadata("immutableRemove.kt")
        public void testImmutableRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/immutableRemove.kt");
        }

        @TestMetadata("implementationInTrait.kt")
        public void testImplementationInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/implementationInTrait.kt");
        }

        @TestMetadata("inheritedImplementations.kt")
        public void testInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/inheritedImplementations.kt");
        }

        @TestMetadata("Iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Iterator.kt");
        }

        @TestMetadata("IteratorWithRemove.kt")
        public void testIteratorWithRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/IteratorWithRemove.kt");
        }

        @TestMetadata("List.kt")
        public void testList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/List.kt");
        }

        @TestMetadata("ListIterator.kt")
        public void testListIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListIterator.kt");
        }

        @TestMetadata("ListWithAllImplementations.kt")
        public void testListWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllImplementations.kt");
        }

        @TestMetadata("ListWithAllInheritedImplementations.kt")
        public void testListWithAllInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllInheritedImplementations.kt");
        }

        @TestMetadata("manyTypeParametersWithUpperBounds.kt")
        public void testManyTypeParametersWithUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/manyTypeParametersWithUpperBounds.kt");
        }

        @TestMetadata("Map.kt")
        public void testMap() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Map.kt");
        }

        @TestMetadata("MapEntry.kt")
        public void testMapEntry() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntry.kt");
        }

        @TestMetadata("MapEntryWithSetValue.kt")
        public void testMapEntryWithSetValue() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntryWithSetValue.kt");
        }

        @TestMetadata("MapWithAllImplementations.kt")
        public void testMapWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapWithAllImplementations.kt");
        }

        @TestMetadata("nonTrivialSubstitution.kt")
        public void testNonTrivialSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialSubstitution.kt");
        }

        @TestMetadata("nonTrivialUpperBound.kt")
        public void testNonTrivialUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialUpperBound.kt");
        }

        @TestMetadata("substitutedIterable.kt")
        public void testSubstitutedIterable() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedIterable.kt");
        }

        @TestMetadata("SubstitutedList.kt")
        public void testSubstitutedList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/SubstitutedList.kt");
        }

        @TestMetadata("substitutedListWithExtraSuperInterface.kt")
        public void testSubstitutedListWithExtraSuperInterface() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedListWithExtraSuperInterface.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtendJavaCollections extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractList.kt");
            }

            @TestMetadata("abstractMap.kt")
            public void testAbstractMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractMap.kt");
            }

            @TestMetadata("abstractSet.kt")
            public void testAbstractSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractSet.kt");
            }

            public void testAllFilesPresentInExtendJavaCollections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/arrayList.kt");
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/hashMap.kt");
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/hashSet.kt");
            }

            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/mapEntry.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapGetOrDefault extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMapGetOrDefault() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("noTypeSafeBridge.kt")
            public void testNoTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/noTypeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridgeNotNullAny.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapRemove")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MapRemove extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMapRemove() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapRemove"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("noDefaultImpls.kt")
            public void testNoDefaultImpls() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/noDefaultImpls.kt");
            }

            @TestMetadata("readOnlyMap.kt")
            public void testReadOnlyMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/readOnlyMap.kt");
            }

            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridge.kt");
            }

            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridgeNotNullAny.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("classesAreSynthetic.kt")
        public void testClassesAreSynthetic() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/classesAreSynthetic.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBound() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/array.kt");
            }

            @TestMetadata("arrayGetIntrinsic.kt")
            public void testArrayGetIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayGetIntrinsic.kt");
            }

            @TestMetadata("boundJvmFieldInInterfaceCompanion.kt")
            public void testBoundJvmFieldInInterfaceCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundJvmFieldInInterfaceCompanion.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/coercionToUnit.kt");
            }

            @TestMetadata("companionObjectReceiver.kt")
            public void testCompanionObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiver.kt");
            }

            @TestMetadata("emptyLHS.kt")
            public void testEmptyLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/emptyLHS.kt");
            }

            @TestMetadata("enumEntryMember.kt")
            public void testEnumEntryMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
            }

            @TestMetadata("genericValOnLHS.kt")
            public void testGenericValOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericValOnLHS.kt");
            }

            @TestMetadata("kCallableNameIntrinsic.kt")
            public void testKCallableNameIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
            }

            @TestMetadata("kt12738.kt")
            public void testKt12738() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
            }

            @TestMetadata("kt15446.kt")
            public void testKt15446() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt15446.kt");
            }

            @TestMetadata("localUnitFunction.kt")
            public void testLocalUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/localUnitFunction.kt");
            }

            @TestMetadata("multiCase.kt")
            public void testMultiCase() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/multiCase.kt");
            }

            @TestMetadata("nullReceiver.kt")
            public void testNullReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/nullReceiver.kt");
            }

            @TestMetadata("objectReceiver.kt")
            public void testObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/objectReceiver.kt");
            }

            @TestMetadata("primitiveReceiver.kt")
            public void testPrimitiveReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/primitiveReceiver.kt");
            }

            @TestMetadata("simpleFunction.kt")
            public void testSimpleFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
            }

            @TestMetadata("smartCastForExtensionReceiver.kt")
            public void testSmartCastForExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/smartCastForExtensionReceiver.kt");
            }

            @TestMetadata("syntheticExtensionOnLHS.kt")
            public void testSyntheticExtensionOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/syntheticExtensionOnLHS.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/equals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Equals extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInEquals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/equals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("nullableReceiverInEquals.kt")
                public void testNullableReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/nullableReceiverInEquals.kt");
                }

                @TestMetadata("propertyAccessors.kt")
                public void testPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/propertyAccessors.kt");
                }

                @TestMetadata("receiverInEquals.kt")
                public void testReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/receiverInEquals.kt");
                }

                @TestMetadata("reflectionReference.kt")
                public void testReflectionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/reflectionReference.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/inline")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inline extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInline() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("emptyLhsProperty.kt")
                public void testEmptyLhsProperty() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/inline/emptyLhsProperty.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/inline/simple.kt");
                }

                @TestMetadata("simpleVal.kt")
                public void testSimpleVal() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/inline/simpleVal.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("booleanNotIntrinsic.kt")
            public void testBooleanNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
            }

            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
            }

            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/coercionToUnit.kt");
            }

            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("enumValueOfMethod.kt")
            public void testEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
            }

            @TestMetadata("equalsIntrinsic.kt")
            public void testEqualsIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
            }

            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
            }

            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
            }

            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("genericCallableReferenceArguments.kt")
            public void testGenericCallableReferenceArguments() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceArguments.kt");
            }

            @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
            public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
            }

            @TestMetadata("genericCallableReferencesWithOverload.kt")
            public void testGenericCallableReferencesWithOverload() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithOverload.kt");
            }

            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
            }

            @TestMetadata("genericWithDependentType.kt")
            public void testGenericWithDependentType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericWithDependentType.kt");
            }

            @TestMetadata("getArityViaFunctionImpl.kt")
            public void testGetArityViaFunctionImpl() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
            }

            @TestMetadata("innerClassConstructorWithTwoReceivers.kt")
            public void testInnerClassConstructorWithTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerClassConstructorWithTwoReceivers.kt");
            }

            @TestMetadata("innerConstructorFromClass.kt")
            public void testInnerConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
            }

            @TestMetadata("innerConstructorFromExtension.kt")
            public void testInnerConstructorFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
            public void testInnerConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
            public void testInnerConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("javaCollectionsStaticMethod.kt")
            public void testJavaCollectionsStaticMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/javaCollectionsStaticMethod.kt");
            }

            @TestMetadata("kt21787.kt")
            public void testKt21787() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt21787.kt");
            }

            @TestMetadata("nestedConstructorFromClass.kt")
            public void testNestedConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
            public void testNestedConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
            }

            @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
            public void testNestedConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
            }

            @TestMetadata("newArray.kt")
            public void testNewArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/newArray.kt");
            }

            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
            }

            @TestMetadata("overloadedFunVsVal.kt")
            public void testOverloadedFunVsVal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
            }

            @TestMetadata("privateClassMember.kt")
            public void testPrivateClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
            }

            @TestMetadata("sortListOfStrings.kt")
            public void testSortListOfStrings() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
            }

            @TestMetadata("specialCalls.kt")
            public void testSpecialCalls() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/specialCalls.kt");
            }

            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
            }

            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
            public void testTopLevelFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
            public void testTopLevelFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
            }

            @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
            public void testTopLevelFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
            }

            @TestMetadata("traitImplMethodWithClassReceiver.kt")
            public void testTraitImplMethodWithClassReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
            }

            @TestMetadata("traitMember.kt")
            public void testTraitMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("captureOuter.kt")
                public void testCaptureOuter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
                }

                @TestMetadata("classMember.kt")
                public void testClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
                }

                @TestMetadata("closureWithSideEffect.kt")
                public void testClosureWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
                }

                @TestMetadata("constructorWithInitializer.kt")
                public void testConstructorWithInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
                }

                @TestMetadata("enumExtendsTrait.kt")
                public void testEnumExtendsTrait() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
                }

                @TestMetadata("equalsHashCode.kt")
                public void testEqualsHashCode() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/equalsHashCode.kt");
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
                }

                @TestMetadata("extensionToLocalClass.kt")
                public void testExtensionToLocalClass() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
                }

                @TestMetadata("extensionToPrimitive.kt")
                public void testExtensionToPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
                }

                @TestMetadata("extensionWithClosure.kt")
                public void testExtensionWithClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
                }

                @TestMetadata("genericMember.kt")
                public void testGenericMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
                }

                @TestMetadata("localClassMember.kt")
                public void testLocalClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
                }

                @TestMetadata("localFunctionName.kt")
                public void testLocalFunctionName() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
                }

                @TestMetadata("localLocal.kt")
                public void testLocalLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
                }

                @TestMetadata("recursiveClosure.kt")
                public void testRecursiveClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
                }

                @TestMetadata("simpleClosure.kt")
                public void testSimpleClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
                }

                @TestMetadata("simpleWithArg.kt")
                public void testSimpleWithArg() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
                }

                @TestMetadata("unitWithSideEffect.kt")
                public void testUnitWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegated.kt");
            }

            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
            }

            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
            }

            @TestMetadata("extensionToArray.kt")
            public void testExtensionToArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
            }

            @TestMetadata("invokePropertyReference.kt")
            public void testInvokePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
            }

            @TestMetadata("javaBeanConvention.kt")
            public void testJavaBeanConvention() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
            }

            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
            }

            @TestMetadata("kt12044.kt")
            public void testKt12044() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12044.kt");
            }

            @TestMetadata("kt12982_protectedPropertyReference.kt")
            public void testKt12982_protectedPropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
            }

            @TestMetadata("kt14330.kt")
            public void testKt14330() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
            }

            @TestMetadata("kt14330_2.kt")
            public void testKt14330_2() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
            }

            @TestMetadata("kt15447.kt")
            public void testKt15447() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt15447.kt");
            }

            @TestMetadata("kt6870_privatePropertyReference.kt")
            public void testKt6870_privatePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
            }

            @TestMetadata("listOfStringsMapLength.kt")
            public void testListOfStringsMapLength() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
            }

            @TestMetadata("localClassVar.kt")
            public void testLocalClassVar() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
            }

            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
            }

            @TestMetadata("privateSetOuterClass.kt")
            public void testPrivateSetOuterClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetOuterClass.kt");
            }

            @TestMetadata("privateSetterInsideClass.kt")
            public void testPrivateSetterInsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
            }

            @TestMetadata("privateSetterOutsideClass.kt")
            public void testPrivateSetterOutsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
            }

            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
            }

            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
            }

            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
            }

            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
            }

            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/serializability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Serializability extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSerializability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/serializability"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boundWithNotSerializableReceiver.kt")
            public void testBoundWithNotSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithNotSerializableReceiver.kt");
            }

            @TestMetadata("boundWithSerializableReceiver.kt")
            public void testBoundWithSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithSerializableReceiver.kt");
            }

            @TestMetadata("noReflect.kt")
            public void testNoReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/noReflect.kt");
            }

            @TestMetadata("reflectedIsNotSerialized.kt")
            public void testReflectedIsNotSerialized() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/reflectedIsNotSerialized.kt");
            }

            @TestMetadata("withReflect.kt")
            public void testWithReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/withReflect.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/varargAndDefaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VarargAndDefaults extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInVarargAndDefaults() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/varargAndDefaults"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("bothWithCoercionToUnit.kt")
            public void testBothWithCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/bothWithCoercionToUnit.kt");
            }

            @TestMetadata("boundReferences.kt")
            public void testBoundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/boundReferences.kt");
            }

            @TestMetadata("defaultAfterVararg.kt")
            public void testDefaultAfterVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/defaultAfterVararg.kt");
            }

            @TestMetadata("defaultWithGenericExpectedType.kt")
            public void testDefaultWithGenericExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/defaultWithGenericExpectedType.kt");
            }

            @TestMetadata("emptyVarargAndDefault.kt")
            public void testEmptyVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/emptyVarargAndDefault.kt");
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/inline.kt");
            }

            @TestMetadata("innerConstructorWithVararg.kt")
            public void testInnerConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/innerConstructorWithVararg.kt");
            }

            @TestMetadata("localFunctionWithDefault.kt")
            public void testLocalFunctionWithDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/localFunctionWithDefault.kt");
            }

            @TestMetadata("manyDefaultsAndVararg.kt")
            public void testManyDefaultsAndVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/manyDefaultsAndVararg.kt");
            }

            @TestMetadata("simpleDefaultArgument.kt")
            public void testSimpleDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/simpleDefaultArgument.kt");
            }

            @TestMetadata("simpleEmptyVararg.kt")
            public void testSimpleEmptyVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/simpleEmptyVararg.kt");
            }

            @TestMetadata("varargViewedAsArray.kt")
            public void testVarargViewedAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/varargViewedAsArray.kt");
            }

            @TestMetadata("varargWithDefaultValue.kt")
            public void testVarargWithDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/varargAndDefaults/varargWithDefaultValue.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/casts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Casts extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCasts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("as.kt")
        public void testAs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/as.kt");
        }

        @TestMetadata("asForConstants.kt")
        public void testAsForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asForConstants.kt");
        }

        @TestMetadata("asSafe.kt")
        public void testAsSafe() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafe.kt");
        }

        @TestMetadata("asSafeFail.kt")
        public void testAsSafeFail() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeFail.kt");
        }

        @TestMetadata("asSafeForConstants.kt")
        public void testAsSafeForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
        }

        @TestMetadata("asUnit.kt")
        public void testAsUnit() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asUnit.kt");
        }

        @TestMetadata("asWithGeneric.kt")
        public void testAsWithGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asWithGeneric.kt");
        }

        @TestMetadata("castGenericNull.kt")
        public void testCastGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castGenericNull.kt");
        }

        @TestMetadata("intersectionTypeMultipleBounds.kt")
        public void testIntersectionTypeMultipleBounds() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
        }

        @TestMetadata("intersectionTypeMultipleBoundsImplicitReceiver.kt")
        public void testIntersectionTypeMultipleBoundsImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBoundsImplicitReceiver.kt");
        }

        @TestMetadata("intersectionTypeSmartcast.kt")
        public void testIntersectionTypeSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
        }

        @TestMetadata("intersectionTypeWithMultipleBoundsAsReceiver.kt")
        public void testIntersectionTypeWithMultipleBoundsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithMultipleBoundsAsReceiver.kt");
        }

        @TestMetadata("intersectionTypeWithoutGenericsAsReceiver.kt")
        public void testIntersectionTypeWithoutGenericsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithoutGenericsAsReceiver.kt");
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/is.kt");
        }

        @TestMetadata("isNullablePrimitive.kt")
        public void testIsNullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/casts/isNullablePrimitive.kt");
        }

        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt22714.kt");
        }

        @TestMetadata("lambdaToUnitCast.kt")
        public void testLambdaToUnitCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/notIs.kt");
        }

        @TestMetadata("unitAsAny.kt")
        public void testUnitAsAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsAny.kt");
        }

        @TestMetadata("unitAsInt.kt")
        public void testUnitAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsInt.kt");
        }

        @TestMetadata("unitAsSafeAny.kt")
        public void testUnitAsSafeAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
        }

        @TestMetadata("unitNullableCast.kt")
        public void testUnitNullableCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitNullableCast.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/casts/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("asFunKBig.kt")
            public void testAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
            }

            @TestMetadata("asFunKSmall.kt")
            public void testAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
            }

            @TestMetadata("isFunKBig.kt")
            public void testIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
            }

            @TestMetadata("isFunKSmall.kt")
            public void testIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
            }

            @TestMetadata("javaTypeIsFunK.kt")
            public void testJavaTypeIsFunK() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/javaTypeIsFunK.kt");
            }

            @TestMetadata("reifiedAsFunKBig.kt")
            public void testReifiedAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
            }

            @TestMetadata("reifiedAsFunKSmall.kt")
            public void testReifiedAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
            }

            @TestMetadata("reifiedIsFunKBig.kt")
            public void testReifiedIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
            }

            @TestMetadata("reifiedIsFunKSmall.kt")
            public void testReifiedIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
            }

            @TestMetadata("reifiedSafeAsFunKBig.kt")
            public void testReifiedSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
            }

            @TestMetadata("reifiedSafeAsFunKSmall.kt")
            public void testReifiedSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
            }

            @TestMetadata("safeAsFunKBig.kt")
            public void testSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
            }

            @TestMetadata("safeAsFunKSmall.kt")
            public void testSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LiteralExpressionAsGenericArgument extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLiteralExpressionAsGenericArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("binaryExpressionCast.kt")
            public void testBinaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
            }

            @TestMetadata("javaBox.kt")
            public void testJavaBox() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/javaBox.kt");
            }

            @TestMetadata("labeledExpressionCast.kt")
            public void testLabeledExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
            }

            @TestMetadata("parenthesizedExpressionCast.kt")
            public void testParenthesizedExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
            }

            @TestMetadata("superConstructor.kt")
            public void testSuperConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
            }

            @TestMetadata("unaryExpressionCast.kt")
            public void testUnaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MutableCollections extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMutableCollections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("asWithMutable.kt")
            public void testAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
            }

            @TestMetadata("isWithMutable.kt")
            public void testIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
            }

            @TestMetadata("mutabilityMarkerInterfaces.kt")
            public void testMutabilityMarkerInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/mutabilityMarkerInterfaces.kt");
            }

            @TestMetadata("reifiedAsWithMutable.kt")
            public void testReifiedAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
            }

            @TestMetadata("reifiedIsWithMutable.kt")
            public void testReifiedIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
            }

            @TestMetadata("reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
            }

            @TestMetadata("safeAsWithMutable.kt")
            public void testSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
            }

            @TestMetadata("weirdMutableCasts.kt")
            public void testWeirdMutableCasts() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/checkcastOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckcastOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCheckcastOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/checkcastOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt19128.kt")
        public void testKt19128() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19128.kt");
        }

        @TestMetadata("kt19246.kt")
        public void testKt19246() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19246.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassLiteral extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClassLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("primitiveKClassEquality.kt")
        public void testPrimitiveKClassEquality() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/primitiveKClassEquality.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBound() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("javaIntrinsicWithSideEffect.kt")
            public void testJavaIntrinsicWithSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/javaIntrinsicWithSideEffect.kt");
            }

            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
            }

            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/smartCast.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJava() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("java.kt")
            public void testJava() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/java.kt");
            }

            @TestMetadata("javaObjectType.kt")
            public void testJavaObjectType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectType.kt");
            }

            @TestMetadata("javaObjectTypeReified.kt")
            public void testJavaObjectTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectTypeReified.kt");
            }

            @TestMetadata("javaPrimitiveType.kt")
            public void testJavaPrimitiveType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveType.kt");
            }

            @TestMetadata("javaPrimitiveTypeReified.kt")
            public void testJavaPrimitiveTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveTypeReified.kt");
            }

            @TestMetadata("javaReified.kt")
            public void testJavaReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaReified.kt");
            }

            @TestMetadata("kt11943.kt")
            public void testKt11943() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
            }

            @TestMetadata("objectSuperConstructorCall.kt")
            public void testObjectSuperConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/objectSuperConstructorCall.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Classes extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
        public void testBoxPrimitiveTypeInClinitOfClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
        }

        @TestMetadata("classCompanionInitializationWithJava.kt")
        public void testClassCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classCompanionInitializationWithJava.kt");
        }

        @TestMetadata("classNamedAsOldPackageFacade.kt")
        public void testClassNamedAsOldPackageFacade() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObject.kt");
        }

        @TestMetadata("classObjectAsExtensionReceiver.kt")
        public void testClassObjectAsExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
        }

        @TestMetadata("classObjectAsStaticInitializer.kt")
        public void testClassObjectAsStaticInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
        }

        @TestMetadata("classObjectField.kt")
        public void testClassObjectField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectField.kt");
        }

        @TestMetadata("classObjectInTrait.kt")
        public void testClassObjectInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
        }

        @TestMetadata("classObjectNotOfEnum.kt")
        public void testClassObjectNotOfEnum() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
        }

        @TestMetadata("classObjectToString.kt")
        public void testClassObjectToString() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectToString.kt");
        }

        @TestMetadata("classObjectWithPrivateGenericMember.kt")
        public void testClassObjectWithPrivateGenericMember() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
        }

        @TestMetadata("classObjectsWithParentClasses.kt")
        public void testClassObjectsWithParentClasses() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
        }

        @TestMetadata("comanionObjectFieldVsClassField.kt")
        public void testComanionObjectFieldVsClassField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/comanionObjectFieldVsClassField.kt");
        }

        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            runTest("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
        }

        @TestMetadata("delegateConstructorCallWithKeywords.kt")
        public void testDelegateConstructorCallWithKeywords() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegateConstructorCallWithKeywords.kt");
        }

        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation2.kt");
        }

        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation3.kt");
        }

        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation4.kt");
        }

        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
        }

        @TestMetadata("delegationGenericArgUpperBound.kt")
        public void testDelegationGenericArgUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
        }

        @TestMetadata("delegationGenericLongArg.kt")
        public void testDelegationGenericLongArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
        }

        @TestMetadata("delegationJava.kt")
        public void testDelegationJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationJava.kt");
        }

        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
        }

        @TestMetadata("exceptionConstructor.kt")
        public void testExceptionConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
        }

        @TestMetadata("extensionOnNamedClassObject.kt")
        public void testExtensionOnNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/funDelegation.kt");
        }

        @TestMetadata("implementComparableInSubclass.kt")
        public void testImplementComparableInSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
        }

        @TestMetadata("inheritSetAndHashSet.kt")
        public void testInheritSetAndHashSet() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritance.kt");
        }

        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
        }

        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedMethod.kt");
        }

        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlock.kt");
        }

        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/innerClass.kt");
        }

        @TestMetadata("interfaceCompanionInitializationWithJava.kt")
        public void testInterfaceCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/interfaceCompanionInitializationWithJava.kt");
        }

        @TestMetadata("kt1018.kt")
        public void testKt1018() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1018.kt");
        }

        @TestMetadata("kt1120.kt")
        public void testKt1120() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1120.kt");
        }

        @TestMetadata("kt1134.kt")
        public void testKt1134() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1134.kt");
        }

        @TestMetadata("kt1157.kt")
        public void testKt1157() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1157.kt");
        }

        @TestMetadata("kt1247.kt")
        public void testKt1247() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1247.kt");
        }

        @TestMetadata("kt1345.kt")
        public void testKt1345() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1345.kt");
        }

        @TestMetadata("kt1439.kt")
        public void testKt1439() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1439.kt");
        }

        @TestMetadata("kt1535.kt")
        public void testKt1535() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1535.kt");
        }

        @TestMetadata("kt1538.kt")
        public void testKt1538() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1538.kt");
        }

        @TestMetadata("kt1578.kt")
        public void testKt1578() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1578.kt");
        }

        @TestMetadata("kt1611.kt")
        public void testKt1611() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1611.kt");
        }

        @TestMetadata("kt1721.kt")
        public void testKt1721() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1721.kt");
        }

        @TestMetadata("kt1726.kt")
        public void testKt1726() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1726.kt");
        }

        @TestMetadata("kt1759.kt")
        public void testKt1759() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1759.kt");
        }

        @TestMetadata("kt1891.kt")
        public void testKt1891() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1891.kt");
        }

        @TestMetadata("kt1918.kt")
        public void testKt1918() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1918.kt");
        }

        @TestMetadata("kt1976.kt")
        public void testKt1976() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1976.kt");
        }

        @TestMetadata("kt1980.kt")
        public void testKt1980() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1980.kt");
        }

        @TestMetadata("kt2224.kt")
        public void testKt2224() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2224.kt");
        }

        @TestMetadata("kt2288.kt")
        public void testKt2288() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2288.kt");
        }

        @TestMetadata("kt2384.kt")
        public void testKt2384() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2384.kt");
        }

        @TestMetadata("kt2390.kt")
        public void testKt2390() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2390.kt");
        }

        @TestMetadata("kt2391.kt")
        public void testKt2391() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2391.kt");
        }

        @TestMetadata("kt2395.kt")
        public void testKt2395() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2395.kt");
        }

        @TestMetadata("kt2417.kt")
        public void testKt2417() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2417.kt");
        }

        @TestMetadata("kt2477.kt")
        public void testKt2477() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2477.kt");
        }

        @TestMetadata("kt2480.kt")
        public void testKt2480() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2480.kt");
        }

        @TestMetadata("kt2482.kt")
        public void testKt2482() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2482.kt");
        }

        @TestMetadata("kt2485.kt")
        public void testKt2485() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2485.kt");
        }

        @TestMetadata("kt249.kt")
        public void testKt249() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt249.kt");
        }

        @TestMetadata("kt2532.kt")
        public void testKt2532() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2532.kt");
        }

        @TestMetadata("kt2566.kt")
        public void testKt2566() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566.kt");
        }

        @TestMetadata("kt2566_2.kt")
        public void testKt2566_2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566_2.kt");
        }

        @TestMetadata("kt2607.kt")
        public void testKt2607() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2607.kt");
        }

        @TestMetadata("kt2626.kt")
        public void testKt2626() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2626.kt");
        }

        @TestMetadata("kt2711.kt")
        public void testKt2711() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2711.kt");
        }

        @TestMetadata("kt2784.kt")
        public void testKt2784() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2784.kt");
        }

        @TestMetadata("kt285.kt")
        public void testKt285() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt285.kt");
        }

        @TestMetadata("kt3001.kt")
        public void testKt3001() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3001.kt");
        }

        @TestMetadata("kt3114.kt")
        public void testKt3114() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3114.kt");
        }

        @TestMetadata("kt3414.kt")
        public void testKt3414() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3414.kt");
        }

        @TestMetadata("kt343.kt")
        public void testKt343() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt343.kt");
        }

        @TestMetadata("kt3546.kt")
        public void testKt3546() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3546.kt");
        }

        @TestMetadata("kt454.kt")
        public void testKt454() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt454.kt");
        }

        @TestMetadata("kt471.kt")
        public void testKt471() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt471.kt");
        }

        @TestMetadata("kt48.kt")
        public void testKt48() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt48.kt");
        }

        @TestMetadata("kt496.kt")
        public void testKt496() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt496.kt");
        }

        @TestMetadata("kt500.kt")
        public void testKt500() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt500.kt");
        }

        @TestMetadata("kt501.kt")
        public void testKt501() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt501.kt");
        }

        @TestMetadata("kt504.kt")
        public void testKt504() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt504.kt");
        }

        @TestMetadata("kt508.kt")
        public void testKt508() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt508.kt");
        }

        @TestMetadata("kt5347.kt")
        public void testKt5347() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt5347.kt");
        }

        @TestMetadata("kt6136.kt")
        public void testKt6136() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6136.kt");
        }

        @TestMetadata("kt633.kt")
        public void testKt633() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt633.kt");
        }

        @TestMetadata("kt6816.kt")
        public void testKt6816() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6816.kt");
        }

        @TestMetadata("kt707.kt")
        public void testKt707() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt707.kt");
        }

        @TestMetadata("kt723.kt")
        public void testKt723() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt723.kt");
        }

        @TestMetadata("kt725.kt")
        public void testKt725() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt725.kt");
        }

        @TestMetadata("kt8011.kt")
        public void testKt8011() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011.kt");
        }

        @TestMetadata("kt8011a.kt")
        public void testKt8011a() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011a.kt");
        }

        @TestMetadata("kt903.kt")
        public void testKt903() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt903.kt");
        }

        @TestMetadata("kt940.kt")
        public void testKt940() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt940.kt");
        }

        @TestMetadata("kt9642.kt")
        public void testKt9642() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt9642.kt");
        }

        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/namedClassObject.kt");
        }

        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/outerThis.kt");
        }

        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
        }

        @TestMetadata("overloadPlusAssign.kt")
        public void testOverloadPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
        }

        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
        }

        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
        }

        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
        }

        @TestMetadata("privateOuterFunctions.kt")
        public void testPrivateOuterFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
        }

        @TestMetadata("privateOuterProperty.kt")
        public void testPrivateOuterProperty() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
        }

        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateToThis.kt");
        }

        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyDelegation.kt");
        }

        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
        }

        @TestMetadata("quotedClassName.kt")
        public void testQuotedClassName() throws Exception {
            runTest("compiler/testData/codegen/box/classes/quotedClassName.kt");
        }

        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            runTest("compiler/testData/codegen/box/classes/rightHandOverride.kt");
        }

        @TestMetadata("sealedInSameFile.kt")
        public void testSealedInSameFile() throws Exception {
            runTest("compiler/testData/codegen/box/classes/sealedInSameFile.kt");
        }

        @TestMetadata("selfcreate.kt")
        public void testSelfcreate() throws Exception {
            runTest("compiler/testData/codegen/box/classes/selfcreate.kt");
        }

        @TestMetadata("simpleBox.kt")
        public void testSimpleBox() throws Exception {
            runTest("compiler/testData/codegen/box/classes/simpleBox.kt");
        }

        @TestMetadata("superConstructorCallWithComplexArg.kt")
        public void testSuperConstructorCallWithComplexArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/superConstructorCallWithComplexArg.kt");
        }

        @TestMetadata("typedDelegation.kt")
        public void testTypedDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/typedDelegation.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/classes/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInner() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("instantiateInDerived.kt")
            public void testInstantiateInDerived() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
            }

            @TestMetadata("instantiateInDerivedLabeled.kt")
            public void testInstantiateInDerivedLabeled() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
            }

            @TestMetadata("instantiateInSameClass.kt")
            public void testInstantiateInSameClass() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
            }

            @TestMetadata("kt6708.kt")
            public void testKt6708() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/kt6708.kt");
            }

            @TestMetadata("properOuter.kt")
            public void testProperOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properOuter.kt");
            }

            @TestMetadata("properSuperLinking.kt")
            public void testProperSuperLinking() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/closures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Closures extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInClosures() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectAsLastExpressionInLambda.kt")
        public void testAnonymousObjectAsLastExpressionInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/anonymousObjectAsLastExpressionInLambda.kt");
        }

        @TestMetadata("captureExtensionReceiver.kt")
        public void testCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
        }

        @TestMetadata("capturedLocalGenericFun.kt")
        public void testCapturedLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
        }

        @TestMetadata("closureInsideConstrucor.kt")
        public void testClosureInsideConstrucor() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
        }

        @TestMetadata("closureOnTopLevel1.kt")
        public void testClosureOnTopLevel1() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
        }

        @TestMetadata("closureOnTopLevel2.kt")
        public void testClosureOnTopLevel2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
        }

        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameter.kt");
        }

        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
        }

        @TestMetadata("crossinlineLocalDeclaration.kt")
        public void testCrossinlineLocalDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/closures/crossinlineLocalDeclaration.kt");
        }

        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
        }

        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
        }

        @TestMetadata("enclosingThis.kt")
        public void testEnclosingThis() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingThis.kt");
        }

        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/extensionClosure.kt");
        }

        @TestMetadata("kt10044.kt")
        public void testKt10044() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt10044.kt");
        }

        @TestMetadata("kt11634.kt")
        public void testKt11634() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634.kt");
        }

        @TestMetadata("kt11634_2.kt")
        public void testKt11634_2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_2.kt");
        }

        @TestMetadata("kt11634_3.kt")
        public void testKt11634_3() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_3.kt");
        }

        @TestMetadata("kt11634_4.kt")
        public void testKt11634_4() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_4.kt");
        }

        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389.kt");
        }

        @TestMetadata("kt19389_set.kt")
        public void testKt19389_set() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389_set.kt");
        }

        @TestMetadata("kt2151.kt")
        public void testKt2151() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt2151.kt");
        }

        @TestMetadata("kt3152.kt")
        public void testKt3152() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3152.kt");
        }

        @TestMetadata("kt3523.kt")
        public void testKt3523() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3523.kt");
        }

        @TestMetadata("kt3738.kt")
        public void testKt3738() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3738.kt");
        }

        @TestMetadata("kt3905.kt")
        public void testKt3905() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3905.kt");
        }

        @TestMetadata("kt4106.kt")
        public void testKt4106() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4106.kt");
        }

        @TestMetadata("kt4137.kt")
        public void testKt4137() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4137.kt");
        }

        @TestMetadata("kt5589.kt")
        public void testKt5589() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt5589.kt");
        }

        @TestMetadata("localClassFunClosure.kt")
        public void testLocalClassFunClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
        }

        @TestMetadata("localClassLambdaClosure.kt")
        public void testLocalClassLambdaClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
        }

        @TestMetadata("localFunctionInFunction.kt")
        public void testLocalFunctionInFunction() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
        }

        @TestMetadata("localFunctionInInitializer.kt")
        public void testLocalFunctionInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
        }

        @TestMetadata("localGenericFun.kt")
        public void testLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localGenericFun.kt");
        }

        @TestMetadata("localReturn.kt")
        public void testLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturn.kt");
        }

        @TestMetadata("localReturnWithAutolabel.kt")
        public void testLocalReturnWithAutolabel() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
        }

        @TestMetadata("noRefToOuter.kt")
        public void testNoRefToOuter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/noRefToOuter.kt");
        }

        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/recursiveClosure.kt");
        }

        @TestMetadata("refsAreSerializable.kt")
        public void testRefsAreSerializable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/refsAreSerializable.kt");
        }

        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosure.kt");
        }

        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
        }

        @TestMetadata("subclosuresWithinInitializers.kt")
        public void testSubclosuresWithinInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
        }

        @TestMetadata("underscoreParameters.kt")
        public void testUnderscoreParameters() throws Exception {
            runTest("compiler/testData/codegen/box/closures/underscoreParameters.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureInSuperConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureInSuperConstructorCall extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureInSuperConstructorCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/captureInSuperConstructorCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructorParameterAndLocalCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterAndLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterAndLocalCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass2.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass2.kt");
            }

            @TestMetadata("kt13454.kt")
            public void testKt13454() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt13454.kt");
            }

            @TestMetadata("kt14148.kt")
            public void testKt14148() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt14148.kt");
            }

            @TestMetadata("kt4174.kt")
            public void testKt4174() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174.kt");
            }

            @TestMetadata("kt4174a.kt")
            public void testKt4174a() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174a.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass.kt");
            }

            @TestMetadata("localCapturedInAnonymousObjectInLocalClass2.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass2.kt");
            }

            @TestMetadata("localCapturedInLambdaInInnerClassInLocalClass.kt")
            public void testLocalCapturedInLambdaInInnerClassInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInInnerClassInLocalClass.kt");
            }

            @TestMetadata("localCapturedInLambdaInLocalClass.kt")
            public void testLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInLocalClass.kt");
            }

            @TestMetadata("localFunctionCapturedInLambda.kt")
            public void testLocalFunctionCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localFunctionCapturedInLambda.kt");
            }

            @TestMetadata("outerAndLocalCapturedInLocalClass.kt")
            public void testOuterAndLocalCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerAndLocalCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedAsImplicitThisInBoundReference.kt")
            public void testOuterCapturedAsImplicitThisInBoundReference() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedAsImplicitThisInBoundReference.kt");
            }

            @TestMetadata("outerCapturedInFunctionLiteral.kt")
            public void testOuterCapturedInFunctionLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInFunctionLiteral.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda.kt")
            public void testOuterCapturedInInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda.kt");
            }

            @TestMetadata("outerCapturedInInlineLambda2.kt")
            public void testOuterCapturedInInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambda.kt")
            public void testOuterCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda.kt");
            }

            @TestMetadata("outerCapturedInLambda2.kt")
            public void testOuterCapturedInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda2.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSecondaryConstructor.kt")
            public void testOuterCapturedInLambdaInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSecondaryConstructor.kt");
            }

            @TestMetadata("outerCapturedInLambdaInSubExpression.kt")
            public void testOuterCapturedInLambdaInSubExpression() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSubExpression.kt");
            }

            @TestMetadata("outerCapturedInLocalClass.kt")
            public void testOuterCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLocalClass.kt");
            }

            @TestMetadata("outerCapturedInNestedLambda.kt")
            public void testOuterCapturedInNestedLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedLambda.kt");
            }

            @TestMetadata("outerCapturedInNestedObject.kt")
            public void testOuterCapturedInNestedObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedObject.kt");
            }

            @TestMetadata("outerCapturedInObject.kt")
            public void testOuterCapturedInObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject.kt");
            }

            @TestMetadata("outerCapturedInObject2.kt")
            public void testOuterCapturedInObject2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject2.kt");
            }

            @TestMetadata("outerEnumEntryCapturedInLambdaInInnerClass.kt")
            public void testOuterEnumEntryCapturedInLambdaInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerEnumEntryCapturedInLambdaInInnerClass.kt");
            }

            @TestMetadata("properValueCapturedByClosure1.kt")
            public void testProperValueCapturedByClosure1() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure1.kt");
            }

            @TestMetadata("properValueCapturedByClosure2.kt")
            public void testProperValueCapturedByClosure2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure2.kt");
            }

            @TestMetadata("referenceToCapturedVariablesInMultipleLambdas.kt")
            public void testReferenceToCapturedVariablesInMultipleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/referenceToCapturedVariablesInMultipleLambdas.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureOuterProperty extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCaptureOuterProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("captureFunctionInProperty.kt")
            public void testCaptureFunctionInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
            }

            @TestMetadata("inFunction.kt")
            public void testInFunction() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
            }

            @TestMetadata("inProperty.kt")
            public void testInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
            }

            @TestMetadata("inPropertyDeepObjectChain.kt")
            public void testInPropertyDeepObjectChain() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
            }

            @TestMetadata("inPropertyFromSuperClass.kt")
            public void testInPropertyFromSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
            }

            @TestMetadata("inPropertyFromSuperSuperClass.kt")
            public void testInPropertyFromSuperSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
            }

            @TestMetadata("kt4176.kt")
            public void testKt4176() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
            }

            @TestMetadata("kt4656.kt")
            public void testKt4656() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/capturedVarsOptimization")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CapturedVarsOptimization extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("capturedInCrossinline.kt")
            public void testCapturedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInCrossinline.kt");
            }

            @TestMetadata("capturedInInlineOnlyAssign.kt")
            public void testCapturedInInlineOnlyAssign() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyAssign.kt");
            }

            @TestMetadata("capturedInInlineOnlyCAO.kt")
            public void testCapturedInInlineOnlyCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyCAO.kt");
            }

            @TestMetadata("capturedInInlineOnlyIncrDecr.kt")
            public void testCapturedInInlineOnlyIncrDecr() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIncrDecr.kt");
            }

            @TestMetadata("capturedInInlineOnlyIndexedCAO.kt")
            public void testCapturedInInlineOnlyIndexedCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIndexedCAO.kt");
            }

            @TestMetadata("capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @TestMetadata("kt17200.kt")
            public void testKt17200() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17200.kt");
            }

            @TestMetadata("kt17588.kt")
            public void testKt17588() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17588.kt");
            }

            @TestMetadata("sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @TestMetadata("withCoroutinesNoStdLib.kt")
            public void testWithCoroutinesNoStdLib_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("withCoroutinesNoStdLib.kt")
            public void testWithCoroutinesNoStdLib_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt", "kotlin.coroutines");
            }

            @TestMetadata("withCoroutines.kt")
            public void testWithCoroutines_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("withCoroutines.kt")
            public void testWithCoroutines_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureInsideClosure extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInClosureInsideClosure() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("localFunInsideLocalFun.kt")
            public void testLocalFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
            }

            @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
            public void testLocalFunInsideLocalFunDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
            }

            @TestMetadata("propertyAndFunctionNameClash.kt")
            public void testPropertyAndFunctionNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
            }

            @TestMetadata("threeLevels.kt")
            public void testThreeLevels() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
            }

            @TestMetadata("threeLevelsDifferentSignatures.kt")
            public void testThreeLevelsDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
            }

            @TestMetadata("varAsFunInsideLocalFun.kt")
            public void testVarAsFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collectionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CollectionLiterals extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCollectionLiterals() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/collectionLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("collectionLiteralsInArgumentPosition.kt")
        public void testCollectionLiteralsInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsInArgumentPosition.kt");
        }

        @TestMetadata("collectionLiteralsWithConstants.kt")
        public void testCollectionLiteralsWithConstants() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithConstants.kt");
        }

        @TestMetadata("collectionLiteralsWithVarargs.kt")
        public void testCollectionLiteralsWithVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithVarargs.kt");
        }

        @TestMetadata("defaultAnnotationParameterValues.kt")
        public void testDefaultAnnotationParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/defaultAnnotationParameterValues.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Collections extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCollections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/charSequence.kt");
        }

        @TestMetadata("implementCollectionThroughKotlin.kt")
        public void testImplementCollectionThroughKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/implementCollectionThroughKotlin.kt");
        }

        @TestMetadata("inSetWithSmartCast.kt")
        public void testInSetWithSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
        }

        @TestMetadata("irrelevantImplCharSequence.kt")
        public void testIrrelevantImplCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequence.kt");
        }

        @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
        public void testIrrelevantImplCharSequenceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceKotlin.kt");
        }

        @TestMetadata("irrelevantImplMutableList.kt")
        public void testIrrelevantImplMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableList.kt");
        }

        @TestMetadata("irrelevantImplMutableListKotlin.kt")
        public void testIrrelevantImplMutableListKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListKotlin.kt");
        }

        @TestMetadata("irrelevantImplMutableListSubstitution.kt")
        public void testIrrelevantImplMutableListSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListSubstitution.kt");
        }

        @TestMetadata("irrelevantRemoveAtOverrideInJava.kt")
        public void testIrrelevantRemoveAtOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantRemoveAtOverrideInJava.kt");
        }

        @TestMetadata("irrelevantSizeOverrideInJava.kt")
        public void testIrrelevantSizeOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantSizeOverrideInJava.kt");
        }

        @TestMetadata("mutableList.kt")
        public void testMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/mutableList.kt");
        }

        @TestMetadata("noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/noStubsInJavaSuperClass.kt");
        }

        @TestMetadata("platformValueContains.kt")
        public void testPlatformValueContains() throws Exception {
            runTest("compiler/testData/codegen/box/collections/platformValueContains.kt");
        }

        @TestMetadata("readOnlyList.kt")
        public void testReadOnlyList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyList.kt");
        }

        @TestMetadata("readOnlyMap.kt")
        public void testReadOnlyMap() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyMap.kt");
        }

        @TestMetadata("removeAtInt.kt")
        public void testRemoveAtInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeAtInt.kt");
        }

        @TestMetadata("strList.kt")
        public void testStrList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/strList.kt");
        }

        @TestMetadata("toArrayInJavaClass.kt")
        public void testToArrayInJavaClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/toArrayInJavaClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/compatibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Compatibility extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInCompatibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("dataClassEqualsHashCodeToString.kt")
        public void testDataClassEqualsHashCodeToString() throws Exception {
            runTest("compiler/testData/codegen/box/compatibility/dataClassEqualsHashCodeToString.kt");
        }

        @TestMetadata("privateCompanionObject.kt")
        public void testPrivateCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/compatibility/privateCompanionObject.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("constantsInWhen.kt")
        public void testConstantsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constantsInWhen.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/constants/float.kt");
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/box/constants/kt9532.kt");
        }

        @TestMetadata("kt9532_lv10.kt")
        public void testKt9532_lv10() throws Exception {
            runTest("compiler/testData/codegen/box/constants/kt9532_lv10.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("compiler/testData/codegen/box/constants/long.kt");
        }

        @TestMetadata("privateConst.kt")
        public void testPrivateConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/privateConst.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constructorCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstructorCall extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInConstructorCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/constructorCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("breakInConstructorArguments.kt")
        public void testBreakInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/breakInConstructorArguments.kt");
        }

        @TestMetadata("continueInConstructorArguments.kt")
        public void testContinueInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/continueInConstructorArguments.kt");
        }

        @TestMetadata("earlyReturnInConstructorArguments.kt")
        public void testEarlyReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/earlyReturnInConstructorArguments.kt");
        }

        @TestMetadata("inlineFunInConstructorCallEvaluationOrder.kt")
        public void testInlineFunInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallEvaluationOrder.kt");
        }

        @TestMetadata("inlineFunInConstructorCallWithDisabledNormalization.kt")
        public void testInlineFunInConstructorCallWithDisabledNormalization() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallWithDisabledNormalization.kt");
        }

        @TestMetadata("inlineFunInConstructorCallWithEnabledNormalization.kt")
        public void testInlineFunInConstructorCallWithEnabledNormalization() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallWithEnabledNormalization.kt");
        }

        @TestMetadata("inlineFunInConstructorCallWithStrictNormalization.kt")
        public void testInlineFunInConstructorCallWithStrictNormalization() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallWithStrictNormalization.kt");
        }

        @TestMetadata("inlineFunInInnerClassConstructorCall.kt")
        public void testInlineFunInInnerClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInInnerClassConstructorCall.kt");
        }

        @TestMetadata("inlineFunInLocalClassConstructorCall.kt")
        public void testInlineFunInLocalClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInLocalClassConstructorCall.kt");
        }

        @TestMetadata("loopInInlineFunInSuperConstructorCallWithEnabledNormalization.kt")
        public void testLoopInInlineFunInSuperConstructorCallWithEnabledNormalization() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunInSuperConstructorCallWithEnabledNormalization.kt");
        }

        @TestMetadata("loopInInlineFunInSuperConstructorCallWithEnabledNormalizationSince13.kt")
        public void testLoopInInlineFunInSuperConstructorCallWithEnabledNormalizationSince13() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunInSuperConstructorCallWithEnabledNormalizationSince13.kt");
        }

        @TestMetadata("loopInInlineFunWithEnabledNormalization.kt")
        public void testLoopInInlineFunWithEnabledNormalization() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunWithEnabledNormalization.kt");
        }

        @TestMetadata("nestedConstructorCallWithJumpOutInConstructorArguments.kt")
        public void testNestedConstructorCallWithJumpOutInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nestedConstructorCallWithJumpOutInConstructorArguments.kt");
        }

        @TestMetadata("nonLocalReturnInConstructorArguments.kt")
        public void testNonLocalReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nonLocalReturnInConstructorArguments.kt");
        }

        @TestMetadata("possiblyPoppedUnitializedValueInArguments.kt")
        public void testPossiblyPoppedUnitializedValueInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/possiblyPoppedUnitializedValueInArguments.kt");
        }

        @TestMetadata("regularConstructorCallEvaluationOrder.kt")
        public void testRegularConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/regularConstructorCallEvaluationOrder.kt");
        }

        @TestMetadata("tryCatchInConstructorCallEvaluationOrder.kt")
        public void testTryCatchInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/tryCatchInConstructorCallEvaluationOrder.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/contracts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contracts extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInContracts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/contracts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("exactlyOnceNotInline.kt")
        public void testExactlyOnceNotInline() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exactlyOnceNotInline.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ControlStructures extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInControlStructures() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bottles.kt")
        public void testBottles() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/bottles.kt");
        }

        @TestMetadata("breakInFinally.kt")
        public void testBreakInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
        }

        @TestMetadata("compareBoxedIntegerToZero.kt")
        public void testCompareBoxedIntegerToZero() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
        }

        @TestMetadata("conditionOfEmptyIf.kt")
        public void testConditionOfEmptyIf() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
        }

        @TestMetadata("continueInExpr.kt")
        public void testContinueInExpr() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
        }

        @TestMetadata("continueInFor.kt")
        public void testContinueInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
        }

        @TestMetadata("continueInForCondition.kt")
        public void testContinueInForCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
        }

        @TestMetadata("continueInWhile.kt")
        public void testContinueInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
        }

        @TestMetadata("continueToLabelInFor.kt")
        public void testContinueToLabelInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhile.kt");
        }

        @TestMetadata("doWhileFib.kt")
        public void testDoWhileFib() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
        }

        @TestMetadata("doWhileWithContinue.kt")
        public void testDoWhileWithContinue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
        }

        @TestMetadata("emptyDoWhile.kt")
        public void testEmptyDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
        }

        @TestMetadata("emptyFor.kt")
        public void testEmptyFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
        }

        @TestMetadata("emptyWhile.kt")
        public void testEmptyWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
        }

        @TestMetadata("factorialTest.kt")
        public void testFactorialTest() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
        }

        @TestMetadata("finallyOnEmptyReturn.kt")
        public void testFinallyOnEmptyReturn() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
        }

        @TestMetadata("forArrayList.kt")
        public void testForArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
        }

        @TestMetadata("forArrayListMultiDecl.kt")
        public void testForArrayListMultiDecl() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
        }

        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequence.kt");
        }

        @TestMetadata("forInCharSequenceMut.kt")
        public void testForInCharSequenceMut() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceMut.kt");
        }

        @TestMetadata("forInSmartCastToArray.kt")
        public void testForInSmartCastToArray() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
        }

        @TestMetadata("forLoopMemberExtensionAll.kt")
        public void testForLoopMemberExtensionAll() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
        }

        @TestMetadata("forLoopMemberExtensionHasNext.kt")
        public void testForLoopMemberExtensionHasNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
        }

        @TestMetadata("forLoopMemberExtensionNext.kt")
        public void testForLoopMemberExtensionNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
        }

        @TestMetadata("forNullableCharInString.kt")
        public void testForNullableCharInString() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forNullableCharInString.kt");
        }

        @TestMetadata("forUserType.kt")
        public void testForUserType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forUserType.kt");
        }

        @TestMetadata("inRangeConditionsInWhen.kt")
        public void testInRangeConditionsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
        }

        @TestMetadata("kt12908.kt")
        public void testKt12908() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908.kt");
        }

        @TestMetadata("kt12908_2.kt")
        public void testKt12908_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
        }

        @TestMetadata("kt1441.kt")
        public void testKt1441() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1441.kt");
        }

        @TestMetadata("kt14839.kt")
        public void testKt14839() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt14839.kt");
        }

        @TestMetadata("kt15726.kt")
        public void testKt15726() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt15726.kt");
        }

        @TestMetadata("kt1688.kt")
        public void testKt1688() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1688.kt");
        }

        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17110.kt");
        }

        @TestMetadata("kt1742.kt")
        public void testKt1742() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1742.kt");
        }

        @TestMetadata("kt17590.kt")
        public void testKt17590() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590.kt");
        }

        @TestMetadata("kt17590_long.kt")
        public void testKt17590_long() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590_long.kt");
        }

        @TestMetadata("kt1899.kt")
        public void testKt1899() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1899.kt");
        }

        @TestMetadata("kt2147.kt")
        public void testKt2147() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2147.kt");
        }

        @TestMetadata("kt2259.kt")
        public void testKt2259() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2259.kt");
        }

        @TestMetadata("kt2291.kt")
        public void testKt2291() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2291.kt");
        }

        @TestMetadata("kt237.kt")
        public void testKt237() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt237.kt");
        }

        @TestMetadata("kt2416.kt")
        public void testKt2416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2416.kt");
        }

        @TestMetadata("kt2423.kt")
        public void testKt2423() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2423.kt");
        }

        @TestMetadata("kt2577.kt")
        public void testKt2577() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2577.kt");
        }

        @TestMetadata("kt2597.kt")
        public void testKt2597() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2597.kt");
        }

        @TestMetadata("kt299.kt")
        public void testKt299() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt299.kt");
        }

        @TestMetadata("kt3087.kt")
        public void testKt3087() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3087.kt");
        }

        @TestMetadata("kt3203_1.kt")
        public void testKt3203_1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
        }

        @TestMetadata("kt3203_2.kt")
        public void testKt3203_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
        }

        @TestMetadata("kt3273.kt")
        public void testKt3273() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3273.kt");
        }

        @TestMetadata("kt3280.kt")
        public void testKt3280() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3280.kt");
        }

        @TestMetadata("kt3574.kt")
        public void testKt3574() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3574.kt");
        }

        @TestMetadata("kt416.kt")
        public void testKt416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt416.kt");
        }

        @TestMetadata("kt513.kt")
        public void testKt513() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt513.kt");
        }

        @TestMetadata("kt628.kt")
        public void testKt628() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt628.kt");
        }

        @TestMetadata("kt769.kt")
        public void testKt769() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt769.kt");
        }

        @TestMetadata("kt772.kt")
        public void testKt772() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt772.kt");
        }

        @TestMetadata("kt773.kt")
        public void testKt773() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt773.kt");
        }

        @TestMetadata("kt8148.kt")
        public void testKt8148() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148.kt");
        }

        @TestMetadata("kt8148_break.kt")
        public void testKt8148_break() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
        }

        @TestMetadata("kt8148_continue.kt")
        public void testKt8148_continue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
        }

        @TestMetadata("kt870.kt")
        public void testKt870() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt870.kt");
        }

        @TestMetadata("kt9022Return.kt")
        public void testKt9022Return() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
        }

        @TestMetadata("kt9022Throw.kt")
        public void testKt9022Throw() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
        }

        @TestMetadata("kt910.kt")
        public void testKt910() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt910.kt");
        }

        @TestMetadata("kt958.kt")
        public void testKt958() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt958.kt");
        }

        @TestMetadata("longRange.kt")
        public void testLongRange() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/longRange.kt");
        }

        @TestMetadata("parameterWithNameForFunctionType.kt")
        public void testParameterWithNameForFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/parameterWithNameForFunctionType.kt");
        }

        @TestMetadata("quicksort.kt")
        public void testQuicksort() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/quicksort.kt");
        }

        @TestMetadata("tryCatchFinallyChain.kt")
        public void testTryCatchFinallyChain() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
        }

        @TestMetadata("tryFinallyGeneric.kt")
        public void testTryFinallyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinallyGeneric.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BreakContinueInExpressions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBreakContinueInExpressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("breakFromOuter.kt")
            public void testBreakFromOuter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
            }

            @TestMetadata("breakInDoWhile.kt")
            public void testBreakInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
            }

            @TestMetadata("breakInExpr.kt")
            public void testBreakInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
            }

            @TestMetadata("continueInDoWhile.kt")
            public void testContinueInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
            }

            @TestMetadata("continueInExpr.kt")
            public void testContinueInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
            }

            @TestMetadata("inlineWithStack.kt")
            public void testInlineWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
            }

            @TestMetadata("innerLoopWithStack.kt")
            public void testInnerLoopWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
            }

            @TestMetadata("kt14581.kt")
            public void testKt14581() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
            }

            @TestMetadata("kt16713.kt")
            public void testKt16713() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713.kt");
            }

            @TestMetadata("kt16713_2.kt")
            public void testKt16713_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713_2.kt");
            }

            @TestMetadata("kt17384.kt")
            public void testKt17384() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt17384.kt");
            }

            @TestMetadata("kt9022And.kt")
            public void testKt9022And() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
            }

            @TestMetadata("kt9022Or.kt")
            public void testKt9022Or() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
            }

            @TestMetadata("pathologicalDoWhile.kt")
            public void testPathologicalDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/pathologicalDoWhile.kt");
            }

            @TestMetadata("popSizes.kt")
            public void testPopSizes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
            }

            @TestMetadata("tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
            }

            @TestMetadata("tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
            }

            @TestMetadata("whileTrueBreak.kt")
            public void testWhileTrueBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArray")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArray extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArray() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArray"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInArraySpecializedToUntil.kt")
            public void testForInArraySpecializedToUntil() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArraySpecializedToUntil.kt");
            }

            @TestMetadata("forInArrayWithArrayPropertyUpdatedInLoopBody.kt")
            public void testForInArrayWithArrayPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody12.kt")
            public void testForInArrayWithArrayVarUpdatedInLoopBody12() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody12.kt");
            }

            @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody13.kt")
            public void testForInArrayWithArrayVarUpdatedInLoopBody13() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody13.kt");
            }

            @TestMetadata("forInDelegatedPropertyUpdatedInLoopBody.kt")
            public void testForInDelegatedPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDelegatedPropertyUpdatedInLoopBody.kt");
            }

            @TestMetadata("forInFieldUpdatedInLoopBody.kt")
            public void testForInFieldUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInFieldUpdatedInLoopBody.kt");
            }

            @TestMetadata("forIntArray.kt")
            public void testForIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forIntArray.kt");
            }

            @TestMetadata("forNullableIntArray.kt")
            public void testForNullableIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forNullableIntArray.kt");
            }

            @TestMetadata("forPrimitiveIntArray.kt")
            public void testForPrimitiveIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forPrimitiveIntArray.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArrayWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInArrayOfObjectArrayWithIndex.kt")
            public void testForInArrayOfObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfObjectArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayOfPrimArrayWithIndex.kt")
            public void testForInArrayOfPrimArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfPrimArrayWithIndex.kt");
            }

            @TestMetadata("forInArrayWithIndexContinuesAsUnmodified.kt")
            public void testForInArrayWithIndexContinuesAsUnmodified() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexContinuesAsUnmodified.kt");
            }

            @TestMetadata("forInArrrayWithIndexNoElementVar.kt")
            public void testForInArrrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInArrrayWithIndexNoIndexVar.kt")
            public void testForInArrrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInArrrayWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInArrrayWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrrayWithIndexWithExplicitlyTypedIndexVariable.kt");
            }

            @TestMetadata("forInByteArrayWithIndexWithSmartCast.kt")
            public void testForInByteArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInByteArrrayWithIndex.kt")
            public void testForInByteArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrrayWithIndex.kt");
            }

            @TestMetadata("forInEmptyArrrayWithIndex.kt")
            public void testForInEmptyArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInEmptyArrrayWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndex.kt")
            public void testForInGenericArrayOfIntsWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndex.kt");
            }

            @TestMetadata("forInGenericArrayOfIntsWithIndexWithSmartCast.kt")
            public void testForInGenericArrayOfIntsWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInGenericArrayWithIndex.kt")
            public void testForInGenericArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrayWithIndexWithSmartCast.kt")
            public void testForInIntArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInIntArrrayWithIndex.kt")
            public void testForInIntArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrrayWithIndex.kt");
            }

            @TestMetadata("forInObjectArrrayWithIndex.kt")
            public void testForInObjectArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInObjectArrrayWithIndex.kt");
            }

            @TestMetadata("forInShortArrayWithIndexWithSmartCast.kt")
            public void testForInShortArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndexWithSmartCast.kt");
            }

            @TestMetadata("forInShortArrrayWithIndex.kt")
            public void testForInShortArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrrayWithIndex.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInCharSequenceWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInCharSeqWithIndexStops.kt")
            public void testForInCharSeqWithIndexStops() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSeqWithIndexStops.kt");
            }

            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterableWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInListWithIndexThrowsCME.kt")
            public void testForInListWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexThrowsCME.kt");
            }

            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInSequenceWithIndex extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReturnsNothing extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInReturnsNothing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
            }

            @TestMetadata("inlineMethod.kt")
            public void testInlineMethod() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
            }

            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryCatchInExpressions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTryCatchInExpressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("catch.kt")
            public void testCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
            }

            @TestMetadata("complexChain.kt")
            public void testComplexChain() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
            }

            @TestMetadata("deadTryCatch.kt")
            public void testDeadTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
            }

            @TestMetadata("differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
            }

            @TestMetadata("expectException.kt")
            public void testExpectException() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
            }

            @TestMetadata("finally.kt")
            public void testFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
            }

            @TestMetadata("inlineTryCatch.kt")
            public void testInlineTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
            }

            @TestMetadata("inlineTryExpr.kt")
            public void testInlineTryExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
            }

            @TestMetadata("inlineTryFinally.kt")
            public void testInlineTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
            }

            @TestMetadata("kt17572.kt")
            public void testKt17572() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572.kt");
            }

            @TestMetadata("kt17572_2.kt")
            public void testKt17572_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2.kt");
            }

            @TestMetadata("kt17572_2_ext.kt")
            public void testKt17572_2_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2_ext.kt");
            }

            @TestMetadata("kt17572_ext.kt")
            public void testKt17572_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_ext.kt");
            }

            @TestMetadata("kt17572_nested.kt")
            public void testKt17572_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_nested.kt");
            }

            @TestMetadata("kt17573.kt")
            public void testKt17573() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573.kt");
            }

            @TestMetadata("kt17573_nested.kt")
            public void testKt17573_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573_nested.kt");
            }

            @TestMetadata("kt8608.kt")
            public void testKt8608() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
            }

            @TestMetadata("kt9644try.kt")
            public void testKt9644try() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
            }

            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
            }

            @TestMetadata("splitTry.kt")
            public void testSplitTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
            }

            @TestMetadata("splitTryCorner1.kt")
            public void testSplitTryCorner1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner1.kt");
            }

            @TestMetadata("splitTryCorner2.kt")
            public void testSplitTryCorner2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner2.kt");
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
            }

            @TestMetadata("tryAfterTry.kt")
            public void testTryAfterTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
            }

            @TestMetadata("tryAndBreak.kt")
            public void testTryAndBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
            }

            @TestMetadata("tryAndContinue.kt")
            public void testTryAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
            }

            @TestMetadata("tryCatchAfterWhileTrue.kt")
            public void testTryCatchAfterWhileTrue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryCatchAfterWhileTrue.kt");
            }

            @TestMetadata("tryInsideCatch.kt")
            public void testTryInsideCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
            }

            @TestMetadata("tryInsideTry.kt")
            public void testTryInsideTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
            }

            @TestMetadata("unmatchedInlineMarkers.kt")
            public void testUnmatchedInlineMarkers() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
            KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("32defaultParametersInSuspend.kt")
        public void test32defaultParametersInSuspend_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("32defaultParametersInSuspend.kt")
        public void test32defaultParametersInSuspend_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt", "kotlin.coroutines");
        }

        @TestMetadata("accessorForSuspend.kt")
        public void testAccessorForSuspend_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("accessorForSuspend.kt")
        public void testAccessorForSuspend_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt", "kotlin.coroutines");
        }

        public void testAllFilesPresentInCoroutines() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("asyncException.kt")
        public void testAsyncException_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/asyncException.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("asyncException.kt")
        public void testAsyncException_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/asyncException.kt", "kotlin.coroutines");
        }

        @TestMetadata("asyncIteratorNullMerge_1_2.kt")
        public void testAsyncIteratorNullMerge_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_2.kt");
        }

        @TestMetadata("asyncIteratorNullMerge_1_3.kt")
        public void testAsyncIteratorNullMerge_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_3.kt");
        }

        @TestMetadata("asyncIteratorToList_1_2.kt")
        public void testAsyncIteratorToList_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_2.kt");
        }

        @TestMetadata("asyncIteratorToList_1_3.kt")
        public void testAsyncIteratorToList_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_3.kt");
        }

        @TestMetadata("asyncIterator_1_2.kt")
        public void testAsyncIterator_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_2.kt");
        }

        @TestMetadata("asyncIterator_1_3.kt")
        public void testAsyncIterator_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_3.kt");
        }

        @TestMetadata("async.kt")
        public void testAsync_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/async.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("async.kt")
        public void testAsync_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/async.kt", "kotlin.coroutines");
        }

        @TestMetadata("await.kt")
        public void testAwait_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/await.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("await.kt")
        public void testAwait_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/await.kt", "kotlin.coroutines");
        }

        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt", "kotlin.coroutines");
        }

        @TestMetadata("beginWithException.kt")
        public void testBeginWithException_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/beginWithException.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("beginWithException.kt")
        public void testBeginWithException_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/beginWithException.kt", "kotlin.coroutines");
        }

        @TestMetadata("capturedVarInSuspendLambda.kt")
        public void testCapturedVarInSuspendLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("capturedVarInSuspendLambda.kt")
        public void testCapturedVarInSuspendLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("catchWithInlineInsideSuspend.kt")
        public void testCatchWithInlineInsideSuspend_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("catchWithInlineInsideSuspend.kt")
        public void testCatchWithInlineInsideSuspend_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt", "kotlin.coroutines");
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/coercionToUnit.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/coercionToUnit.kt", "kotlin.coroutines");
        }

        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("coroutineContextInInlinedLambda.kt")
        public void testCoroutineContextInInlinedLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("coroutineContextInInlinedLambda.kt")
        public void testCoroutineContextInInlinedLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("coroutineToString.kt")
        public void testCoroutineToString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineToString.kt");
        }

        @TestMetadata("coroutineToString_1_2.kt")
        public void testCoroutineToString_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineToString_1_2.kt");
        }

        @TestMetadata("createCoroutineSafe.kt")
        public void testCreateCoroutineSafe_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("createCoroutineSafe.kt")
        public void testCreateCoroutineSafe_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt", "kotlin.coroutines");
        }

        @TestMetadata("createCoroutinesOnManualInstances.kt")
        public void testCreateCoroutinesOnManualInstances() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances.kt");
        }

        @TestMetadata("createCoroutinesOnManualInstances_1_2.kt")
        public void testCreateCoroutinesOnManualInstances_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances_1_2.kt");
        }

        @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
        public void testCrossInlineWithCapturedOuterReceiver_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
        public void testCrossInlineWithCapturedOuterReceiver_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt", "kotlin.coroutines");
        }

        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt", "kotlin.coroutines");
        }

        @TestMetadata("delegatedSuspendMember.kt")
        public void testDelegatedSuspendMember_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("delegatedSuspendMember.kt")
        public void testDelegatedSuspendMember_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt", "kotlin.coroutines");
        }

        @TestMetadata("dispatchResume.kt")
        public void testDispatchResume_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/dispatchResume.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("dispatchResume.kt")
        public void testDispatchResume_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/dispatchResume.kt", "kotlin.coroutines");
        }

        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/emptyClosure.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/emptyClosure.kt", "kotlin.coroutines");
        }

        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt", "kotlin.coroutines");
        }

        @TestMetadata("generate.kt")
        public void testGenerate_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/generate.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("generate.kt")
        public void testGenerate_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/generate.kt", "kotlin.coroutines");
        }

        @TestMetadata("handleException.kt")
        public void testHandleException_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleException.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("handleException.kt")
        public void testHandleException_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleException.kt", "kotlin.coroutines");
        }

        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt", "kotlin.coroutines");
        }

        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt", "kotlin.coroutines");
        }

        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt", "kotlin.coroutines");
        }

        @TestMetadata("illegalState.kt")
        public void testIllegalState() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/illegalState.kt");
        }

        @TestMetadata("illegalState_1_2.kt")
        public void testIllegalState_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/illegalState_1_2.kt");
        }

        @TestMetadata("indirectInlineUsedAsNonInline.kt")
        public void testIndirectInlineUsedAsNonInline_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("indirectInlineUsedAsNonInline.kt")
        public void testIndirectInlineUsedAsNonInline_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt", "kotlin.coroutines");
        }

        @TestMetadata("inlineFunInGenericClass.kt")
        public void testInlineFunInGenericClass_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("inlineFunInGenericClass.kt")
        public void testInlineFunInGenericClass_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt", "kotlin.coroutines");
        }

        @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
        public void testInlineGenericFunCalledFromSubclass_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
        public void testInlineGenericFunCalledFromSubclass_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt", "kotlin.coroutines");
        }

        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt", "kotlin.coroutines");
        }

        @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
        public void testInlineSuspendLambdaNonLocalReturn_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
        public void testInlineSuspendLambdaNonLocalReturn_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt", "kotlin.coroutines");
        }

        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt", "kotlin.coroutines");
        }

        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt", "kotlin.coroutines");
        }

        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt", "kotlin.coroutines");
        }

        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/iterateOverArray.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/iterateOverArray.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt12958.kt")
        public void testKt12958_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt12958.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt12958.kt")
        public void testKt12958_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt12958.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt15016.kt")
        public void testKt15016_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15016.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt15016.kt")
        public void testKt15016_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15016.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt15017.kt")
        public void testKt15017_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15017.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt15017.kt")
        public void testKt15017_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15017.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt15930.kt")
        public void testKt15930_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15930.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt15930.kt")
        public void testKt15930_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt15930.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt21605.kt")
        public void testKt21605_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt21605.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt21605.kt")
        public void testKt21605_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt21605.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt25912.kt")
        public void testKt25912_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt25912.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt25912.kt")
        public void testKt25912_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt25912.kt", "kotlin.coroutines");
        }

        @TestMetadata("kt28844.kt")
        public void testKt28844_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt28844.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("kt28844.kt")
        public void testKt28844_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/kt28844.kt", "kotlin.coroutines");
        }

        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt", "kotlin.coroutines");
        }

        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastStatementInc.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastStatementInc.kt", "kotlin.coroutines");
        }

        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt", "kotlin.coroutines");
        }

        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt", "kotlin.coroutines");
        }

        @TestMetadata("localCallableRef.kt")
        public void testLocalCallableRef() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localCallableRef.kt");
        }

        @TestMetadata("localDelegate.kt")
        public void testLocalDelegate_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localDelegate.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("localDelegate.kt")
        public void testLocalDelegate_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localDelegate.kt", "kotlin.coroutines");
        }

        @TestMetadata("longRangeInSuspendCall.kt")
        public void testLongRangeInSuspendCall_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("longRangeInSuspendCall.kt")
        public void testLongRangeInSuspendCall_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt", "kotlin.coroutines");
        }

        @TestMetadata("longRangeInSuspendFun.kt")
        public void testLongRangeInSuspendFun_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("longRangeInSuspendFun.kt")
        public void testLongRangeInSuspendFun_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt", "kotlin.coroutines");
        }

        @TestMetadata("mergeNullAndString.kt")
        public void testMergeNullAndString_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("mergeNullAndString.kt")
        public void testMergeNullAndString_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt", "kotlin.coroutines");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt", "kotlin.coroutines");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt", "kotlin.coroutines");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt", "kotlin.coroutines");
        }

        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt", "kotlin.coroutines");
        }

        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt", "kotlin.coroutines");
        }

        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt", "kotlin.coroutines");
        }

        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt", "kotlin.coroutines");
        }

        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("overrideDefaultArgument.kt")
        public void testOverrideDefaultArgument_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("overrideDefaultArgument.kt")
        public void testOverrideDefaultArgument_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt", "kotlin.coroutines");
        }

        @TestMetadata("recursiveSuspend.kt")
        public void testRecursiveSuspend_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("recursiveSuspend.kt")
        public void testRecursiveSuspend_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt", "kotlin.coroutines");
        }

        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/returnByLabel.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/returnByLabel.kt", "kotlin.coroutines");
        }

        @TestMetadata("simpleException.kt")
        public void testSimpleException_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simpleException.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("simpleException.kt")
        public void testSimpleException_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simpleException.kt", "kotlin.coroutines");
        }

        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt", "kotlin.coroutines");
        }

        @TestMetadata("simple.kt")
        public void testSimple_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simple.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("simple.kt")
        public void testSimple_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/simple.kt", "kotlin.coroutines");
        }

        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendCallsInArguments.kt")
        public void testSuspendCallsInArguments_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendCallsInArguments.kt")
        public void testSuspendCallsInArguments_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendCoroutineFromStateMachine.kt")
        public void testSuspendCoroutineFromStateMachine_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendCoroutineFromStateMachine.kt")
        public void testSuspendCoroutineFromStateMachine_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendCovariantJavaOverrides.kt")
        public void testSuspendCovariantJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCovariantJavaOverrides.kt");
        }

        @TestMetadata("suspendCovariantJavaOverrides_1_2.kt")
        public void testSuspendCovariantJavaOverrides_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCovariantJavaOverrides_1_2.kt");
        }

        @TestMetadata("suspendDefaultImpl.kt")
        public void testSuspendDefaultImpl_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendDefaultImpl.kt")
        public void testSuspendDefaultImpl_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendDelegation.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendDelegation.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendFunImportedFromObject.kt")
        public void testSuspendFunImportedFromObject_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendFunImportedFromObject.kt")
        public void testSuspendFunImportedFromObject_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInCycle.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInCycle.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
        public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
        public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
        public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
        public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspendJavaOverrides.kt")
        public void testSuspendJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendJavaOverrides.kt");
        }

        @TestMetadata("suspendJavaOverrides_1_2.kt")
        public void testSuspendJavaOverrides_1_2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendJavaOverrides_1_2.kt");
        }

        @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
        public void testSuspensionInsideSafeCallWithElvis_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
        public void testSuspensionInsideSafeCallWithElvis_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt", "kotlin.coroutines");
        }

        @TestMetadata("suspensionInsideSafeCall.kt")
        public void testSuspensionInsideSafeCall_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("suspensionInsideSafeCall.kt")
        public void testSuspensionInsideSafeCall_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt", "kotlin.coroutines");
        }

        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt", "kotlin.coroutines");
        }

        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt", "kotlin.coroutines");
        }

        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt", "kotlin.coroutines");
        }

        @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
        public void testVarCaptuedInCoroutineIntrinsic_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
        public void testVarCaptuedInCoroutineIntrinsic_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt", "kotlin.coroutines");
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt", "kotlin.coroutines");
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt", "kotlin.coroutines");
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/bridges")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bridges extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBridges() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/bridges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("lambdaWithLongReceiver.kt")
            public void testLambdaWithLongReceiver_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("lambdaWithLongReceiver.kt")
            public void testLambdaWithLongReceiver_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt", "kotlin.coroutines");
            }

            @TestMetadata("lambdaWithMultipleParameters.kt")
            public void testLambdaWithMultipleParameters_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("lambdaWithMultipleParameters.kt")
            public void testLambdaWithMultipleParameters_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlow extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInControlFlow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("breakFinally.kt")
            public void testBreakFinally_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("breakFinally.kt")
            public void testBreakFinally_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt", "kotlin.coroutines");
            }

            @TestMetadata("breakStatement.kt")
            public void testBreakStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("breakStatement.kt")
            public void testBreakStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("complexChainSuspend.kt")
            public void testComplexChainSuspend_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("complexChainSuspend.kt")
            public void testComplexChainSuspend_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt", "kotlin.coroutines");
            }

            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("finallyCatch.kt")
            public void testFinallyCatch_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("finallyCatch.kt")
            public void testFinallyCatch_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt", "kotlin.coroutines");
            }

            @TestMetadata("forContinue.kt")
            public void testForContinue_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("forContinue.kt")
            public void testForContinue_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt", "kotlin.coroutines");
            }

            @TestMetadata("forStatement.kt")
            public void testForStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("forStatement.kt")
            public void testForStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("forWithStep.kt")
            public void testForWithStep_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("forWithStep.kt")
            public void testForWithStep_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt", "kotlin.coroutines");
            }

            @TestMetadata("ifStatement.kt")
            public void testIfStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("ifStatement.kt")
            public void testIfStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("kt22694_1_2.kt")
            public void testKt22694_1_2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_2.kt");
            }

            @TestMetadata("kt22694_1_3.kt")
            public void testKt22694_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_3.kt");
            }

            @TestMetadata("labeledWhile.kt")
            public void testLabeledWhile_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("labeledWhile.kt")
            public void testLabeledWhile_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt", "kotlin.coroutines");
            }

            @TestMetadata("multipleCatchBlocksSuspend.kt")
            public void testMultipleCatchBlocksSuspend_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("multipleCatchBlocksSuspend.kt")
            public void testMultipleCatchBlocksSuspend_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt", "kotlin.coroutines");
            }

            @TestMetadata("returnFromFinally.kt")
            public void testReturnFromFinally_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("returnFromFinally.kt")
            public void testReturnFromFinally_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt", "kotlin.coroutines");
            }

            @TestMetadata("returnWithFinally.kt")
            public void testReturnWithFinally_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("returnWithFinally.kt")
            public void testReturnWithFinally_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt", "kotlin.coroutines");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt", "kotlin.coroutines");
            }

            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt", "kotlin.coroutines");
            }

            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt", "kotlin.coroutines");
            }

            @TestMetadata("whenWithSuspensions.kt")
            public void testWhenWithSuspensions_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("whenWithSuspensions.kt")
            public void testWhenWithSuspensions_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt", "kotlin.coroutines");
            }

            @TestMetadata("whileStatement.kt")
            public void testWhileStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("whileStatement.kt")
            public void testWhileStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Debug extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDebug() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("debuggerMetadata.kt")
            public void testDebuggerMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/debuggerMetadata.kt");
            }

            @TestMetadata("firstSuspensionPoint.kt")
            public void testFirstSuspensionPoint() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/firstSuspensionPoint.kt");
            }

            @TestMetadata("fqName.kt")
            public void testFqName() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/fqName.kt");
            }

            @TestMetadata("runtimeDebugMetadata.kt")
            public void testRuntimeDebugMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/runtimeDebugMetadata.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FeatureIntersection extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFeatureIntersection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("breakWithNonEmptyStack.kt")
            public void testBreakWithNonEmptyStack_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("breakWithNonEmptyStack.kt")
            public void testBreakWithNonEmptyStack_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt", "kotlin.coroutines");
            }

            @TestMetadata("delegate.kt")
            public void testDelegate_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("delegate.kt")
            public void testDelegate_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt", "kotlin.coroutines");
            }

            @TestMetadata("destructuringInLambdas.kt")
            public void testDestructuringInLambdas_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("destructuringInLambdas.kt")
            public void testDestructuringInLambdas_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt", "kotlin.coroutines");
            }

            @TestMetadata("safeCallOnTwoReceiversLong.kt")
            public void testSafeCallOnTwoReceiversLong_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("safeCallOnTwoReceiversLong.kt")
            public void testSafeCallOnTwoReceiversLong_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt", "kotlin.coroutines");
            }

            @TestMetadata("safeCallOnTwoReceivers.kt")
            public void testSafeCallOnTwoReceivers_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("safeCallOnTwoReceivers.kt")
            public void testSafeCallOnTwoReceivers_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendDestructuringInLambdas.kt")
            public void testSuspendDestructuringInLambdas_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendDestructuringInLambdas.kt")
            public void testSuspendDestructuringInLambdas_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendFunction12.kt")
            public void testSuspendFunction12() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunction12.kt");
            }

            @TestMetadata("suspendFunctionIsAs.kt")
            public void testSuspendFunctionIsAs() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionIsAs.kt");
            }

            @TestMetadata("suspendOperatorPlusAssign.kt")
            public void testSuspendOperatorPlusAssign_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendOperatorPlusAssign.kt")
            public void testSuspendOperatorPlusAssign_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
            public void testSuspendOperatorPlusCallFromLambda_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
            public void testSuspendOperatorPlusCallFromLambda_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendOperatorPlus.kt")
            public void testSuspendOperatorPlus_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendOperatorPlus.kt")
            public void testSuspendOperatorPlus_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt", "kotlin.coroutines");
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReference extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("bigArity.kt")
                public void testBigArity() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bigArity.kt");
                }

                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/fromJava.kt");
                }

                @TestMetadata("longArgs.kt")
                public void testLongArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/longArgs.kt");
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Bound extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInBound() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("emptyLHS.kt")
                    public void testEmptyLHS() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound/emptyLHS.kt");
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Function extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInFunction() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("genericCallableReferenceArguments.kt")
                    public void testGenericCallableReferenceArguments() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferenceArguments.kt");
                    }

                    @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
                    public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
                    }

                    @TestMetadata("getArityViaFunctionImpl.kt")
                    public void testGetArityViaFunctionImpl() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/getArityViaFunctionImpl.kt");
                    }

                    @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Local extends AbstractLightAnalysisModeTest {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                        }

                        public void testAllFilesPresentInLocal() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                        }

                        @TestMetadata("equalsHashCode.kt")
                        public void testEqualsHashCode() throws Exception {
                            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local/equalsHashCode.kt");
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Tailrec extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                    KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInTailrec() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("controlFlowIf.kt")
                public void testControlFlowIf_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("controlFlowIf.kt")
                public void testControlFlowIf_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt", "kotlin.coroutines");
                }

                @TestMetadata("controlFlowWhen.kt")
                public void testControlFlowWhen_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("controlFlowWhen.kt")
                public void testControlFlowWhen_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt", "kotlin.coroutines");
                }

                @TestMetadata("extention.kt")
                public void testExtention_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("extention.kt")
                public void testExtention_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt", "kotlin.coroutines");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt", "kotlin.coroutines");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt", "kotlin.coroutines");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt", "kotlin.coroutines");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt", "kotlin.coroutines");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt", "kotlin.coroutines");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt", "kotlin.coroutines");
                }

                @TestMetadata("sum.kt")
                public void testSum_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("sum.kt")
                public void testSum_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt", "kotlin.coroutines");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt", "kotlin.coroutines");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt", "kotlin.coroutines");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt", "kotlin.coroutines");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineClasses extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInlineClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("bridgeGenerationCrossinline.kt")
            public void testBridgeGenerationCrossinline_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineClasses/bridgeGenerationCrossinline.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("bridgeGenerationCrossinline.kt")
            public void testBridgeGenerationCrossinline_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineClasses/bridgeGenerationCrossinline.kt", "kotlin.coroutines");
            }

            @TestMetadata("bridgeGenerationNonInline.kt")
            public void testBridgeGenerationNonInline_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineClasses/bridgeGenerationNonInline.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("bridgeGenerationNonInline.kt")
            public void testBridgeGenerationNonInline_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/inlineClasses/bridgeGenerationNonInline.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt", "kotlin.coroutines");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt", "kotlin.coroutines");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt", "kotlin.coroutines");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt", "kotlin.coroutines");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt", "kotlin.coroutines");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intrinsicSemantics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntrinsicSemantics extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInIntrinsicSemantics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intrinsicSemantics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
            public void testCoroutineContextReceiverNotIntrinsic_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
            public void testCoroutineContextReceiverNotIntrinsic_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt", "kotlin.coroutines");
            }

            @TestMetadata("coroutineContextReceiver.kt")
            public void testCoroutineContextReceiver_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("coroutineContextReceiver.kt")
            public void testCoroutineContextReceiver_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt", "kotlin.coroutines");
            }

            @TestMetadata("coroutineContext.kt")
            public void testCoroutineContext_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("coroutineContext.kt")
            public void testCoroutineContext_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt", "kotlin.coroutines");
            }

            @TestMetadata("intercepted.kt")
            public void testIntercepted_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("intercepted.kt")
            public void testIntercepted_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt", "kotlin.coroutines");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
            public void testStartCoroutineUninterceptedOrReturnInterception_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
            public void testStartCoroutineUninterceptedOrReturnInterception_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt", "kotlin.coroutines");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
            public void testStartCoroutineUninterceptedOrReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
            public void testStartCoroutineUninterceptedOrReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt", "kotlin.coroutines");
            }

            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
            public void testSuspendCoroutineUninterceptedOrReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
            public void testSuspendCoroutineUninterceptedOrReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaInterop extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaInterop() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/javaInterop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("objectWithSeveralSuspends.kt")
            public void testObjectWithSeveralSuspends_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/objectWithSeveralSuspends.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("objectWithSeveralSuspends.kt")
            public void testObjectWithSeveralSuspends_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/objectWithSeveralSuspends.kt", "kotlin.coroutines");
            }

            @TestMetadata("returnLambda.kt")
            public void testReturnLambda_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/returnLambda.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("returnLambda.kt")
            public void testReturnLambda_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/returnLambda.kt", "kotlin.coroutines");
            }

            @TestMetadata("returnObject.kt")
            public void testReturnObject_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/returnObject.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("returnObject.kt")
            public void testReturnObject_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/returnObject.kt", "kotlin.coroutines");
            }

            @TestMetadata("severalCaptures.kt")
            public void testSeveralCaptures_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/severalCaptures.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("severalCaptures.kt")
            public void testSeveralCaptures_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/javaInterop/severalCaptures.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/anonymous")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Anonymous extends AbstractLightAnalysisModeTest {
                @TestMetadata("simple.kt")
                public void ignoreSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/anonymous/simple.kt");
                }

                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInAnonymous() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/anonymous"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/named")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Named extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                    KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInNamed() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/named"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("capturedParameters.kt")
                public void testCapturedParameters_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("capturedParameters.kt")
                public void testCapturedParameters_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt", "kotlin.coroutines");
                }

                @TestMetadata("capturedVariables.kt")
                public void testCapturedVariables_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("capturedVariables.kt")
                public void testCapturedVariables_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt", "kotlin.coroutines");
                }

                @TestMetadata("extension.kt")
                public void testExtension_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("extension.kt")
                public void testExtension_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt", "kotlin.coroutines");
                }

                @TestMetadata("infix.kt")
                public void testInfix_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("infix.kt")
                public void testInfix_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt", "kotlin.coroutines");
                }

                @TestMetadata("insideLambda.kt")
                public void testInsideLambda_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("insideLambda.kt")
                public void testInsideLambda_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt", "kotlin.coroutines");
                }

                @TestMetadata("nestedLocals.kt")
                public void testNestedLocals_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("nestedLocals.kt")
                public void testNestedLocals_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt", "kotlin.coroutines");
                }

                @TestMetadata("rec.kt")
                public void testRec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/rec.kt");
                }

                @TestMetadata("simpleSuspensionPoint.kt")
                public void testSimpleSuspensionPoint_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("simpleSuspensionPoint.kt")
                public void testSimpleSuspensionPoint_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt", "kotlin.coroutines");
                }

                @TestMetadata("simple.kt")
                public void testSimple_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("simple.kt")
                public void testSimple_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt", "kotlin.coroutines");
                }

                @TestMetadata("stateMachine.kt")
                public void testStateMachine_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("stateMachine.kt")
                public void testStateMachine_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt", "kotlin.coroutines");
                }

                @TestMetadata("withArguments.kt")
                public void testWithArguments_1_2() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt", "kotlin.coroutines.experimental");
                }

                @TestMetadata("withArguments.kt")
                public void testWithArguments_1_3() throws Exception {
                    runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt", "kotlin.coroutines");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiModule extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInMultiModule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("inlineCrossModule.kt")
            public void testInlineCrossModule_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineCrossModule.kt")
            public void testInlineCrossModule_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineFunctionWithOptionalParam.kt")
            public void testInlineFunctionWithOptionalParam_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineFunctionWithOptionalParam.kt")
            public void testInlineFunctionWithOptionalParam_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineMultiModuleOverride.kt")
            public void testInlineMultiModuleOverride_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineMultiModuleOverride.kt")
            public void testInlineMultiModuleOverride_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineMultiModuleWithController.kt")
            public void testInlineMultiModuleWithController_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineMultiModuleWithController.kt")
            public void testInlineMultiModuleWithController_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
            public void testInlineMultiModuleWithInnerInlining_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
            public void testInlineMultiModuleWithInnerInlining_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineMultiModule.kt")
            public void testInlineMultiModule_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineMultiModule.kt")
            public void testInlineMultiModule_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineTailCall.kt")
            public void testInlineTailCall_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineTailCall.kt")
            public void testInlineTailCall_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineWithJava.kt")
            public void testInlineWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineWithJava.kt");
            }

            @TestMetadata("inlineWithJava_1_2.kt")
            public void testInlineWithJava_1_2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineWithJava_1_2.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/simple.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/multiModule/simple.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/noStdLib")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NoStdLib extends AbstractLightAnalysisModeTest {
            @TestMetadata("breakFinally.kt")
            public void ignoreBreakFinally_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/breakFinally.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("breakFinally.kt")
            public void ignoreBreakFinally_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/breakFinally.kt", "kotlin.coroutines");
            }

            @TestMetadata("breakStatement.kt")
            public void ignoreBreakStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/breakStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("breakStatement.kt")
            public void ignoreBreakStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/breakStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("crossinline.kt")
            public void ignoreCrossinline_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/crossinline.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("crossinline.kt")
            public void ignoreCrossinline_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/crossinline.kt", "kotlin.coroutines");
            }

            @TestMetadata("ifStatement.kt")
            public void ignoreIfStatement_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/ifStatement.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("ifStatement.kt")
            public void ignoreIfStatement_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/ifStatement.kt", "kotlin.coroutines");
            }

            @TestMetadata("stateMachine.kt")
            public void ignoreStateMachine_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/stateMachine.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("stateMachine.kt")
            public void ignoreStateMachine_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/stateMachine.kt", "kotlin.coroutines");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void ignoreSwitchLikeWhen_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/switchLikeWhen.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("switchLikeWhen.kt")
            public void ignoreSwitchLikeWhen_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/noStdLib/switchLikeWhen.kt", "kotlin.coroutines");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNoStdLib() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/noStdLib"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/redundantLocalsElimination")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RedundantLocalsElimination extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInRedundantLocalsElimination() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/redundantLocalsElimination"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("ktor_receivedMessage.kt")
            public void testKtor_receivedMessage_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("ktor_receivedMessage.kt")
            public void testKtor_receivedMessage_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/reflect")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reflect extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInReflect() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/reflect"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callSuspend.kt")
            public void testCallSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspend.kt");
            }

            @TestMetadata("callSuspendBy.kt")
            public void testCallSuspendBy() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspendBy.kt");
            }

            @TestMetadata("isSuspend12.kt")
            public void testIsSuspend12() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/isSuspend12.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/stackUnwinding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StackUnwinding extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInStackUnwinding() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/stackUnwinding"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("exception.kt")
            public void testException_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("exception.kt")
            public void testException_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineSuspendFunction.kt")
            public void testInlineSuspendFunction_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineSuspendFunction.kt")
            public void testInlineSuspendFunction_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt", "kotlin.coroutines");
            }

            @TestMetadata("rethrowInFinallyWithSuspension.kt")
            public void testRethrowInFinallyWithSuspension_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("rethrowInFinallyWithSuspension.kt")
            public void testRethrowInFinallyWithSuspension_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt", "kotlin.coroutines");
            }

            @TestMetadata("rethrowInFinally.kt")
            public void testRethrowInFinally_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("rethrowInFinally.kt")
            public void testRethrowInFinally_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt", "kotlin.coroutines");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendInCycle.kt")
            public void testSuspendInCycle_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendInCycle.kt")
            public void testSuspendInCycle_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionAsCoroutine extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionAsCoroutine() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("dispatchResume.kt")
            public void testDispatchResume_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("dispatchResume.kt")
            public void testDispatchResume_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt", "kotlin.coroutines");
            }

            @TestMetadata("handleException.kt")
            public void testHandleException_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("handleException.kt")
            public void testHandleException_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt", "kotlin.coroutines");
            }

            @TestMetadata("ifExpressionInsideCoroutine_1_2.kt")
            public void testIfExpressionInsideCoroutine_1_2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_2.kt");
            }

            @TestMetadata("ifExpressionInsideCoroutine_1_3.kt")
            public void testIfExpressionInsideCoroutine_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_3.kt");
            }

            @TestMetadata("inlineTwoReceivers.kt")
            public void testInlineTwoReceivers_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineTwoReceivers.kt")
            public void testInlineTwoReceivers_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt", "kotlin.coroutines");
            }

            @TestMetadata("inline.kt")
            public void testInline_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inline.kt")
            public void testInline_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt", "kotlin.coroutines");
            }

            @TestMetadata("member.kt")
            public void testMember_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("member.kt")
            public void testMember_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt", "kotlin.coroutines");
            }

            @TestMetadata("noinlineTwoReceivers.kt")
            public void testNoinlineTwoReceivers_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("noinlineTwoReceivers.kt")
            public void testNoinlineTwoReceivers_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt", "kotlin.coroutines");
            }

            @TestMetadata("openFunWithJava.kt")
            public void testOpenFunWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/openFunWithJava.kt");
            }

            @TestMetadata("openFunWithJava_1_2.kt")
            public void testOpenFunWithJava_1_2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/openFunWithJava_1_2.kt");
            }

            @TestMetadata("operators.kt")
            public void testOperators_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("operators.kt")
            public void testOperators_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt", "kotlin.coroutines");
            }

            @TestMetadata("privateFunctions.kt")
            public void testPrivateFunctions_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("privateFunctions.kt")
            public void testPrivateFunctions_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt", "kotlin.coroutines");
            }

            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt", "kotlin.coroutines");
            }

            @TestMetadata("returnNoSuspend.kt")
            public void testReturnNoSuspend_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("returnNoSuspend.kt")
            public void testReturnNoSuspend_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt", "kotlin.coroutines");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt", "kotlin.coroutines");
            }

            @TestMetadata("superCallAbstractClass.kt")
            public void testSuperCallAbstractClass_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("superCallAbstractClass.kt")
            public void testSuperCallAbstractClass_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt", "kotlin.coroutines");
            }

            @TestMetadata("superCallInterface.kt")
            public void testSuperCallInterface_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("superCallInterface.kt")
            public void testSuperCallInterface_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt", "kotlin.coroutines");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt", "kotlin.coroutines");
            }

            @TestMetadata("withVariables.kt")
            public void testWithVariables_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("withVariables.kt")
            public void testWithVariables_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuspendFunctionTypeCall extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuspendFunctionTypeCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt", "kotlin.coroutines");
            }

            @TestMetadata("manyParameters.kt")
            public void testManyParameters_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("manyParameters.kt")
            public void testManyParameters_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt", "kotlin.coroutines");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendModifier.kt")
            public void testSuspendModifier_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendModifier.kt")
            public void testSuspendModifier_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailCallOptimizations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTailCallOptimizations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("also.kt")
            public void testAlso_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/also.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("also.kt")
            public void testAlso_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/also.kt", "kotlin.coroutines");
            }

            @TestMetadata("crossinline.kt")
            public void testCrossinline_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("crossinline.kt")
            public void testCrossinline_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt", "kotlin.coroutines");
            }

            @TestMetadata("epam.kt")
            public void testEpam_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/epam.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("epam.kt")
            public void testEpam_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/epam.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineWithStateMachine.kt")
            public void testInlineWithStateMachine_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithStateMachine.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineWithStateMachine.kt")
            public void testInlineWithStateMachine_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithStateMachine.kt", "kotlin.coroutines");
            }

            @TestMetadata("inlineWithoutStateMachine.kt")
            public void testInlineWithoutStateMachine_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("inlineWithoutStateMachine.kt")
            public void testInlineWithoutStateMachine_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt", "kotlin.coroutines");
            }

            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt", "kotlin.coroutines");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/simple.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("simple.kt")
            public void testSimple_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/simple.kt", "kotlin.coroutines");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt", "kotlin.coroutines");
            }

            @TestMetadata("unreachable.kt")
            public void testUnreachable_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unreachable.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("unreachable.kt")
            public void testUnreachable_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unreachable.kt", "kotlin.coroutines");
            }

            @TestMetadata("whenUnit.kt")
            public void testWhenUnit_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/whenUnit.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("whenUnit.kt")
            public void testWhenUnit_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailCallOptimizations/whenUnit.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/tailOperations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TailOperations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInTailOperations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailOperations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("suspendWithIf.kt")
            public void testSuspendWithIf_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendWithIf.kt")
            public void testSuspendWithIf_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendWithTryCatch.kt")
            public void testSuspendWithTryCatch_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendWithTryCatch.kt")
            public void testSuspendWithTryCatch_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendWithWhen.kt")
            public void testSuspendWithWhen_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendWithWhen.kt")
            public void testSuspendWithWhen_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt", "kotlin.coroutines");
            }

            @TestMetadata("tailInlining.kt")
            public void testTailInlining_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("tailInlining.kt")
            public void testTailInlining_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/unitTypeReturn")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnitTypeReturn extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInUnitTypeReturn() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/unitTypeReturn"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("coroutineNonLocalReturn.kt")
            public void testCoroutineNonLocalReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("coroutineNonLocalReturn.kt")
            public void testCoroutineNonLocalReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt", "kotlin.coroutines");
            }

            @TestMetadata("coroutineReturn.kt")
            public void testCoroutineReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("coroutineReturn.kt")
            public void testCoroutineReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendNonLocalReturn.kt")
            public void testSuspendNonLocalReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendNonLocalReturn.kt")
            public void testSuspendNonLocalReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt", "kotlin.coroutines");
            }

            @TestMetadata("suspendReturn.kt")
            public void testSuspendReturn_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("suspendReturn.kt")
            public void testSuspendReturn_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt", "kotlin.coroutines");
            }

            @TestMetadata("unitSafeCall.kt")
            public void testUnitSafeCall_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("unitSafeCall.kt")
            public void testUnitSafeCall_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VarSpilling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInVarSpilling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt19475.kt")
            public void testKt19475_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("kt19475.kt")
            public void testKt19475_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt", "kotlin.coroutines");
            }

            @TestMetadata("nullSpilling.kt")
            public void testNullSpilling_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("nullSpilling.kt")
            public void testNullSpilling_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt", "kotlin.coroutines");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DataClasses extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDataClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayParams.kt")
        public void testArrayParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
        }

        @TestMetadata("changingVarParam.kt")
        public void testChangingVarParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
        }

        @TestMetadata("doubleParam.kt")
        public void testDoubleParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
        }

        @TestMetadata("floatParam.kt")
        public void testFloatParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/floatParam.kt");
        }

        @TestMetadata("genericParam.kt")
        public void testGenericParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/genericParam.kt");
        }

        @TestMetadata("kt5002.kt")
        public void testKt5002() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt5002.kt");
        }

        @TestMetadata("mixedParams.kt")
        public void testMixedParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
        }

        @TestMetadata("multiDeclarationFor.kt")
        public void testMultiDeclarationFor() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
        }

        @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
        public void testNonTrivialFinalMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
        }

        @TestMetadata("nonTrivialMemberInSuperClass.kt")
        public void testNonTrivialMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
        }

        @TestMetadata("privateValParams.kt")
        public void testPrivateValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
        }

        @TestMetadata("twoValParams.kt")
        public void testTwoValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
        }

        @TestMetadata("twoVarParams.kt")
        public void testTwoVarParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
        }

        @TestMetadata("typeParameterWithNonTrivialBound.kt")
        public void testTypeParameterWithNonTrivialBound() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/typeParameterWithNonTrivialBound.kt");
        }

        @TestMetadata("unitComponent.kt")
        public void testUnitComponent() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Copy extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCopy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultParam.kt")
            public void testConstructorWithDefaultParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
            }

            @TestMetadata("copyInObjectNestedDataClass.kt")
            public void testCopyInObjectNestedDataClass() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
            }

            @TestMetadata("kt12708.kt")
            public void testKt12708() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
            }

            @TestMetadata("kt3033.kt")
            public void testKt3033() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
            }

            @TestMetadata("valInConstructorParams.kt")
            public void testValInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
            }

            @TestMetadata("varInConstructorParams.kt")
            public void testVarInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
            }

            @TestMetadata("withGenericParameter.kt")
            public void testWithGenericParameter() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
            }

            @TestMetadata("withSecondaryConstructor.kt")
            public void testWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withSecondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equals extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEquals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("genericarray.kt")
            public void testGenericarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
            }

            @TestMetadata("intarray.kt")
            public void testIntarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/null.kt");
            }

            @TestMetadata("nullother.kt")
            public void testNullother() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
            }

            @TestMetadata("sameinstance.kt")
            public void testSameinstance() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HashCode extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInHashCode() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/array.kt");
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
            }

            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
            }

            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
            }

            @TestMetadata("genericNull.kt")
            public void testGenericNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToString extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInToString() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclaredWrongSignature.kt");
            }

            @TestMetadata("arrayParams.kt")
            public void testArrayParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
            }

            @TestMetadata("changingVarParam.kt")
            public void testChangingVarParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
            }

            @TestMetadata("genericParam.kt")
            public void testGenericParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
            }

            @TestMetadata("mixedParams.kt")
            public void testMixedParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
            }

            @TestMetadata("unitComponent.kt")
            public void testUnitComponent() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRange.kt")
        public void testIntersectingVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
        }

        @TestMetadata("intersectingVariableRangeInFinally.kt")
        public void testIntersectingVariableRangeInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractLightAnalysisModeTest {
        @TestMetadata("implementedByFake.kt")
        public void ignoreImplementedByFake() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake.kt");
        }

        @TestMetadata("implementedByFake2.kt")
        public void ignoreImplementedByFake2() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake2.kt");
        }

        @TestMetadata("implementedByFake3.kt")
        public void ignoreImplementedByFake3() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake3.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("callDefaultFromInitializer.kt")
        public void testCallDefaultFromInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/callDefaultFromInitializer.kt");
        }

        @TestMetadata("inheritedFromInterfaceViaAbstractSuperclass.kt")
        public void testInheritedFromInterfaceViaAbstractSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/inheritedFromInterfaceViaAbstractSuperclass.kt");
        }

        @TestMetadata("kt6382.kt")
        public void testKt6382() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/protected.kt");
        }

        @TestMetadata("simpleFromOtherFile.kt")
        public void testSimpleFromOtherFile() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
        }

        @TestMetadata("superCallCheck.kt")
        public void testSuperCallCheck() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/superCallCheck.kt");
        }

        @TestMetadata("useThisInLambda.kt")
        public void testUseThisInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useThisInLambda.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotation.kt")
            public void testAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
            }

            @TestMetadata("annotationWithEmptyArray.kt")
            public void testAnnotationWithEmptyArray() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotationWithEmptyArray.kt");
            }

            @TestMetadata("checkIfConstructorIsSynthetic.kt")
            public void testCheckIfConstructorIsSynthetic() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/checkIfConstructorIsSynthetic.kt");
            }

            @TestMetadata("defArgs1.kt")
            public void testDefArgs1() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
            }

            @TestMetadata("defArgs1InnerClass.kt")
            public void testDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
            }

            @TestMetadata("defArgs2.kt")
            public void testDefArgs2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
            }

            @TestMetadata("doubleDefArgs1InnerClass.kt")
            public void testDoubleDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
            }

            @TestMetadata("enumWithOneDefArg.kt")
            public void testEnumWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
            }

            @TestMetadata("enumWithTwoDefArgs.kt")
            public void testEnumWithTwoDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
            }

            @TestMetadata("enumWithTwoDoubleDefArgs.kt")
            public void testEnumWithTwoDoubleDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
            }

            @TestMetadata("kt2852.kt")
            public void testKt2852() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
            }

            @TestMetadata("kt3060.kt")
            public void testKt3060() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
            }

            @TestMetadata("manyArgs.kt")
            public void testManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/manyArgs.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Convention extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConvention() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("incWithDefaultInGetter.kt")
            public void testIncWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
            }

            @TestMetadata("kt9140.kt")
            public void testKt9140() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
            }

            @TestMetadata("plusAssignWithDefaultInGetter.kt")
            public void testPlusAssignWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractLightAnalysisModeTest {
            @TestMetadata("funInTraitChain.kt")
            public void ignoreFunInTraitChain() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTraitChain.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("abstractClass.kt")
            public void testAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("complexInheritance.kt")
            public void testComplexInheritance() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/complexInheritance.kt");
            }

            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
            }

            @TestMetadata("covariantOverrideGeneric.kt")
            public void testCovariantOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
            }

            @TestMetadata("extensionFunctionManyArgs.kt")
            public void testExtensionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
            }

            @TestMetadata("extentionFunction.kt")
            public void testExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
            }

            @TestMetadata("extentionFunctionDouble.kt")
            public void testExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
            }

            @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
            public void testExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("extentionFunctionInClassObject.kt")
            public void testExtentionFunctionInClassObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
            }

            @TestMetadata("extentionFunctionInObject.kt")
            public void testExtentionFunctionInObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
            }

            @TestMetadata("extentionFunctionWithOneDefArg.kt")
            public void testExtentionFunctionWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
            }

            @TestMetadata("funInTrait.kt")
            public void testFunInTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
            }

            @TestMetadata("innerExtentionFunction.kt")
            public void testInnerExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
            }

            @TestMetadata("innerExtentionFunctionDouble.kt")
            public void testInnerExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
            }

            @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
            public void testInnerExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
            }

            @TestMetadata("innerExtentionFunctionManyArgs.kt")
            public void testInnerExtentionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
            }

            @TestMetadata("memberFunctionManyArgs.kt")
            public void testMemberFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
            }

            @TestMetadata("mixingNamedAndPositioned.kt")
            public void testMixingNamedAndPositioned() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
            }

            @TestMetadata("topLevelManyArgs.kt")
            public void testTopLevelManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInPrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("memberExtensionFunction.kt")
            public void testMemberExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
            }

            @TestMetadata("memberFunction.kt")
            public void testMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Signature extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt2789.kt")
            public void testKt2789() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
            }

            @TestMetadata("kt9428.kt")
            public void testKt9428() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
            }

            @TestMetadata("kt9924.kt")
            public void testKt9924() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractLightAnalysisModeTest {
        @TestMetadata("genericDelegateUncheckedCast2.kt")
        public void ignoreGenericDelegateUncheckedCast2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast2.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
        public void testAccessTopLevelDelegatedPropertyInClinit() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("capturePropertyInClosure.kt")
        public void testCapturePropertyInClosure() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
        }

        @TestMetadata("castGetReturnType.kt")
        public void testCastGetReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
        }

        @TestMetadata("castSetParameter.kt")
        public void testCastSetParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
        }

        @TestMetadata("delegateAsInnerClass.kt")
        public void testDelegateAsInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
        }

        @TestMetadata("delegateByOtherProperty.kt")
        public void testDelegateByOtherProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
        }

        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
        }

        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
        }

        @TestMetadata("delegateForExtProperty.kt")
        public void testDelegateForExtProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
        }

        @TestMetadata("delegateForExtPropertyInClass.kt")
        public void testDelegateForExtPropertyInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
        }

        @TestMetadata("delegateWithPrivateSet.kt")
        public void testDelegateWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
        }

        @TestMetadata("extensionDelegatesWithSameNames.kt")
        public void testExtensionDelegatesWithSameNames() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionDelegatesWithSameNames.kt");
        }

        @TestMetadata("extensionPropertyAndExtensionGetValue.kt")
        public void testExtensionPropertyAndExtensionGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionPropertyAndExtensionGetValue.kt");
        }

        @TestMetadata("genericDelegate.kt")
        public void testGenericDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
        }

        @TestMetadata("genericDelegateUncheckedCast1.kt")
        public void testGenericDelegateUncheckedCast1() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast1.kt");
        }

        @TestMetadata("genericSetValueViaSyntheticAccessor.kt")
        public void testGenericSetValueViaSyntheticAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericSetValueViaSyntheticAccessor.kt");
        }

        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
        }

        @TestMetadata("getAsExtensionFunInClass.kt")
        public void testGetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
        }

        @TestMetadata("getDelegateWithoutReflection.kt")
        public void testGetDelegateWithoutReflection() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getDelegateWithoutReflection.kt");
        }

        @TestMetadata("inClassVal.kt")
        public void testInClassVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
        }

        @TestMetadata("inClassVar.kt")
        public void testInClassVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
        }

        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
        }

        @TestMetadata("inferredPropertyType.kt")
        public void testInferredPropertyType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
        }

        @TestMetadata("kt4138.kt")
        public void testKt4138() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
        }

        @TestMetadata("kt6722.kt")
        public void testKt6722() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
        }

        @TestMetadata("kt9712.kt")
        public void testKt9712() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
        }

        @TestMetadata("privateSetterKPropertyIsNotMutable.kt")
        public void testPrivateSetterKPropertyIsNotMutable() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateSetterKPropertyIsNotMutable.kt");
        }

        @TestMetadata("privateVar.kt")
        public void testPrivateVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
        }

        @TestMetadata("propertyMetadataShouldBeCached.kt")
        public void testPropertyMetadataShouldBeCached() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/propertyMetadataShouldBeCached.kt");
        }

        @TestMetadata("protectedVarWithPrivateSet.kt")
        public void testProtectedVarWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
        }

        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
        }

        @TestMetadata("setAsExtensionFunInClass.kt")
        public void testSetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
        }

        @TestMetadata("stackOverflowOnCallFromGetValue.kt")
        public void testStackOverflowOnCallFromGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/stackOverflowOnCallFromGetValue.kt");
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
        }

        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
        }

        @TestMetadata("twoPropByOneDelegete.kt")
        public void testTwoPropByOneDelegete() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
        }

        @TestMetadata("useKPropertyLater.kt")
        public void testUseKPropertyLater() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
        }

        @TestMetadata("useReflectionOnKProperty.kt")
        public void testUseReflectionOnKProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
        }

        @TestMetadata("valInInnerClass.kt")
        public void testValInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
        }

        @TestMetadata("varInInnerClass.kt")
        public void testVarInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("capturedLocalVal.kt")
            public void testCapturedLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
            }

            @TestMetadata("capturedLocalValNoInline.kt")
            public void testCapturedLocalValNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
            }

            @TestMetadata("capturedLocalVar.kt")
            public void testCapturedLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
            }

            @TestMetadata("capturedLocalVarNoInline.kt")
            public void testCapturedLocalVarNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
            }

            @TestMetadata("inlineGetValue.kt")
            public void testInlineGetValue() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
            }

            @TestMetadata("inlineOperators.kt")
            public void testInlineOperators() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
            }

            @TestMetadata("kt12891.kt")
            public void testKt12891() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
            }

            @TestMetadata("kt13557.kt")
            public void testKt13557() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
            }

            @TestMetadata("kt16864.kt")
            public void testKt16864() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt16864.kt");
            }

            @TestMetadata("kt19690.kt")
            public void testKt19690() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt19690.kt");
            }

            @TestMetadata("kt21085.kt")
            public void testKt21085() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt21085.kt");
            }

            @TestMetadata("kt23117.kt")
            public void testKt23117() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt23117.kt");
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
            }

            @TestMetadata("localValNoExplicitType.kt")
            public void testLocalValNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
            }

            @TestMetadata("localVarNoExplicitType.kt")
            public void testLocalVarNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/provideDelegate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProvideDelegate extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/differentReceivers.kt");
            }

            @TestMetadata("evaluationOrder.kt")
            public void testEvaluationOrder() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrder.kt");
            }

            @TestMetadata("evaluationOrderVar.kt")
            public void testEvaluationOrderVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrderVar.kt");
            }

            @TestMetadata("extensionDelegated.kt")
            public void testExtensionDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/extensionDelegated.kt");
            }

            @TestMetadata("generic.kt")
            public void testGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/generic.kt");
            }

            @TestMetadata("hostCheck.kt")
            public void testHostCheck() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/hostCheck.kt");
            }

            @TestMetadata("inClass.kt")
            public void testInClass() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inClass.kt");
            }

            @TestMetadata("inlineProvideDelegate.kt")
            public void testInlineProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inlineProvideDelegate.kt");
            }

            @TestMetadata("jvmStaticInObject.kt")
            public void testJvmStaticInObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/jvmStaticInObject.kt");
            }

            @TestMetadata("kt15437.kt")
            public void testKt15437() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt15437.kt");
            }

            @TestMetadata("kt16441.kt")
            public void testKt16441() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt16441.kt");
            }

            @TestMetadata("kt18902.kt")
            public void testKt18902() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt18902.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/local.kt");
            }

            @TestMetadata("localCaptured.kt")
            public void testLocalCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localCaptured.kt");
            }

            @TestMetadata("localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localDifferentReceivers.kt");
            }

            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/memberExtension.kt");
            }

            @TestMetadata("propertyMetadata.kt")
            public void testPropertyMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/propertyMetadata.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractLightAnalysisModeTest {
        @TestMetadata("withDefaultParameters.kt")
        public void ignoreWithDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultParameters.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDelegation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("byMiddleInterface.kt")
        public void testByMiddleInterface() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/byMiddleInterface.kt");
        }

        @TestMetadata("defaultOverride.kt")
        public void testDefaultOverride() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/defaultOverride.kt");
        }

        @TestMetadata("delegationToMap.kt")
        public void testDelegationToMap() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToMap.kt");
        }

        @TestMetadata("delegationToVal.kt")
        public void testDelegationToVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToVal.kt");
        }

        @TestMetadata("delegationWithPrivateConstructor.kt")
        public void testDelegationWithPrivateConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationWithPrivateConstructor.kt");
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond.kt");
        }

        @TestMetadata("diamond2.kt")
        public void testDiamond2() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond2.kt");
        }

        @TestMetadata("hiddenSuperOverrideIn1.0.kt")
        public void testHiddenSuperOverrideIn1_0() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/hiddenSuperOverrideIn1.0.kt");
        }

        @TestMetadata("inClassDeclaration.kt")
        public void testInClassDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inClassDeclaration.kt");
        }

        @TestMetadata("kt8154.kt")
        public void testKt8154() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt8154.kt");
        }

        @TestMetadata("mixed.kt")
        public void testMixed() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/mixed.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/simple.kt");
        }

        @TestMetadata("simple1.0.kt")
        public void testSimple1_0() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/simple1.0.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringDeclInLambdaParam extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDestructuringDeclInLambdaParam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
        }

        @TestMetadata("otherParameters.kt")
        public void testOtherParameters() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
        }

        @TestMetadata("stdlibUsages.kt")
        public void testStdlibUsages() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
        }

        @TestMetadata("underscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
        }

        @TestMetadata("withIndexed.kt")
        public void testWithIndexed() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Diagnostics extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInDiagnostics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("kt6176.kt")
                public void testKt6176() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnObjects extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInOnObjects() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("invokeOnClassObject1.kt")
                    public void testInvokeOnClassObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
                    }

                    @TestMetadata("invokeOnClassObject2.kt")
                    public void testInvokeOnClassObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
                    public void testInvokeOnClassObjectOfNestedClass1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
                    public void testInvokeOnClassObjectOfNestedClass2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
                    }

                    @TestMetadata("invokeOnEnum1.kt")
                    public void testInvokeOnEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
                    }

                    @TestMetadata("invokeOnEnum2.kt")
                    public void testInvokeOnEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum1.kt")
                    public void testInvokeOnImportedEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
                    }

                    @TestMetadata("invokeOnImportedEnum2.kt")
                    public void testInvokeOnImportedEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
                    }

                    @TestMetadata("invokeOnObject1.kt")
                    public void testInvokeOnObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
                    }

                    @TestMetadata("invokeOnObject2.kt")
                    public void testInvokeOnObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TailRecursion extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInTailRecursion() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
                }

                @TestMetadata("defaultArgsOverridden.kt")
                public void testDefaultArgsOverridden() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
                }

                @TestMetadata("extensionTailCall.kt")
                public void testExtensionTailCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
                }

                @TestMetadata("functionWithNoTails.kt")
                public void testFunctionWithNoTails() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
                }

                @TestMetadata("functionWithNonTailRecursions.kt")
                public void testFunctionWithNonTailRecursions() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
                }

                @TestMetadata("functionWithoutAnnotation.kt")
                public void testFunctionWithoutAnnotation() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
                }

                @TestMetadata("insideElvis.kt")
                public void testInsideElvis() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
                }

                @TestMetadata("labeledThisReferences.kt")
                public void testLabeledThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
                }

                @TestMetadata("loops.kt")
                public void testLoops() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
                }

                @TestMetadata("multilevelBlocks.kt")
                public void testMultilevelBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
                }

                @TestMetadata("recursiveCallInLambda.kt")
                public void testRecursiveCallInLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
                }

                @TestMetadata("recursiveCallInLocalFunction.kt")
                public void testRecursiveCallInLocalFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
                }

                @TestMetadata("recursiveInnerFunction.kt")
                public void testRecursiveInnerFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
                }

                @TestMetadata("returnIf.kt")
                public void testReturnIf() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
                }

                @TestMetadata("returnInCatch.kt")
                public void testReturnInCatch() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
                }

                @TestMetadata("returnInIfInFinally.kt")
                public void testReturnInIfInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
                }

                @TestMetadata("simpleBlock.kt")
                public void testSimpleBlock() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
                }

                @TestMetadata("simpleReturn.kt")
                public void testSimpleReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
                }

                @TestMetadata("simpleReturnWithElse.kt")
                public void testSimpleReturnWithElse() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
                }

                @TestMetadata("tailRecursionInFinally.kt")
                public void testTailRecursionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
                }

                @TestMetadata("thisReferences.kt")
                public void testThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
                }

                @TestMetadata("unitBlocks.kt")
                public void testUnitBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
                }

                @TestMetadata("whenWithCondition.kt")
                public void testWhenWithCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
                }

                @TestMetadata("whenWithInRange.kt")
                public void testWhenWithInRange() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
                }

                @TestMetadata("whenWithoutCondition.kt")
                public void testWhenWithoutCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInVararg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt4172.kt")
            public void testKt4172() throws Exception {
                runTest("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/elvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Elvis extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInElvis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericNull.kt");
        }

        @TestMetadata("kt6694ExactAnnotationForElvis.kt")
        public void testKt6694ExactAnnotationForElvis() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
        }

        @TestMetadata("nullNullOk.kt")
        public void testNullNullOk() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/nullNullOk.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/primitive.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("abstractMethodInEnum.kt")
        public void testAbstractMethodInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
        }

        @TestMetadata("abstractNestedClass.kt")
        public void testAbstractNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedParameter.kt")
        public void testAnnotatedParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter.kt");
        }

        @TestMetadata("annotatedParameter2.kt")
        public void testAnnotatedParameter2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter2.kt");
        }

        @TestMetadata("asReturnExpression.kt")
        public void testAsReturnExpression() throws Exception {
            runTest("compiler/testData/codegen/box/enum/asReturnExpression.kt");
        }

        @TestMetadata("classForEnumEntry.kt")
        public void testClassForEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/enum/classForEnumEntry.kt");
        }

        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass.kt")
        public void testDeepInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass.kt");
        }

        @TestMetadata("deepInnerClassInEnumEntryClass2.kt")
        public void testDeepInnerClassInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass2.kt");
        }

        @TestMetadata("emptyConstructor.kt")
        public void testEmptyConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyConstructor.kt");
        }

        @TestMetadata("emptyEnumValuesValueOf.kt")
        public void testEmptyEnumValuesValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
        }

        @TestMetadata("enumCompanionInit.kt")
        public void testEnumCompanionInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumCompanionInit.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor1.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor1.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor2.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor2.kt");
        }

        @TestMetadata("enumEntryReferenceFromInnerClassConstructor3.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor3.kt");
        }

        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
        }

        @TestMetadata("enumShort.kt")
        public void testEnumShort() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumShort.kt");
        }

        @TestMetadata("enumWithLambdaParameter.kt")
        public void testEnumWithLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
        }

        @TestMetadata("inPackage.kt")
        public void testInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inPackage.kt");
        }

        @TestMetadata("inclassobj.kt")
        public void testInclassobj() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inclassobj.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inner.kt");
        }

        @TestMetadata("innerClassInEnumEntryClass.kt")
        public void testInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass.kt")
        public void testInnerClassMethodInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass.kt");
        }

        @TestMetadata("innerClassMethodInEnumEntryClass2.kt")
        public void testInnerClassMethodInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass2.kt");
        }

        @TestMetadata("innerWithExistingClassObject.kt")
        public void testInnerWithExistingClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
        }

        @TestMetadata("kt1119.kt")
        public void testKt1119() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt1119.kt");
        }

        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731.kt");
        }

        @TestMetadata("kt20651.kt")
        public void testKt20651() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651.kt");
        }

        @TestMetadata("kt20651_inlineLambda.kt")
        public void testKt20651_inlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651_inlineLambda.kt");
        }

        @TestMetadata("kt20651a.kt")
        public void testKt20651a() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651a.kt");
        }

        @TestMetadata("kt20651b.kt")
        public void testKt20651b() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651b.kt");
        }

        @TestMetadata("kt2350.kt")
        public void testKt2350() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt2350.kt");
        }

        @TestMetadata("kt7257.kt")
        public void testKt7257() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257.kt");
        }

        @TestMetadata("kt7257_anonObjectInit.kt")
        public void testKt7257_anonObjectInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectInit.kt");
        }

        @TestMetadata("kt7257_anonObjectMethod.kt")
        public void testKt7257_anonObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectMethod.kt");
        }

        @TestMetadata("kt7257_boundReference1.kt")
        public void testKt7257_boundReference1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference1.kt");
        }

        @TestMetadata("kt7257_boundReference2.kt")
        public void testKt7257_boundReference2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference2.kt");
        }

        @TestMetadata("kt7257_boundReferenceWithImplicitReceiver.kt")
        public void testKt7257_boundReferenceWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReferenceWithImplicitReceiver.kt");
        }

        @TestMetadata("kt7257_explicitReceiver.kt")
        public void testKt7257_explicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_explicitReceiver.kt");
        }

        @TestMetadata("kt7257_fullyQualifiedReceiver.kt")
        public void testKt7257_fullyQualifiedReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_fullyQualifiedReceiver.kt");
        }

        @TestMetadata("kt7257_namedLocalFun.kt")
        public void testKt7257_namedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_namedLocalFun.kt");
        }

        @TestMetadata("kt7257_notInline.kt")
        public void testKt7257_notInline() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_notInline.kt");
        }

        @TestMetadata("kt9711.kt")
        public void testKt9711() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711.kt");
        }

        @TestMetadata("kt9711_2.kt")
        public void testKt9711_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711_2.kt");
        }

        @TestMetadata("manyDefaultParameters.kt")
        public void testManyDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/enum/manyDefaultParameters.kt");
        }

        @TestMetadata("modifierFlags.kt")
        public void testModifierFlags() throws Exception {
            runTest("compiler/testData/codegen/box/enum/modifierFlags.kt");
        }

        @TestMetadata("noClassForSimpleEnum.kt")
        public void testNoClassForSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/noClassForSimpleEnum.kt");
        }

        @TestMetadata("objectInEnum.kt")
        public void testObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/objectInEnum.kt");
        }

        @TestMetadata("ordinal.kt")
        public void testOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinal.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simple.kt");
        }

        @TestMetadata("sortEnumEntries.kt")
        public void testSortEnumEntries() throws Exception {
            runTest("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
        }

        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/enum/toString.kt");
        }

        @TestMetadata("valueof.kt")
        public void testValueof() throws Exception {
            runTest("compiler/testData/codegen/box/enum/valueof.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/enum/defaultCtor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultCtor extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultCtor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/enum/defaultCtor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithDefaultArguments.kt");
            }

            @TestMetadata("constructorWithVararg.kt")
            public void testConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithVararg.kt");
            }

            @TestMetadata("entryClassConstructorWithDefaultArguments.kt")
            public void testEntryClassConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("entryClassConstructorWithVarargs.kt")
            public void testEntryClassConstructorWithVarargs() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithVarargs.kt");
            }

            @TestMetadata("secondaryConstructorWithDefaultArguments.kt")
            public void testSecondaryConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithDefaultArguments.kt");
            }

            @TestMetadata("secondaryConstructorWithVararg.kt")
            public void testSecondaryConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithVararg.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Evaluate extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInEvaluate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/char.kt");
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/divide.kt");
        }

        @TestMetadata("intrinsics.kt")
        public void testIntrinsics() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/intrinsics.kt");
        }

        @TestMetadata("kt9443.kt")
        public void testKt9443() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/kt9443.kt");
        }

        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValue.kt");
        }

        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueByte.kt");
        }

        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueInt.kt");
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/minus.kt");
        }

        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/mod.kt");
        }

        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/multiply.kt");
        }

        @TestMetadata("parenthesized.kt")
        public void testParenthesized() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/parenthesized.kt");
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/plus.kt");
        }

        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/simpleCallBinary.kt");
        }

        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryMinus.kt");
        }

        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryPlus.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclExcl extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExclExcl() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/genericNull.kt");
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/primitive.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionFunctions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExtensionFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("executionOrder.kt")
        public void testExecutionOrder() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
        }

        @TestMetadata("kt1061.kt")
        public void testKt1061() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
        }

        @TestMetadata("kt1249.kt")
        public void testKt1249() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
        }

        @TestMetadata("kt1290.kt")
        public void testKt1290() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
        }

        @TestMetadata("kt13312.kt")
        public void testKt13312() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt13312.kt");
        }

        @TestMetadata("kt1776.kt")
        public void testKt1776() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
        }

        @TestMetadata("kt1953.kt")
        public void testKt1953() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
        }

        @TestMetadata("kt1953_class.kt")
        public void testKt1953_class() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
        }

        @TestMetadata("kt3285.kt")
        public void testKt3285() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
        }

        @TestMetadata("kt3298.kt")
        public void testKt3298() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
        }

        @TestMetadata("kt3646.kt")
        public void testKt3646() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
        }

        @TestMetadata("kt3969.kt")
        public void testKt3969() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
        }

        @TestMetadata("kt4228.kt")
        public void testKt4228() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
        }

        @TestMetadata("kt475.kt")
        public void testKt475() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
        }

        @TestMetadata("kt5467.kt")
        public void testKt5467() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
        }

        @TestMetadata("kt606.kt")
        public void testKt606() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
        }

        @TestMetadata("kt865.kt")
        public void testKt865() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
        }

        @TestMetadata("nested2.kt")
        public void testNested2() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
        }

        @TestMetadata("shared.kt")
        public void testShared() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/shared.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/simple.kt");
        }

        @TestMetadata("thisMethodInObjectLiteral.kt")
        public void testThisMethodInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
        }

        @TestMetadata("virtual.kt")
        public void testVirtual() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
        }

        @TestMetadata("whenFail.kt")
        public void testWhenFail() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionProperties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionProperties extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("accessorForPrivateSetter.kt")
        public void testAccessorForPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
        }

        public void testAllFilesPresentInExtensionProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericValForPrimitiveType.kt")
        public void testGenericValForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
        }

        @TestMetadata("genericValMultipleUpperBounds.kt")
        public void testGenericValMultipleUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValMultipleUpperBounds.kt");
        }

        @TestMetadata("genericVarForPrimitiveType.kt")
        public void testGenericVarForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClass.kt");
        }

        @TestMetadata("inClassLongTypeInReceiver.kt")
        public void testInClassLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
        }

        @TestMetadata("inClassWithGetter.kt")
        public void testInClassWithGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
        }

        @TestMetadata("inClassWithPrivateGetter.kt")
        public void testInClassWithPrivateGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
        }

        @TestMetadata("inClassWithPrivateSetter.kt")
        public void testInClassWithPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
        }

        @TestMetadata("inClassWithSetter.kt")
        public void testInClassWithSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
        }

        @TestMetadata("kt9897.kt")
        public void testKt9897() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
        }

        @TestMetadata("kt9897_topLevel.kt")
        public void testKt9897_topLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
        }

        @TestMetadata("nonAbstractInInterface.kt")
        public void testNonAbstractInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/nonAbstractInInterface.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
        }

        @TestMetadata("topLevelLongTypeInReceiver.kt")
        public void testTopLevelLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/external")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class External extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInExternal() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("jvmStaticExternal.kt")
        public void testJvmStaticExternal() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternal.kt");
        }

        @TestMetadata("jvmStaticExternalPrivate.kt")
        public void testJvmStaticExternalPrivate() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternalPrivate.kt");
        }

        @TestMetadata("withDefaultArg.kt")
        public void testWithDefaultArg() throws Exception {
            runTest("compiler/testData/codegen/box/external/withDefaultArg.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fakeOverride")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FakeOverride extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFakeOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("diamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/function.kt");
        }

        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FieldRename extends AbstractLightAnalysisModeTest {
        @TestMetadata("jvmFieldNoClash1.kt")
        public void ignoreJvmFieldNoClash1() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash1.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFieldRename() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("constructorAndClassObject.kt")
        public void testConstructorAndClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
        }

        @TestMetadata("delegates.kt")
        public void testDelegates() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/delegates.kt");
        }

        @TestMetadata("genericPropertyWithItself.kt")
        public void testGenericPropertyWithItself() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
        }

        @TestMetadata("jvmFieldNoClash2.kt")
        public void testJvmFieldNoClash2() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash2.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/finally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Finally extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("finallyAndFinally.kt")
        public void testFinallyAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
        }

        @TestMetadata("kt3549.kt")
        public void testKt3549() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3549.kt");
        }

        @TestMetadata("kt3706.kt")
        public void testKt3706() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3706.kt");
        }

        @TestMetadata("kt3867.kt")
        public void testKt3867() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3867.kt");
        }

        @TestMetadata("kt3874.kt")
        public void testKt3874() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3874.kt");
        }

        @TestMetadata("kt3894.kt")
        public void testKt3894() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3894.kt");
        }

        @TestMetadata("kt4134.kt")
        public void testKt4134() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt4134.kt");
        }

        @TestMetadata("loopAndFinally.kt")
        public void testLoopAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/loopAndFinally.kt");
        }

        @TestMetadata("notChainCatch.kt")
        public void testNotChainCatch() throws Exception {
            runTest("compiler/testData/codegen/box/finally/notChainCatch.kt");
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryFinally.kt");
        }

        @TestMetadata("tryLoopTry.kt")
        public void testTryLoopTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryLoopTry.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fullJdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FullJdk extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFullJdk() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/charBuffer.kt");
        }

        @TestMetadata("ifInWhile.kt")
        public void testIfInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/ifInWhile.kt");
        }

        @TestMetadata("intCountDownLatchExtension.kt")
        public void testIntCountDownLatchExtension() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/intCountDownLatchExtension.kt");
        }

        @TestMetadata("kt434.kt")
        public void testKt434() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt434.kt");
        }

        @TestMetadata("platformTypeAssertionStackTrace.kt")
        public void testPlatformTypeAssertionStackTrace() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/platformTypeAssertionStackTrace.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Native extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNative() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("nativePropertyAccessors.kt")
            public void testNativePropertyAccessors() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/nativePropertyAccessors.kt");
            }

            @TestMetadata("simpleNative.kt")
            public void testSimpleNative() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/simpleNative.kt");
            }

            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/topLevel.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInRegressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt15112.kt")
            public void testKt15112() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt15112.kt");
            }

            @TestMetadata("kt1770.kt")
            public void testKt1770() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt1770.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/functions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Functions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("coerceVoidToArray.kt")
        public void testCoerceVoidToArray() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
        }

        @TestMetadata("coerceVoidToObject.kt")
        public void testCoerceVoidToObject() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
        }

        @TestMetadata("dataLocalVariable.kt")
        public void testDataLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/functions/dataLocalVariable.kt");
        }

        @TestMetadata("defaultargs.kt")
        public void testDefaultargs() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs.kt");
        }

        @TestMetadata("defaultargs1.kt")
        public void testDefaultargs1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs1.kt");
        }

        @TestMetadata("defaultargs2.kt")
        public void testDefaultargs2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs2.kt");
        }

        @TestMetadata("defaultargs3.kt")
        public void testDefaultargs3() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs3.kt");
        }

        @TestMetadata("defaultargs4.kt")
        public void testDefaultargs4() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs4.kt");
        }

        @TestMetadata("defaultargs5.kt")
        public void testDefaultargs5() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs5.kt");
        }

        @TestMetadata("defaultargs6.kt")
        public void testDefaultargs6() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs6.kt");
        }

        @TestMetadata("defaultargs7.kt")
        public void testDefaultargs7() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs7.kt");
        }

        @TestMetadata("ea33909.kt")
        public void testEa33909() throws Exception {
            runTest("compiler/testData/codegen/box/functions/ea33909.kt");
        }

        @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
        public void testFakeDescriptorWithSeveralOverridenOne() throws Exception {
            runTest("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
        }

        @TestMetadata("functionNtoString.kt")
        public void testFunctionNtoString() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoString.kt");
        }

        @TestMetadata("functionNtoStringGeneric.kt")
        public void testFunctionNtoStringGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
        }

        @TestMetadata("functionNtoStringNoReflect.kt")
        public void testFunctionNtoStringNoReflect() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
        }

        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
        }

        @TestMetadata("kt1038.kt")
        public void testKt1038() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1038.kt");
        }

        @TestMetadata("kt1199.kt")
        public void testKt1199() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1199.kt");
        }

        @TestMetadata("kt1413.kt")
        public void testKt1413() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1413.kt");
        }

        @TestMetadata("kt1649_1.kt")
        public void testKt1649_1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_1.kt");
        }

        @TestMetadata("kt1649_2.kt")
        public void testKt1649_2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_2.kt");
        }

        @TestMetadata("kt1739.kt")
        public void testKt1739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1739.kt");
        }

        @TestMetadata("kt2270.kt")
        public void testKt2270() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2270.kt");
        }

        @TestMetadata("kt2271.kt")
        public void testKt2271() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2271.kt");
        }

        @TestMetadata("kt2280.kt")
        public void testKt2280() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2280.kt");
        }

        @TestMetadata("kt2481.kt")
        public void testKt2481() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2481.kt");
        }

        @TestMetadata("kt2716.kt")
        public void testKt2716() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2716.kt");
        }

        @TestMetadata("kt2739.kt")
        public void testKt2739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2739.kt");
        }

        @TestMetadata("kt2929.kt")
        public void testKt2929() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2929.kt");
        }

        @TestMetadata("kt3214.kt")
        public void testKt3214() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3214.kt");
        }

        @TestMetadata("kt3313.kt")
        public void testKt3313() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3313.kt");
        }

        @TestMetadata("kt3573.kt")
        public void testKt3573() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3573.kt");
        }

        @TestMetadata("kt3724.kt")
        public void testKt3724() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3724.kt");
        }

        @TestMetadata("kt395.kt")
        public void testKt395() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt395.kt");
        }

        @TestMetadata("kt785.kt")
        public void testKt785() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt785.kt");
        }

        @TestMetadata("kt873.kt")
        public void testKt873() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt873.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localFunction.kt");
        }

        @TestMetadata("localReturnInsideFunctionExpression.kt")
        public void testLocalReturnInsideFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
        }

        @TestMetadata("nothisnoclosure.kt")
        public void testNothisnoclosure() throws Exception {
            runTest("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
        }

        @TestMetadata("prefixRecursiveCall.kt")
        public void testPrefixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
        }

        @TestMetadata("recursiveCompareTo.kt")
        public void testRecursiveCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
        }

        @TestMetadata("recursiveIncrementCall.kt")
        public void testRecursiveIncrementCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/functions/bigArity")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BigArity extends AbstractLightAnalysisModeTest {
            @TestMetadata("noBigFunctionTypes.kt")
            public void ignoreNoBigFunctionTypes() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/noBigFunctionTypes.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBigArity() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/bigArity"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callFromJava.kt")
            public void testCallFromJava() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callFromJava.kt");
            }

            @TestMetadata("callWithIncorrectNumberOfArguments.kt")
            public void testCallWithIncorrectNumberOfArguments() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callWithIncorrectNumberOfArguments.kt");
            }

            @TestMetadata("function255.kt")
            public void testFunction255() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/function255.kt");
            }

            @TestMetadata("instanceOfCallableReference.kt")
            public void testInstanceOfCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/instanceOfCallableReference.kt");
            }

            @TestMetadata("invokeCallableReference.kt")
            public void testInvokeCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeCallableReference.kt");
            }

            @TestMetadata("invokeLambda.kt")
            public void testInvokeLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeLambda.kt");
            }

            @TestMetadata("invokeMemberCallableReference.kt")
            public void testInvokeMemberCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeMemberCallableReference.kt");
            }

            @TestMetadata("javaLambda.kt")
            public void testJavaLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/javaLambda.kt");
            }

            @TestMetadata("subclass.kt")
            public void testSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/subclass.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionExpression extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
            }

            @TestMetadata("functionExpressionWithThisReference.kt")
            public void testFunctionExpressionWithThisReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
            }

            @TestMetadata("functionLiteralExpression.kt")
            public void testFunctionLiteralExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
            }

            @TestMetadata("underscoreParameters.kt")
            public void testUnderscoreParameters() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInvoke() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("castFunctionToExtension.kt")
            public void testCastFunctionToExtension() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
            }

            @TestMetadata("extensionInvokeOnExpr.kt")
            public void testExtensionInvokeOnExpr() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
            }

            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invoke.kt");
            }

            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
            }

            @TestMetadata("invokeOnSyntheticProperty.kt")
            public void testInvokeOnSyntheticProperty() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnSyntheticProperty.kt");
            }

            @TestMetadata("kt3189.kt")
            public void testKt3189() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
            }

            @TestMetadata("kt3190.kt")
            public void testKt3190() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
            }

            @TestMetadata("kt3297.kt")
            public void testKt3297() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
            }

            @TestMetadata("kt3450getAndInvoke.kt")
            public void testKt3450getAndInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
            }

            @TestMetadata("kt3631invokeOnString.kt")
            public void testKt3631invokeOnString() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
            }

            @TestMetadata("kt3772.kt")
            public void testKt3772() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
            }

            @TestMetadata("kt3821invokeOnThis.kt")
            public void testKt3821invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
            }

            @TestMetadata("kt3822invokeOnThis.kt")
            public void testKt3822invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callInlineLocalInLambda.kt")
            public void testCallInlineLocalInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
            }

            @TestMetadata("definedWithinLambda.kt")
            public void testDefinedWithinLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage1.kt")
            public void testDefinedWithinLambdaInnerUsage1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
            }

            @TestMetadata("definedWithinLambdaInnerUsage2.kt")
            public void testDefinedWithinLambdaInnerUsage2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
            }

            @TestMetadata("kt2895.kt")
            public void testKt2895() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
            }

            @TestMetadata("kt3308.kt")
            public void testKt3308() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
            }

            @TestMetadata("kt3978.kt")
            public void testKt3978() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
            }

            @TestMetadata("kt4119.kt")
            public void testKt4119() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
            }

            @TestMetadata("kt4119_2.kt")
            public void testKt4119_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
            }

            @TestMetadata("kt4514.kt")
            public void testKt4514() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
            }

            @TestMetadata("kt4777.kt")
            public void testKt4777() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
            }

            @TestMetadata("kt4783.kt")
            public void testKt4783() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
            }

            @TestMetadata("kt4784.kt")
            public void testKt4784() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
            }

            @TestMetadata("kt4989.kt")
            public void testKt4989() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
            }

            @TestMetadata("localExtensionOnNullableParameter.kt")
            public void testLocalExtensionOnNullableParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
            }

            @TestMetadata("localFunctionInConstructor.kt")
            public void testLocalFunctionInConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
            }

            @TestMetadata("localFunctionVsLocalVariable.kt")
            public void testLocalFunctionVsLocalVariable() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionVsLocalVariable.kt");
            }

            @TestMetadata("overloadedLocalFunWithoutClosure.kt")
            public void testOverloadedLocalFunWithoutClosure() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunWithoutClosure.kt");
            }

            @TestMetadata("overloadedLocalFunction.kt")
            public void testOverloadedLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction.kt");
            }

            @TestMetadata("overloadedLocalFunction1.kt")
            public void testOverloadedLocalFunction1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction1.kt");
            }

            @TestMetadata("overloadedLocalFunction2.kt")
            public void testOverloadedLocalFunction2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction2.kt");
            }

            @TestMetadata("overloadedLocalFunction3.kt")
            public void testOverloadedLocalFunction3() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction3.kt");
            }

            @TestMetadata("parameterAsDefaultValue.kt")
            public void testParameterAsDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/parameterAsDefaultValue.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/hashPMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HashPMap extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInHashPMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/hashPMap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("empty.kt")
        public void testEmpty() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/empty.kt");
        }

        @TestMetadata("manyNumbers.kt")
        public void testManyNumbers() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/manyNumbers.kt");
        }

        @TestMetadata("rewriteWithDifferent.kt")
        public void testRewriteWithDifferent() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithDifferent.kt");
        }

        @TestMetadata("rewriteWithEqual.kt")
        public void testRewriteWithEqual() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithEqual.kt");
        }

        @TestMetadata("simplePlusGet.kt")
        public void testSimplePlusGet() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusGet.kt");
        }

        @TestMetadata("simplePlusMinus.kt")
        public void testSimplePlusMinus() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusMinus.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ieee754 extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIeee754() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ieee754"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anyToReal.kt")
        public void testAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal.kt");
        }

        @TestMetadata("asComparableToDouble.kt")
        public void testAsComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble.kt");
        }

        @TestMetadata("asComparableToDouble_properIeeeComparisons.kt")
        public void testAsComparableToDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableToTWithT_properIeeeComparisons.kt")
        public void testComparableToTWithT_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableToTWithT_properIeeeComparisons.kt");
        }

        @TestMetadata("comparableTypeCast.kt")
        public void testComparableTypeCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast.kt");
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/dataClass.kt");
        }

        @TestMetadata("differentTypesComparison.kt")
        public void testDifferentTypesComparison() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/differentTypesComparison.kt");
        }

        @TestMetadata("equalsDouble.kt")
        public void testEqualsDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble.kt");
        }

        @TestMetadata("equalsDouble_properIeeeComparisons.kt")
        public void testEqualsDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsFloat.kt")
        public void testEqualsFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat.kt");
        }

        @TestMetadata("equalsFloat_properIeeeComparisons.kt")
        public void testEqualsFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNaN.kt")
        public void testEqualsNaN() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN.kt");
        }

        @TestMetadata("equalsNaN_properIeeeComparisons.kt")
        public void testEqualsNaN_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableDouble.kt")
        public void testEqualsNullableDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble.kt");
        }

        @TestMetadata("equalsNullableDouble_properIeeeComparisons.kt")
        public void testEqualsNullableDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("equalsNullableFloat.kt")
        public void testEqualsNullableFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat.kt");
        }

        @TestMetadata("equalsNullableFloat_properIeeeComparisons.kt")
        public void testEqualsNullableFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("explicitCompareCall.kt")
        public void testExplicitCompareCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall.kt");
        }

        @TestMetadata("explicitEqualsCall.kt")
        public void testExplicitEqualsCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic.kt");
        }

        @TestMetadata("greaterDouble.kt")
        public void testGreaterDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble.kt");
        }

        @TestMetadata("greaterDouble_properIeeeComparisons.kt")
        public void testGreaterDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("greaterFloat.kt")
        public void testGreaterFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat.kt");
        }

        @TestMetadata("greaterFloat_properIeeeComparisons.kt")
        public void testGreaterFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/inline.kt");
        }

        @TestMetadata("lessDouble.kt")
        public void testLessDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble.kt");
        }

        @TestMetadata("lessDouble_properIeeeAndNewInference.kt")
        public void testLessDouble_properIeeeAndNewInference() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeAndNewInference.kt");
        }

        @TestMetadata("lessDouble_properIeeeComparisons.kt")
        public void testLessDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeComparisons.kt");
        }

        @TestMetadata("lessFloat.kt")
        public void testLessFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat.kt");
        }

        @TestMetadata("lessFloat_properIeeeComparisons.kt")
        public void testLessFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat_properIeeeComparisons.kt");
        }

        @TestMetadata("nullableAnyToReal.kt")
        public void testNullableAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal.kt");
        }

        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals.kt");
        }

        @TestMetadata("nullableDoubleEquals10.kt")
        public void testNullableDoubleEquals10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals10.kt");
        }

        @TestMetadata("nullableDoubleEqualsLV13.kt")
        public void testNullableDoubleEqualsLV13() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEqualsLV13.kt");
        }

        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals.kt");
        }

        @TestMetadata("nullableDoubleNotEquals10.kt")
        public void testNullableDoubleNotEquals10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals10.kt");
        }

        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals.kt");
        }

        @TestMetadata("nullableFloatEquals10.kt")
        public void testNullableFloatEquals10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals10.kt");
        }

        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals.kt");
        }

        @TestMetadata("nullableFloatNotEquals10.kt")
        public void testNullableFloatNotEquals10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals10.kt");
        }

        @TestMetadata("nullableIntEquals.kt")
        public void testNullableIntEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableIntEquals.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/safeCall.kt");
        }

        @TestMetadata("smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt")
        public void testSmartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes.kt")
        public void testSmartCastToDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion.kt");
        }

        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDifferentTypes_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypes_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes_properIeeeComparisons.kt");
        }

        @TestMetadata("smartCastToDoubleAndComparableToDouble.kt")
        public void testSmartCastToDoubleAndComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDoubleAndComparableToDouble.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when.kt");
        }

        @TestMetadata("when10.kt")
        public void testWhen10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when10.kt");
        }

        @TestMetadata("when10_properIeeeComparisons.kt")
        public void testWhen10_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when10_properIeeeComparisons.kt");
        }

        @TestMetadata("whenNoSubject.kt")
        public void testWhenNoSubject() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject.kt");
        }

        @TestMetadata("whenNoSubject_properIeeeComparisons.kt")
        public void testWhenNoSubject_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject_properIeeeComparisons.kt");
        }

        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast.kt");
        }

        @TestMetadata("whenNullableSmartCast10.kt")
        public void testWhenNullableSmartCast10() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast10.kt");
        }

        @TestMetadata("when_properIeeeComparisons.kt")
        public void testWhen_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when_properIeeeComparisons.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/increment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Increment extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIncrement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayElement.kt")
        public void testArrayElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/arrayElement.kt");
        }

        @TestMetadata("assignPlusOnSmartCast.kt")
        public void testAssignPlusOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
        }

        @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
        public void testAugmentedAssignmentWithComplexRhs() throws Exception {
            runTest("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
        }

        @TestMetadata("classNaryGetSet.kt")
        public void testClassNaryGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
        }

        @TestMetadata("classWithGetSet.kt")
        public void testClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classWithGetSet.kt");
        }

        @TestMetadata("extOnLong.kt")
        public void testExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/extOnLong.kt");
        }

        @TestMetadata("genericClassWithGetSet.kt")
        public void testGenericClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
        }

        @TestMetadata("memberExtOnLong.kt")
        public void testMemberExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
        }

        @TestMetadata("mutableListElement.kt")
        public void testMutableListElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/mutableListElement.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("compiler/testData/codegen/box/increment/nullable.kt");
        }

        @TestMetadata("postfixIncrementDoubleSmartCast.kt")
        public void testPostfixIncrementDoubleSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnClass.kt")
        public void testPostfixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
        }

        @TestMetadata("postfixIncrementOnClassSmartCast.kt")
        public void testPostfixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnShortSmartCast.kt")
        public void testPostfixIncrementOnShortSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
        }

        @TestMetadata("postfixIncrementOnSmartCast.kt")
        public void testPostfixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
        }

        @TestMetadata("postfixNullableClassIncrement.kt")
        public void testPostfixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
        }

        @TestMetadata("postfixNullableIncrement.kt")
        public void testPostfixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
        }

        @TestMetadata("prefixIncrementOnClass.kt")
        public void testPrefixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
        }

        @TestMetadata("prefixIncrementOnClassSmartCast.kt")
        public void testPrefixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
        }

        @TestMetadata("prefixIncrementOnSmartCast.kt")
        public void testPrefixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
        }

        @TestMetadata("prefixNullableClassIncrement.kt")
        public void testPrefixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
        }

        @TestMetadata("prefixNullableIncrement.kt")
        public void testPrefixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inference extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt10822.kt")
        public void testKt10822() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt10822.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boundCallableReferencePassedToInlineFunction.kt")
        public void testBoundCallableReferencePassedToInlineFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunction.kt");
        }

        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt");
        }

        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt");
        }

        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
        }

        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSet.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSet.kt");
        }

        @TestMetadata("boxUnboxOfInlineClassForCapturedVars.kt")
        public void testBoxUnboxOfInlineClassForCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVars.kt");
        }

        @TestMetadata("bridgeForFunctionReturningInlineClass.kt")
        public void testBridgeForFunctionReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClass.kt");
        }

        @TestMetadata("bridgeGenerationWithInlineClassOverAny.kt")
        public void testBridgeGenerationWithInlineClassOverAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAny.kt");
        }

        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterface.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterface() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterface.kt");
        }

        @TestMetadata("callComputablePropertyInsideInlineClass.kt")
        public void testCallComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callComputablePropertyInsideInlineClass.kt");
        }

        @TestMetadata("callSpecializedEqualsViaReflection.kt")
        public void testCallSpecializedEqualsViaReflection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflection.kt");
        }

        @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClass.kt")
        public void testCallSpeciallyOverriddenPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClass.kt");
        }

        @TestMetadata("callableReferencesWithInlineClasses.kt")
        public void testCallableReferencesWithInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClasses.kt");
        }

        @TestMetadata("castInsideWhenExpression.kt")
        public void testCastInsideWhenExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpression.kt");
        }

        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctions.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctions.kt");
        }

        @TestMetadata("checkBoxingAfterAssertionOperator.kt")
        public void testCheckBoxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperator.kt");
        }

        @TestMetadata("checkBoxingForComplexClassHierarchy.kt")
        public void testCheckBoxingForComplexClassHierarchy() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchy.kt");
        }

        @TestMetadata("checkBoxingForNonLocalAndLabeledReturns.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturns() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturns.kt");
        }

        @TestMetadata("checkBoxingFromReturnTypeForInlineClasses.kt")
        public void testCheckBoxingFromReturnTypeForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClasses.kt");
        }

        @TestMetadata("checkBoxingOnFunctionCalls.kt")
        public void testCheckBoxingOnFunctionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCalls.kt");
        }

        @TestMetadata("checkBoxingOnLocalVariableAssignments.kt")
        public void testCheckBoxingOnLocalVariableAssignments() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignments.kt");
        }

        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt");
        }

        @TestMetadata("checkCallingMembersInsideInlineClass.kt")
        public void testCheckCallingMembersInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClass.kt");
        }

        @TestMetadata("checkCastToInlineClass.kt")
        public void testCheckCastToInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClass.kt");
        }

        @TestMetadata("checkForInstanceOfInlineClass.kt")
        public void testCheckForInstanceOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClass.kt");
        }

        @TestMetadata("checkLambdaWithInlineClassesInFunctionalType.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalType.kt");
        }

        @TestMetadata("checkUnboxingResultFromTypeVariable.kt")
        public void testCheckUnboxingResultFromTypeVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariable.kt");
        }

        @TestMetadata("classLiteralOnInlineClass.kt")
        public void testClassLiteralOnInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClass.kt");
        }

        @TestMetadata("computablePropertyInsideInlineClass.kt")
        public void testComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/computablePropertyInsideInlineClass.kt");
        }

        @TestMetadata("conformToComparableAndCallInterfaceMethod.kt")
        public void testConformToComparableAndCallInterfaceMethod() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethod.kt");
        }

        @TestMetadata("correctBoxingForBranchExpressions.kt")
        public void testCorrectBoxingForBranchExpressions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressions.kt");
        }

        @TestMetadata("createInlineClassInArgumentPosition.kt")
        public void testCreateInlineClassInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPosition.kt");
        }

        @TestMetadata("crossinlineWithInlineClassInParameter.kt")
        public void testCrossinlineWithInlineClassInParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameter.kt");
        }

        @TestMetadata("defaultFunctionsFromAnyForInlineClass.kt")
        public void testDefaultFunctionsFromAnyForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClass.kt");
        }

        @TestMetadata("elvisWithInlineClassAndNullConstant.kt")
        public void testElvisWithInlineClassAndNullConstant() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstant.kt");
        }

        @TestMetadata("emptyConstructorForInlineClass.kt")
        public void testEmptyConstructorForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClass.kt");
        }

        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClass.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClass.kt");
        }

        @TestMetadata("equalsOperatorWithGenericCall.kt")
        public void testEqualsOperatorWithGenericCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCall.kt");
        }

        @TestMetadata("extLambdaInInlineClassFun.kt")
        public void testExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun.kt");
        }

        @TestMetadata("extLambdaInInlineClassFun2.kt")
        public void testExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2.kt");
        }

        @TestMetadata("inlineClassAsLastExpressionInInLambda.kt")
        public void testInlineClassAsLastExpressionInInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambda.kt");
        }

        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointData() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt");
        }

        @TestMetadata("inlineClassFunctionInvoke.kt")
        public void testInlineClassFunctionInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvoke.kt");
        }

        @TestMetadata("inlineClassImplementsCollection.kt")
        public void testInlineClassImplementsCollection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollection.kt");
        }

        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplate.kt");
        }

        @TestMetadata("inlineClassPropertyReferenceGetAndSet.kt")
        public void testInlineClassPropertyReferenceGetAndSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSet.kt");
        }

        @TestMetadata("inlineClassValueCapturedInInlineLambda.kt")
        public void testInlineClassValueCapturedInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambda.kt");
        }

        @TestMetadata("inlineClassValueCapturedInNonInlineLambda.kt")
        public void testInlineClassValueCapturedInNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambda.kt");
        }

        @TestMetadata("inlineClassValuesInsideStrings.kt")
        public void testInlineClassValuesInsideStrings() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStrings.kt");
        }

        @TestMetadata("inlineClassWithCustomEquals.kt")
        public void testInlineClassWithCustomEquals() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEquals.kt");
        }

        @TestMetadata("inlineClassWithDefaultFunctionsFromAny.kt")
        public void testInlineClassWithDefaultFunctionsFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAny.kt");
        }

        @TestMetadata("inlineClassesAsInlineFunParameters.kt")
        public void testInlineClassesAsInlineFunParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParameters.kt");
        }

        @TestMetadata("inlineClassesCheckCast.kt")
        public void testInlineClassesCheckCast() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCast.kt");
        }

        @TestMetadata("inlineClassesInInlineLambdaParameters.kt")
        public void testInlineClassesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParameters.kt");
        }

        @TestMetadata("inlineClassesRefTypesInInlineLambdaParameters.kt")
        public void testInlineClassesRefTypesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParameters.kt");
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun.kt")
        public void testInlineExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun.kt");
        }

        @TestMetadata("inlineExtLambdaInInlineClassFun2.kt")
        public void testInlineExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2.kt");
        }

        @TestMetadata("inlineFunctionInsideInlineClass.kt")
        public void testInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClass.kt");
        }

        @TestMetadata("interfaceImplementationByDelegation.kt")
        public void testInterfaceImplementationByDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/interfaceImplementationByDelegation.kt");
        }

        @TestMetadata("iterateOverArrayOfInlineClassValues.kt")
        public void testIterateOverArrayOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValues.kt");
        }

        @TestMetadata("iterateOverListOfInlineClassValues.kt")
        public void testIterateOverListOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValues.kt");
        }

        @TestMetadata("javaClassIntrinsicOnInlineClasses.kt")
        public void testJavaClassIntrinsicOnInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClasses.kt");
        }

        @TestMetadata("jvmFieldInInlineClassCompanion.kt")
        public void testJvmFieldInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanion.kt");
        }

        @TestMetadata("jvmStaticFunInInlineClassCompanion.kt")
        public void testJvmStaticFunInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticFunInInlineClassCompanion.kt");
        }

        @TestMetadata("jvmStaticPropertyAccessorInInlineClassCompanion.kt")
        public void testJvmStaticPropertyAccessorInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticPropertyAccessorInInlineClassCompanion.kt");
        }

        @TestMetadata("jvmStaticVarInInlineClassCompanion.kt")
        public void testJvmStaticVarInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticVarInInlineClassCompanion.kt");
        }

        @TestMetadata("kt25246.kt")
        public void testKt25246() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25246.kt");
        }

        @TestMetadata("kt25750.kt")
        public void testKt25750() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750.kt");
        }

        @TestMetadata("kt25771.kt")
        public void testKt25771() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25771.kt");
        }

        @TestMetadata("kt26103.kt")
        public void testKt26103() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103.kt");
        }

        @TestMetadata("kt26103_contravariantUnderlyingType.kt")
        public void testKt26103_contravariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_contravariantUnderlyingType.kt");
        }

        @TestMetadata("kt26103_covariantUnderlyingType.kt")
        public void testKt26103_covariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_covariantUnderlyingType.kt");
        }

        @TestMetadata("kt26103_original.kt")
        public void testKt26103_original() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_original.kt");
        }

        @TestMetadata("kt27096.kt")
        public void testKt27096() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096.kt");
        }

        @TestMetadata("kt27096_enum.kt")
        public void testKt27096_enum() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enum.kt");
        }

        @TestMetadata("kt27096_functional.kt")
        public void testKt27096_functional() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functional.kt");
        }

        @TestMetadata("kt27096_innerClass.kt")
        public void testKt27096_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_innerClass.kt");
        }

        @TestMetadata("kt27096_nullablePrimitive.kt")
        public void testKt27096_nullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitive.kt");
        }

        @TestMetadata("kt27096_nullableReference.kt")
        public void testKt27096_nullableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReference.kt");
        }

        @TestMetadata("kt27096_primitive.kt")
        public void testKt27096_primitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitive.kt");
        }

        @TestMetadata("kt27096_reference.kt")
        public void testKt27096_reference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_reference.kt");
        }

        @TestMetadata("kt27113.kt")
        public void testKt27113() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113.kt");
        }

        @TestMetadata("kt27113a.kt")
        public void testKt27113a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113a.kt");
        }

        @TestMetadata("kt27132.kt")
        public void testKt27132() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132.kt");
        }

        @TestMetadata("kt27140.kt")
        public void testKt27140() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140.kt");
        }

        @TestMetadata("kt27705.kt")
        public void testKt27705() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705.kt");
        }

        @TestMetadata("kt27706.kt")
        public void testKt27706() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706.kt");
        }

        @TestMetadata("kt28405.kt")
        public void testKt28405() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28405.kt");
        }

        @TestMetadata("kt28585.kt")
        public void testKt28585() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28585.kt");
        }

        @TestMetadata("kt28879.kt")
        public void testKt28879() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28879.kt");
        }

        @TestMetadata("kt28920_javaObjectType.kt")
        public void testKt28920_javaObjectType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaObjectType.kt");
        }

        @TestMetadata("kt28920_javaPrimitiveType.kt")
        public void testKt28920_javaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaPrimitiveType.kt");
        }

        @TestMetadata("mapInlineClassesWithSuppressWildcardsMode.kt")
        public void testMapInlineClassesWithSuppressWildcardsMode() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mapInlineClassesWithSuppressWildcardsMode.kt");
        }

        @TestMetadata("mappingOfBoxedFlexibleInlineClassType.kt")
        public void testMappingOfBoxedFlexibleInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mappingOfBoxedFlexibleInlineClassType.kt");
        }

        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableType.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableType.kt");
        }

        @TestMetadata("nullableEqeqNonNull.kt")
        public void testNullableEqeqNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNull.kt");
        }

        @TestMetadata("nullableWrapperEquality.kt")
        public void testNullableWrapperEquality() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEquality.kt");
        }

        @TestMetadata("overridingFunCallingPrivateFun.kt")
        public void testOverridingFunCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFun.kt");
        }

        @TestMetadata("passInlineClassAsVararg.kt")
        public void testPassInlineClassAsVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVararg.kt");
        }

        @TestMetadata("passInlineClassWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargs.kt");
        }

        @TestMetadata("referToPropertyInCompanionObjectOfInlineClass.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClass.kt");
        }

        @TestMetadata("referToUnderlyingPropertyInsideInlineClass.kt")
        public void testReferToUnderlyingPropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClass.kt");
        }

        @TestMetadata("referToUnderlyingPropertyOfInlineClass.kt")
        public void testReferToUnderlyingPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClass.kt");
        }

        @TestMetadata("secondaryConstructorWithVararg.kt")
        public void testSecondaryConstructorWithVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVararg.kt");
        }

        @TestMetadata("secondaryConstructorsInsideInlineClass.kt")
        public void testSecondaryConstructorsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClass.kt");
        }

        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt");
        }

        @TestMetadata("smartCastOnThisOfInlineClassType.kt")
        public void testSmartCastOnThisOfInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassType.kt");
        }

        @TestMetadata("toStringCallingPrivateFun.kt")
        public void testToStringCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFun.kt");
        }

        @TestMetadata("typeChecksForInlineClasses.kt")
        public void testTypeChecksForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClasses.kt");
        }

        @TestMetadata("UIntArraySortExample.kt")
        public void testUIntArraySortExample() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExample.kt");
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt");
        }

        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt");
        }

        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvoke.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvoke.kt");
        }

        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClass.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClass.kt");
        }

        @TestMetadata("unboxValueFromPlatformType.kt")
        public void testUnboxValueFromPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformType.kt");
        }

        @TestMetadata("unboxValueOfAnyBeforeMethodInvocation.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocation.kt");
        }

        @TestMetadata("useInlineClassesInsideElvisOperator.kt")
        public void testUseInlineClassesInsideElvisOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperator.kt");
        }

        @TestMetadata("useInlineFunctionInsideInlineClass.kt")
        public void testUseInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClass.kt");
        }

        @TestMetadata("useThisInsideInlineClass.kt")
        public void testUseThisInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReferences extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCallableReferences() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/callableReferences"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boundInlineClassExtensionFun.kt")
            public void testBoundInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionFun.kt");
            }

            @TestMetadata("boundInlineClassExtensionVal.kt")
            public void testBoundInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassExtensionVal.kt");
            }

            @TestMetadata("boundInlineClassMemberFun.kt")
            public void testBoundInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberFun.kt");
            }

            @TestMetadata("boundInlineClassMemberVal.kt")
            public void testBoundInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassMemberVal.kt");
            }

            @TestMetadata("boundInlineClassPrimaryVal.kt")
            public void testBoundInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/boundInlineClassPrimaryVal.kt");
            }

            @TestMetadata("constructorWithInlineClassParameters.kt")
            public void testConstructorWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/constructorWithInlineClassParameters.kt");
            }

            @TestMetadata("funWithInlineClassParameters.kt")
            public void testFunWithInlineClassParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/funWithInlineClassParameters.kt");
            }

            @TestMetadata("inlineClassExtensionFun.kt")
            public void testInlineClassExtensionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionFun.kt");
            }

            @TestMetadata("inlineClassExtensionVal.kt")
            public void testInlineClassExtensionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassExtensionVal.kt");
            }

            @TestMetadata("inlineClassInternalPrimaryVal.kt")
            public void testInlineClassInternalPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassInternalPrimaryVal.kt");
            }

            @TestMetadata("inlineClassMemberFun.kt")
            public void testInlineClassMemberFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberFun.kt");
            }

            @TestMetadata("inlineClassMemberVal.kt")
            public void testInlineClassMemberVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassMemberVal.kt");
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryConstructor.kt");
            }

            @TestMetadata("inlineClassPrimaryVal.kt")
            public void testInlineClassPrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrimaryVal.kt");
            }

            @TestMetadata("inlineClassPrivatePrimaryVal.kt")
            public void testInlineClassPrivatePrimaryVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassPrivatePrimaryVal.kt");
            }

            @TestMetadata("inlineClassTypeBoundMemberVar.kt")
            public void testInlineClassTypeBoundMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeBoundMemberVar.kt");
            }

            @TestMetadata("inlineClassTypeMemberVar.kt")
            public void testInlineClassTypeMemberVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeMemberVar.kt");
            }

            @TestMetadata("inlineClassTypeTopLevelVar.kt")
            public void testInlineClassTypeTopLevelVar() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/callableReferences/inlineClassTypeTopLevelVar.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ContextsAndAccessors extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod.kt")
            public void testAccessPrivateInlineClassCompanionMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod.kt");
            }

            @TestMetadata("accessPrivateInlineClassCompanionMethod2.kt")
            public void testAccessPrivateInlineClassCompanionMethod2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassCompanionMethod2.kt");
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromCompanion.kt")
            public void testAccessPrivateInlineClassConstructorFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromCompanion.kt");
            }

            @TestMetadata("accessPrivateInlineClassConstructorFromLambda.kt")
            public void testAccessPrivateInlineClassConstructorFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassConstructorFromLambda.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromCompanion2.kt")
            public void testAccessPrivateInlineClassMethodFromCompanion2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromCompanion2.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromInlineLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromInlineLambda2.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda.kt")
            public void testAccessPrivateInlineClassMethodFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda.kt");
            }

            @TestMetadata("accessPrivateInlineClassMethodFromLambda2.kt")
            public void testAccessPrivateInlineClassMethodFromLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateInlineClassMethodFromLambda2.kt");
            }

            @TestMetadata("accessPrivateStaticInlineClassCompanionMethod.kt")
            public void testAccessPrivateStaticInlineClassCompanionMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/accessPrivateStaticInlineClassCompanionMethod.kt");
            }

            public void testAllFilesPresentInContextsAndAccessors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("captureInlineClassInstanceInLambda.kt")
            public void testCaptureInlineClassInstanceInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda.kt");
            }

            @TestMetadata("captureInlineClassInstanceInLambda2.kt")
            public void testCaptureInlineClassInstanceInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInLambda2.kt");
            }

            @TestMetadata("captureInlineClassInstanceInObject.kt")
            public void testCaptureInlineClassInstanceInObject() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/captureInlineClassInstanceInObject.kt");
            }

            @TestMetadata("inlineLambdaInInlineClassFun.kt")
            public void testInlineLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/inlineLambdaInInlineClassFun.kt");
            }

            @TestMetadata("kt26858.kt")
            public void testKt26858() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt26858.kt");
            }

            @TestMetadata("kt27513.kt")
            public void testKt27513() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/kt27513.kt");
            }

            @TestMetadata("lambdaInInlineClassFun.kt")
            public void testLambdaInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/lambdaInInlineClassFun.kt");
            }

            @TestMetadata("objectInInlineClassFun.kt")
            public void testObjectInInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/objectInInlineClassFun.kt");
            }

            @TestMetadata("toPrivateCompanionFun.kt")
            public void testToPrivateCompanionFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionFun.kt");
            }

            @TestMetadata("toPrivateCompanionVal.kt")
            public void testToPrivateCompanionVal() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/contextsAndAccessors/toPrivateCompanionVal.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/defaultParameterValues")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultParameterValues extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultParameterValues() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/defaultParameterValues"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("defaultConstructorParameterValuesOfInlineClassType.kt")
            public void testDefaultConstructorParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultConstructorParameterValuesOfInlineClassType.kt");
            }

            @TestMetadata("defaultInterfaceFunParameterValuesOfInlineClassType.kt")
            public void testDefaultInterfaceFunParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultInterfaceFunParameterValuesOfInlineClassType.kt");
            }

            @TestMetadata("defaultParameterValuesOfInlineClassType.kt")
            public void testDefaultParameterValuesOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassType.kt");
            }

            @TestMetadata("defaultParameterValuesOfInlineClassTypeBoxing.kt")
            public void testDefaultParameterValuesOfInlineClassTypeBoxing() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultParameterValuesOfInlineClassTypeBoxing.kt");
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFun.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFun.kt");
            }

            @TestMetadata("defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt")
            public void testDefaultValueOfInlineClassTypeInInlineFunInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/defaultValueOfInlineClassTypeInInlineFunInInlineClass.kt");
            }

            @TestMetadata("inlineClassFun.kt")
            public void testInlineClassFun() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassFun.kt");
            }

            @TestMetadata("inlineClassPrimaryConstructor.kt")
            public void testInlineClassPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassPrimaryConstructor.kt");
            }

            @TestMetadata("inlineClassSecondaryConstructor.kt")
            public void testInlineClassSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/inlineClassSecondaryConstructor.kt");
            }

            @TestMetadata("kt26554.kt")
            public void testKt26554() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt26554.kt");
            }

            @TestMetadata("kt27416.kt")
            public void testKt27416() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/defaultParameterValues/kt27416.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/functionNameMangling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionNameMangling extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionNameMangling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/functionNameMangling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("anonymousObjectInFunctionWithMangledName.kt")
            public void testAnonymousObjectInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/anonymousObjectInFunctionWithMangledName.kt");
            }

            @TestMetadata("extensionFunctionsDoNotClash.kt")
            public void testExtensionFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/extensionFunctionsDoNotClash.kt");
            }

            @TestMetadata("functionsWithDifferentNullabilityDoNotClash.kt")
            public void testFunctionsWithDifferentNullabilityDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/functionsWithDifferentNullabilityDoNotClash.kt");
            }

            @TestMetadata("genericFunctionsDoNotClash.kt")
            public void testGenericFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericFunctionsDoNotClash.kt");
            }

            @TestMetadata("genericSignatureOfFunctionWithMangledName.kt")
            public void testGenericSignatureOfFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/genericSignatureOfFunctionWithMangledName.kt");
            }

            @TestMetadata("localClassInFunctionWithMangledName.kt")
            public void testLocalClassInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/localClassInFunctionWithMangledName.kt");
            }

            @TestMetadata("mangledFunctionsCanBeOverridden.kt")
            public void testMangledFunctionsCanBeOverridden() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsCanBeOverridden.kt");
            }

            @TestMetadata("mangledFunctionsDoNotClash.kt")
            public void testMangledFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsDoNotClash.kt");
            }

            @TestMetadata("mangledFunctionsPresentInStackTrace.kt")
            public void testMangledFunctionsPresentInStackTrace() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mangledFunctionsPresentInStackTrace.kt");
            }

            @TestMetadata("mixedSignatureFunctionsDoNotClash.kt")
            public void testMixedSignatureFunctionsDoNotClash() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/mixedSignatureFunctionsDoNotClash.kt");
            }

            @TestMetadata("overridingMethodInGenericClass.kt")
            public void testOverridingMethodInGenericClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClass.kt");
            }

            @TestMetadata("overridingMethodInGenericClass2.kt")
            public void testOverridingMethodInGenericClass2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/overridingMethodInGenericClass2.kt");
            }

            @TestMetadata("propertySetterWithInlineClassTypeArgument.kt")
            public void testPropertySetterWithInlineClassTypeArgument() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/propertySetterWithInlineClassTypeArgument.kt");
            }

            @TestMetadata("reflectionForFunctionWithMangledName.kt")
            public void testReflectionForFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForFunctionWithMangledName.kt");
            }

            @TestMetadata("reflectionForLocalClassInFunctionWithMangledName.kt")
            public void testReflectionForLocalClassInFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForLocalClassInFunctionWithMangledName.kt");
            }

            @TestMetadata("reflectionForPropertyOfInlineClassType.kt")
            public void testReflectionForPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/reflectionForPropertyOfInlineClassType.kt");
            }

            @TestMetadata("syntheticAccessorForFunctionWithMangledName.kt")
            public void testSyntheticAccessorForFunctionWithMangledName() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorForFunctionWithMangledName.kt");
            }

            @TestMetadata("syntheticAccessorsForPropertyOfInlineClassType.kt")
            public void testSyntheticAccessorsForPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/functionNameMangling/syntheticAccessorsForPropertyOfInlineClassType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/hiddenConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HiddenConstructor extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInHiddenConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/hiddenConstructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultParameters.kt")
            public void testConstructorWithDefaultParameters() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/constructorWithDefaultParameters.kt");
            }

            @TestMetadata("delegatingSuperConstructorCall.kt")
            public void testDelegatingSuperConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCall.kt");
            }

            @TestMetadata("delegatingSuperConstructorCallInSecondaryConstructor.kt")
            public void testDelegatingSuperConstructorCallInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingSuperConstructorCallInSecondaryConstructor.kt");
            }

            @TestMetadata("delegatingThisConstructorCall.kt")
            public void testDelegatingThisConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/delegatingThisConstructorCall.kt");
            }

            @TestMetadata("enumClassConstructor.kt")
            public void testEnumClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/enumClassConstructor.kt");
            }

            @TestMetadata("innerClassConstructor.kt")
            public void testInnerClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/innerClassConstructor.kt");
            }

            @TestMetadata("kt28855.kt")
            public void testKt28855() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/kt28855.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/primaryConstructor.kt");
            }

            @TestMetadata("privateConstructor.kt")
            public void testPrivateConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/privateConstructor.kt");
            }

            @TestMetadata("sealedClassConstructor.kt")
            public void testSealedClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/sealedClassConstructor.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/hiddenConstructor/secondaryConstructor.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InterfaceMethodCalls extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInterfaceMethodCalls() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("defaultInterfaceExtensionFunCall.kt")
            public void testDefaultInterfaceExtensionFunCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceExtensionFunCall.kt");
            }

            @TestMetadata("defaultInterfaceMethodCall.kt")
            public void testDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/defaultInterfaceMethodCall.kt");
            }

            @TestMetadata("genericDefaultInterfaceExtensionFunCall.kt")
            public void testGenericDefaultInterfaceExtensionFunCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceExtensionFunCall.kt");
            }

            @TestMetadata("genericDefaultInterfaceMethodCall.kt")
            public void testGenericDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericDefaultInterfaceMethodCall.kt");
            }

            @TestMetadata("genericInterfaceMethodCall.kt")
            public void testGenericInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/genericInterfaceMethodCall.kt");
            }

            @TestMetadata("overriddenDefaultInterfaceMethodCall.kt")
            public void testOverriddenDefaultInterfaceMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/interfaceMethodCalls/overriddenDefaultInterfaceMethodCall.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/inlineClasses/propertyDelegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyDelegation extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInPropertyDelegation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/propertyDelegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("captureLocalVarDelegatedToInlineClass.kt")
            public void testCaptureLocalVarDelegatedToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/captureLocalVarDelegatedToInlineClass.kt");
            }

            @TestMetadata("delegateClassVarToInlineClass.kt")
            public void testDelegateClassVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClass.kt");
            }

            @TestMetadata("delegateClassVarToInlineClassWithProvideDelegate.kt")
            public void testDelegateClassVarToInlineClassWithProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateClassVarToInlineClassWithProvideDelegate.kt");
            }

            @TestMetadata("delegateCompanionVarToInlineClass.kt")
            public void testDelegateCompanionVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateCompanionVarToInlineClass.kt");
            }

            @TestMetadata("delegateJvmStaticCompanionVarToInlineClass.kt")
            public void testDelegateJvmStaticCompanionVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateJvmStaticCompanionVarToInlineClass.kt");
            }

            @TestMetadata("delegateLocalVarToInlineClass.kt")
            public void testDelegateLocalVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateLocalVarToInlineClass.kt");
            }

            @TestMetadata("delegateObjectVarToInlineClass.kt")
            public void testDelegateObjectVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateObjectVarToInlineClass.kt");
            }

            @TestMetadata("delegatePrivateCompanionVarToInlineClass.kt")
            public void testDelegatePrivateCompanionVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatePrivateCompanionVarToInlineClass.kt");
            }

            @TestMetadata("delegateTopLevelVarToInlineClass.kt")
            public void testDelegateTopLevelVarToInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegateTopLevelVarToInlineClass.kt");
            }

            @TestMetadata("delegatedPropertyOfInlineClassType.kt")
            public void testDelegatedPropertyOfInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/delegatedPropertyOfInlineClassType.kt");
            }

            @TestMetadata("kt27070.kt")
            public void testKt27070() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/propertyDelegation/kt27070.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/innerNested")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerNested extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInnerNested() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/innerNested"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("createNestedClass.kt")
        public void testCreateNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/createNestedClass.kt");
        }

        @TestMetadata("createdNestedInOuterMember.kt")
        public void testCreatedNestedInOuterMember() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/createdNestedInOuterMember.kt");
        }

        @TestMetadata("extensionFun.kt")
        public void testExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/extensionFun.kt");
        }

        @TestMetadata("extensionToNested.kt")
        public void testExtensionToNested() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/extensionToNested.kt");
        }

        @TestMetadata("importNestedClass.kt")
        public void testImportNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/importNestedClass.kt");
        }

        @TestMetadata("innerGeneric.kt")
        public void testInnerGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerGeneric.kt");
        }

        @TestMetadata("innerGenericClassFromJava.kt")
        public void testInnerGenericClassFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerGenericClassFromJava.kt");
        }

        @TestMetadata("innerJavaClass.kt")
        public void testInnerJavaClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerJavaClass.kt");
        }

        @TestMetadata("innerLabeledThis.kt")
        public void testInnerLabeledThis() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerLabeledThis.kt");
        }

        @TestMetadata("innerSimple.kt")
        public void testInnerSimple() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/innerSimple.kt");
        }

        @TestMetadata("kt3132.kt")
        public void testKt3132() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt3132.kt");
        }

        @TestMetadata("kt3927.kt")
        public void testKt3927() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt3927.kt");
        }

        @TestMetadata("kt5363.kt")
        public void testKt5363() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt5363.kt");
        }

        @TestMetadata("kt6804.kt")
        public void testKt6804() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/kt6804.kt");
        }

        @TestMetadata("nestedClassInObject.kt")
        public void testNestedClassInObject() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedClassInObject.kt");
        }

        @TestMetadata("nestedClassObject.kt")
        public void testNestedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedClassObject.kt");
        }

        @TestMetadata("nestedEnumConstant.kt")
        public void testNestedEnumConstant() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedEnumConstant.kt");
        }

        @TestMetadata("nestedGeneric.kt")
        public void testNestedGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedGeneric.kt");
        }

        @TestMetadata("nestedInPackage.kt")
        public void testNestedInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedInPackage.kt");
        }

        @TestMetadata("nestedObjects.kt")
        public void testNestedObjects() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedObjects.kt");
        }

        @TestMetadata("nestedSimple.kt")
        public void testNestedSimple() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/nestedSimple.kt");
        }

        @TestMetadata("passingOuterRef.kt")
        public void testPassingOuterRef() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/passingOuterRef.kt");
        }

        @TestMetadata("protectedNestedClass.kt")
        public void testProtectedNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/protectedNestedClass.kt");
        }

        @TestMetadata("protectedNestedClassFromJava.kt")
        public void testProtectedNestedClassFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/innerNested/protectedNestedClassFromJava.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuperConstructorCall extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSuperConstructorCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/innerNested/superConstructorCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("deepInnerHierarchy.kt")
            public void testDeepInnerHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/deepInnerHierarchy.kt");
            }

            @TestMetadata("deepLocalHierarchy.kt")
            public void testDeepLocalHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/deepLocalHierarchy.kt");
            }

            @TestMetadata("innerExtendsInnerViaSecondaryConstuctor.kt")
            public void testInnerExtendsInnerViaSecondaryConstuctor() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerViaSecondaryConstuctor.kt");
            }

            @TestMetadata("innerExtendsInnerWithProperOuterCapture.kt")
            public void testInnerExtendsInnerWithProperOuterCapture() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerWithProperOuterCapture.kt");
            }

            @TestMetadata("innerExtendsOuter.kt")
            public void testInnerExtendsOuter() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsOuter.kt");
            }

            @TestMetadata("kt11833_1.kt")
            public void testKt11833_1() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_1.kt");
            }

            @TestMetadata("kt11833_2.kt")
            public void testKt11833_2() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_2.kt");
            }

            @TestMetadata("localClassOuterDiffersFromInnerOuter.kt")
            public void testLocalClassOuterDiffersFromInnerOuter() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localClassOuterDiffersFromInnerOuter.kt");
            }

            @TestMetadata("localExtendsInner.kt")
            public void testLocalExtendsInner() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsInner.kt");
            }

            @TestMetadata("localExtendsLocalWithClosure.kt")
            public void testLocalExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsLocalWithClosure.kt");
            }

            @TestMetadata("localWithClosureExtendsLocalWithClosure.kt")
            public void testLocalWithClosureExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/localWithClosureExtendsLocalWithClosure.kt");
            }

            @TestMetadata("objectExtendsClassDefaultArgument.kt")
            public void testObjectExtendsClassDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassDefaultArgument.kt");
            }

            @TestMetadata("objectExtendsClassVararg.kt")
            public void testObjectExtendsClassVararg() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassVararg.kt");
            }

            @TestMetadata("objectExtendsInner.kt")
            public void testObjectExtendsInner() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInner.kt");
            }

            @TestMetadata("objectExtendsInnerDefaultArgument.kt")
            public void testObjectExtendsInnerDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerDefaultArgument.kt");
            }

            @TestMetadata("objectExtendsInnerOfLocalVarargAndDefault.kt")
            public void testObjectExtendsInnerOfLocalVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalVarargAndDefault.kt");
            }

            @TestMetadata("objectExtendsInnerOfLocalWithCapture.kt")
            public void testObjectExtendsInnerOfLocalWithCapture() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalWithCapture.kt");
            }

            @TestMetadata("objectExtendsLocalCaptureInSuperCall.kt")
            public void testObjectExtendsLocalCaptureInSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalCaptureInSuperCall.kt");
            }

            @TestMetadata("objectExtendsLocalWithClosure.kt")
            public void testObjectExtendsLocalWithClosure() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalWithClosure.kt");
            }

            @TestMetadata("objectExtendsLocal_kt16858.kt")
            public void testObjectExtendsLocal_kt16858() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocal_kt16858.kt");
            }

            @TestMetadata("objectOuterDiffersFromInnerOuter.kt")
            public void testObjectOuterDiffersFromInnerOuter() throws Exception {
                runTest("compiler/testData/codegen/box/innerNested/superConstructorCall/objectOuterDiffersFromInnerOuter.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/instructions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Instructions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInInstructions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/instructions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/instructions/swap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Swap extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInSwap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/instructions/swap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("swapRefToSharedVarInt.kt")
            public void testSwapRefToSharedVarInt() throws Exception {
                runTest("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarInt.kt");
            }

            @TestMetadata("swapRefToSharedVarLong.kt")
            public void testSwapRefToSharedVarLong() throws Exception {
                runTest("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarLong.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Intrinsics extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIntrinsics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/intrinsics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charToInt.kt")
        public void testCharToInt() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/charToInt.kt");
        }

        @TestMetadata("defaultObjectMapping.kt")
        public void testDefaultObjectMapping() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/defaultObjectMapping.kt");
        }

        @TestMetadata("ea35953.kt")
        public void testEa35953() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/ea35953.kt");
        }

        @TestMetadata("incWithLabel.kt")
        public void testIncWithLabel() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/incWithLabel.kt");
        }

        @TestMetadata("javaObjectType.kt")
        public void testJavaObjectType() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/javaObjectType.kt");
        }

        @TestMetadata("javaPrimitiveType.kt")
        public void testJavaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/javaPrimitiveType.kt");
        }

        @TestMetadata("kt10131.kt")
        public void testKt10131() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt10131.kt");
        }

        @TestMetadata("kt10131a.kt")
        public void testKt10131a() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt10131a.kt");
        }

        @TestMetadata("kt12125.kt")
        public void testKt12125() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125.kt");
        }

        @TestMetadata("kt12125_2.kt")
        public void testKt12125_2() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_2.kt");
        }

        @TestMetadata("kt12125_inc.kt")
        public void testKt12125_inc() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_inc.kt");
        }

        @TestMetadata("kt12125_inc_2.kt")
        public void testKt12125_inc_2() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt12125_inc_2.kt");
        }

        @TestMetadata("kt5937.kt")
        public void testKt5937() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt5937.kt");
        }

        @TestMetadata("kt8666.kt")
        public void testKt8666() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/kt8666.kt");
        }

        @TestMetadata("longRangeWithExplicitDot.kt")
        public void testLongRangeWithExplicitDot() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/longRangeWithExplicitDot.kt");
        }

        @TestMetadata("prefixIncDec.kt")
        public void testPrefixIncDec() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/prefixIncDec.kt");
        }

        @TestMetadata("rangeFromCollection.kt")
        public void testRangeFromCollection() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/rangeFromCollection.kt");
        }

        @TestMetadata("stringFromCollection.kt")
        public void testStringFromCollection() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/stringFromCollection.kt");
        }

        @TestMetadata("throwable.kt")
        public void testThrowable() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwable.kt");
        }

        @TestMetadata("throwableCallableReference.kt")
        public void testThrowableCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwableCallableReference.kt");
        }

        @TestMetadata("throwableParamOrder.kt")
        public void testThrowableParamOrder() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/throwableParamOrder.kt");
        }

        @TestMetadata("tostring.kt")
        public void testTostring() throws Exception {
            runTest("compiler/testData/codegen/box/intrinsics/tostring.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ir")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ir extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInIr() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ir"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("classInitializers.kt")
        public void testClassInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/ir/classInitializers.kt");
        }

        @TestMetadata("enumClass.kt")
        public void testEnumClass() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass.kt");
        }

        @TestMetadata("enumClass2.kt")
        public void testEnumClass2() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass2.kt");
        }

        @TestMetadata("enumClass3.kt")
        public void testEnumClass3() throws Exception {
            runTest("compiler/testData/codegen/box/ir/enumClass3.kt");
        }

        @TestMetadata("fileClassInitializers.kt")
        public void testFileClassInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/ir/fileClassInitializers.kt");
        }

        @TestMetadata("kt25405.kt")
        public void testKt25405() throws Exception {
            runTest("compiler/testData/codegen/box/ir/kt25405.kt");
        }

        @TestMetadata("kt29833.kt")
        public void testKt29833() throws Exception {
            runTest("compiler/testData/codegen/box/ir/kt29833.kt");
        }

        @TestMetadata("objectClass.kt")
        public void testObjectClass() throws Exception {
            runTest("compiler/testData/codegen/box/ir/objectClass.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/ir/simple.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/ir/closureConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureConversion extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInClosureConversion() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ir/closureConversion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("closureConversion1.kt")
            public void testClosureConversion1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion1.kt");
            }

            @TestMetadata("closureConversion2.kt")
            public void testClosureConversion2() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion2.kt");
            }

            @TestMetadata("closureConversion3.kt")
            public void testClosureConversion3() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion3.kt");
            }

            @TestMetadata("closureConversion4.kt")
            public void testClosureConversion4() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/closureConversion4.kt");
            }

            @TestMetadata("innerClass1.kt")
            public void testInnerClass1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/innerClass1.kt");
            }

            @TestMetadata("innerClass2.kt")
            public void testInnerClass2() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/innerClass2.kt");
            }

            @TestMetadata("mutable1.kt")
            public void testMutable1() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/mutable1.kt");
            }

            @TestMetadata("mutablePrimitives.kt")
            public void testMutablePrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/ir/closureConversion/mutablePrimitives.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ir/primitiveNumberComparisons")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrimitiveNumberComparisons extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInPrimitiveNumberComparisons() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ir/primitiveNumberComparisons"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("comparableToDouble.kt")
            public void testComparableToDouble() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/comparableToDouble.kt");
            }

            @TestMetadata("doubleEqeq.kt")
            public void testDoubleEqeq() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/doubleEqeq.kt");
            }

            @TestMetadata("floatEqeq.kt")
            public void testFloatEqeq() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/floatEqeq.kt");
            }

            @TestMetadata("mixedNumberTypes.kt")
            public void testMixedNumberTypes() throws Exception {
                runTest("compiler/testData/codegen/box/ir/primitiveNumberComparisons/mixedNumberTypes.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaInterop extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJavaInterop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericSamProjectedOut.kt")
        public void testGenericSamProjectedOut() throws Exception {
            runTest("compiler/testData/codegen/box/javaInterop/genericSamProjectedOut.kt");
        }

        @TestMetadata("lambdaInstanceOf.kt")
        public void testLambdaInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/javaInterop/lambdaInstanceOf.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/generics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Generics extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInGenerics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/generics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("allWildcardsOnClass.kt")
            public void testAllWildcardsOnClass() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/generics/allWildcardsOnClass.kt");
            }

            @TestMetadata("covariantOverrideWithDeclarationSiteProjection.kt")
            public void testCovariantOverrideWithDeclarationSiteProjection() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/generics/covariantOverrideWithDeclarationSiteProjection.kt");
            }

            @TestMetadata("invariantArgumentsNoWildcard.kt")
            public void testInvariantArgumentsNoWildcard() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/generics/invariantArgumentsNoWildcard.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotNullAssertions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNotNullAssertions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("destructuringAssignmentWithNullabilityAssertionOnExtensionReceiver_lv12.kt")
            public void testDestructuringAssignmentWithNullabilityAssertionOnExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/destructuringAssignmentWithNullabilityAssertionOnExtensionReceiver_lv12.kt");
            }

            @TestMetadata("extensionReceiverParameter.kt")
            public void testExtensionReceiverParameter() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/extensionReceiverParameter.kt");
            }

            @TestMetadata("functionAssertion.kt")
            public void testFunctionAssertion() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/functionAssertion.kt");
            }

            @TestMetadata("functionWithBigArity.kt")
            public void testFunctionWithBigArity() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/functionWithBigArity.kt");
            }

            @TestMetadata("incWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv11.kt")
            public void testIncWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv11() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/incWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv11.kt");
            }

            @TestMetadata("incWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv12.kt")
            public void testIncWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/incWithNullabilityAssertionOnExtensionReceiverInPrivateOperator_lv12.kt");
            }

            @TestMetadata("incWithNullabilityAssertionOnExtensionReceiver_lv11.kt")
            public void testIncWithNullabilityAssertionOnExtensionReceiver_lv11() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/incWithNullabilityAssertionOnExtensionReceiver_lv11.kt");
            }

            @TestMetadata("incWithNullabilityAssertionOnExtensionReceiver_lv12.kt")
            public void testIncWithNullabilityAssertionOnExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/incWithNullabilityAssertionOnExtensionReceiver_lv12.kt");
            }

            @TestMetadata("mapPut.kt")
            public void testMapPut() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/mapPut.kt");
            }

            @TestMetadata("nullabilityAssertionOnExtensionReceiver_lv11.kt")
            public void testNullabilityAssertionOnExtensionReceiver_lv11() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnExtensionReceiver_lv11.kt");
            }

            @TestMetadata("nullabilityAssertionOnExtensionReceiver_lv12.kt")
            public void testNullabilityAssertionOnExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnExtensionReceiver_lv12.kt");
            }

            @TestMetadata("nullabilityAssertionOnInlineFunExtensionReceiver_lv11.kt")
            public void testNullabilityAssertionOnInlineFunExtensionReceiver_lv11() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnInlineFunExtensionReceiver_lv11.kt");
            }

            @TestMetadata("nullabilityAssertionOnInlineFunExtensionReceiver_lv12.kt")
            public void testNullabilityAssertionOnInlineFunExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnInlineFunExtensionReceiver_lv12.kt");
            }

            @TestMetadata("nullabilityAssertionOnMemberExtensionReceiver_lv12.kt")
            public void testNullabilityAssertionOnMemberExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnMemberExtensionReceiver_lv12.kt");
            }

            @TestMetadata("nullabilityAssertionOnPrivateMemberExtensionReceiver_lv12.kt")
            public void testNullabilityAssertionOnPrivateMemberExtensionReceiver_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/nullabilityAssertionOnPrivateMemberExtensionReceiver_lv12.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EnhancedNullability extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInEnhancedNullability() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("inFunctionWithExpressionBody.kt")
                public void testInFunctionWithExpressionBody() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inFunctionWithExpressionBody.kt");
                }

                @TestMetadata("inFunctionWithExpressionBodyWithJavaGeneric.kt")
                public void testInFunctionWithExpressionBodyWithJavaGeneric() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inFunctionWithExpressionBodyWithJavaGeneric.kt");
                }

                @TestMetadata("inLocalFunctionWithExpressionBody.kt")
                public void testInLocalFunctionWithExpressionBody() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inLocalFunctionWithExpressionBody.kt");
                }

                @TestMetadata("inLocalVariableInitializer.kt")
                public void testInLocalVariableInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inLocalVariableInitializer.kt");
                }

                @TestMetadata("inMemberPropertyInitializer.kt")
                public void testInMemberPropertyInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inMemberPropertyInitializer.kt");
                }

                @TestMetadata("inPropertyGetterWithExpressionBody.kt")
                public void testInPropertyGetterWithExpressionBody() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inPropertyGetterWithExpressionBody.kt");
                }

                @TestMetadata("inTopLevelPropertyInitializer.kt")
                public void testInTopLevelPropertyInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/javaInterop/notNullAssertions/enhancedNullability/inTopLevelPropertyInitializer.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/objectMethods")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ObjectMethods extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInObjectMethods() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/objectMethods"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("cloneCallsConstructor.kt")
            public void testCloneCallsConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsConstructor.kt");
            }

            @TestMetadata("cloneCallsSuper.kt")
            public void testCloneCallsSuper() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuper.kt");
            }

            @TestMetadata("cloneCallsSuperAndModifies.kt")
            public void testCloneCallsSuperAndModifies() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuperAndModifies.kt");
            }

            @TestMetadata("cloneHashSet.kt")
            public void testCloneHashSet() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneHashSet.kt");
            }

            @TestMetadata("cloneHierarchy.kt")
            public void testCloneHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneHierarchy.kt");
            }

            @TestMetadata("cloneableClassWithoutClone.kt")
            public void testCloneableClassWithoutClone() throws Exception {
                runTest("compiler/testData/codegen/box/javaInterop/objectMethods/cloneableClassWithoutClone.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jdk extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJdk() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jdk"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayList.kt")
        public void testArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/arrayList.kt");
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/hashMap.kt");
        }

        @TestMetadata("iteratingOverHashMap.kt")
        public void testIteratingOverHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/iteratingOverHashMap.kt");
        }

        @TestMetadata("kt1397.kt")
        public void testKt1397() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/kt1397.kt");
        }

        @TestMetadata("removeIf.kt")
        public void testRemoveIf() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/removeIf.kt");
        }

        @TestMetadata("stream.kt")
        public void testStream() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/stream.kt");
        }

        @TestMetadata("streamBackwardCompatibility.kt")
        public void testStreamBackwardCompatibility() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/streamBackwardCompatibility.kt");
        }

        @TestMetadata("useStream.kt")
        public void testUseStream() throws Exception {
            runTest("compiler/testData/codegen/box/jdk/useStream.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm8 extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvm8() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bridgeInClass.kt")
        public void testBridgeInClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/bridgeInClass.kt");
        }

        @TestMetadata("bridgeInInterface.kt")
        public void testBridgeInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/bridgeInInterface.kt");
        }

        @TestMetadata("capturedSuperCall.kt")
        public void testCapturedSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/capturedSuperCall.kt");
        }

        @TestMetadata("defaultArgs.kt")
        public void testDefaultArgs() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/defaultArgs.kt");
        }

        @TestMetadata("inlineFromAnotherFile.kt")
        public void testInlineFromAnotherFile() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/inlineFromAnotherFile.kt");
        }

        @TestMetadata("inlineFromStdlib.kt")
        public void testInlineFromStdlib() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/inlineFromStdlib.kt");
        }

        @TestMetadata("kt11969.kt")
        public void testKt11969() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt11969.kt");
        }

        @TestMetadata("kt14243.kt")
        public void testKt14243() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt14243.kt");
        }

        @TestMetadata("kt14243_2.kt")
        public void testKt14243_2() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt14243_2.kt");
        }

        @TestMetadata("kt14243_prop.kt")
        public void testKt14243_prop() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt14243_prop.kt");
        }

        @TestMetadata("kt16581.kt")
        public void testKt16581() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt16581.kt");
        }

        @TestMetadata("kt16581_2.kt")
        public void testKt16581_2() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt16581_2.kt");
        }

        @TestMetadata("kt16588.kt")
        public void testKt16588() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt16588.kt");
        }

        @TestMetadata("kt6301.kt")
        public void testKt6301() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt6301.kt");
        }

        @TestMetadata("kt6301_2.kt")
        public void testKt6301_2() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/kt6301_2.kt");
        }

        @TestMetadata("oneImplementation.kt")
        public void testOneImplementation() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/oneImplementation.kt");
        }

        @TestMetadata("oneImplementation2.kt")
        public void testOneImplementation2() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/oneImplementation2.kt");
        }

        @TestMetadata("simpleCall.kt")
        public void testSimpleCall() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/simpleCall.kt");
        }

        @TestMetadata("simpleProperty.kt")
        public void testSimpleProperty() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/simpleProperty.kt");
        }

        @TestMetadata("treeMapBridge.kt")
        public void testTreeMapBridge() throws Exception {
            runTest("compiler/testData/codegen/box/jvm8/treeMapBridge.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/defaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Defaults extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessor.kt")
            public void testAccessor() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/accessor.kt");
            }

            @TestMetadata("accessorFromCompanion.kt")
            public void testAccessorFromCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/accessorFromCompanion.kt");
            }

            @TestMetadata("accessorsFromDefaultImpls.kt")
            public void testAccessorsFromDefaultImpls() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/accessorsFromDefaultImpls.kt");
            }

            public void testAllFilesPresentInDefaults() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("bridgeInClass.kt")
            public void testBridgeInClass() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeInClass.kt");
            }

            @TestMetadata("bridgeInInterface.kt")
            public void testBridgeInInterface() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeInInterface.kt");
            }

            @TestMetadata("bridgeInInterface2.kt")
            public void testBridgeInInterface2() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeInInterface2.kt");
            }

            @TestMetadata("bridgeInInterfaceWithProperties.kt")
            public void testBridgeInInterfaceWithProperties() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeInInterfaceWithProperties.kt");
            }

            @TestMetadata("bridgeInInterfaceWithProperties2.kt")
            public void testBridgeInInterfaceWithProperties2() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeInInterfaceWithProperties2.kt");
            }

            @TestMetadata("bridgeWithJava.kt")
            public void testBridgeWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/bridgeWithJava.kt");
            }

            @TestMetadata("callableReference.kt")
            public void testCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/callableReference.kt");
            }

            @TestMetadata("capturedSuperCall.kt")
            public void testCapturedSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/capturedSuperCall.kt");
            }

            @TestMetadata("defaultArgs.kt")
            public void testDefaultArgs() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/defaultArgs.kt");
            }

            @TestMetadata("diamond.kt")
            public void testDiamond() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/diamond.kt");
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/inline.kt");
            }

            @TestMetadata("inlineProperty.kt")
            public void testInlineProperty() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/inlineProperty.kt");
            }

            @TestMetadata("kt11969.kt")
            public void testKt11969() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/kt11969.kt");
            }

            @TestMetadata("kt14243.kt")
            public void testKt14243() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/kt14243.kt");
            }

            @TestMetadata("kt14243_2.kt")
            public void testKt14243_2() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/kt14243_2.kt");
            }

            @TestMetadata("kt14243_prop.kt")
            public void testKt14243_prop() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/kt14243_prop.kt");
            }

            @TestMetadata("oneImplementation.kt")
            public void testOneImplementation() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/oneImplementation.kt");
            }

            @TestMetadata("oneImplementation2.kt")
            public void testOneImplementation2() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/oneImplementation2.kt");
            }

            @TestMetadata("privateDefaultFromDefaultImpl.kt")
            public void testPrivateDefaultFromDefaultImpl() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/privateDefaultFromDefaultImpl.kt");
            }

            @TestMetadata("privateInDefaultImpls.kt")
            public void testPrivateInDefaultImpls() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/privateInDefaultImpls.kt");
            }

            @TestMetadata("simpleCall.kt")
            public void testSimpleCall() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/simpleCall.kt");
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/simpleProperty.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/defaults/superCall.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/compatibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Compatibility extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInCompatibility() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/compatibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("bridge.kt")
                public void testBridge() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridge.kt");
                }

                @TestMetadata("bridge2.kt")
                public void testBridge2() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridge2.kt");
                }

                @TestMetadata("bridge3.kt")
                public void testBridge3() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridge3.kt");
                }

                @TestMetadata("bridgeWithProperties.kt")
                public void testBridgeWithProperties() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridgeWithProperties.kt");
                }

                @TestMetadata("bridgeWithProperties2.kt")
                public void testBridgeWithProperties2() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridgeWithProperties2.kt");
                }

                @TestMetadata("bridgeWithProperties3.kt")
                public void testBridgeWithProperties3() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/bridgeWithProperties3.kt");
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/defaultArgs.kt");
                }

                @TestMetadata("inheritedJvmDefault.kt")
                public void testInheritedJvmDefault() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/inheritedJvmDefault.kt");
                }

                @TestMetadata("propertyAnnotation.kt")
                public void testPropertyAnnotation() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/propertyAnnotation.kt");
                }

                @TestMetadata("simpleFunction.kt")
                public void testSimpleFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/compatibility/simpleFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/delegationBy")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegationBy extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInDelegationBy() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/delegationBy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/delegationBy/simple.kt");
                }

                @TestMetadata("simpleProperty.kt")
                public void testSimpleProperty() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/delegationBy/simpleProperty.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/noDelegation")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NoDelegation extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInNoDelegation() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/noDelegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("noDelegationToDefaultMethodInClass.kt")
                public void testNoDelegationToDefaultMethodInClass() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/noDelegation/noDelegationToDefaultMethodInClass.kt");
                }

                @TestMetadata("noDelegationToDefaultMethodInInterface.kt")
                public void testNoDelegationToDefaultMethodInInterface() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/noDelegation/noDelegationToDefaultMethodInInterface.kt");
                }

                @TestMetadata("noDelegationToDefaultMethodInInterface2.kt")
                public void testNoDelegationToDefaultMethodInInterface2() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/noDelegation/noDelegationToDefaultMethodInInterface2.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/jvm8/defaults/reflection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Reflection extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInReflection() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/defaults/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("propertyAnnotations.kt")
                public void testPropertyAnnotations() throws Exception {
                    runTest("compiler/testData/codegen/box/jvm8/defaults/reflection/propertyAnnotations.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/interfaceFlag")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InterfaceFlag extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInInterfaceFlag() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/interfaceFlag"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/interfaceFlag/superCall.kt");
            }

            @TestMetadata("superCallIndirect.kt")
            public void testSuperCallIndirect() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/interfaceFlag/superCallIndirect.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/jvm8/javaDefaults")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaDefaults extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInJavaDefaults() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvm8/javaDefaults"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("capturedSuperCall.kt")
            public void testCapturedSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/capturedSuperCall.kt");
            }

            @TestMetadata("defaultMethodCallFromInterface.kt")
            public void testDefaultMethodCallFromInterface() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/defaultMethodCallFromInterface.kt");
            }

            @TestMetadata("defaultMethodCallViaClass.kt")
            public void testDefaultMethodCallViaClass() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/defaultMethodCallViaClass.kt");
            }

            @TestMetadata("defaultMethodCallViaInterface.kt")
            public void testDefaultMethodCallViaInterface() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/defaultMethodCallViaInterface.kt");
            }

            @TestMetadata("defaultMethodOverride.kt")
            public void testDefaultMethodOverride() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/defaultMethodOverride.kt");
            }

            @TestMetadata("dontDelegateToDefaultMethods.kt")
            public void testDontDelegateToDefaultMethods() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/dontDelegateToDefaultMethods.kt");
            }

            @TestMetadata("inheritKotlin.kt")
            public void testInheritKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/inheritKotlin.kt");
            }

            @TestMetadata("invokeDefaultViaSuper.kt")
            public void testInvokeDefaultViaSuper() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/invokeDefaultViaSuper.kt");
            }

            @TestMetadata("longChainOfKotlinExtendsFromJavaWithDefault.kt")
            public void testLongChainOfKotlinExtendsFromJavaWithDefault() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/longChainOfKotlinExtendsFromJavaWithDefault.kt");
            }

            @TestMetadata("samOnInterfaceWithDefaultMethod.kt")
            public void testSamOnInterfaceWithDefaultMethod() throws Exception {
                runTest("compiler/testData/codegen/box/jvm8/javaDefaults/samOnInterfaceWithDefaultMethod.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmField")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmField extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmField() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmField"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotationCompanion.kt")
        public void testAnnotationCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/annotationCompanion.kt");
        }

        @TestMetadata("annotationCompanionWithJava.kt")
        public void testAnnotationCompanionWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/annotationCompanionWithJava.kt");
        }

        @TestMetadata("captureClassFields.kt")
        public void testCaptureClassFields() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/captureClassFields.kt");
        }

        @TestMetadata("capturePackageFields.kt")
        public void testCapturePackageFields() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/capturePackageFields.kt");
        }

        @TestMetadata("checkNoAccessors.kt")
        public void testCheckNoAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/checkNoAccessors.kt");
        }

        @TestMetadata("classFieldReference.kt")
        public void testClassFieldReference() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/classFieldReference.kt");
        }

        @TestMetadata("classFieldReflection.kt")
        public void testClassFieldReflection() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/classFieldReflection.kt");
        }

        @TestMetadata("compoundAccess.kt")
        public void testCompoundAccess() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/compoundAccess.kt");
        }

        @TestMetadata("constructorProperty.kt")
        public void testConstructorProperty() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/constructorProperty.kt");
        }

        @TestMetadata("initializersOrder.kt")
        public void testInitializersOrder() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/initializersOrder.kt");
        }

        @TestMetadata("interfaceCompanion.kt")
        public void testInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/interfaceCompanion.kt");
        }

        @TestMetadata("interfaceCompanionWithJava.kt")
        public void testInterfaceCompanionWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/interfaceCompanionWithJava.kt");
        }

        @TestMetadata("publicField.kt")
        public void testPublicField() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/publicField.kt");
        }

        @TestMetadata("publicFieldJava.kt")
        public void testPublicFieldJava() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/publicFieldJava.kt");
        }

        @TestMetadata("simpleMemberProperty.kt")
        public void testSimpleMemberProperty() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/simpleMemberProperty.kt");
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/superCall.kt");
        }

        @TestMetadata("superCall2.kt")
        public void testSuperCall2() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/superCall2.kt");
        }

        @TestMetadata("topLevelFieldReference.kt")
        public void testTopLevelFieldReference() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/topLevelFieldReference.kt");
        }

        @TestMetadata("topLevelFieldReflection.kt")
        public void testTopLevelFieldReflection() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/topLevelFieldReflection.kt");
        }

        @TestMetadata("visibility.kt")
        public void testVisibility() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/visibility.kt");
        }

        @TestMetadata("writeFieldReference.kt")
        public void testWriteFieldReference() throws Exception {
            runTest("compiler/testData/codegen/box/jvmField/writeFieldReference.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmName extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmName"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotationProperties.kt")
        public void testAnnotationProperties() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/annotationProperties.kt");
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/callableReference.kt");
        }

        @TestMetadata("clashingErasure.kt")
        public void testClashingErasure() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/clashingErasure.kt");
        }

        @TestMetadata("classMembers.kt")
        public void testClassMembers() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/classMembers.kt");
        }

        @TestMetadata("fakeJvmNameInJava.kt")
        public void testFakeJvmNameInJava() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/fakeJvmNameInJava.kt");
        }

        @TestMetadata("functionName.kt")
        public void testFunctionName() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/functionName.kt");
        }

        @TestMetadata("loadJvmName.kt")
        public void testLoadJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/loadJvmName.kt");
        }

        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/multifileClass.kt");
        }

        @TestMetadata("multifileClassWithLocalClass.kt")
        public void testMultifileClassWithLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/multifileClassWithLocalClass.kt");
        }

        @TestMetadata("multifileClassWithLocalGeneric.kt")
        public void testMultifileClassWithLocalGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/multifileClassWithLocalGeneric.kt");
        }

        @TestMetadata("propertyAccessorsUseSite.kt")
        public void testPropertyAccessorsUseSite() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/propertyAccessorsUseSite.kt");
        }

        @TestMetadata("propertyName.kt")
        public void testPropertyName() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/propertyName.kt");
        }

        @TestMetadata("renamedFileClass.kt")
        public void testRenamedFileClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmName/renamedFileClass.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/jvmName/fileFacades")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileFacades extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFileFacades() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmName/fileFacades"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("differentFiles.kt")
            public void testDifferentFiles() throws Exception {
                runTest("compiler/testData/codegen/box/jvmName/fileFacades/differentFiles.kt");
            }

            @TestMetadata("javaAnnotationOnFileFacade.kt")
            public void testJavaAnnotationOnFileFacade() throws Exception {
                runTest("compiler/testData/codegen/box/jvmName/fileFacades/javaAnnotationOnFileFacade.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/jvmName/fileFacades/simple.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmOverloads extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmOverloads() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmOverloads"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/companionObject.kt");
        }

        @TestMetadata("defaultsNotAtEnd.kt")
        public void testDefaultsNotAtEnd() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/defaultsNotAtEnd.kt");
        }

        @TestMetadata("doubleParameters.kt")
        public void testDoubleParameters() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/doubleParameters.kt");
        }

        @TestMetadata("extensionMethod.kt")
        public void testExtensionMethod() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/extensionMethod.kt");
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/generics.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/innerClass.kt");
        }

        @TestMetadata("multipleDefaultParameters.kt")
        public void testMultipleDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/multipleDefaultParameters.kt");
        }

        @TestMetadata("noRedundantVarargs.kt")
        public void testNoRedundantVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/noRedundantVarargs.kt");
        }

        @TestMetadata("nonDefaultParameter.kt")
        public void testNonDefaultParameter() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/nonDefaultParameter.kt");
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/primaryConstructor.kt");
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/privateClass.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/secondaryConstructor.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/simple.kt");
        }

        @TestMetadata("simpleJavaCall.kt")
        public void testSimpleJavaCall() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/simpleJavaCall.kt");
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/jvmOverloads/varargs.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmPackageName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmPackageName extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmPackageName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("metadataField.kt")
        public void testMetadataField() throws Exception {
            runTest("compiler/testData/codegen/box/jvmPackageName/metadataField.kt");
        }

        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/jvmPackageName/multifileClass.kt");
        }

        @TestMetadata("rootPackage.kt")
        public void testRootPackage() throws Exception {
            runTest("compiler/testData/codegen/box/jvmPackageName/rootPackage.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/jvmPackageName/simple.kt");
        }

        @TestMetadata("withJvmName.kt")
        public void testWithJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/jvmPackageName/withJvmName.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmStatic extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInJvmStatic() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotations.kt")
        public void testAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/annotations.kt");
        }

        @TestMetadata("closure.kt")
        public void testClosure() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/closure.kt");
        }

        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/companionObject.kt");
        }

        @TestMetadata("convention.kt")
        public void testConvention() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/convention.kt");
        }

        @TestMetadata("default.kt")
        public void testDefault() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/default.kt");
        }

        @TestMetadata("enumCompanion.kt")
        public void testEnumCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/enumCompanion.kt");
        }

        @TestMetadata("explicitObject.kt")
        public void testExplicitObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/explicitObject.kt");
        }

        @TestMetadata("funAccess.kt")
        public void testFunAccess() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/funAccess.kt");
        }

        @TestMetadata("importStaticMemberFromObject.kt")
        public void testImportStaticMemberFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/importStaticMemberFromObject.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/inline.kt");
        }

        @TestMetadata("inlinePropertyAccessors.kt")
        public void testInlinePropertyAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/inlinePropertyAccessors.kt");
        }

        @TestMetadata("interfaceCompanion.kt")
        public void testInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/interfaceCompanion.kt");
        }

        @TestMetadata("kt21246.kt")
        public void testKt21246() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/kt21246.kt");
        }

        @TestMetadata("kt21246a.kt")
        public void testKt21246a() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/kt21246a.kt");
        }

        @TestMetadata("kt9897_static.kt")
        public void testKt9897_static() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/kt9897_static.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/object.kt");
        }

        @TestMetadata("postfixInc.kt")
        public void testPostfixInc() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/postfixInc.kt");
        }

        @TestMetadata("prefixInc.kt")
        public void testPrefixInc() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/prefixInc.kt");
        }

        @TestMetadata("privateMethod.kt")
        public void testPrivateMethod() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/privateMethod.kt");
        }

        @TestMetadata("privateSetter.kt")
        public void testPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/privateSetter.kt");
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/propertyAccess.kt");
        }

        @TestMetadata("propertyAccessorsCompanion.kt")
        public void testPropertyAccessorsCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/propertyAccessorsCompanion.kt");
        }

        @TestMetadata("propertyAccessorsObject.kt")
        public void testPropertyAccessorsObject() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/propertyAccessorsObject.kt");
        }

        @TestMetadata("propertyAsDefault.kt")
        public void testPropertyAsDefault() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/propertyAsDefault.kt");
        }

        @TestMetadata("propertyGetterDelegatesToAnother.kt")
        public void testPropertyGetterDelegatesToAnother() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/propertyGetterDelegatesToAnother.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/simple.kt");
        }

        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/jvmStatic/syntheticAccessor.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/labels")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Labels extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInLabels() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("controlLabelClashesWithFuncitonName.kt")
        public void testControlLabelClashesWithFuncitonName() throws Exception {
            runTest("compiler/testData/codegen/box/labels/controlLabelClashesWithFuncitonName.kt");
        }

        @TestMetadata("infixCallLabelling.kt")
        public void testInfixCallLabelling() throws Exception {
            runTest("compiler/testData/codegen/box/labels/infixCallLabelling.kt");
        }

        @TestMetadata("labeledDeclarations.kt")
        public void testLabeledDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/labels/labeledDeclarations.kt");
        }

        @TestMetadata("propertyAccessor.kt")
        public void testPropertyAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessor.kt");
        }

        @TestMetadata("propertyAccessorFunctionLiteral.kt")
        public void testPropertyAccessorFunctionLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorFunctionLiteral.kt");
        }

        @TestMetadata("propertyAccessorInnerExtensionFun.kt")
        public void testPropertyAccessorInnerExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorInnerExtensionFun.kt");
        }

        @TestMetadata("propertyAccessorObject.kt")
        public void testPropertyAccessorObject() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyAccessorObject.kt");
        }

        @TestMetadata("propertyInClassAccessor.kt")
        public void testPropertyInClassAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/labels/propertyInClassAccessor.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LazyCodegen extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("exceptionInFieldInitializer.kt")
        public void testExceptionInFieldInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/exceptionInFieldInitializer.kt");
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/ifElse.kt");
        }

        @TestMetadata("increment.kt")
        public void testIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/increment.kt");
        }

        @TestMetadata("safeAssign.kt")
        public void testSafeAssign() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeAssign.kt");
        }

        @TestMetadata("safeAssignComplex.kt")
        public void testSafeAssignComplex() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeAssignComplex.kt");
        }

        @TestMetadata("safeCallAndArray.kt")
        public void testSafeCallAndArray() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/safeCallAndArray.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/toString.kt");
        }

        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/tryCatchExpression.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/box/lazyCodegen/when.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Optimizations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInOptimizations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/lazyCodegen/optimizations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("negateConstantCompare.kt")
            public void testNegateConstantCompare() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateConstantCompare.kt");
            }

            @TestMetadata("negateFalse.kt")
            public void testNegateFalse() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalse.kt");
            }

            @TestMetadata("negateFalseVar.kt")
            public void testNegateFalseVar() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalseVar.kt");
            }

            @TestMetadata("negateFalseVarChain.kt")
            public void testNegateFalseVarChain() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalseVarChain.kt");
            }

            @TestMetadata("negateObjectComp.kt")
            public void testNegateObjectComp() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateObjectComp.kt");
            }

            @TestMetadata("negateObjectComp2.kt")
            public void testNegateObjectComp2() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateObjectComp2.kt");
            }

            @TestMetadata("negateTrue.kt")
            public void testNegateTrue() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateTrue.kt");
            }

            @TestMetadata("negateTrueVar.kt")
            public void testNegateTrueVar() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/negateTrueVar.kt");
            }

            @TestMetadata("noOptimization.kt")
            public void testNoOptimization() throws Exception {
                runTest("compiler/testData/codegen/box/lazyCodegen/optimizations/noOptimization.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/localClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalClasses extends AbstractLightAnalysisModeTest {
        @TestMetadata("closureOfInnerLocalClass.kt")
        public void ignoreClosureOfInnerLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/closureOfInnerLocalClass.kt");
        }

        @TestMetadata("closureWithSelfInstantiation.kt")
        public void ignoreClosureWithSelfInstantiation() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/closureWithSelfInstantiation.kt");
        }

        @TestMetadata("subclassingExtensionReceiverClass.kt")
        public void ignoreSubclassingExtensionReceiverClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/subclassingExtensionReceiverClass.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInLocalClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/localClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectInExtension.kt")
        public void testAnonymousObjectInExtension() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/anonymousObjectInExtension.kt");
        }

        @TestMetadata("anonymousObjectInInitializer.kt")
        public void testAnonymousObjectInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/anonymousObjectInInitializer.kt");
        }

        @TestMetadata("anonymousObjectInParameterInitializer.kt")
        public void testAnonymousObjectInParameterInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/anonymousObjectInParameterInitializer.kt");
        }

        @TestMetadata("closureOfLambdaInLocalClass.kt")
        public void testClosureOfLambdaInLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/closureOfLambdaInLocalClass.kt");
        }

        @TestMetadata("inExtensionFunction.kt")
        public void testInExtensionFunction() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/inExtensionFunction.kt");
        }

        @TestMetadata("inExtensionProperty.kt")
        public void testInExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/inExtensionProperty.kt");
        }

        @TestMetadata("inLocalExtensionFunction.kt")
        public void testInLocalExtensionFunction() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/inLocalExtensionFunction.kt");
        }

        @TestMetadata("inLocalExtensionProperty.kt")
        public void testInLocalExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/inLocalExtensionProperty.kt");
        }

        @TestMetadata("innerClassInLocalClass.kt")
        public void testInnerClassInLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/innerClassInLocalClass.kt");
        }

        @TestMetadata("innerOfLocalCaptureExtensionReceiver.kt")
        public void testInnerOfLocalCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/innerOfLocalCaptureExtensionReceiver.kt");
        }

        @TestMetadata("kt2700.kt")
        public void testKt2700() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt2700.kt");
        }

        @TestMetadata("kt2873.kt")
        public void testKt2873() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt2873.kt");
        }

        @TestMetadata("kt3210.kt")
        public void testKt3210() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt3210.kt");
        }

        @TestMetadata("kt3389.kt")
        public void testKt3389() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt3389.kt");
        }

        @TestMetadata("kt3584.kt")
        public void testKt3584() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt3584.kt");
        }

        @TestMetadata("kt4174.kt")
        public void testKt4174() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/kt4174.kt");
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localClass.kt");
        }

        @TestMetadata("localClassCaptureExtensionReceiver.kt")
        public void testLocalClassCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localClassCaptureExtensionReceiver.kt");
        }

        @TestMetadata("localClassInInitializer.kt")
        public void testLocalClassInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localClassInInitializer.kt");
        }

        @TestMetadata("localClassInParameterInitializer.kt")
        public void testLocalClassInParameterInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localClassInParameterInitializer.kt");
        }

        @TestMetadata("localDataClass.kt")
        public void testLocalDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localDataClass.kt");
        }

        @TestMetadata("localExtendsInnerAndReferencesOuterMember.kt")
        public void testLocalExtendsInnerAndReferencesOuterMember() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/localExtendsInnerAndReferencesOuterMember.kt");
        }

        @TestMetadata("nameWithWhitespace.kt")
        public void testNameWithWhitespace() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/nameWithWhitespace.kt");
        }

        @TestMetadata("noclosure.kt")
        public void testNoclosure() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/noclosure.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/object.kt");
        }

        @TestMetadata("ownClosureOfInnerLocalClass.kt")
        public void testOwnClosureOfInnerLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/ownClosureOfInnerLocalClass.kt");
        }

        @TestMetadata("recaptureVarCapturedInLocalClass1.kt")
        public void testRecaptureVarCapturedInLocalClass1() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/recaptureVarCapturedInLocalClass1.kt");
        }

        @TestMetadata("recaptureVarCapturedInLocalClass2.kt")
        public void testRecaptureVarCapturedInLocalClass2() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/recaptureVarCapturedInLocalClass2.kt");
        }

        @TestMetadata("recaptureVarCapturedInLocalClass3.kt")
        public void testRecaptureVarCapturedInLocalClass3() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/recaptureVarCapturedInLocalClass3.kt");
        }

        @TestMetadata("withclosure.kt")
        public void testWithclosure() throws Exception {
            runTest("compiler/testData/codegen/box/localClasses/withclosure.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/mangling")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Mangling extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInMangling() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/mangling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("field.kt")
        public void testField() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/field.kt");
        }

        @TestMetadata("fun.kt")
        public void testFun() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/fun.kt");
        }

        @TestMetadata("internal.kt")
        public void testInternal() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/internal.kt");
        }

        @TestMetadata("internalOverride.kt")
        public void testInternalOverride() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/internalOverride.kt");
        }

        @TestMetadata("internalOverrideSuperCall.kt")
        public void testInternalOverrideSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/internalOverrideSuperCall.kt");
        }

        @TestMetadata("noOverrideWithJava.kt")
        public void testNoOverrideWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/noOverrideWithJava.kt");
        }

        @TestMetadata("parentheses.kt")
        public void testParentheses() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/parentheses.kt");
        }

        @TestMetadata("publicOverride.kt")
        public void testPublicOverride() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/publicOverride.kt");
        }

        @TestMetadata("publicOverrideSuperCall.kt")
        public void testPublicOverrideSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/mangling/publicOverrideSuperCall.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/multiDecl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiDecl extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInMultiDecl() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("ComplexInitializer.kt")
        public void testComplexInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/ComplexInitializer.kt");
        }

        @TestMetadata("component.kt")
        public void testComponent() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/component.kt");
        }

        @TestMetadata("kt9828_hashMap.kt")
        public void testKt9828_hashMap() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/kt9828_hashMap.kt");
        }

        @TestMetadata("returnInElvis.kt")
        public void testReturnInElvis() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/returnInElvis.kt");
        }

        @TestMetadata("SimpleVals.kt")
        public void testSimpleVals() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/SimpleVals.kt");
        }

        @TestMetadata("SimpleValsExtensions.kt")
        public void testSimpleValsExtensions() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/SimpleValsExtensions.kt");
        }

        @TestMetadata("SimpleVarsExtensions.kt")
        public void testSimpleVarsExtensions() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/SimpleVarsExtensions.kt");
        }

        @TestMetadata("UnderscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/UnderscoreNames.kt");
        }

        @TestMetadata("ValCapturedInFunctionLiteral.kt")
        public void testValCapturedInFunctionLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/ValCapturedInFunctionLiteral.kt");
        }

        @TestMetadata("ValCapturedInLocalFunction.kt")
        public void testValCapturedInLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/ValCapturedInLocalFunction.kt");
        }

        @TestMetadata("ValCapturedInObjectLiteral.kt")
        public void testValCapturedInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/ValCapturedInObjectLiteral.kt");
        }

        @TestMetadata("VarCapturedInFunctionLiteral.kt")
        public void testVarCapturedInFunctionLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/VarCapturedInFunctionLiteral.kt");
        }

        @TestMetadata("VarCapturedInLocalFunction.kt")
        public void testVarCapturedInLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/VarCapturedInLocalFunction.kt");
        }

        @TestMetadata("VarCapturedInObjectLiteral.kt")
        public void testVarCapturedInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/multiDecl/VarCapturedInObjectLiteral.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/multiDecl/forIterator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForIterator extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForIterator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forIterator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclFor.kt");
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentMemberExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForValCaptured.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class LongIterator extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLongIterator() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forIterator/longIterator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForRange extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForRange() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclFor.kt");
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentMemberExtensions.kt");
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForValCaptured.kt");
            }

            @TestMetadata("UnderscoreNames.kt")
            public void testUnderscoreNames() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/UnderscoreNames.kt");
            }

            @TestMetadata("UnderscoreNamesDontCallComponent.kt")
            public void testUnderscoreNamesDontCallComponent() throws Exception {
                runTest("compiler/testData/codegen/box/multiDecl/forRange/UnderscoreNamesDontCallComponent.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExplicitRangeTo extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInExplicitRangeTo() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclFor.kt")
                public void testMultiDeclFor() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclFor.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }

                @TestMetadata("MultiDeclForValCaptured.kt")
                public void testMultiDeclForValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForValCaptured.kt");
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Int extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInInt() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentExtensionsValCaptured.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentMemberExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInLong() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentExtensionsValCaptured.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentMemberExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExplicitRangeToWithDot extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInExplicitRangeToWithDot() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclFor.kt")
                public void testMultiDeclFor() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclFor.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }

                @TestMetadata("MultiDeclForValCaptured.kt")
                public void testMultiDeclForValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForValCaptured.kt");
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Int extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInInt() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentExtensionsValCaptured.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentMemberExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long extends AbstractLightAnalysisModeTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                    }

                    public void testAllFilesPresentInLong() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentExtensionsValCaptured.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentMemberExtensions.kt");
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        runTest("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLong() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentMemberExtensions.kt");
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("callMultifileClassMemberFromOtherPackage.kt")
        public void testCallMultifileClassMemberFromOtherPackage() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/callMultifileClassMemberFromOtherPackage.kt");
        }

        @TestMetadata("callsToMultifileClassFromOtherPackage.kt")
        public void testCallsToMultifileClassFromOtherPackage() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/callsToMultifileClassFromOtherPackage.kt");
        }

        @TestMetadata("constPropertyReferenceFromMultifileClass.kt")
        public void testConstPropertyReferenceFromMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/constPropertyReferenceFromMultifileClass.kt");
        }

        @TestMetadata("inlineMultifileClassMemberFromOtherPackage.kt")
        public void testInlineMultifileClassMemberFromOtherPackage() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/inlineMultifileClassMemberFromOtherPackage.kt");
        }

        @TestMetadata("kt16077.kt")
        public void testKt16077() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/kt16077.kt");
        }

        @TestMetadata("multifileClassPartsInitialization.kt")
        public void testMultifileClassPartsInitialization() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/multifileClassPartsInitialization.kt");
        }

        @TestMetadata("multifileClassWith2Files.kt")
        public void testMultifileClassWith2Files() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/multifileClassWith2Files.kt");
        }

        @TestMetadata("multifileClassWithCrossCall.kt")
        public void testMultifileClassWithCrossCall() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/multifileClassWithCrossCall.kt");
        }

        @TestMetadata("multifileClassWithPrivate.kt")
        public void testMultifileClassWithPrivate() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/multifileClassWithPrivate.kt");
        }

        @TestMetadata("privateConstVal.kt")
        public void testPrivateConstVal() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/privateConstVal.kt");
        }

        @TestMetadata("samePartNameDifferentFacades.kt")
        public void testSamePartNameDifferentFacades() throws Exception {
            runTest("compiler/testData/codegen/box/multifileClasses/samePartNameDifferentFacades.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/multifileClasses/optimized")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Optimized extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInOptimized() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multifileClasses/optimized"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callableRefToConstVal.kt")
            public void testCallableRefToConstVal() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToConstVal.kt");
            }

            @TestMetadata("callableRefToFun.kt")
            public void testCallableRefToFun() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToFun.kt");
            }

            @TestMetadata("callableRefToInternalConstValInline.kt")
            public void testCallableRefToInternalConstValInline() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToInternalConstValInline.kt");
            }

            @TestMetadata("callableRefToPrivateConstVal.kt")
            public void testCallableRefToPrivateConstVal() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToPrivateConstVal.kt");
            }

            @TestMetadata("calls.kt")
            public void testCalls() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/calls.kt");
            }

            @TestMetadata("overlappingFuns.kt")
            public void testOverlappingFuns() throws Exception {
                runTest("compiler/testData/codegen/box/multifileClasses/optimized/overlappingFuns.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Multiplatform extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInMultiplatform() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiplatform"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("noArgActualConstructor.kt")
        public void testNoArgActualConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/multiplatform/noArgActualConstructor.kt");
        }

        @TestMetadata("optionalExpectation.kt")
        public void testOptionalExpectation() throws Exception {
            runTest("compiler/testData/codegen/box/multiplatform/optionalExpectation.kt");
        }

        @TestMetadata("optionalExpectationJvm.kt")
        public void testOptionalExpectationJvm() throws Exception {
            runTest("compiler/testData/codegen/box/multiplatform/optionalExpectationJvm.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/multiplatform/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultArguments extends AbstractLightAnalysisModeTest {
            @TestMetadata("delegatedExpectedInterface.kt")
            public void ignoreDelegatedExpectedInterface() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/delegatedExpectedInterface.kt");
            }

            @TestMetadata("superCall.kt")
            public void ignoreSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/superCall.kt");
            }

            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/annotations.kt");
            }

            @TestMetadata("bothInExpectAndActual.kt")
            public void testBothInExpectAndActual() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/bothInExpectAndActual.kt");
            }

            @TestMetadata("bothInExpectAndActual2.kt")
            public void testBothInExpectAndActual2() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/bothInExpectAndActual2.kt");
            }

            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/constructor.kt");
            }

            @TestMetadata("dispatchReceiverValue.kt")
            public void testDispatchReceiverValue() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/dispatchReceiverValue.kt");
            }

            @TestMetadata("extensionReceiverValue.kt")
            public void testExtensionReceiverValue() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/extensionReceiverValue.kt");
            }

            @TestMetadata("function.kt")
            public void testFunction() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/function.kt");
            }

            @TestMetadata("inheritedFromCommonClass.kt")
            public void testInheritedFromCommonClass() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedFromCommonClass.kt");
            }

            @TestMetadata("inheritedFromExpectedClass.kt")
            public void testInheritedFromExpectedClass() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedFromExpectedClass.kt");
            }

            @TestMetadata("inheritedFromExpectedInterface.kt")
            public void testInheritedFromExpectedInterface() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedFromExpectedInterface.kt");
            }

            @TestMetadata("inheritedFromExpectedMethod.kt")
            public void testInheritedFromExpectedMethod() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedFromExpectedMethod.kt");
            }

            @TestMetadata("inheritedInExpectedDeclarations.kt")
            public void testInheritedInExpectedDeclarations() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedInExpectedDeclarations.kt");
            }

            @TestMetadata("inheritedViaAnotherInterfaceIndirectly.kt")
            public void testInheritedViaAnotherInterfaceIndirectly() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inheritedViaAnotherInterfaceIndirectly.kt");
            }

            @TestMetadata("inlineFunctionWithDefaultLambda.kt")
            public void testInlineFunctionWithDefaultLambda() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/inlineFunctionWithDefaultLambda.kt");
            }

            @TestMetadata("jvmOverloads.kt")
            public void testJvmOverloads() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/jvmOverloads.kt");
            }

            @TestMetadata("kt23239.kt")
            public void testKt23239() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/kt23239.kt");
            }

            @TestMetadata("kt23739.kt")
            public void testKt23739() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/kt23739.kt");
            }

            @TestMetadata("parametersInArgumentValues.kt")
            public void testParametersInArgumentValues() throws Exception {
                runTest("compiler/testData/codegen/box/multiplatform/defaultArguments/parametersInArgumentValues.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NonLocalReturns extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInNonLocalReturns() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt6895.kt")
        public void testKt6895() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/kt6895.kt");
        }

        @TestMetadata("kt9644let.kt")
        public void testKt9644let() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/kt9644let.kt");
        }

        @TestMetadata("localReturnInsideProperty.kt")
        public void testLocalReturnInsideProperty() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/localReturnInsideProperty.kt");
        }

        @TestMetadata("returnInsideTwoLambdas.kt")
        public void testReturnInsideTwoLambdas() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/returnInsideTwoLambdas.kt");
        }

        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/use.kt");
        }

        @TestMetadata("useWithException.kt")
        public void testUseWithException() throws Exception {
            runTest("compiler/testData/codegen/box/nonLocalReturns/useWithException.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/nullCheckOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NullCheckOptimization extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInNullCheckOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("isNullable.kt")
        public void testIsNullable() throws Exception {
            runTest("compiler/testData/codegen/box/nullCheckOptimization/isNullable.kt");
        }

        @TestMetadata("kt22410.kt")
        public void testKt22410() throws Exception {
            runTest("compiler/testData/codegen/box/nullCheckOptimization/kt22410.kt");
        }

        @TestMetadata("kt7774.kt")
        public void testKt7774() throws Exception {
            runTest("compiler/testData/codegen/box/nullCheckOptimization/kt7774.kt");
        }

        @TestMetadata("primitiveCheckWithSideEffect.kt")
        public void testPrimitiveCheckWithSideEffect() throws Exception {
            runTest("compiler/testData/codegen/box/nullCheckOptimization/primitiveCheckWithSideEffect.kt");
        }

        @TestMetadata("trivialInstanceOf.kt")
        public void testTrivialInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/nullCheckOptimization/trivialInstanceOf.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/objectIntrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectIntrinsics extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInObjectIntrinsics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objectIntrinsics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("objects.kt")
        public void testObjects() throws Exception {
            runTest("compiler/testData/codegen/box/objectIntrinsics/objects.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/objects")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Objects extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInObjects() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectPropertyInitialization.kt")
        public void testAnonymousObjectPropertyInitialization() throws Exception {
            runTest("compiler/testData/codegen/box/objects/anonymousObjectPropertyInitialization.kt");
        }

        @TestMetadata("anonymousObjectReturnsFromTopLevelFun.kt")
        public void testAnonymousObjectReturnsFromTopLevelFun() throws Exception {
            runTest("compiler/testData/codegen/box/objects/anonymousObjectReturnsFromTopLevelFun.kt");
        }

        @TestMetadata("classCallsProtectedInheritedByCompanion.kt")
        public void testClassCallsProtectedInheritedByCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/objects/classCallsProtectedInheritedByCompanion.kt");
        }

        @TestMetadata("classCompanion.kt")
        public void testClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/objects/classCompanion.kt");
        }

        @TestMetadata("compoundAssignmentToArrayAccessToExtensionPropertyImportedFromObject.kt")
        public void testCompoundAssignmentToArrayAccessToExtensionPropertyImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToArrayAccessToExtensionPropertyImportedFromObject.kt");
        }

        @TestMetadata("compoundAssignmentToArrayAccessToPropertyImportedFromObject.kt")
        public void testCompoundAssignmentToArrayAccessToPropertyImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToArrayAccessToPropertyImportedFromObject.kt");
        }

        @TestMetadata("compoundAssignmentToExtensionPropertyImportedFromObject.kt")
        public void testCompoundAssignmentToExtensionPropertyImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToExtensionPropertyImportedFromObject.kt");
        }

        @TestMetadata("compoundAssignmentToObjectFromCall.kt")
        public void testCompoundAssignmentToObjectFromCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToObjectFromCall.kt");
        }

        @TestMetadata("compoundAssignmentToPropertyImportedFromObject.kt")
        public void testCompoundAssignmentToPropertyImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToPropertyImportedFromObject.kt");
        }

        @TestMetadata("compoundAssignmentToPropertyWithQualifier.kt")
        public void testCompoundAssignmentToPropertyWithQualifier() throws Exception {
            runTest("compiler/testData/codegen/box/objects/compoundAssignmentToPropertyWithQualifier.kt");
        }

        @TestMetadata("flist.kt")
        public void testFlist() throws Exception {
            runTest("compiler/testData/codegen/box/objects/flist.kt");
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/objects/initializationOrder.kt");
        }

        @TestMetadata("interfaceCompanion.kt")
        public void testInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/objects/interfaceCompanion.kt");
        }

        @TestMetadata("interfaceCompanionObjectReference.kt")
        public void testInterfaceCompanionObjectReference() throws Exception {
            runTest("compiler/testData/codegen/box/objects/interfaceCompanionObjectReference.kt");
        }

        @TestMetadata("kt1047.kt")
        public void testKt1047() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt1047.kt");
        }

        @TestMetadata("kt11117.kt")
        public void testKt11117() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt11117.kt");
        }

        @TestMetadata("kt1136.kt")
        public void testKt1136() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt1136.kt");
        }

        @TestMetadata("kt1186.kt")
        public void testKt1186() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt1186.kt");
        }

        @TestMetadata("kt1600.kt")
        public void testKt1600() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt1600.kt");
        }

        @TestMetadata("kt1737.kt")
        public void testKt1737() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt1737.kt");
        }

        @TestMetadata("kt18982.kt")
        public void testKt18982() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt18982.kt");
        }

        @TestMetadata("kt2398.kt")
        public void testKt2398() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2398.kt");
        }

        @TestMetadata("kt2663.kt")
        public void testKt2663() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2663.kt");
        }

        @TestMetadata("kt2663_2.kt")
        public void testKt2663_2() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2663_2.kt");
        }

        @TestMetadata("kt2663_3.kt")
        public void testKt2663_3() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2663_3.kt");
        }

        @TestMetadata("kt2675.kt")
        public void testKt2675() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2675.kt");
        }

        @TestMetadata("kt2719.kt")
        public void testKt2719() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2719.kt");
        }

        @TestMetadata("kt2822.kt")
        public void testKt2822() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt2822.kt");
        }

        @TestMetadata("kt3238.kt")
        public void testKt3238() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt3238.kt");
        }

        @TestMetadata("kt3684.kt")
        public void testKt3684() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt3684.kt");
        }

        @TestMetadata("kt4086.kt")
        public void testKt4086() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt4086.kt");
        }

        @TestMetadata("kt535.kt")
        public void testKt535() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt535.kt");
        }

        @TestMetadata("kt560.kt")
        public void testKt560() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt560.kt");
        }

        @TestMetadata("kt694.kt")
        public void testKt694() throws Exception {
            runTest("compiler/testData/codegen/box/objects/kt694.kt");
        }

        @TestMetadata("localFunctionInObjectInitializer_kt4516.kt")
        public void testLocalFunctionInObjectInitializer_kt4516() throws Exception {
            runTest("compiler/testData/codegen/box/objects/localFunctionInObjectInitializer_kt4516.kt");
        }

        @TestMetadata("methodOnObject.kt")
        public void testMethodOnObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/methodOnObject.kt");
        }

        @TestMetadata("nestedDerivedClassCallsProtectedFromCompanion.kt")
        public void testNestedDerivedClassCallsProtectedFromCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/objects/nestedDerivedClassCallsProtectedFromCompanion.kt");
        }

        @TestMetadata("nestedObjectWithSuperclass.kt")
        public void testNestedObjectWithSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/objects/nestedObjectWithSuperclass.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/object.kt");
        }

        @TestMetadata("objectExtendsInnerAndReferencesOuterMember.kt")
        public void testObjectExtendsInnerAndReferencesOuterMember() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectExtendsInnerAndReferencesOuterMember.kt");
        }

        @TestMetadata("objectInLocalAnonymousObject.kt")
        public void testObjectInLocalAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectInLocalAnonymousObject.kt");
        }

        @TestMetadata("objectInitialization_kt5523.kt")
        public void testObjectInitialization_kt5523() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectInitialization_kt5523.kt");
        }

        @TestMetadata("objectLiteral.kt")
        public void testObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectLiteral.kt");
        }

        @TestMetadata("objectLiteralInClosure.kt")
        public void testObjectLiteralInClosure() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectLiteralInClosure.kt");
        }

        @TestMetadata("objectVsClassInitialization_kt5291.kt")
        public void testObjectVsClassInitialization_kt5291() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectVsClassInitialization_kt5291.kt");
        }

        @TestMetadata("objectWithSuperclass.kt")
        public void testObjectWithSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectWithSuperclass.kt");
        }

        @TestMetadata("objectWithSuperclassAndTrait.kt")
        public void testObjectWithSuperclassAndTrait() throws Exception {
            runTest("compiler/testData/codegen/box/objects/objectWithSuperclassAndTrait.kt");
        }

        @TestMetadata("privateExtensionFromInitializer_kt4543.kt")
        public void testPrivateExtensionFromInitializer_kt4543() throws Exception {
            runTest("compiler/testData/codegen/box/objects/privateExtensionFromInitializer_kt4543.kt");
        }

        @TestMetadata("privateFunctionFromClosureInInitializer_kt5582.kt")
        public void testPrivateFunctionFromClosureInInitializer_kt5582() throws Exception {
            runTest("compiler/testData/codegen/box/objects/privateFunctionFromClosureInInitializer_kt5582.kt");
        }

        @TestMetadata("receiverInConstructor.kt")
        public void testReceiverInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/objects/receiverInConstructor.kt");
        }

        @TestMetadata("safeAccess.kt")
        public void testSafeAccess() throws Exception {
            runTest("compiler/testData/codegen/box/objects/safeAccess.kt");
        }

        @TestMetadata("selfReferenceToCompanionObjectInAnonymousObjectInSuperConstructorCall.kt")
        public void testSelfReferenceToCompanionObjectInAnonymousObjectInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToCompanionObjectInAnonymousObjectInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToCompanionObjectInInlineLambdaInConstructorBody.kt")
        public void testSelfReferenceToCompanionObjectInInlineLambdaInConstructorBody() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToCompanionObjectInInlineLambdaInConstructorBody.kt");
        }

        @TestMetadata("selfReferenceToCompanionObjectInInlineLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToCompanionObjectInInlineLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToCompanionObjectInInlineLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToCompanionObjectInLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToCompanionObjectInLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToCompanionObjectInLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToInterfaceCompanionObjectInAnonymousObjectInSuperConstructorCall.kt")
        public void testSelfReferenceToInterfaceCompanionObjectInAnonymousObjectInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToInterfaceCompanionObjectInAnonymousObjectInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToInterfaceCompanionObjectInInlineLambdaInConstructorBody.kt")
        public void testSelfReferenceToInterfaceCompanionObjectInInlineLambdaInConstructorBody() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToInterfaceCompanionObjectInInlineLambdaInConstructorBody.kt");
        }

        @TestMetadata("selfReferenceToInterfaceCompanionObjectInInlineLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToInterfaceCompanionObjectInInlineLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToInterfaceCompanionObjectInInlineLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToInterfaceCompanionObjectInLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToInterfaceCompanionObjectInLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToInterfaceCompanionObjectInLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToObjectInAnonymousObjectInSuperConstructorCall.kt")
        public void testSelfReferenceToObjectInAnonymousObjectInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToObjectInAnonymousObjectInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToObjectInInlineLambdaInConstructorBody.kt")
        public void testSelfReferenceToObjectInInlineLambdaInConstructorBody() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToObjectInInlineLambdaInConstructorBody.kt");
        }

        @TestMetadata("selfReferenceToObjectInInlineLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToObjectInInlineLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToObjectInInlineLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("selfReferenceToObjectInLambdaInSuperConstructorCall.kt")
        public void testSelfReferenceToObjectInLambdaInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/objects/selfReferenceToObjectInLambdaInSuperConstructorCall.kt");
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/box/objects/simpleObject.kt");
        }

        @TestMetadata("thisInConstructor.kt")
        public void testThisInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/objects/thisInConstructor.kt");
        }

        @TestMetadata("useAnonymousObjectAsIterator.kt")
        public void testUseAnonymousObjectAsIterator() throws Exception {
            runTest("compiler/testData/codegen/box/objects/useAnonymousObjectAsIterator.kt");
        }

        @TestMetadata("useImportedMember.kt")
        public void testUseImportedMember() throws Exception {
            runTest("compiler/testData/codegen/box/objects/useImportedMember.kt");
        }

        @TestMetadata("useImportedMemberFromCompanion.kt")
        public void testUseImportedMemberFromCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/objects/useImportedMemberFromCompanion.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/objects/companionObjectAccess")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObjectAccess extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCompanionObjectAccess() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objects/companionObjectAccess"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt27117.kt")
            public void testKt27117() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27117.kt");
            }

            @TestMetadata("kt27117_lv12.kt")
            public void testKt27117_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27117_lv12.kt");
            }

            @TestMetadata("kt27117_lv13.kt")
            public void testKt27117_lv13() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27117_lv13.kt");
            }

            @TestMetadata("kt27121.kt")
            public void testKt27121() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27121.kt");
            }

            @TestMetadata("kt27121_lv12.kt")
            public void testKt27121_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27121_lv12.kt");
            }

            @TestMetadata("kt27121_lv13.kt")
            public void testKt27121_lv13() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/kt27121_lv13.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromAnonymousObjectInNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromAnonymousObjectInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromAnonymousObjectInNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromInitBlock.kt")
            public void testPrivateCompanionObjectAccessedFromInitBlock() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromInitBlock.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromInitBlockOfNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromInitBlockOfNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromInitBlockOfNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromInlineLambdaInNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromInlineLambdaInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromInlineLambdaInNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromLambdaInNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromLambdaInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromLambdaInNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromMethodInlinedInNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromMethodInlinedInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromMethodInlinedInNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromNestedClass.kt")
            public void testPrivateCompanionObjectAccessedFromNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromNestedClass.kt");
            }

            @TestMetadata("privateCompanionObjectAccessedFromNestedClassSeveralTimes.kt")
            public void testPrivateCompanionObjectAccessedFromNestedClassSeveralTimes() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectAccessedFromNestedClassSeveralTimes.kt");
            }

            @TestMetadata("privateCompanionObjectUsedInNestedClass.kt")
            public void testPrivateCompanionObjectUsedInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/privateCompanionObjectUsedInNestedClass.kt");
            }

            @TestMetadata("protectedCompanionObjectAccessedFromNestedClass.kt")
            public void testProtectedCompanionObjectAccessedFromNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/objects/companionObjectAccess/protectedCompanionObjectAccessedFromNestedClass.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimitiveCompanion extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInPrimitiveCompanion() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("byteCompanionObject.kt")
                public void testByteCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/byteCompanionObject.kt");
                }

                @TestMetadata("charCompanionObject.kt")
                public void testCharCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/charCompanionObject.kt");
                }

                @TestMetadata("doubleCompanionObject.kt")
                public void testDoubleCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/doubleCompanionObject.kt");
                }

                @TestMetadata("floatCompanionObject.kt")
                public void testFloatCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/floatCompanionObject.kt");
                }

                @TestMetadata("intCompanionObject.kt")
                public void testIntCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/intCompanionObject.kt");
                }

                @TestMetadata("longCompanionObject.kt")
                public void testLongCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/longCompanionObject.kt");
                }

                @TestMetadata("shortCompanionObject.kt")
                public void testShortCompanionObject() throws Exception {
                    runTest("compiler/testData/codegen/box/objects/companionObjectAccess/primitiveCompanion/shortCompanionObject.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/operatorConventions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OperatorConventions extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInOperatorConventions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/operatorConventions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedAssignment.kt")
        public void testAnnotatedAssignment() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/annotatedAssignment.kt");
        }

        @TestMetadata("assignmentOperations.kt")
        public void testAssignmentOperations() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/assignmentOperations.kt");
        }

        @TestMetadata("augmentedAssignmentInInitializer.kt")
        public void testAugmentedAssignmentInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/augmentedAssignmentInInitializer.kt");
        }

        @TestMetadata("augmentedAssignmentWithArrayLHS.kt")
        public void testAugmentedAssignmentWithArrayLHS() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/augmentedAssignmentWithArrayLHS.kt");
        }

        @TestMetadata("incDecOnObject.kt")
        public void testIncDecOnObject() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/incDecOnObject.kt");
        }

        @TestMetadata("infixFunctionOverBuiltinMember.kt")
        public void testInfixFunctionOverBuiltinMember() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/infixFunctionOverBuiltinMember.kt");
        }

        @TestMetadata("kt14201.kt")
        public void testKt14201() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt14201.kt");
        }

        @TestMetadata("kt14201_2.kt")
        public void testKt14201_2() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt14201_2.kt");
        }

        @TestMetadata("kt14227.kt")
        public void testKt14227() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt14227.kt");
        }

        @TestMetadata("kt20387.kt")
        public void testKt20387() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt20387.kt");
        }

        @TestMetadata("kt4152.kt")
        public void testKt4152() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt4152.kt");
        }

        @TestMetadata("kt4987.kt")
        public void testKt4987() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/kt4987.kt");
        }

        @TestMetadata("nestedMaps.kt")
        public void testNestedMaps() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/nestedMaps.kt");
        }

        @TestMetadata("operatorSetLambda.kt")
        public void testOperatorSetLambda() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/operatorSetLambda.kt");
        }

        @TestMetadata("overloadedSet.kt")
        public void testOverloadedSet() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/overloadedSet.kt");
        }

        @TestMetadata("percentAsModOnBigIntegerWithoutRem.kt")
        public void testPercentAsModOnBigIntegerWithoutRem() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/percentAsModOnBigIntegerWithoutRem.kt");
        }

        @TestMetadata("plusExplicit.kt")
        public void testPlusExplicit() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/plusExplicit.kt");
        }

        @TestMetadata("remAssignmentOperation.kt")
        public void testRemAssignmentOperation() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/remAssignmentOperation.kt");
        }

        @TestMetadata("remOverModOperation.kt")
        public void testRemOverModOperation() throws Exception {
            runTest("compiler/testData/codegen/box/operatorConventions/remOverModOperation.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/operatorConventions/compareTo")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompareTo extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCompareTo() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/operatorConventions/compareTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/boolean.kt");
            }

            @TestMetadata("comparable.kt")
            public void testComparable() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/comparable.kt");
            }

            @TestMetadata("doubleInt.kt")
            public void testDoubleInt() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/doubleInt.kt");
            }

            @TestMetadata("doubleLong.kt")
            public void testDoubleLong() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/doubleLong.kt");
            }

            @TestMetadata("extensionArray.kt")
            public void testExtensionArray() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/extensionArray.kt");
            }

            @TestMetadata("extensionObject.kt")
            public void testExtensionObject() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/extensionObject.kt");
            }

            @TestMetadata("intDouble.kt")
            public void testIntDouble() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/intDouble.kt");
            }

            @TestMetadata("intLong.kt")
            public void testIntLong() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/intLong.kt");
            }

            @TestMetadata("longDouble.kt")
            public void testLongDouble() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/longDouble.kt");
            }

            @TestMetadata("longInt.kt")
            public void testLongInt() throws Exception {
                runTest("compiler/testData/codegen/box/operatorConventions/compareTo/longInt.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/optimizations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Optimizations extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInOptimizations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/optimizations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("hashCode.kt")
        public void testHashCode() throws Exception {
            runTest("compiler/testData/codegen/box/optimizations/hashCode.kt");
        }

        @TestMetadata("kt20844.kt")
        public void testKt20844() throws Exception {
            runTest("compiler/testData/codegen/box/optimizations/kt20844.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/package")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Package extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPackage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/package"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinit.kt")
        public void testBoxPrimitiveTypeInClinit() throws Exception {
            runTest("compiler/testData/codegen/box/package/boxPrimitiveTypeInClinit.kt");
        }

        @TestMetadata("checkCast.kt")
        public void testCheckCast() throws Exception {
            runTest("compiler/testData/codegen/box/package/checkCast.kt");
        }

        @TestMetadata("incrementProperty.kt")
        public void testIncrementProperty() throws Exception {
            runTest("compiler/testData/codegen/box/package/incrementProperty.kt");
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/package/initializationOrder.kt");
        }

        @TestMetadata("invokespecial.kt")
        public void testInvokespecial() throws Exception {
            runTest("compiler/testData/codegen/box/package/invokespecial.kt");
        }

        @TestMetadata("mainInFiles.kt")
        public void testMainInFiles() throws Exception {
            runTest("compiler/testData/codegen/box/package/mainInFiles.kt");
        }

        @TestMetadata("nullablePrimitiveNoFieldInitializer.kt")
        public void testNullablePrimitiveNoFieldInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/package/nullablePrimitiveNoFieldInitializer.kt");
        }

        @TestMetadata("packageLocalClassNotImportedWithDefaultImport.kt")
        public void testPackageLocalClassNotImportedWithDefaultImport() throws Exception {
            runTest("compiler/testData/codegen/box/package/packageLocalClassNotImportedWithDefaultImport.kt");
        }

        @TestMetadata("packageQualifiedMethod.kt")
        public void testPackageQualifiedMethod() throws Exception {
            runTest("compiler/testData/codegen/box/package/packageQualifiedMethod.kt");
        }

        @TestMetadata("privateMembersInImportList.kt")
        public void testPrivateMembersInImportList() throws Exception {
            runTest("compiler/testData/codegen/box/package/privateMembersInImportList.kt");
        }

        @TestMetadata("privateTopLevelPropAndVarInInner.kt")
        public void testPrivateTopLevelPropAndVarInInner() throws Exception {
            runTest("compiler/testData/codegen/box/package/privateTopLevelPropAndVarInInner.kt");
        }

        @TestMetadata("referenceWithTheSameNameAsPackage.kt")
        public void testReferenceWithTheSameNameAsPackage() throws Exception {
            runTest("compiler/testData/codegen/box/package/referenceWithTheSameNameAsPackage.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/parametersMetadata")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ParametersMetadata extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInParametersMetadata() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/parametersMetadata"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("defaultImpls.kt")
        public void testDefaultImpls() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/defaultImpls.kt");
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/delegation.kt");
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/enum.kt");
        }

        @TestMetadata("extensionFunction.kt")
        public void testExtensionFunction() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/extensionFunction.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/function.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/innerClass.kt");
        }

        @TestMetadata("superParams.kt")
        public void testSuperParams() throws Exception {
            runTest("compiler/testData/codegen/box/parametersMetadata/superParams.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/platformTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformTypes extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPlatformTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/platformTypes/primitives")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Primitives extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInPrimitives() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/platformTypes/primitives"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/assign.kt");
            }

            @TestMetadata("compareTo.kt")
            public void testCompareTo() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/compareTo.kt");
            }

            @TestMetadata("dec.kt")
            public void testDec() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/dec.kt");
            }

            @TestMetadata("div.kt")
            public void testDiv() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/div.kt");
            }

            @TestMetadata("equals.kt")
            public void testEquals() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/equals.kt");
            }

            @TestMetadata("equalsNull_lv11.kt")
            public void testEqualsNull_lv11() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/equalsNull_lv11.kt");
            }

            @TestMetadata("equalsNull_lv12.kt")
            public void testEqualsNull_lv12() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/equalsNull_lv12.kt");
            }

            @TestMetadata("equalsNull_withExplicitFlag.kt")
            public void testEqualsNull_withExplicitFlag() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/equalsNull_withExplicitFlag.kt");
            }

            @TestMetadata("hashCode.kt")
            public void testHashCode() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/hashCode.kt");
            }

            @TestMetadata("identityEquals.kt")
            public void testIdentityEquals() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/identityEquals.kt");
            }

            @TestMetadata("inc.kt")
            public void testInc() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/inc.kt");
            }

            @TestMetadata("minus.kt")
            public void testMinus() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/minus.kt");
            }

            @TestMetadata("mod.kt")
            public void testMod() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/mod.kt");
            }

            @TestMetadata("not.kt")
            public void testNot() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/not.kt");
            }

            @TestMetadata("notEquals.kt")
            public void testNotEquals() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/notEquals.kt");
            }

            @TestMetadata("plus.kt")
            public void testPlus() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/plus.kt");
            }

            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/plusAssign.kt");
            }

            @TestMetadata("rangeTo.kt")
            public void testRangeTo() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/rangeTo.kt");
            }

            @TestMetadata("times.kt")
            public void testTimes() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/times.kt");
            }

            @TestMetadata("toShort.kt")
            public void testToShort() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/toShort.kt");
            }

            @TestMetadata("toString.kt")
            public void testToString() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/toString.kt");
            }

            @TestMetadata("unaryMinus.kt")
            public void testUnaryMinus() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/unaryMinus.kt");
            }

            @TestMetadata("unaryPlus.kt")
            public void testUnaryPlus() throws Exception {
                runTest("compiler/testData/codegen/box/platformTypes/primitives/unaryPlus.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/polymorphicSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PolymorphicSignature extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPolymorphicSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/polymorphicSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousSubclass.kt")
        public void testAnonymousSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/anonymousSubclass.kt");
        }

        @TestMetadata("invoke.kt")
        public void testInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/invoke.kt");
        }

        @TestMetadata("invokeExact.kt")
        public void testInvokeExact() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/invokeExact.kt");
        }

        @TestMetadata("invokeExactWithInlineClass.kt")
        public void testInvokeExactWithInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/invokeExactWithInlineClass.kt");
        }

        @TestMetadata("varargOfObjects_after.kt")
        public void testVarargOfObjects_after() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/varargOfObjects_after.kt");
        }

        @TestMetadata("varargOfObjects_before.kt")
        public void testVarargOfObjects_before() throws Exception {
            runTest("compiler/testData/codegen/box/polymorphicSignature/varargOfObjects_before.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/primitiveTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrimitiveTypes extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPrimitiveTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/primitiveTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("comparisonWithNaN.kt")
        public void testComparisonWithNaN() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/comparisonWithNaN.kt");
        }

        @TestMetadata("comparisonWithNullCallsFun.kt")
        public void testComparisonWithNullCallsFun() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/comparisonWithNullCallsFun.kt");
        }

        @TestMetadata("conversions.kt")
        public void testConversions() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/conversions.kt");
        }

        @TestMetadata("ea35963.kt")
        public void testEa35963() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/ea35963.kt");
        }

        @TestMetadata("equalsHashCodeToString.kt")
        public void testEqualsHashCodeToString() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/equalsHashCodeToString.kt");
        }

        @TestMetadata("incrementByteCharShort.kt")
        public void testIncrementByteCharShort() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/incrementByteCharShort.kt");
        }

        @TestMetadata("intLiteralIsNotNull.kt")
        public void testIntLiteralIsNotNull() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/intLiteralIsNotNull.kt");
        }

        @TestMetadata("kt1054.kt")
        public void testKt1054() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt1054.kt");
        }

        @TestMetadata("kt1055.kt")
        public void testKt1055() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt1055.kt");
        }

        @TestMetadata("kt1093.kt")
        public void testKt1093() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt1093.kt");
        }

        @TestMetadata("kt13023.kt")
        public void testKt13023() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt13023.kt");
        }

        @TestMetadata("kt14868.kt")
        public void testKt14868() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt14868.kt");
        }

        @TestMetadata("kt1508.kt")
        public void testKt1508() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt1508.kt");
        }

        @TestMetadata("kt1634.kt")
        public void testKt1634() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt1634.kt");
        }

        @TestMetadata("kt16732.kt")
        public void testKt16732() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt16732.kt");
        }

        @TestMetadata("kt2251.kt")
        public void testKt2251() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt2251.kt");
        }

        @TestMetadata("kt2269.kt")
        public void testKt2269() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt2269.kt");
        }

        @TestMetadata("kt2275.kt")
        public void testKt2275() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt2275.kt");
        }

        @TestMetadata("kt239.kt")
        public void testKt239() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt239.kt");
        }

        @TestMetadata("kt242.kt")
        public void testKt242() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt242.kt");
        }

        @TestMetadata("kt243.kt")
        public void testKt243() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt243.kt");
        }

        @TestMetadata("kt248.kt")
        public void testKt248() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt248.kt");
        }

        @TestMetadata("kt2768.kt")
        public void testKt2768() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt2768.kt");
        }

        @TestMetadata("kt2794.kt")
        public void testKt2794() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt2794.kt");
        }

        @TestMetadata("kt3078.kt")
        public void testKt3078() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt3078.kt");
        }

        @TestMetadata("kt3517.kt")
        public void testKt3517() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt3517.kt");
        }

        @TestMetadata("kt3576.kt")
        public void testKt3576() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt3576.kt");
        }

        @TestMetadata("kt3613.kt")
        public void testKt3613() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt3613.kt");
        }

        @TestMetadata("kt4097.kt")
        public void testKt4097() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt4097.kt");
        }

        @TestMetadata("kt4098.kt")
        public void testKt4098() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt4098.kt");
        }

        @TestMetadata("kt4210.kt")
        public void testKt4210() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt4210.kt");
        }

        @TestMetadata("kt4251.kt")
        public void testKt4251() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt4251.kt");
        }

        @TestMetadata("kt446.kt")
        public void testKt446() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt446.kt");
        }

        @TestMetadata("kt518.kt")
        public void testKt518() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt518.kt");
        }

        @TestMetadata("kt6590_identityEquals.kt")
        public void testKt6590_identityEquals() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt6590_identityEquals.kt");
        }

        @TestMetadata("kt665.kt")
        public void testKt665() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt665.kt");
        }

        @TestMetadata("kt684.kt")
        public void testKt684() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt684.kt");
        }

        @TestMetadata("kt711.kt")
        public void testKt711() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt711.kt");
        }

        @TestMetadata("kt737.kt")
        public void testKt737() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt737.kt");
        }

        @TestMetadata("kt752.kt")
        public void testKt752() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt752.kt");
        }

        @TestMetadata("kt753.kt")
        public void testKt753() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt753.kt");
        }

        @TestMetadata("kt756.kt")
        public void testKt756() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt756.kt");
        }

        @TestMetadata("kt757.kt")
        public void testKt757() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt757.kt");
        }

        @TestMetadata("kt828.kt")
        public void testKt828() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt828.kt");
        }

        @TestMetadata("kt877.kt")
        public void testKt877() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt877.kt");
        }

        @TestMetadata("kt882.kt")
        public void testKt882() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt882.kt");
        }

        @TestMetadata("kt887.kt")
        public void testKt887() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt887.kt");
        }

        @TestMetadata("kt935.kt")
        public void testKt935() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/kt935.kt");
        }

        @TestMetadata("nullAsNullableIntIsNull.kt")
        public void testNullAsNullableIntIsNull() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/nullAsNullableIntIsNull.kt");
        }

        @TestMetadata("nullableCharBoolean.kt")
        public void testNullableCharBoolean() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/nullableCharBoolean.kt");
        }

        @TestMetadata("number.kt")
        public void testNumber() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/number.kt");
        }

        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/rangeTo.kt");
        }

        @TestMetadata("substituteIntForGeneric.kt")
        public void testSubstituteIntForGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/substituteIntForGeneric.kt");
        }

        @TestMetadata("unboxComparable.kt")
        public void testUnboxComparable() throws Exception {
            runTest("compiler/testData/codegen/box/primitiveTypes/unboxComparable.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/primitiveTypes/equalityWithObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EqualityWithObject extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEqualityWithObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/primitiveTypes/equalityWithObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boxedEqPrimitiveEvaluationOrder.kt")
            public void testBoxedEqPrimitiveEvaluationOrder() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/boxedEqPrimitiveEvaluationOrder.kt");
            }

            @TestMetadata("boxedLongEqualsLong.kt")
            public void testBoxedLongEqualsLong() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/boxedLongEqualsLong.kt");
            }

            @TestMetadata("intEqualsNullableInt.kt")
            public void testIntEqualsNullableInt() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/intEqualsNullableInt.kt");
            }

            @TestMetadata("intEqualsNullableIntWithSmartCasts.kt")
            public void testIntEqualsNullableIntWithSmartCasts() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/intEqualsNullableIntWithSmartCasts.kt");
            }

            @TestMetadata("objectWithAsymmetricEqualsEqPrimitive.kt")
            public void testObjectWithAsymmetricEqualsEqPrimitive() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/objectWithAsymmetricEqualsEqPrimitive.kt");
            }

            @TestMetadata("whenIntAsNullableAny.kt")
            public void testWhenIntAsNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/whenIntAsNullableAny.kt");
            }

            @TestMetadata("whenNullableBoxed.kt")
            public void testWhenNullableBoxed() throws Exception {
                runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/whenNullableBoxed.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Generated extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInGenerated() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("boxedEqPrimitiveBoolean.kt")
                public void testBoxedEqPrimitiveBoolean() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveBoolean.kt");
                }

                @TestMetadata("boxedEqPrimitiveByte.kt")
                public void testBoxedEqPrimitiveByte() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveByte.kt");
                }

                @TestMetadata("boxedEqPrimitiveChar.kt")
                public void testBoxedEqPrimitiveChar() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveChar.kt");
                }

                @TestMetadata("boxedEqPrimitiveInt.kt")
                public void testBoxedEqPrimitiveInt() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveInt.kt");
                }

                @TestMetadata("boxedEqPrimitiveLong.kt")
                public void testBoxedEqPrimitiveLong() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveLong.kt");
                }

                @TestMetadata("boxedEqPrimitiveShort.kt")
                public void testBoxedEqPrimitiveShort() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/boxedEqPrimitiveShort.kt");
                }

                @TestMetadata("primitiveEqBoxedBoolean.kt")
                public void testPrimitiveEqBoxedBoolean() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedBoolean.kt");
                }

                @TestMetadata("primitiveEqBoxedByte.kt")
                public void testPrimitiveEqBoxedByte() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedByte.kt");
                }

                @TestMetadata("primitiveEqBoxedChar.kt")
                public void testPrimitiveEqBoxedChar() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedChar.kt");
                }

                @TestMetadata("primitiveEqBoxedInt.kt")
                public void testPrimitiveEqBoxedInt() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedInt.kt");
                }

                @TestMetadata("primitiveEqBoxedLong.kt")
                public void testPrimitiveEqBoxedLong() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedLong.kt");
                }

                @TestMetadata("primitiveEqBoxedShort.kt")
                public void testPrimitiveEqBoxedShort() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqBoxedShort.kt");
                }

                @TestMetadata("primitiveEqObjectBoolean.kt")
                public void testPrimitiveEqObjectBoolean() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectBoolean.kt");
                }

                @TestMetadata("primitiveEqObjectByte.kt")
                public void testPrimitiveEqObjectByte() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectByte.kt");
                }

                @TestMetadata("primitiveEqObjectChar.kt")
                public void testPrimitiveEqObjectChar() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectChar.kt");
                }

                @TestMetadata("primitiveEqObjectInt.kt")
                public void testPrimitiveEqObjectInt() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectInt.kt");
                }

                @TestMetadata("primitiveEqObjectLong.kt")
                public void testPrimitiveEqObjectLong() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectLong.kt");
                }

                @TestMetadata("primitiveEqObjectShort.kt")
                public void testPrimitiveEqObjectShort() throws Exception {
                    runTest("compiler/testData/codegen/box/primitiveTypes/equalityWithObject/generated/primitiveEqObjectShort.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/private")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Private extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPrivate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConvention.kt")
        public void testArrayConvention() throws Exception {
            runTest("compiler/testData/codegen/box/private/arrayConvention.kt");
        }

        @TestMetadata("kt9855.kt")
        public void testKt9855() throws Exception {
            runTest("compiler/testData/codegen/box/private/kt9855.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/privateConstructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrivateConstructors extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPrivateConstructors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/privateConstructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("base.kt")
        public void testBase() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/base.kt");
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/captured.kt");
        }

        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/companion.kt");
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/inline.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/inner.kt");
        }

        @TestMetadata("kt4860.kt")
        public void testKt4860() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/kt4860.kt");
        }

        @TestMetadata("secondary.kt")
        public void testSecondary() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/secondary.kt");
        }

        @TestMetadata("synthetic.kt")
        public void testSynthetic() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/synthetic.kt");
        }

        @TestMetadata("withArguments.kt")
        public void testWithArguments() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/withArguments.kt");
        }

        @TestMetadata("withDefault.kt")
        public void testWithDefault() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/withDefault.kt");
        }

        @TestMetadata("withLinkedClasses.kt")
        public void testWithLinkedClasses() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/withLinkedClasses.kt");
        }

        @TestMetadata("withLinkedObjects.kt")
        public void testWithLinkedObjects() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/withLinkedObjects.kt");
        }

        @TestMetadata("withVarargs.kt")
        public void testWithVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/privateConstructors/withVarargs.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractLightAnalysisModeTest {
        @TestMetadata("augmentedAssignmentsAndIncrements.kt")
        public void ignoreAugmentedAssignmentsAndIncrements() throws Exception {
            runTest("compiler/testData/codegen/box/properties/augmentedAssignmentsAndIncrements.kt");
        }

        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        @TestMetadata("accessToPrivateProperty.kt")
        public void testAccessToPrivateProperty() throws Exception {
            runTest("compiler/testData/codegen/box/properties/accessToPrivateProperty.kt");
        }

        @TestMetadata("accessToPrivateSetter.kt")
        public void testAccessToPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/properties/accessToPrivateSetter.kt");
        }

        public void testAllFilesPresentInProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("classArtificialFieldInsideNested.kt")
        public void testClassArtificialFieldInsideNested() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classArtificialFieldInsideNested.kt");
        }

        @TestMetadata("classFieldInsideLambda.kt")
        public void testClassFieldInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classFieldInsideLambda.kt");
        }

        @TestMetadata("classFieldInsideLocalInSetter.kt")
        public void testClassFieldInsideLocalInSetter() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classFieldInsideLocalInSetter.kt");
        }

        @TestMetadata("classFieldInsideNested.kt")
        public void testClassFieldInsideNested() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classFieldInsideNested.kt");
        }

        @TestMetadata("classObjectProperties.kt")
        public void testClassObjectProperties() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classObjectProperties.kt");
        }

        @TestMetadata("classPrivateArtificialFieldInsideNested.kt")
        public void testClassPrivateArtificialFieldInsideNested() throws Exception {
            runTest("compiler/testData/codegen/box/properties/classPrivateArtificialFieldInsideNested.kt");
        }

        @TestMetadata("collectionSize.kt")
        public void testCollectionSize() throws Exception {
            runTest("compiler/testData/codegen/box/properties/collectionSize.kt");
        }

        @TestMetadata("commonPropertiesKJK.kt")
        public void testCommonPropertiesKJK() throws Exception {
            runTest("compiler/testData/codegen/box/properties/commonPropertiesKJK.kt");
        }

        @TestMetadata("companionFieldInsideLambda.kt")
        public void testCompanionFieldInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/properties/companionFieldInsideLambda.kt");
        }

        @TestMetadata("companionObjectAccessor.kt")
        public void testCompanionObjectAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/properties/companionObjectAccessor.kt");
        }

        @TestMetadata("companionObjectPropertiesFromJava.kt")
        public void testCompanionObjectPropertiesFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/properties/companionObjectPropertiesFromJava.kt");
        }

        @TestMetadata("companionPrivateField.kt")
        public void testCompanionPrivateField() throws Exception {
            runTest("compiler/testData/codegen/box/properties/companionPrivateField.kt");
        }

        @TestMetadata("companionPrivateFieldInsideLambda.kt")
        public void testCompanionPrivateFieldInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/properties/companionPrivateFieldInsideLambda.kt");
        }

        @TestMetadata("field.kt")
        public void testField() throws Exception {
            runTest("compiler/testData/codegen/box/properties/field.kt");
        }

        @TestMetadata("fieldInClass.kt")
        public void testFieldInClass() throws Exception {
            runTest("compiler/testData/codegen/box/properties/fieldInClass.kt");
        }

        @TestMetadata("fieldInsideField.kt")
        public void testFieldInsideField() throws Exception {
            runTest("compiler/testData/codegen/box/properties/fieldInsideField.kt");
        }

        @TestMetadata("fieldInsideLambda.kt")
        public void testFieldInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/properties/fieldInsideLambda.kt");
        }

        @TestMetadata("fieldInsideNested.kt")
        public void testFieldInsideNested() throws Exception {
            runTest("compiler/testData/codegen/box/properties/fieldInsideNested.kt");
        }

        @TestMetadata("fieldSimple.kt")
        public void testFieldSimple() throws Exception {
            runTest("compiler/testData/codegen/box/properties/fieldSimple.kt");
        }

        @TestMetadata("generalAccess.kt")
        public void testGeneralAccess() throws Exception {
            runTest("compiler/testData/codegen/box/properties/generalAccess.kt");
        }

        @TestMetadata("javaPropertyBoxedGetter.kt")
        public void testJavaPropertyBoxedGetter() throws Exception {
            runTest("compiler/testData/codegen/box/properties/javaPropertyBoxedGetter.kt");
        }

        @TestMetadata("javaPropertyBoxedSetter.kt")
        public void testJavaPropertyBoxedSetter() throws Exception {
            runTest("compiler/testData/codegen/box/properties/javaPropertyBoxedSetter.kt");
        }

        @TestMetadata("kt10715.kt")
        public void testKt10715() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt10715.kt");
        }

        @TestMetadata("kt10729.kt")
        public void testKt10729() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt10729.kt");
        }

        @TestMetadata("kt1159.kt")
        public void testKt1159() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1159.kt");
        }

        @TestMetadata("kt1165.kt")
        public void testKt1165() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1165.kt");
        }

        @TestMetadata("kt1168.kt")
        public void testKt1168() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1168.kt");
        }

        @TestMetadata("kt1170.kt")
        public void testKt1170() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1170.kt");
        }

        @TestMetadata("kt12200.kt")
        public void testKt12200() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt12200.kt");
        }

        @TestMetadata("kt1398.kt")
        public void testKt1398() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1398.kt");
        }

        @TestMetadata("kt1417.kt")
        public void testKt1417() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1417.kt");
        }

        @TestMetadata("kt1482_2279.kt")
        public void testKt1482_2279() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1482_2279.kt");
        }

        @TestMetadata("kt1714.kt")
        public void testKt1714() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1714.kt");
        }

        @TestMetadata("kt1714_minimal.kt")
        public void testKt1714_minimal() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1714_minimal.kt");
        }

        @TestMetadata("kt1892.kt")
        public void testKt1892() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt1892.kt");
        }

        @TestMetadata("kt2331.kt")
        public void testKt2331() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt2331.kt");
        }

        @TestMetadata("kt257.kt")
        public void testKt257() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt257.kt");
        }

        @TestMetadata("kt2655.kt")
        public void testKt2655() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt2655.kt");
        }

        @TestMetadata("kt2786.kt")
        public void testKt2786() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt2786.kt");
        }

        @TestMetadata("kt2892.kt")
        public void testKt2892() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt2892.kt");
        }

        @TestMetadata("kt3118.kt")
        public void testKt3118() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt3118.kt");
        }

        @TestMetadata("kt3524.kt")
        public void testKt3524() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt3524.kt");
        }

        @TestMetadata("kt3551.kt")
        public void testKt3551() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt3551.kt");
        }

        @TestMetadata("kt3556.kt")
        public void testKt3556() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt3556.kt");
        }

        @TestMetadata("kt3930.kt")
        public void testKt3930() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt3930.kt");
        }

        @TestMetadata("kt4140.kt")
        public void testKt4140() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4140.kt");
        }

        @TestMetadata("kt4252.kt")
        public void testKt4252() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4252.kt");
        }

        @TestMetadata("kt4252_2.kt")
        public void testKt4252_2() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4252_2.kt");
        }

        @TestMetadata("kt4340.kt")
        public void testKt4340() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4340.kt");
        }

        @TestMetadata("kt4373.kt")
        public void testKt4373() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4373.kt");
        }

        @TestMetadata("kt4383.kt")
        public void testKt4383() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt4383.kt");
        }

        @TestMetadata("kt613.kt")
        public void testKt613() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt613.kt");
        }

        @TestMetadata("kt8928.kt")
        public void testKt8928() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt8928.kt");
        }

        @TestMetadata("kt9603.kt")
        public void testKt9603() throws Exception {
            runTest("compiler/testData/codegen/box/properties/kt9603.kt");
        }

        @TestMetadata("primitiveOverrideDefaultAccessor.kt")
        public void testPrimitiveOverrideDefaultAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/properties/primitiveOverrideDefaultAccessor.kt");
        }

        @TestMetadata("primitiveOverrideDelegateAccessor.kt")
        public void testPrimitiveOverrideDelegateAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/properties/primitiveOverrideDelegateAccessor.kt");
        }

        @TestMetadata("privateAccessorOfOverriddenProperty.kt")
        public void testPrivateAccessorOfOverriddenProperty() throws Exception {
            runTest("compiler/testData/codegen/box/properties/privateAccessorOfOverriddenProperty.kt");
        }

        @TestMetadata("privatePropertyInConstructor.kt")
        public void testPrivatePropertyInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/properties/privatePropertyInConstructor.kt");
        }

        @TestMetadata("privatePropertyWithoutBackingField.kt")
        public void testPrivatePropertyWithoutBackingField() throws Exception {
            runTest("compiler/testData/codegen/box/properties/privatePropertyWithoutBackingField.kt");
        }

        @TestMetadata("protectedJavaFieldInInline.kt")
        public void testProtectedJavaFieldInInline() throws Exception {
            runTest("compiler/testData/codegen/box/properties/protectedJavaFieldInInline.kt");
        }

        @TestMetadata("protectedJavaProperty.kt")
        public void testProtectedJavaProperty() throws Exception {
            runTest("compiler/testData/codegen/box/properties/protectedJavaProperty.kt");
        }

        @TestMetadata("protectedJavaPropertyInCompanion.kt")
        public void testProtectedJavaPropertyInCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/properties/protectedJavaPropertyInCompanion.kt");
        }

        @TestMetadata("substituteJavaSuperField.kt")
        public void testSubstituteJavaSuperField() throws Exception {
            runTest("compiler/testData/codegen/box/properties/substituteJavaSuperField.kt");
        }

        @TestMetadata("twoAnnotatedExtensionPropertiesWithoutBackingFields.kt")
        public void testTwoAnnotatedExtensionPropertiesWithoutBackingFields() throws Exception {
            runTest("compiler/testData/codegen/box/properties/twoAnnotatedExtensionPropertiesWithoutBackingFields.kt");
        }

        @TestMetadata("typeInferredFromGetter.kt")
        public void testTypeInferredFromGetter() throws Exception {
            runTest("compiler/testData/codegen/box/properties/typeInferredFromGetter.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/properties/const")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Const extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConst() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/const"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constFlags.kt")
            public void testConstFlags() throws Exception {
                runTest("compiler/testData/codegen/box/properties/const/constFlags.kt");
            }

            @TestMetadata("constValInAnnotationDefault.kt")
            public void testConstValInAnnotationDefault() throws Exception {
                runTest("compiler/testData/codegen/box/properties/const/constValInAnnotationDefault.kt");
            }

            @TestMetadata("fpNonConstValProperlyInitialized.kt")
            public void testFpNonConstValProperlyInitialized() throws Exception {
                runTest("compiler/testData/codegen/box/properties/const/fpNonConstValProperlyInitialized.kt");
            }

            @TestMetadata("interfaceCompanion.kt")
            public void testInterfaceCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/properties/const/interfaceCompanion.kt");
            }

            @TestMetadata("nonConstValsAreProperlyInitialized.kt")
            public void testNonConstValsAreProperlyInitialized() throws Exception {
                runTest("compiler/testData/codegen/box/properties/const/nonConstValsAreProperlyInitialized.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/properties/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lateinit extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            @TestMetadata("accessor.kt")
            public void testAccessor() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/accessor.kt");
            }

            @TestMetadata("accessorException.kt")
            public void testAccessorException() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/accessorException.kt");
            }

            @TestMetadata("accessorExceptionPublic.kt")
            public void testAccessorExceptionPublic() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/accessorExceptionPublic.kt");
            }

            public void testAllFilesPresentInLateinit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("exceptionField.kt")
            public void testExceptionField() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/exceptionField.kt");
            }

            @TestMetadata("exceptionGetter.kt")
            public void testExceptionGetter() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/exceptionGetter.kt");
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/override.kt");
            }

            @TestMetadata("overrideException.kt")
            public void testOverrideException() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/overrideException.kt");
            }

            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/privateSetter.kt");
            }

            @TestMetadata("privateSetterFromLambda.kt")
            public void testPrivateSetterFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/privateSetterFromLambda.kt");
            }

            @TestMetadata("privateSetterViaSubclass.kt")
            public void testPrivateSetterViaSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/privateSetterViaSubclass.kt");
            }

            @TestMetadata("simpleVar.kt")
            public void testSimpleVar() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/simpleVar.kt");
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                runTest("compiler/testData/codegen/box/properties/lateinit/visibility.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IsInitializedAndDeinitialize extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInIsInitializedAndDeinitialize() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("companionObjectField.kt")
                public void testCompanionObjectField() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/companionObjectField.kt");
                }

                @TestMetadata("emptyLhs.kt")
                public void testEmptyLhs() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/emptyLhs.kt");
                }

                @TestMetadata("innerSubclass.kt")
                public void testInnerSubclass() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/innerSubclass.kt");
                }

                @TestMetadata("nonInlineLambda.kt")
                public void testNonInlineLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/nonInlineLambda.kt");
                }

                @TestMetadata("propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/propertyImportedFromObject.kt");
                }

                @TestMetadata("sideEffects.kt")
                public void testSideEffects() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/sideEffects.kt");
                }

                @TestMetadata("simpleIsInitialized.kt")
                public void testSimpleIsInitialized() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/simpleIsInitialized.kt");
                }

                @TestMetadata("topLevelProperty.kt")
                public void testTopLevelProperty() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/isInitializedAndDeinitialize/topLevelProperty.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/properties/lateinit/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/lateinit/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("capturedLocalLateinit.kt")
                public void testCapturedLocalLateinit() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/capturedLocalLateinit.kt");
                }

                @TestMetadata("kt23260.kt")
                public void testKt23260() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/kt23260.kt");
                }

                @TestMetadata("localLateinit.kt")
                public void testLocalLateinit() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/localLateinit.kt");
                }

                @TestMetadata("uninitializedCapturedMemberAccess.kt")
                public void testUninitializedCapturedMemberAccess() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/uninitializedCapturedMemberAccess.kt");
                }

                @TestMetadata("uninitializedCapturedRead.kt")
                public void testUninitializedCapturedRead() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/uninitializedCapturedRead.kt");
                }

                @TestMetadata("uninitializedMemberAccess.kt")
                public void testUninitializedMemberAccess() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/uninitializedMemberAccess.kt");
                }

                @TestMetadata("uninitializedRead.kt")
                public void testUninitializedRead() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/local/uninitializedRead.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/properties/lateinit/topLevel")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TopLevel extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                @TestMetadata("accessorException.kt")
                public void testAccessorException() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/topLevel/accessorException.kt");
                }

                @TestMetadata("accessorForTopLevelLateinit.kt")
                public void testAccessorForTopLevelLateinit() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/topLevel/accessorForTopLevelLateinit.kt");
                }

                public void testAllFilesPresentInTopLevel() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/lateinit/topLevel"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("topLevelLateinit.kt")
                public void testTopLevelLateinit() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/topLevel/topLevelLateinit.kt");
                }

                @TestMetadata("uninitializedMemberAccess.kt")
                public void testUninitializedMemberAccess() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/topLevel/uninitializedMemberAccess.kt");
                }

                @TestMetadata("uninitializedRead.kt")
                public void testUninitializedRead() throws Exception {
                    runTest("compiler/testData/codegen/box/properties/lateinit/topLevel/uninitializedRead.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/publishedApi")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PublishedApi extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInPublishedApi() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/publishedApi"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("noMangling.kt")
        public void testNoMangling() throws Exception {
            runTest("compiler/testData/codegen/box/publishedApi/noMangling.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/publishedApi/simple.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/publishedApi/topLevel.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ranges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ranges extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInRanges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("forByteProgressionWithIntIncrement.kt")
        public void testForByteProgressionWithIntIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forByteProgressionWithIntIncrement.kt");
        }

        @TestMetadata("forInRangeLiteralWithMixedTypeBounds.kt")
        public void testForInRangeLiteralWithMixedTypeBounds() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forInRangeLiteralWithMixedTypeBounds.kt");
        }

        @TestMetadata("forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forInRangeWithImplicitReceiver.kt");
        }

        @TestMetadata("forInStringVarUpdatedInLoopBody.kt")
        public void testForInStringVarUpdatedInLoopBody() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forInStringVarUpdatedInLoopBody.kt");
        }

        @TestMetadata("forInStringWithCustomIterator.kt")
        public void testForInStringWithCustomIterator() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forInStringWithCustomIterator.kt");
        }

        @TestMetadata("forIntRange.kt")
        public void testForIntRange() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forIntRange.kt");
        }

        @TestMetadata("forNullableIntInRangeWithImplicitReceiver.kt")
        public void testForNullableIntInRangeWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/forNullableIntInRangeWithImplicitReceiver.kt");
        }

        @TestMetadata("multiAssignmentIterationOverIntRange.kt")
        public void testMultiAssignmentIterationOverIntRange() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/multiAssignmentIterationOverIntRange.kt");
        }

        @TestMetadata("safeCallRangeTo.kt")
        public void testSafeCallRangeTo() throws Exception {
            runTest("compiler/testData/codegen/box/ranges/safeCallRangeTo.kt");
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/contains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contains extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/contains"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("comparisonWithRangeBoundEliminated.kt")
            public void testComparisonWithRangeBoundEliminated() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/comparisonWithRangeBoundEliminated.kt");
            }

            @TestMetadata("evaluationOrderForCollection.kt")
            public void testEvaluationOrderForCollection() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/evaluationOrderForCollection.kt");
            }

            @TestMetadata("evaluationOrderForComparableRange.kt")
            public void testEvaluationOrderForComparableRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/evaluationOrderForComparableRange.kt");
            }

            @TestMetadata("evaluationOrderForDownTo.kt")
            public void testEvaluationOrderForDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/evaluationOrderForDownTo.kt");
            }

            @TestMetadata("evaluationOrderForRangeLiteral.kt")
            public void testEvaluationOrderForRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/evaluationOrderForRangeLiteral.kt");
            }

            @TestMetadata("genericCharInRangeLiteral.kt")
            public void testGenericCharInRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/genericCharInRangeLiteral.kt");
            }

            @TestMetadata("inArray.kt")
            public void testInArray() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inArray.kt");
            }

            @TestMetadata("inCharSequence.kt")
            public void testInCharSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inCharSequence.kt");
            }

            @TestMetadata("inComparableRange.kt")
            public void testInComparableRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inComparableRange.kt");
            }

            @TestMetadata("inCustomObjectRange.kt")
            public void testInCustomObjectRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inCustomObjectRange.kt");
            }

            @TestMetadata("inDoubleRangeLiteralVsComparableRangeLiteral.kt")
            public void testInDoubleRangeLiteralVsComparableRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inDoubleRangeLiteralVsComparableRangeLiteral.kt");
            }

            @TestMetadata("inExtensionRange.kt")
            public void testInExtensionRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inExtensionRange.kt");
            }

            @TestMetadata("inFloatingPointRangeWithNaNBound.kt")
            public void testInFloatingPointRangeWithNaNBound() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inFloatingPointRangeWithNaNBound.kt");
            }

            @TestMetadata("inIntRange.kt")
            public void testInIntRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inIntRange.kt");
            }

            @TestMetadata("inIterable.kt")
            public void testInIterable() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inIterable.kt");
            }

            @TestMetadata("inNonMatchingRange.kt")
            public void testInNonMatchingRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inNonMatchingRange.kt");
            }

            @TestMetadata("inOptimizableDoubleRange.kt")
            public void testInOptimizableDoubleRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inOptimizableDoubleRange.kt");
            }

            @TestMetadata("inOptimizableFloatRange.kt")
            public void testInOptimizableFloatRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inOptimizableFloatRange.kt");
            }

            @TestMetadata("inOptimizableIntRange.kt")
            public void testInOptimizableIntRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inOptimizableIntRange.kt");
            }

            @TestMetadata("inOptimizableLongRange.kt")
            public void testInOptimizableLongRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inOptimizableLongRange.kt");
            }

            @TestMetadata("inPrimitiveProgression.kt")
            public void testInPrimitiveProgression() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inPrimitiveProgression.kt");
            }

            @TestMetadata("inPrimitiveRange.kt")
            public void testInPrimitiveRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inPrimitiveRange.kt");
            }

            @TestMetadata("inRangeLiteralComposition.kt")
            public void testInRangeLiteralComposition() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inRangeLiteralComposition.kt");
            }

            @TestMetadata("inRangeWithCustomContains.kt")
            public void testInRangeWithCustomContains() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inRangeWithCustomContains.kt");
            }

            @TestMetadata("inRangeWithImplicitReceiver.kt")
            public void testInRangeWithImplicitReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inRangeWithImplicitReceiver.kt");
            }

            @TestMetadata("inRangeWithNonmatchingArguments.kt")
            public void testInRangeWithNonmatchingArguments() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inRangeWithNonmatchingArguments.kt");
            }

            @TestMetadata("inRangeWithSmartCast.kt")
            public void testInRangeWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inRangeWithSmartCast.kt");
            }

            @TestMetadata("inUntil.kt")
            public void testInUntil() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/inUntil.kt");
            }

            @TestMetadata("kt20106.kt")
            public void testKt20106() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/kt20106.kt");
            }

            @TestMetadata("nullableInPrimitiveRange.kt")
            public void testNullableInPrimitiveRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/nullableInPrimitiveRange.kt");
            }

            @TestMetadata("rangeContainsString.kt")
            public void testRangeContainsString() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/contains/rangeContainsString.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/ranges/contains/generated")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Generated extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInGenerated() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/contains/generated"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("arrayIndices.kt")
                public void testArrayIndices() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/arrayIndices.kt");
                }

                @TestMetadata("charDownTo.kt")
                public void testCharDownTo() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/charDownTo.kt");
                }

                @TestMetadata("charRangeLiteral.kt")
                public void testCharRangeLiteral() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/charRangeLiteral.kt");
                }

                @TestMetadata("charSequenceIndices.kt")
                public void testCharSequenceIndices() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/charSequenceIndices.kt");
                }

                @TestMetadata("charUntil.kt")
                public void testCharUntil() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/charUntil.kt");
                }

                @TestMetadata("collectionIndices.kt")
                public void testCollectionIndices() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/collectionIndices.kt");
                }

                @TestMetadata("doubleRangeLiteral.kt")
                public void testDoubleRangeLiteral() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/doubleRangeLiteral.kt");
                }

                @TestMetadata("floatRangeLiteral.kt")
                public void testFloatRangeLiteral() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/floatRangeLiteral.kt");
                }

                @TestMetadata("intDownTo.kt")
                public void testIntDownTo() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/intDownTo.kt");
                }

                @TestMetadata("intRangeLiteral.kt")
                public void testIntRangeLiteral() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/intRangeLiteral.kt");
                }

                @TestMetadata("intUntil.kt")
                public void testIntUntil() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/intUntil.kt");
                }

                @TestMetadata("longDownTo.kt")
                public void testLongDownTo() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/longDownTo.kt");
                }

                @TestMetadata("longRangeLiteral.kt")
                public void testLongRangeLiteral() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/longRangeLiteral.kt");
                }

                @TestMetadata("longUntil.kt")
                public void testLongUntil() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/contains/generated/longUntil.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/expression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Expression extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/expression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("emptyDownto.kt")
            public void testEmptyDownto() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/emptyDownto.kt");
            }

            @TestMetadata("emptyRange.kt")
            public void testEmptyRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/emptyRange.kt");
            }

            @TestMetadata("inexactDownToMinValue.kt")
            public void testInexactDownToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/inexactDownToMinValue.kt");
            }

            @TestMetadata("inexactSteppedDownTo.kt")
            public void testInexactSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/inexactSteppedDownTo.kt");
            }

            @TestMetadata("inexactSteppedRange.kt")
            public void testInexactSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/inexactSteppedRange.kt");
            }

            @TestMetadata("inexactToMaxValue.kt")
            public void testInexactToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/inexactToMaxValue.kt");
            }

            @TestMetadata("maxValueMinusTwoToMaxValue.kt")
            public void testMaxValueMinusTwoToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/maxValueMinusTwoToMaxValue.kt");
            }

            @TestMetadata("maxValueToMaxValue.kt")
            public void testMaxValueToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/maxValueToMaxValue.kt");
            }

            @TestMetadata("maxValueToMinValue.kt")
            public void testMaxValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/maxValueToMinValue.kt");
            }

            @TestMetadata("oneElementDownTo.kt")
            public void testOneElementDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/oneElementDownTo.kt");
            }

            @TestMetadata("oneElementRange.kt")
            public void testOneElementRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/oneElementRange.kt");
            }

            @TestMetadata("openRange.kt")
            public void testOpenRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/openRange.kt");
            }

            @TestMetadata("overflowZeroDownToMaxValue.kt")
            public void testOverflowZeroDownToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/overflowZeroDownToMaxValue.kt");
            }

            @TestMetadata("overflowZeroToMinValue.kt")
            public void testOverflowZeroToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/overflowZeroToMinValue.kt");
            }

            @TestMetadata("progressionDownToMinValue.kt")
            public void testProgressionDownToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/progressionDownToMinValue.kt");
            }

            @TestMetadata("progressionMaxValueMinusTwoToMaxValue.kt")
            public void testProgressionMaxValueMinusTwoToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/progressionMaxValueMinusTwoToMaxValue.kt");
            }

            @TestMetadata("progressionMaxValueToMaxValue.kt")
            public void testProgressionMaxValueToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/progressionMaxValueToMaxValue.kt");
            }

            @TestMetadata("progressionMaxValueToMinValue.kt")
            public void testProgressionMaxValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/progressionMaxValueToMinValue.kt");
            }

            @TestMetadata("progressionMinValueToMinValue.kt")
            public void testProgressionMinValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/progressionMinValueToMinValue.kt");
            }

            @TestMetadata("reversedBackSequence.kt")
            public void testReversedBackSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedBackSequence.kt");
            }

            @TestMetadata("reversedEmptyBackSequence.kt")
            public void testReversedEmptyBackSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedEmptyBackSequence.kt");
            }

            @TestMetadata("reversedEmptyRange.kt")
            public void testReversedEmptyRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedEmptyRange.kt");
            }

            @TestMetadata("reversedInexactSteppedDownTo.kt")
            public void testReversedInexactSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedInexactSteppedDownTo.kt");
            }

            @TestMetadata("reversedRange.kt")
            public void testReversedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedRange.kt");
            }

            @TestMetadata("reversedSimpleSteppedRange.kt")
            public void testReversedSimpleSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/reversedSimpleSteppedRange.kt");
            }

            @TestMetadata("simpleDownTo.kt")
            public void testSimpleDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/simpleDownTo.kt");
            }

            @TestMetadata("simpleRange.kt")
            public void testSimpleRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/simpleRange.kt");
            }

            @TestMetadata("simpleRangeWithNonConstantEnds.kt")
            public void testSimpleRangeWithNonConstantEnds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/simpleRangeWithNonConstantEnds.kt");
            }

            @TestMetadata("simpleSteppedDownTo.kt")
            public void testSimpleSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/simpleSteppedDownTo.kt");
            }

            @TestMetadata("simpleSteppedRange.kt")
            public void testSimpleSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/expression/simpleSteppedRange.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInDownTo")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInDownTo extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInDownTo() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInDownTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forIntInDownTo.kt")
            public void testForIntInDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInDownTo/forIntInDownTo.kt");
            }

            @TestMetadata("forIntInDownToWithNonConstBounds.kt")
            public void testForIntInDownToWithNonConstBounds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInDownTo/forIntInDownToWithNonConstBounds.kt");
            }

            @TestMetadata("forIntInNonOptimizedDownTo.kt")
            public void testForIntInNonOptimizedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInDownTo/forIntInNonOptimizedDownTo.kt");
            }

            @TestMetadata("forLongInDownTo.kt")
            public void testForLongInDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInDownTo/forLongInDownTo.kt");
            }

            @TestMetadata("forNullableIntInDownTo.kt")
            public void testForNullableIntInDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInDownTo/forNullableIntInDownTo.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInIndices")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIndices extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInIndices() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInIndices"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInCharSequenceIndices.kt");
            }

            @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInCollectionImplicitReceiverIndices.kt");
            }

            @TestMetadata("forInCollectionIndices.kt")
            public void testForInCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInCollectionIndices.kt");
            }

            @TestMetadata("forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInNonOptimizedIndices.kt");
            }

            @TestMetadata("forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInObjectArrayIndices.kt");
            }

            @TestMetadata("forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forInPrimitiveArrayIndices.kt");
            }

            @TestMetadata("forNullableIntInArrayIndices.kt")
            public void testForNullableIntInArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forNullableIntInArrayIndices.kt");
            }

            @TestMetadata("forNullableIntInCollectionIndices.kt")
            public void testForNullableIntInCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/forNullableIntInCollectionIndices.kt");
            }

            @TestMetadata("indexOfLast.kt")
            public void testIndexOfLast() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/indexOfLast.kt");
            }

            @TestMetadata("kt12983_forInGenericArrayIndices.kt")
            public void testKt12983_forInGenericArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInGenericArrayIndices.kt");
            }

            @TestMetadata("kt12983_forInGenericCollectionIndices.kt")
            public void testKt12983_forInGenericCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInGenericCollectionIndices.kt");
            }

            @TestMetadata("kt12983_forInSpecificArrayIndices.kt")
            public void testKt12983_forInSpecificArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInSpecificArrayIndices.kt");
            }

            @TestMetadata("kt12983_forInSpecificCollectionIndices.kt")
            public void testKt12983_forInSpecificCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInSpecificCollectionIndices.kt");
            }

            @TestMetadata("kt13241_Array.kt")
            public void testKt13241_Array() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt13241_Array.kt");
            }

            @TestMetadata("kt13241_CharSequence.kt")
            public void testKt13241_CharSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt13241_CharSequence.kt");
            }

            @TestMetadata("kt13241_Collection.kt")
            public void testKt13241_Collection() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInIndices/kt13241_Collection.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInReversed extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInReversed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInReversed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInReversedArrayIndices.kt")
            public void testForInReversedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedArrayIndices.kt");
            }

            @TestMetadata("forInReversedCharSequenceIndices.kt")
            public void testForInReversedCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedCharSequenceIndices.kt");
            }

            @TestMetadata("forInReversedCollectionIndices.kt")
            public void testForInReversedCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedCollectionIndices.kt");
            }

            @TestMetadata("forInReversedDownTo.kt")
            public void testForInReversedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedDownTo.kt");
            }

            @TestMetadata("forInReversedEmptyRange.kt")
            public void testForInReversedEmptyRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedEmptyRange.kt");
            }

            @TestMetadata("forInReversedEmptyRangeLiteral.kt")
            public void testForInReversedEmptyRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedEmptyRangeLiteral.kt");
            }

            @TestMetadata("forInReversedEmptyRangeLiteralWithNonConstBounds.kt")
            public void testForInReversedEmptyRangeLiteralWithNonConstBounds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedEmptyRangeLiteralWithNonConstBounds.kt");
            }

            @TestMetadata("forInReversedRange.kt")
            public void testForInReversedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedRange.kt");
            }

            @TestMetadata("forInReversedRangeLiteral.kt")
            public void testForInReversedRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedRangeLiteral.kt");
            }

            @TestMetadata("forInReversedRangeLiteralWithNonConstBounds.kt")
            public void testForInReversedRangeLiteralWithNonConstBounds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedRangeLiteralWithNonConstBounds.kt");
            }

            @TestMetadata("ForInReversedReversedRange.kt")
            public void testForInReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/ForInReversedReversedRange.kt");
            }

            @TestMetadata("forInReversedReversedReversedRange.kt")
            public void testForInReversedReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedReversedReversedRange.kt");
            }

            @TestMetadata("forInReversedUntil.kt")
            public void testForInReversedUntil() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedUntil.kt");
            }

            @TestMetadata("forInReversedUntilWithNonConstBounds.kt")
            public void testForInReversedUntilWithNonConstBounds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInReversed/forInReversedUntilWithNonConstBounds.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/ranges/forInReversed/evaluationOrder")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EvaluationOrder extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInEvaluationOrder() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInReversed/evaluationOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("forInReversedDownToEvaluationOrder.kt")
                public void testForInReversedDownToEvaluationOrder() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/forInReversed/evaluationOrder/forInReversedDownToEvaluationOrder.kt");
                }

                @TestMetadata("forInReversedRangeLiteralEvaluationOrder.kt")
                public void testForInReversedRangeLiteralEvaluationOrder() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/forInReversed/evaluationOrder/forInReversedRangeLiteralEvaluationOrder.kt");
                }

                @TestMetadata("forInReversedUntilEvaluationOrder.kt")
                public void testForInReversedUntilEvaluationOrder() throws Exception {
                    runTest("compiler/testData/codegen/box/ranges/forInReversed/evaluationOrder/forInReversedUntilEvaluationOrder.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInUntil")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInUntil extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForInUntil() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInUntil"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInUntilChar.kt")
            public void testForInUntilChar() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilChar.kt");
            }

            @TestMetadata("forInUntilChar0.kt")
            public void testForInUntilChar0() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilChar0.kt");
            }

            @TestMetadata("forInUntilInt.kt")
            public void testForInUntilInt() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilInt.kt");
            }

            @TestMetadata("forInUntilLesserInt.kt")
            public void testForInUntilLesserInt() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilLesserInt.kt");
            }

            @TestMetadata("forInUntilLong.kt")
            public void testForInUntilLong() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilLong.kt");
            }

            @TestMetadata("forInUntilMaxint.kt")
            public void testForInUntilMaxint() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilMaxint.kt");
            }

            @TestMetadata("forInUntilMinint.kt")
            public void testForInUntilMinint() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilMinint.kt");
            }

            @TestMetadata("forInUntilMinlong.kt")
            public void testForInUntilMinlong() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forInUntilMinlong.kt");
            }

            @TestMetadata("forIntInIntUntilSmartcastInt.kt")
            public void testForIntInIntUntilSmartcastInt() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forInUntil/forIntInIntUntilSmartcastInt.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forWithPossibleOverflow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForWithPossibleOverflow extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInForWithPossibleOverflow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forWithPossibleOverflow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInDownToCharMinValue.kt")
            public void testForInDownToCharMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToCharMinValue.kt");
            }

            @TestMetadata("forInDownToCharMinValueReversed.kt")
            public void testForInDownToCharMinValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToCharMinValueReversed.kt");
            }

            @TestMetadata("forInDownToIntMinValue.kt")
            public void testForInDownToIntMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToIntMinValue.kt");
            }

            @TestMetadata("forInDownToIntMinValueReversed.kt")
            public void testForInDownToIntMinValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToIntMinValueReversed.kt");
            }

            @TestMetadata("forInDownToLongMinValue.kt")
            public void testForInDownToLongMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToLongMinValue.kt");
            }

            @TestMetadata("forInDownToLongMinValueReversed.kt")
            public void testForInDownToLongMinValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInDownToLongMinValueReversed.kt");
            }

            @TestMetadata("forInRangeToCharMaxValue.kt")
            public void testForInRangeToCharMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToCharMaxValue.kt");
            }

            @TestMetadata("forInRangeToCharMaxValueReversed.kt")
            public void testForInRangeToCharMaxValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToCharMaxValueReversed.kt");
            }

            @TestMetadata("forInRangeToIntMaxValue.kt")
            public void testForInRangeToIntMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToIntMaxValue.kt");
            }

            @TestMetadata("forInRangeToIntMaxValueReversed.kt")
            public void testForInRangeToIntMaxValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToIntMaxValueReversed.kt");
            }

            @TestMetadata("forInRangeToLongMaxValue.kt")
            public void testForInRangeToLongMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToLongMaxValue.kt");
            }

            @TestMetadata("forInRangeToLongMaxValueReversed.kt")
            public void testForInRangeToLongMaxValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInRangeToLongMaxValueReversed.kt");
            }

            @TestMetadata("forInUntilIntMinValueReversed.kt")
            public void testForInUntilIntMinValueReversed() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/forWithPossibleOverflow/forInUntilIntMinValueReversed.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/literal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Literal extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInLiteral() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/literal"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("emptyDownto.kt")
            public void testEmptyDownto() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/emptyDownto.kt");
            }

            @TestMetadata("emptyRange.kt")
            public void testEmptyRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/emptyRange.kt");
            }

            @TestMetadata("inexactDownToMinValue.kt")
            public void testInexactDownToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/inexactDownToMinValue.kt");
            }

            @TestMetadata("inexactSteppedDownTo.kt")
            public void testInexactSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/inexactSteppedDownTo.kt");
            }

            @TestMetadata("inexactSteppedRange.kt")
            public void testInexactSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/inexactSteppedRange.kt");
            }

            @TestMetadata("inexactToMaxValue.kt")
            public void testInexactToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/inexactToMaxValue.kt");
            }

            @TestMetadata("maxValueMinusTwoToMaxValue.kt")
            public void testMaxValueMinusTwoToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/maxValueMinusTwoToMaxValue.kt");
            }

            @TestMetadata("maxValueToMaxValue.kt")
            public void testMaxValueToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/maxValueToMaxValue.kt");
            }

            @TestMetadata("maxValueToMinValue.kt")
            public void testMaxValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/maxValueToMinValue.kt");
            }

            @TestMetadata("oneElementDownTo.kt")
            public void testOneElementDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/oneElementDownTo.kt");
            }

            @TestMetadata("oneElementRange.kt")
            public void testOneElementRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/oneElementRange.kt");
            }

            @TestMetadata("openRange.kt")
            public void testOpenRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/openRange.kt");
            }

            @TestMetadata("overflowZeroDownToMaxValue.kt")
            public void testOverflowZeroDownToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/overflowZeroDownToMaxValue.kt");
            }

            @TestMetadata("overflowZeroToMinValue.kt")
            public void testOverflowZeroToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/overflowZeroToMinValue.kt");
            }

            @TestMetadata("progressionDownToMinValue.kt")
            public void testProgressionDownToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/progressionDownToMinValue.kt");
            }

            @TestMetadata("progressionMaxValueMinusTwoToMaxValue.kt")
            public void testProgressionMaxValueMinusTwoToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/progressionMaxValueMinusTwoToMaxValue.kt");
            }

            @TestMetadata("progressionMaxValueToMaxValue.kt")
            public void testProgressionMaxValueToMaxValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/progressionMaxValueToMaxValue.kt");
            }

            @TestMetadata("progressionMaxValueToMinValue.kt")
            public void testProgressionMaxValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/progressionMaxValueToMinValue.kt");
            }

            @TestMetadata("progressionMinValueToMinValue.kt")
            public void testProgressionMinValueToMinValue() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/progressionMinValueToMinValue.kt");
            }

            @TestMetadata("reversedBackSequence.kt")
            public void testReversedBackSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedBackSequence.kt");
            }

            @TestMetadata("reversedEmptyBackSequence.kt")
            public void testReversedEmptyBackSequence() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedEmptyBackSequence.kt");
            }

            @TestMetadata("reversedEmptyRange.kt")
            public void testReversedEmptyRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedEmptyRange.kt");
            }

            @TestMetadata("reversedInexactSteppedDownTo.kt")
            public void testReversedInexactSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedInexactSteppedDownTo.kt");
            }

            @TestMetadata("reversedRange.kt")
            public void testReversedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedRange.kt");
            }

            @TestMetadata("reversedSimpleSteppedRange.kt")
            public void testReversedSimpleSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/reversedSimpleSteppedRange.kt");
            }

            @TestMetadata("simpleDownTo.kt")
            public void testSimpleDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/simpleDownTo.kt");
            }

            @TestMetadata("simpleRange.kt")
            public void testSimpleRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/simpleRange.kt");
            }

            @TestMetadata("simpleRangeWithNonConstantEnds.kt")
            public void testSimpleRangeWithNonConstantEnds() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/simpleRangeWithNonConstantEnds.kt");
            }

            @TestMetadata("simpleSteppedDownTo.kt")
            public void testSimpleSteppedDownTo() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/simpleSteppedDownTo.kt");
            }

            @TestMetadata("simpleSteppedRange.kt")
            public void testSimpleSteppedRange() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/literal/simpleSteppedRange.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/nullableLoopParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullableLoopParameter extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInNullableLoopParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/nullableLoopParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("progressionExpression.kt")
            public void testProgressionExpression() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/nullableLoopParameter/progressionExpression.kt");
            }

            @TestMetadata("rangeExpression.kt")
            public void testRangeExpression() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/nullableLoopParameter/rangeExpression.kt");
            }

            @TestMetadata("rangeLiteral.kt")
            public void testRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/ranges/nullableLoopParameter/rangeLiteral.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/reflection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reflection extends AbstractLightAnalysisModeTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
        }

        public void testAllFilesPresentInReflection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationRetentionAnnotation.kt")
            public void testAnnotationRetentionAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/annotationRetentionAnnotation.kt");
            }

            @TestMetadata("annotationsOnJavaMembers.kt")
            public void testAnnotationsOnJavaMembers() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/annotationsOnJavaMembers.kt");
            }

            @TestMetadata("classLiteralWithVoidDefault.kt")
            public void testClassLiteralWithVoidDefault() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/classLiteralWithVoidDefault.kt");
            }

            @TestMetadata("findAnnotation.kt")
            public void testFindAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/findAnnotation.kt");
            }

            @TestMetadata("localClassLiteral.kt")
            public void testLocalClassLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/localClassLiteral.kt");
            }

            @TestMetadata("localClassParameterAnnotation.kt")
            public void testLocalClassParameterAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/localClassParameterAnnotation.kt");
            }

            @TestMetadata("openSuspendFun.kt")
            public void testOpenSuspendFun() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/openSuspendFun.kt");
            }

            @TestMetadata("privateAnnotation.kt")
            public void testPrivateAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/privateAnnotation.kt");
            }

            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/propertyAccessors.kt");
            }

            @TestMetadata("propertyWithoutBackingField.kt")
            public void testPropertyWithoutBackingField() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/propertyWithoutBackingField.kt");
            }

            @TestMetadata("retentions.kt")
            public void testRetentions() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/retentions.kt");
            }

            @TestMetadata("setparam.kt")
            public void testSetparam() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/setparam.kt");
            }

            @TestMetadata("simpleClassAnnotation.kt")
            public void testSimpleClassAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/simpleClassAnnotation.kt");
            }

            @TestMetadata("simpleConstructorAnnotation.kt")
            public void testSimpleConstructorAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/simpleConstructorAnnotation.kt");
            }

            @TestMetadata("simpleFunAnnotation.kt")
            public void testSimpleFunAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/simpleFunAnnotation.kt");
            }

            @TestMetadata("simpleParamAnnotation.kt")
            public void testSimpleParamAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/simpleParamAnnotation.kt");
            }

            @TestMetadata("simpleValAnnotation.kt")
            public void testSimpleValAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/annotations/simpleValAnnotation.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/annotations/onTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OnTypes extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInOnTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/annotations/onTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("differentArgumentTypes.kt")
                public void testDifferentArgumentTypes() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/annotations/onTypes/differentArgumentTypes.kt");
                }

                @TestMetadata("differentPositions.kt")
                public void testDifferentPositions() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/annotations/onTypes/differentPositions.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/builtins")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Builtins extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInBuiltins() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/builtins"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("collections.kt")
            public void testCollections() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/builtins/collections.kt");
            }

            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/builtins/enumNameOrdinal.kt");
            }

            @TestMetadata("stringLength.kt")
            public void testStringLength() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/builtins/stringLength.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/call")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Call extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/call"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("bigArity.kt")
            public void testBigArity() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/bigArity.kt");
            }

            @TestMetadata("callInstanceJavaMethod.kt")
            public void testCallInstanceJavaMethod() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/callInstanceJavaMethod.kt");
            }

            @TestMetadata("callPrivateJavaMethod.kt")
            public void testCallPrivateJavaMethod() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/callPrivateJavaMethod.kt");
            }

            @TestMetadata("callStaticJavaMethod.kt")
            public void testCallStaticJavaMethod() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/callStaticJavaMethod.kt");
            }

            @TestMetadata("cannotCallEnumConstructor.kt")
            public void testCannotCallEnumConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/cannotCallEnumConstructor.kt");
            }

            @TestMetadata("disallowNullValueForNotNullField.kt")
            public void testDisallowNullValueForNotNullField() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/disallowNullValueForNotNullField.kt");
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/equalsHashCodeToString.kt");
            }

            @TestMetadata("exceptionHappened.kt")
            public void testExceptionHappened() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/exceptionHappened.kt");
            }

            @TestMetadata("fakeOverride.kt")
            public void testFakeOverride() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/fakeOverride.kt");
            }

            @TestMetadata("fakeOverrideSubstituted.kt")
            public void testFakeOverrideSubstituted() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/fakeOverrideSubstituted.kt");
            }

            @TestMetadata("incorrectNumberOfArguments.kt")
            public void testIncorrectNumberOfArguments() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/incorrectNumberOfArguments.kt");
            }

            @TestMetadata("innerClassConstructor.kt")
            public void testInnerClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/innerClassConstructor.kt");
            }

            @TestMetadata("jvmStatic.kt")
            public void testJvmStatic() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/jvmStatic.kt");
            }

            @TestMetadata("jvmStaticInObjectIncorrectReceiver.kt")
            public void testJvmStaticInObjectIncorrectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/jvmStaticInObjectIncorrectReceiver.kt");
            }

            @TestMetadata("localClassMember.kt")
            public void testLocalClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/localClassMember.kt");
            }

            @TestMetadata("memberOfGenericClass.kt")
            public void testMemberOfGenericClass() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/memberOfGenericClass.kt");
            }

            @TestMetadata("privateProperty.kt")
            public void testPrivateProperty() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/privateProperty.kt");
            }

            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/propertyAccessors.kt");
            }

            @TestMetadata("propertyGetterAndGetFunctionDifferentReturnType.kt")
            public void testPropertyGetterAndGetFunctionDifferentReturnType() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/propertyGetterAndGetFunctionDifferentReturnType.kt");
            }

            @TestMetadata("protectedMembers.kt")
            public void testProtectedMembers() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/protectedMembers.kt");
            }

            @TestMetadata("returnUnit.kt")
            public void testReturnUnit() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/returnUnit.kt");
            }

            @TestMetadata("simpleConstructor.kt")
            public void testSimpleConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/simpleConstructor.kt");
            }

            @TestMetadata("simpleMemberFunction.kt")
            public void testSimpleMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/simpleMemberFunction.kt");
            }

            @TestMetadata("simpleTopLevelFunctions.kt")
            public void testSimpleTopLevelFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/call/simpleTopLevelFunctions.kt");
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/call/bound")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bound extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInBound() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/call/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("companionObjectPropertyAccessors.kt")
                public void testCompanionObjectPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/companionObjectPropertyAccessors.kt");
                }

                @TestMetadata("extensionFunction.kt")
                public void testExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/extensionFunction.kt");
                }

                @TestMetadata("extensionPropertyAccessors.kt")
                public void testExtensionPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/extensionPropertyAccessors.kt");
                }

                @TestMetadata("innerClassConstructor.kt")
                public void testInnerClassConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/innerClassConstructor.kt");
                }

                @TestMetadata("javaInstanceField.kt")
                public void testJavaInstanceField() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/javaInstanceField.kt");
                }

                @TestMetadata("javaInstanceMethod.kt")
                public void testJavaInstanceMethod() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/javaInstanceMethod.kt");
                }

                @TestMetadata("jvmStaticCompanionObjectPropertyAccessors.kt")
                public void testJvmStaticCompanionObjectPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/jvmStaticCompanionObjectPropertyAccessors.kt");
                }

                @TestMetadata("jvmStaticObjectFunction.kt")
                public void testJvmStaticObjectFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/jvmStaticObjectFunction.kt");
                }

                @TestMetadata("jvmStaticObjectPropertyAccessors.kt")
                public void testJvmStaticObjectPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/jvmStaticObjectPropertyAccessors.kt");
                }

                @TestMetadata("memberFunction.kt")
                public void testMemberFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/memberFunction.kt");
                }

                @TestMetadata("memberPropertyAccessors.kt")
                public void testMemberPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/memberPropertyAccessors.kt");
                }

                @TestMetadata("objectFunction.kt")
                public void testObjectFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/objectFunction.kt");
                }

                @TestMetadata("objectPropertyAccessors.kt")
                public void testObjectPropertyAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/bound/objectPropertyAccessors.kt");
                }
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/call/inlineClasses")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InlineClasses extends AbstractLightAnalysisModeTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
                }

                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/call/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("constructorWithInlineClassParameters.kt")
                public void testConstructorWithInlineClassParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/constructorWithInlineClassParameters.kt");
                }

                @TestMetadata("fieldAccessors.kt")
                public void testFieldAccessors() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/fieldAccessors.kt");
                }

                @TestMetadata("functionsWithInlineClassParameters.kt")
                public void testFunctionsWithInlineClassParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/functionsWithInlineClassParameters.kt");
                }

                @TestMetadata("inlineClassConstructor.kt")
                public void testInlineClassConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/inlineClassConstructor.kt");
                }

                @TestMetadata("internalPrimaryValOfInlineClass.kt")
                public void testInternalPrimaryValOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/internalPrimaryValOfInlineClass.kt");
                }

                @TestMetadata("jvmStaticFieldInObject.kt")
                public void testJvmStaticFieldInObject() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/jvmStaticFieldInObject.kt");
                }

                @TestMetadata("jvmStaticFunction.kt")
                public void testJvmStaticFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/jvmStaticFunction.kt");
                }

                @TestMetadata("nonOverridingFunOfInlineClass.kt")
                public void testNonOverridingFunOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/nonOverridingFunOfInlineClass.kt");
                }

                @TestMetadata("nonOverridingVarOfInlineClass.kt")
                public void testNonOverridingVarOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/nonOverridingVarOfInlineClass.kt");
                }

                @TestMetadata("overridingFunOfInlineClass.kt")
                public void testOverridingFunOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/overridingFunOfInlineClass.kt");
                }

                @TestMetadata("overridingVarOfInlineClass.kt")
                public void testOverridingVarOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/overridingVarOfInlineClass.kt");
                }

                @TestMetadata("primaryValOfInlineClass.kt")
                public void testPrimaryValOfInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/primaryValOfInlineClass.kt");
                }

                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    runTest("compiler/testData/codegen/box/reflection/call/inlineClasses/properties.kt");
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/callBy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallBy extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCallBy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/callBy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boundExtensionFunction.kt")
            public void testBoundExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/boundExtensionFunction.kt");
            }

            @TestMetadata("boundExtensionPropertyAcessor.kt")
            public void testBoundExtensionPropertyAcessor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/boundExtensionPropertyAcessor.kt");
            }

            @TestMetadata("boundJvmStaticInObject.kt")
            public void testBoundJvmStaticInObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/boundJvmStaticInObject.kt");
            }

            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/companionObject.kt");
            }

            @TestMetadata("defaultAndNonDefaultIntertwined.kt")
            public void testDefaultAndNonDefaultIntertwined() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/defaultAndNonDefaultIntertwined.kt");
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/extensionFunction.kt");
            }

            @TestMetadata("inlineClassFunctionsAndConstructors.kt")
            public void testInlineClassFunctionsAndConstructors() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/inlineClassFunctionsAndConstructors.kt");
            }

            @TestMetadata("inlineClassMembers.kt")
            public void testInlineClassMembers() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/inlineClassMembers.kt");
            }

            @TestMetadata("jvmStaticInCompanionObject.kt")
            public void testJvmStaticInCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/jvmStaticInCompanionObject.kt");
            }

            @TestMetadata("jvmStaticInObject.kt")
            public void testJvmStaticInObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/jvmStaticInObject.kt");
            }

            @TestMetadata("manyArgumentsNoneDefaultConstructor.kt")
            public void testManyArgumentsNoneDefaultConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/manyArgumentsNoneDefaultConstructor.kt");
            }

            @TestMetadata("manyArgumentsNoneDefaultFunction.kt")
            public void testManyArgumentsNoneDefaultFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/manyArgumentsNoneDefaultFunction.kt");
            }

            @TestMetadata("manyArgumentsOnlyOneDefault.kt")
            public void testManyArgumentsOnlyOneDefault() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/manyArgumentsOnlyOneDefault.kt");
            }

            @TestMetadata("manyMaskArguments.kt")
            public void testManyMaskArguments() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/manyMaskArguments.kt");
            }

            @TestMetadata("nonDefaultParameterOmitted.kt")
            public void testNonDefaultParameterOmitted() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/nonDefaultParameterOmitted.kt");
            }

            @TestMetadata("nullValue.kt")
            public void testNullValue() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/nullValue.kt");
            }

            @TestMetadata("ordinaryMethodIsInvokedWhenNoDefaultValuesAreUsed.kt")
            public void testOrdinaryMethodIsInvokedWhenNoDefaultValuesAreUsed() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/ordinaryMethodIsInvokedWhenNoDefaultValuesAreUsed.kt");
            }

            @TestMetadata("primitiveDefaultValues.kt")
            public void testPrimitiveDefaultValues() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/primitiveDefaultValues.kt");
            }

            @TestMetadata("privateMemberFunction.kt")
            public void testPrivateMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/privateMemberFunction.kt");
            }

            @TestMetadata("simpleConstructor.kt")
            public void testSimpleConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/simpleConstructor.kt");
            }

            @TestMetadata("simpleMemberFunciton.kt")
            public void testSimpleMemberFunciton() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/simpleMemberFunciton.kt");
            }

            @TestMetadata("simpleTopLevelFunction.kt")
            public void testSimpleTopLevelFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/callBy/simpleTopLevelFunction.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/classLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassLiterals extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInClassLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/classLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationClassLiteral.kt")
            public void testAnnotationClassLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/annotationClassLiteral.kt");
            }

            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/arrays.kt");
            }

            @TestMetadata("builtinClassLiterals.kt")
            public void testBuiltinClassLiterals() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/builtinClassLiterals.kt");
            }

            @TestMetadata("genericArrays.kt")
            public void testGenericArrays() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/genericArrays.kt");
            }

            @TestMetadata("genericClass.kt")
            public void testGenericClass() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/genericClass.kt");
            }

            @TestMetadata("reifiedTypeClassLiteral.kt")
            public void testReifiedTypeClassLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/reifiedTypeClassLiteral.kt");
            }

            @TestMetadata("simpleClassLiteral.kt")
            public void testSimpleClassLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classLiterals/simpleClassLiteral.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/classes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Classes extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("classSimpleName.kt")
            public void testClassSimpleName() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/classSimpleName.kt");
            }

            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/companionObject.kt");
            }

            @TestMetadata("createInstance.kt")
            public void testCreateInstance() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/createInstance.kt");
            }

            @TestMetadata("declaredMembers.kt")
            public void testDeclaredMembers() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/declaredMembers.kt");
            }

            @TestMetadata("javaVoid.kt")
            public void testJavaVoid() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/javaVoid.kt");
            }

            @TestMetadata("jvmName.kt")
            public void testJvmName() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/jvmName.kt");
            }

            @TestMetadata("jvmNameOfStandardClasses.kt")
            public void testJvmNameOfStandardClasses() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/jvmNameOfStandardClasses.kt");
            }

            @TestMetadata("localClassSimpleName.kt")
            public void testLocalClassSimpleName() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/localClassSimpleName.kt");
            }

            @TestMetadata("nestedClasses.kt")
            public void testNestedClasses() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/nestedClasses.kt");
            }

            @TestMetadata("nestedClassesJava.kt")
            public void testNestedClassesJava() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/nestedClassesJava.kt");
            }

            @TestMetadata("objectInstance.kt")
            public void testObjectInstance() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/objectInstance.kt");
            }

            @TestMetadata("primitiveKClassEquality.kt")
            public void testPrimitiveKClassEquality() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/primitiveKClassEquality.kt");
            }

            @TestMetadata("qualifiedName.kt")
            public void testQualifiedName() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/qualifiedName.kt");
            }

            @TestMetadata("qualifiedNameOfStandardClasses.kt")
            public void testQualifiedNameOfStandardClasses() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/qualifiedNameOfStandardClasses.kt");
            }

            @TestMetadata("sealedSubclasses.kt")
            public void testSealedSubclasses() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/sealedSubclasses.kt");
            }

            @TestMetadata("starProjectedType.kt")
            public void testStarProjectedType() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/classes/starProjectedType.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/constructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructors extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/constructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationClass.kt")
            public void testAnnotationClass() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/annotationClass.kt");
            }

            @TestMetadata("classesWithoutConstructors.kt")
            public void testClassesWithoutConstructors() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/classesWithoutConstructors.kt");
            }

            @TestMetadata("constructorName.kt")
            public void testConstructorName() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/constructorName.kt");
            }

            @TestMetadata("enumEntry.kt")
            public void testEnumEntry() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/enumEntry.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/primaryConstructor.kt");
            }

            @TestMetadata("simpleGetConstructors.kt")
            public void testSimpleGetConstructors() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/constructors/simpleGetConstructors.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/createAnnotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateAnnotation extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInCreateAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/createAnnotation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationType.kt")
            public void testAnnotationType() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/annotationType.kt");
            }

            @TestMetadata("arrayOfKClasses.kt")
            public void testArrayOfKClasses() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/arrayOfKClasses.kt");
            }

            @TestMetadata("callByJava.kt")
            public void testCallByJava() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/callByJava.kt");
            }

            @TestMetadata("callByKotlin.kt")
            public void testCallByKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/callByKotlin.kt");
            }

            @TestMetadata("callJava.kt")
            public void testCallJava() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/callJava.kt");
            }

            @TestMetadata("callKotlin.kt")
            public void testCallKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/callKotlin.kt");
            }

            @TestMetadata("createJdkAnnotationInstance.kt")
            public void testCreateJdkAnnotationInstance() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/createJdkAnnotationInstance.kt");
            }

            @TestMetadata("enumKClassAnnotation.kt")
            public void testEnumKClassAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/enumKClassAnnotation.kt");
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/equalsHashCodeToString.kt");
            }

            @TestMetadata("floatingPointParameters.kt")
            public void testFloatingPointParameters() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/floatingPointParameters.kt");
            }

            @TestMetadata("parameterNamedEquals.kt")
            public void testParameterNamedEquals() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/parameterNamedEquals.kt");
            }

            @TestMetadata("primitivesAndArrays.kt")
            public void testPrimitivesAndArrays() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/createAnnotation/primitivesAndArrays.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/enclosing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enclosing extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInEnclosing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/enclosing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("anonymousObjectInInlinedLambda.kt")
            public void testAnonymousObjectInInlinedLambda() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/anonymousObjectInInlinedLambda.kt");
            }

            @TestMetadata("classInLambda.kt")
            public void testClassInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/classInLambda.kt");
            }

            @TestMetadata("functionExpressionInProperty.kt")
            public void testFunctionExpressionInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/functionExpressionInProperty.kt");
            }

            @TestMetadata("kt11969.kt")
            public void testKt11969() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/kt11969.kt");
            }

            @TestMetadata("kt6368.kt")
            public void testKt6368() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/kt6368.kt");
            }

            @TestMetadata("kt6691_lambdaInSamConstructor.kt")
            public void testKt6691_lambdaInSamConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/kt6691_lambdaInSamConstructor.kt");
            }

            @TestMetadata("lambdaInClassObject.kt")
            public void testLambdaInClassObject() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInClassObject.kt");
            }

            @TestMetadata("lambdaInConstructor.kt")
            public void testLambdaInConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInConstructor.kt");
            }

            @TestMetadata("lambdaInFunction.kt")
            public void testLambdaInFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInFunction.kt");
            }

            @TestMetadata("lambdaInLambda.kt")
            public void testLambdaInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInLambda.kt");
            }

            @TestMetadata("lambdaInLocalClassConstructor.kt")
            public void testLambdaInLocalClassConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalClassConstructor.kt");
            }

            @TestMetadata("lambdaInLocalClassSuperCall.kt")
            public void testLambdaInLocalClassSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalClassSuperCall.kt");
            }

            @TestMetadata("lambdaInLocalFunction.kt")
            public void testLambdaInLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalFunction.kt");
            }

            @TestMetadata("lambdaInMemberFunction.kt")
            public void testLambdaInMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunction.kt");
            }

            @TestMetadata("lambdaInMemberFunctionInLocalClass.kt")
            public void testLambdaInMemberFunctionInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunctionInLocalClass.kt");
            }

            @TestMetadata("lambdaInMemberFunctionInNestedClass.kt")
            public void testLambdaInMemberFunctionInNestedClass() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunctionInNestedClass.kt");
            }

            @TestMetadata("lambdaInObjectDeclaration.kt")
            public void testLambdaInObjectDeclaration() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectDeclaration.kt");
            }

            @TestMetadata("lambdaInObjectExpression.kt")
            public void testLambdaInObjectExpression() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectExpression.kt");
            }

            @TestMetadata("lambdaInObjectLiteralSuperCall.kt")
            public void testLambdaInObjectLiteralSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectLiteralSuperCall.kt");
            }

            @TestMetadata("lambdaInPackage.kt")
            public void testLambdaInPackage() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInPackage.kt");
            }

            @TestMetadata("lambdaInPropertyGetter.kt")
            public void testLambdaInPropertyGetter() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInPropertyGetter.kt");
            }

            @TestMetadata("lambdaInPropertySetter.kt")
            public void testLambdaInPropertySetter() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/lambdaInPropertySetter.kt");
            }

            @TestMetadata("localClassInTopLevelFunction.kt")
            public void testLocalClassInTopLevelFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/localClassInTopLevelFunction.kt");
            }

            @TestMetadata("objectInLambda.kt")
            public void testObjectInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/enclosing/objectInLambda.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractLightAnalysisModeTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.JVM, testDataFilePath);
            }

            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("declaredVsInheritedFunctions.kt")
            public void testDeclaredVsInheritedFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/declaredVsInheritedFunctions.kt");
            }

            @TestMetadata("enumValuesValueOf.kt")
            public void testEnumValuesValueOf() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/enumValuesValueOf.kt");
            }

            @TestMetadata("functionFromStdlib.kt")
            public void testFunctionFromStdlib() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/functionFromStdlib.kt");
            }

            @TestMetadata("functionReferenceErasedToKFunction.kt")
            public void testFunctionReferenceErasedToKFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/functionReferenceErasedToKFunction.kt");
            }

            @TestMetadata("genericOverriddenFunction.kt")
            public void testGenericOverriddenFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/genericOverriddenFunction.kt");
            }

            @TestMetadata("instanceOfFunction.kt")
            public void testInstanceOfFunction() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/instanceOfFunction.kt");
            }

            @TestMetadata("javaClassGetFunctions.kt")
            public void testJavaClassGetFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/reflection/functions/javaClassGetFunctions.kt");
            }

            @TestMetadata("javaMethodsSmokeTest.kt")
            public void testJavaMethodsSmokeTest() throws Exce