/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// pref.cpp

#include "pref.h"
#include "prefcddb.h"
#include "prefgeneral.h"

#include "settings.h"

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>



KoverArtistPreferences::KoverArtistPreferences()
:KDialogBase(IconList, i18n("KoverArtist Preferences"),
             Default|Ok|Apply|Cancel, Ok)
{
   QFrame *frame;

   KIconLoader *ildr = KGlobal::iconLoader();

   frame = addPage(i18n("General"), i18n("General Options"),
                   ildr->loadIcon("kfm_home", KIcon::Desktop, KIcon::SizeMedium));
   mPgGen = new KoverArtistPrefGeneral(frame);
   mPgGen->setMinimumSize(mPgGen->sizeHint());

   frame = addPage(i18n("Audio-CDs"), i18n("Audio-CD And CDDB Options"),
                   ildr->loadIcon("cd", KIcon::Desktop, KIcon::SizeMedium));
   mPgCdDb = new KoverArtistPrefCdDb(frame);
   mPgCdDb->setMinimumSize(mPgCdDb->sizeHint());

   fromConfig();
   resize(700, 500);
}


void KoverArtistPreferences::fromConfig(KoverArtist::Settings* aStg)
{
   QString str;

   if (!aStg) aStg = KoverArtist::Settings::instance();

   mPgGen->mCbxLocalImages->setChecked(aStg->localImages);
   mPgGen->mCbxRemoveImageBorders->setChecked(aStg->removeImageBorders);

   mPgCdDb->mEdtCdDrive->setText(aStg->cdDevice);
   mPgCdDb->mEdtCddbServer->setText(aStg->cddbServer);
   str.sprintf("%d", aStg->cddbPort);
   mPgCdDb->mEdtCddbPort->setText(str);
   mPgCdDb->mCbxAutoSetTitle->setChecked(aStg->cddbAutoSetTitle);
}


void KoverArtistPreferences::toConfig()
{
   KoverArtist::Settings* stg = KoverArtist::Settings::instance();

   stg->localImages = mPgGen->mCbxLocalImages->isChecked();
   stg->removeImageBorders = mPgGen->mCbxRemoveImageBorders->isChecked();

   stg->cdDevice = mPgCdDb->mEdtCdDrive->text();
   stg->cddbServer = mPgCdDb->mEdtCddbServer->text();
   stg->cddbPort = mPgCdDb->mEdtCddbPort->text().toInt();
   stg->cddbAutoSetTitle = mPgCdDb->mCbxAutoSetTitle->isChecked();

   stg->sync();
}


void KoverArtistPreferences::slotOk()
{
   toConfig();
   accept();
}


void KoverArtistPreferences::slotApply()
{
   toConfig();
}


void KoverArtistPreferences::slotDefault()
{
   KoverArtist::Settings def;
   fromConfig(&def);
}


#include "pref.moc"
