/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// rendertext.cpp

#include "rendertext.h"

#include <qimage.h>
#include <qstring.h>
#include <qvaluevector.h>


namespace KoverArtist
{


RenderText::RenderText(const RendererBase* aParent, const QFont& aFont,
                       const QColor& aColor, const QRect& aBB,
                       Qt::AlignmentFlags aAlign, const QString& aText,
                       int aAngle)
:mParent(aParent)
,mBB(aBB)
,mAlign(aAlign)
,mText(aText)
,mFont(aFont)
,mColor(aColor)
,mAngle(aAngle)
{
}


void RenderText::render(QPainter& p)
{
   p.setPen(mColor);
   p.setFont(mFont);

   if (mAngle)
   {
      QWMatrix wm = p.worldMatrix();
      p.rotate(mAngle);
      p.drawText(mBB, mAlign, mText);
      p.setWorldMatrix(wm, false);
   }
   else p.drawText(mBB, mAlign, mText);
}


} //namespace
