#ifndef AUDIOCONTROL_H_INCLUDED
#define AUDIOCONTROL_H_INCLUDED
#include <qdialog.h>
#include <qbutton.h>
#include <qbuttongroup.h>

class QLineEdit;
class QRadioButton;
class CallAudio;
class DspOutOss;

class AudioControl : public QDialog
{
	Q_OBJECT
public:
	AudioControl( CallAudio *callaudio, QWidget *parent = 0, const char *name = 0 );
	~AudioControl( void );

protected slots:
	void rwButtonClicked( void );
	void rowoButtonClicked( void );
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum rdwr { rw, rowo };
	enum Codecs { ulaw, gsm, ilbc };
	enum SizeOfPayload { size80, size160 };
	enum Ringingtone { ringingtoneYes, ringingtoneNo };
	QButtonGroup *bg1;
	QButtonGroup *bg2;
	QButtonGroup *bg3;
	CallAudio *a;
	QLineEdit *dspdev;
	QLineEdit *dspdev2;
	QButtonGroup *ringing;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
	QRadioButton *rwButton;
	QRadioButton *rowoButton;
};

class VideoControl : public QDialog
{
	Q_OBJECT
public:
	VideoControl( CallAudio *callaudio, QWidget *parent = 0, const char *name = 0 );
	~VideoControl( void );

protected slots:
	void slotOk( void );
	void slotApply( void );
	void slotCancel( void );

private:
	enum Codecs { h261, h263 };
	QButtonGroup *bg1;
	CallAudio *a;
	QLineEdit *videoSW;
	QPushButton *okPushButton;
	QPushButton *cancelPushButton;
};

#endif // AUDIOCONTROL_H_INCLUDED
