/*************************************************************************
 *  Copyright (C) 2009, 2010 by Volker Lanz <vl@fidra.de>                *
 *                                                                       *
 *  This program is free software; you can redistribute it and/or        *
 *  modify it under the terms of the GNU General Public License as       *
 *  published by the Free Software Foundation; either version 3 of       *
 *  the License, or (at your option) any later version.                  *
 *                                                                       *
 *  This program is distributed in the hope that it will be useful,      *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *  GNU General Public License for more details.                         *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.*
 *************************************************************************/

#if !defined(MOUNTENTRY__H)

#define MOUNTENTRY__H

#include "util/libpartitionmanagerexport.h"

#include <QString>
#include <QStringList>
#include <QtGlobal>

struct mntent;

class LIBKPMCORE_EXPORT MountEntry
{
public:
    enum IdentifyType { deviceNode, uuid, label };

public:
    MountEntry(const QString& n, const QString& p, const QString& t, const QStringList& o, qint32 d, qint32 pn, IdentifyType type);
    MountEntry(struct mntent* p, IdentifyType type);

public:
    QString name;
    QString path;
    QString type;
    QStringList options;
    qint32 dumpFreq;
    qint32 passNumber;
    IdentifyType identifyType;
};

#endif
