//
// C++ Interface: kpgdatatablechildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDATATABLECHILDVIEW_H
#define KPGDATATABLECHILDVIEW_H

#include <kmdichildview.h>

#include "../DbObjects/kpgtableindex.h"
#include "kpgdatatable.h"

class QBoxLayout;
class KXMLGUIFactory;
class KPoGreView;
class KPGConnection;
class KPGDataTable;
class KPGKateXmlEditorDialog;

/**
  * MDI child view for editable data table
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGDataTableChildView : public KMdiChildView
{
	Q_OBJECT
public:
    KPGDataTableChildView(KPoGreView *, 
		KXMLGUIFactory *, 
		KPGConnection *, 
		const QString&, 
		const QString &, 
		const ListTableColumns &,
		const MapIndexKey &, 
		const QString &, 
		const QString &, 
		KPGKateXmlEditorDialog *);
    
    ~KPGDataTableChildView();
	
	KPGDataTable* getDataTable() const { return m_pDataTable; }
	
	// Return true, if window can be closed
	bool requestClose();
	
private:
	// Editable data table window
	KPGDataTable*	m_pDataTable;
	
	QBoxLayout* m_pLayout;
	KPoGreView* m_pPoGreView;

public slots:

	// Add KPGDataTable GUI client to factory
	void slotActivated();

	// Remove KPGDataTable GUI client from factory
	void slotDeactivated();
};

#endif
