//
// C++ Implementation: kpgaggregate
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgaggregate.h"

// include files for KDE
#include <kdebug.h>

#include "kpgaggregatesfolder.h"

KPGAggregate::KPGAggregate(KPGAggregatesFolder *parent, const QString name)
  : KPGTreeItem(parent, name)
{
	setPixmap(0, *m_pIconAggregate);
}

KPGAggregate::KPGAggregate(KPGAggregatesFolder *parent, KPGAggregate *after, const QString name)
  : KPGTreeItem(parent, after, name)
{
    setPixmap(0, *m_pIconAggregate);
}

KPGAggregate::~KPGAggregate()
{
}

void KPGAggregate::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["aggegfnoid"].to(m_oidAggregateFn);
	pqxxTuple["aggtransfnoid"].to(m_oidTransFn);
	pqxxTuple["aggfinalfnoid"].to(m_oidFinalFn);
	pqxxTuple["inputtypoid"].to(m_oidInputType);
	pqxxTuple["transtypoid"].to(m_oidTransType);
	pqxxTuple["returntypoid"].to(m_oidRetType);
		
	m_strDescription = pqxxTuple["description"].c_str();
	m_strAggregateFn = pqxxTuple["aggfnname"].c_str();
	m_strOwner = pqxxTuple["aggrowner"].c_str();
	m_strTransFn = pqxxTuple["aggtransfn"].c_str();
	m_strFinalFn = pqxxTuple["aggfinalfn"].c_str();
	m_strInputTypName = pqxxTuple["inputtypname"].c_str();
	m_strTransTypName = pqxxTuple["transtypname"].c_str();
	m_strRetTypName = pqxxTuple["returntypname"].c_str();
	m_strInitVal = pqxxTuple["agginitval"].c_str();
}



