/***************************************************************************
                          kpgconnection.h  -  description
                             -------------------
    begin                : � led 13 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGCONNECTION_H
#define KPGCONNECTION_H

// Note that for new code which you wish to be strictly Unicode-clean, you can define the macro QT_NO_ASCII_CAST when compiling your code.
#define QT_NO_ASCII_CAST

// include files for libpgxx 
#include <pqxx/connection>
#include <pqxx/transaction_base> 

#include "kpgfunction.h"

using namespace pqxx;

class QString;
class QStringList;
class QTextCodec;
 
/**
  * Define a pqxx::noticer to process warnings generated by 
  * the database server 
  *
  * @author Lumir Vanek
  */
struct KPGNoticer : noticer
{
    virtual void operator()(const char Msg[]) throw ();
	QStringList *m_pListOfNotifications;
};


/**
  * Item that represent connection to PostgreSQL server
  *
  * @author Lumir Vanek
  */
class KPGConnection : public connection
{
public: 
	KPGConnection(const QString);
	virtual ~KPGConnection() throw ();
	
	// Various transactions types
	enum ETransType { eTransNormal = 0, eTransNone, eTransRobust };
	
    void setPassword(const QString & strPassword) { m_strPassword = strPassword; }
    
    const QString & password() const { return m_strPassword; }
  
	// Return encoder name for QTextCodec regards to connection client encoding
	const QString encoderName();
	
	// Return connection encoding
	const QString clientEncoding() { return QString(get_variable("CLIENT_ENCODING")); }
	
	// Return text codec
	QTextCodec *textCodec() const  { return m_pTextCodec; }
	
	// Return list of notifications
	const QStringList & notifications() const { return m_listOfNotifications; }
	
	void clearNotifications();
	
	// Run SQL statement, make conversion regard connection encoding
	pqxx::result runQuery(const QString&);

	// Run SQL statement, make conversion regard connection encoding
	pqxx::result runQuery(const QString &, ETransType);
	
	// Run prepared SQL statement
	pqxx::result runPreparedStatement(const std::string &, const ListArgumentsWithValues &, ETransType = eTransNormal);
	
    void setTrace();
  
  	// Set prepare declaration for argument, regards of its datatype
    void setPrepareDeclaration(pqxx::prepare::declaration &, const QString &);
      
  	// Set value to prepared statement invocation, regards of its datatype. Return false, if conversion fails
  	bool setInvocationValue(prepare::invocation &, const QString &, const QString &);

protected:
    QStringList m_listOfNotifications;
    FILE *m_pFileTrace;
    QString m_strPassword; // remember password, that is used for connection
    
    // Codec for encode/decode strings from/to database
    QTextCodec *m_pTextCodec;
};

#endif
