//
// C++ Interface: kpgdomain
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDOMAIN_H
#define KPGDOMAIN_H

#include "kpgobject.h"

class KPGDomainsFolder;
class KPGDomainConstraintsFolder;

/**
  *Item that represent domain. Domains are useful for abstracting common
  * fields between tables into a single location for maintenance. For
  * example, an email address column may be used in several tables, all with
  * the same properties. Define a domain and use that rather than setting up
  * each table's constraints individually. 
  *
  * @author Lumir Vanek
  */
class KPGDomain : public KPGObject
{
public:
    KPGDomain(KPGDomainsFolder *, const QString, pqxx::oid);
	KPGDomain(KPGDomainsFolder *, KPGDomain *, const QString, pqxx::oid);
    ~KPGDomain();

	virtual eNodeType type() const { return nodeDomain; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "DOMAIN"; }
  	
	void setProperties(const pqxx::result::tuple &);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
    void refreshConstraints();
    
    KPGDomainConstraintsFolder * getDomainConstraintsFolder() { return m_pFolderConstraints; }

	/*
	 * Functions for accessing properties
	 */
	pqxx::oid oidBaseType() const { return m_oidBaseType; }
	const QString & baseType() const { return m_strBaseType; }
	int typLen() const { return m_iTypLen; }
    bool hasDefault() const { return ! m_strDefault.isEmpty(); }
    bool isNotNull() const { return m_bNotNull; }
    const QString &defaultValue() const { return m_strDefault; }
    int typNDims() const { return m_iTypNDims; }
	const QString & typDelim() const { return m_strTypDelim; }
    const QString & owner() const { return m_strOwner; }
    		
protected:

	/*
	 * Properties
	 */
	pqxx::oid m_oidBaseType;
	QString m_strBaseType;
	int m_iTypLen;
	bool m_bNotNull;
	QString m_strDefault;
	int m_iTypNDims;
	QString m_strTypDelim;
	QString m_strOwner;
      
    // Folder with owned objects
    KPGDomainConstraintsFolder *m_pFolderConstraints;
};

#endif
