//
// C++ Interface: kpgfunction
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGFUNCTION_H
#define KPGFUNCTION_H

// include files for Qt
#include <qvaluelist.h>

#include "kpgobject.h"

class KPGFunctionsFolder;


/**
  * Function argument
  *
  * @author Lumir Vanek
  */
class KPGFunctionArgument
{
public:
	KPGFunctionArgument() {;}
	KPGFunctionArgument(unsigned int iSequence, const QString & strName, const QString & strMode, const QString & strTypName)
	{
		m_iSequence = iSequence;
		m_strName = strName;
		m_strMode = strMode;
		m_strTypName = strTypName;
	}

	const unsigned int sequence() const { return m_iSequence; }
	const QString &name() const { return m_strName; }
	const QString &mode() const { return m_strMode; }
	const QString &typName() const { return m_strTypName; }

protected:
	unsigned int m_iSequence; // Starts from 1
	QString m_strName;
	QString m_strMode;
	QString m_strTypName;
};

/**
  * Function argument vith value
  *
  * @author Lumir Vanek
  */
class KPGFunctionArgumentWithValue : public KPGFunctionArgument
{
public:	
	KPGFunctionArgumentWithValue() {;}
	KPGFunctionArgumentWithValue(unsigned int iSequence, const QString & strName, const QString & strMode, const QString & strTypName, const QString & strValue)
	: KPGFunctionArgument(iSequence, strName, strMode, strTypName) 
	{
		m_strValue = strValue;
	}
	
	const QString &value() const { return m_strValue; }

protected:
	QString m_strValue;
};

typedef QValueList<KPGFunctionArgumentWithValue> ListArgumentsWithValues;


/**
  * Database function
  *
  * @author Lumir Vanek
  */
class KPGFunction : public KPGObject
{
public:
    KPGFunction(KPGFunctionsFolder *, const QString, pqxx::oid);
	KPGFunction(KPGFunctionsFolder *, KPGFunction *, const QString, pqxx::oid);
    ~KPGFunction();

	typedef QValueList<KPGFunctionArgument> ListArguments;

	virtual eNodeType type() const { return nodeFunction; }
		
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "FUNCTION"; }
  	
	void setProperties(const pqxx::result::tuple &);
	void setArgTypes(const QString strArgTypes) { m_strArgTypes = strArgTypes; }
	void setSrc(const QString &strSrc) { m_strSrc = strSrc; }
	void setListArguments(const QString &, const QString &, const QString &, const QString &);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
    
    /*
	 * Functions for accessing properties
	 */
	bool isAggregate() const { return m_bIsAgg; }	 
	bool isSecdef() const { return m_bIsSecdef; }
	bool isStrict() const { return m_bIsStrict; }
	bool returnSet() const { return m_bRetSet; }
	const QString & getVolatile() const { return m_strVolatile; }
	int nArgs() const { return m_iNArgs; }
	const QString & bin() const { return m_strBin; }
	const QString langName() const { return m_strLanName; }
	const QString & argTypes() const { return  m_strArgTypes; }
	const QString & source() const { return m_strSrc; }
	const QString & returnTypName() const { return m_strReturnTypName; }
	pqxx::oid oidReturnType() const { return m_oidReturnType; }
	const QString & acl() const { return m_strACL; }
	const QString & owner() const { return m_strFuncOwner; }
		    
    // Return arguments. Old variant, based on pg_proc.proargtypes
    const QString argumentTypes() const { return "(" + argTypes() + ")"; }
    
    // Return name with arguments. New variant, based on info since PostgreSQL 8.1
    const QString nameWithArguments() const;
    
    // Get list of arguments
    const KPGFunction::ListArguments & listArguments() const { return m_listArguments; }
    
protected:
	
	/*
	 * Properties
	 */
	bool m_bIsAgg;
	bool m_bIsSecdef;
	bool m_bIsStrict;
	bool m_bRetSet;
	QString m_strVolatile;
	int m_iNArgs;
	QString m_strBin;
	QString m_strACL;
	pqxx::oid m_oidReturnType;
	QString m_strReturnTypName;
	QString m_strLanName;
	QString m_strFuncOwner;	
	
	// This includes only input arguments (including INOUT arguments), and thus represents the call signature of the function.
	QString m_strArgTypes;
	
	// It might be the actual source code of the function for interpreted languages, a link symbol, a file name, or just about anything else, depending on the implementation language/call convention.
	QString m_strSrc;
	
	// List of argument informations, available since PostgreSQL 8.1
	ListArguments m_listArguments;
};

#endif
